/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.server.common.TwException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ObjectUtils;

public class DataUtil {
    public static final int[] constellationEdgeDay = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
    public static final String[] CONSTELLATION_ARR = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7 ", "\u53cc\u9c7c\u5ea7 ", "\u767d\u7f8a\u5ea7 ", "\u91d1\u725b\u5ea7 ", "\u53cc\u5b50\u5ea7 ", "\u5de8\u87f9\u5ea7 ", " \u72ee\u5b50\u5ea7 ", "\u5904\u5973\u5ea7 ", " \u5929\u79e4\u5ea7 ", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u9b54\u7faf\u5ea7"};

    public static Map<String, String> getConstellation(LocalDate date) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (ObjectUtils.isEmpty((Object)date)) {
            return map;
        }
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        String csonstel = day < constellationEdgeDay[month - 1] ? CONSTELLATION_ARR[month - 1] : CONSTELLATION_ARR[month];
        String dayOfMonth = month + "\u6708" + day + "\u65e5";
        String age = LocalDate.now().getYear() - date.getYear() + "\u5c81";
        map.put("csonstel", csonstel);
        map.put("dayOfMonth", dayOfMonth);
        map.put("age", age);
        return map;
    }

    public static void checkDataLength(Object data, Integer length) {
        if (length == null) {
            length = 255;
        }
        if (data != null) {
            if (DataUtil.isPrimitiveType(data)) {
                if (data.toString().length() > length) {
                    throw TwException.error("", "\u5b57\u6bb5\u957f\u5ea6\u8d85\u8fc7[" + length + "],\u8bf7\u6838\u9a8c\uff01");
                }
            } else if (data instanceof BaseModel || data instanceof TwCommonPayload) {
                Map dataMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)data), Map.class);
                for (Map.Entry entry : dataMap.entrySet()) {
                    DataUtil.checkDataLength(entry.getValue(), length);
                }
            } else if (data instanceof Map) {
                Map dataMap = (Map)data;
                for (Map.Entry entry : dataMap.entrySet()) {
                    DataUtil.checkDataLength(entry.getValue(), length);
                }
            } else if (data instanceof List) {
                List dataList = (List)data;
                Integer finalLength = length;
                dataList.forEach(dataValue -> DataUtil.checkDataLength(dataValue, finalLength));
            }
        }
    }

    public static boolean isPrimitiveType(Object obj) {
        return obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Boolean || obj instanceof String || obj instanceof Character;
    }
}

