/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeoplePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationBusinessQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.annotation.ReSubmitCheck;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
public class CrmPeopleController {
    private static final Logger log = LoggerFactory.getLogger(CrmPeopleController.class);
    private final CrmPeopleService service;

    @PostMapping(value={"/people"})
    @ReSubmitCheck(argExpressions={""}, interval=500L, message="\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4456")
    public TwOutputUtil insertOrUpdate(CrmPeoplePayload payload) {
        return TwOutputUtil.ok(this.service.insertOrUpdate(payload));
    }

    @GetMapping(value={"/people/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmPeopleVO prdFileVO = this.service.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }

    @GetMapping(value={"/people/updateLoveLevel"})
    public TwOutputUtil updateLoveLevel(Long key, Integer level) {
        this.service.updateLoveLevel(key, level);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/people/customerOperationList"})
    public TwOutputUtil queryList(Long operId) {
        List vos = this.service.queryList(operId);
        return TwOutputUtil.ok(vos);
    }

    @GetMapping(value={"/people/paging"})
    public TwOutputUtil paging(CrmPeopleQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @DeleteMapping(value={"/people/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys, String type) {
        this.service.deleteSoft(Arrays.asList(keys), type);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/people/queryRefPeopleList"})
    public TwOutputUtil queryRefPeopleList(Long key, String searchStr, String type) {
        List vos = this.service.queryRefPeopleList(key, searchStr, type);
        return TwOutputUtil.ok(vos);
    }

    @GetMapping(value={"/people/queryOperateFollowList/{key}"})
    public TwOutputUtil queryOperateFollowList(@PathVariable Long key) {
        List vos = this.service.queryOperateFollowList(key);
        return TwOutputUtil.ok(vos);
    }

    @GetMapping(value={"/people/queryBusinessFollowPaging/paging"})
    @UdcNameClass
    public TwOutputUtil queryBusinessFollowPaging(CrmCustomerOperationBusinessQuery query) {
        Object paging = this.service.queryBusinessFollowPaging(query);
        return TwOutputUtil.ok(paging);
    }

    @GetMapping(value={"/people/queryLogList/{key}"})
    @UdcNameClass
    public TwOutputUtil logList(@PathVariable Long key) {
        List prdSystemLogVOS = this.service.queryLogList(key);
        return TwOutputUtil.ok(prdSystemLogVOS);
    }

    @GetMapping(value={"/people/queryPeopleView/{key}"})
    public TwOutputUtil queryCustomerView(@PathVariable Long key) {
        Object view = this.service.queryPeopleView(key);
        return TwOutputUtil.ok(view);
    }

    @GetMapping(value={"/people/queryOperationPlanList/{key}"})
    @UdcNameClass
    public TwOutputUtil queryOperationPlanList(@PathVariable Long key) {
        List vos = this.service.queryOperationPlanDetailList(key);
        return TwOutputUtil.ok(vos);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/people/batchExport"})
    public void batchExport(HttpServletResponse response, CrmPeopleQuery query) {
        this.service.downloadBatch(response, query);
    }

    public CrmPeopleController(CrmPeopleService service) {
        this.service = service;
    }
}

