/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdProbationExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdProbationExamQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdProbationExamService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdProbationExamVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.util.JavaMailPayload;
import com.elitesland.tw.tw5.server.common.util.JavaMailUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.base.HrBaseEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdProbationExamConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdProbationExamDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdProbationExamDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdProbationExamRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdProbationExamServiceImpl
implements PrdProbationExamService {
    private static final Logger log = LoggerFactory.getLogger(PrdProbationExamServiceImpl.class);
    private final PrdProbationExamDao prdProbationExamDao;
    private final PrdProbationExamRepo prdProbationExamRepo;
    private final PrdSystemRoleDAO prdSystemRoleDAO;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final PrdEvaluateService prdEvaluateService;
    private final JavaMailUtil mailUtil;
    private final PrdMessageConfigService messageConfigService;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final PersonResService personResService;

    @Transactional(rollbackFor={Exception.class})
    public PrdProbationExamVO save(PrdProbationExamPayload prdProbationExamPayload) {
        this.checkData(prdProbationExamPayload);
        PrdProbationExamQuery prdProbationExamQuery = new PrdProbationExamQuery();
        prdProbationExamQuery.setType(prdProbationExamPayload.getType());
        prdProbationExamQuery.setUserId(prdProbationExamPayload.getUserId());
        prdProbationExamQuery.setProcInstStatus(ProcInstStatus.APPROVING);
        Long count = this.prdProbationExamDao.count(prdProbationExamQuery);
        if (count > 0L) {
            throw new BusinessException(HrBaseEnum.FLOW_REPEAT_ERR.getDesc());
        }
        PrdProbationExamDO prdProbationExamDO = new PrdProbationExamDO();
        prdProbationExamDO = PrdProbationExamConvert.INSTANCE.p2d(prdProbationExamPayload);
        prdProbationExamDO.setApplyDate(LocalDate.now());
        prdProbationExamDO.setFinishFlag(false);
        prdProbationExamDO.setApplyUserId(prdProbationExamPayload.getUserId());
        Boolean recommendFlag = false;
        PrdOrgEmployeeVO prdOrgEmployeeVO = this.prdOrgEmployeeService.queryByUserId(prdProbationExamQuery.getUserId());
        if (null == prdOrgEmployeeVO) {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u8d44\u6e90\uff0c\u8bf7\u6838\u5b9e\uff1a" + prdProbationExamQuery.getUserId());
        }
        if (null != prdOrgEmployeeVO.getJobInternalRecommId()) {
            recommendFlag = true;
            prdProbationExamDO.setRecommendUserId(prdOrgEmployeeVO.getJobInternalRecommId());
        }
        prdProbationExamDO.setRecommendFlag(recommendFlag);
        PrdProbationExamDO res = (PrdProbationExamDO)((Object)this.prdProbationExamRepo.save((Object)prdProbationExamDO));
        if (prdProbationExamPayload.getType().equals(HrBaseEnum.MIDDLE.getCode())) {
            this.startWorkFlow(res, prdProbationExamPayload.getTaskFlag());
        } else if (prdProbationExamPayload.getType().equals(HrBaseEnum.LATE.getCode())) {
            this.startWorkFlowLate(res, prdProbationExamPayload.getTaskFlag());
        }
        JavaMailPayload javaMailPayload = new JavaMailPayload();
        javaMailPayload.setReceiveEmail(res.getEmail());
        javaMailPayload.setText("\u8bd5\u7528\u671f\u8003\u6838\u6d41\u7a0b\u5df2\u53d1\u9001\uff0c\u8bf7\u5173\u6ce8tw\u5e73\u53f0\u5f85\u529e\u4fe1\u606f");
        javaMailPayload.setSubject("\u8bd5\u7528\u671f\u8003\u6838\u6d41\u7a0b\u53d1\u8d77\u901a\u77e5");
        this.mailUtil.sendEmailAsyncByAdmin(javaMailPayload);
        return PrdProbationExamConvert.INSTANCE.d2v(res);
    }

    private void startWorkFlowLate(PrdProbationExamDO res, Boolean taskFlag) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("Activity_0b5qy4u", res.getUserId());
        PrdOrgEmployeeRefDO prdOrgEmployeeRefDO = this.prdOrgEmployeeDAO.queryByOrgIdAndUserId(res.getBaseBuId(), res.getUserId());
        if (null != prdOrgEmployeeRefDO) {
            variables.put("Activity_01gwytg", prdOrgEmployeeRefDO.getParentId());
        }
        PrdOrgOrganizationVO prdOrgOrganizationVO = this.prdOrgOrganizationService.queryDetailSimpleByOrgId(res.getBaseBuId());
        variables.put("Activity_0q54wfb", prdOrgOrganizationVO.getManageId());
        Object procName = "A43.\u8bd5\u7528\u671f\u8003\u6838\u6d41\u7a0b(\u672b\u671f)";
        procName = (String)procName + res.getUserName();
        List<Long> hrUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_HIRING_MANAGER.getCode()));
        variables.put("Activity_00mrx9q", hrUserIds);
        Boolean pushFlag = false;
        variables.put("push", pushFlag);
        Long procuserId = res.getUserId();
        if (!taskFlag.booleanValue()) {
            procuserId = GlobalUtil.getLoginUser().getId();
        }
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)HrBaseEnum.PROBATION_EXAM_LATE.getCode(), (String)procName, (String)res.getId().toString(), variables), procuserId);
        String procInstId = processInfo.getProcInstId();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        PrdProbationExamPayload payload = new PrdProbationExamPayload();
        payload.setId(res.getId());
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setName((String)procName);
        payload.setType(res.getType());
        this.updateByCondition(payload);
    }

    private void sendEmail(PrdProbationExamDO res) {
        try {
            log.info("\u5f00\u59cb\u53d1\u90ae\u4ef6\u903b\u8f91");
            ArrayList<Long> receiveUserIds = new ArrayList<Long>();
            receiveUserIds.add(res.getUserId());
            String noticeSource = String.join((CharSequence)",", receiveUserIds.stream().map(String::valueOf).collect(Collectors.toList()));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("title", "\u8bd5\u7528\u671f\u8003\u6838\u6d41\u7a0b");
            data.put("content", "\u8bd5\u7528\u671f\u8003\u6838\u6d41\u7a0bcontent");
            PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20230208181400");
            this.messageConfigService.sendMessageConfig(configVO, data, "appoint_people", noticeSource);
            log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u90ae\u4ef6\u53d1\u9001\u51fa\u73b0\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void startWorkFlow(PrdProbationExamDO res, Boolean taskFlag) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        List<Long> glUserIds = this.prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLATFORM_IT_ADMINISTRATOR.getCode()));
        variables.put("Activity_1mm1x7m", glUserIds);
        variables.put("Activity_1ow5lcd", res.getUserId());
        PrdOrgEmployeeRefDO prdOrgEmployeeRefDO = this.prdOrgEmployeeDAO.queryByOrgIdAndUserId(res.getBaseBuId(), res.getUserId());
        if (null != prdOrgEmployeeRefDO) {
            variables.put("Activity_1918p7a", prdOrgEmployeeRefDO.getParentId());
        }
        PrdOrgOrganizationVO prdOrgOrganizationVO = this.prdOrgOrganizationService.queryDetailSimpleByOrgId(res.getBaseBuId());
        variables.put("Activity_002ual9", prdOrgOrganizationVO.getManageId());
        Object procName = "A42.\u8bd5\u7528\u671f\u8003\u6838\u6d41\u7a0b(\u4e2d\u671f)";
        procName = (String)procName + res.getUserName();
        Long procuserId = res.getUserId();
        if (!taskFlag.booleanValue()) {
            procuserId = GlobalUtil.getLoginUser().getId();
        }
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)HrBaseEnum.PROBATION_EXAM.getCode(), (String)procName, (String)res.getId().toString(), variables), procuserId);
        String procInstId = processInfo.getProcInstId();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        PrdProbationExamPayload payload = new PrdProbationExamPayload();
        payload.setId(res.getId());
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setName((String)procName);
        payload.setType(res.getType());
        this.updateByCondition(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdProbationExamVO update(PrdProbationExamPayload prdProbationExamPayload) {
        Assert.notNull((Object)prdProbationExamPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PrdProbationExamVO res = this.save(prdProbationExamPayload);
        return res;
    }

    public PrdProbationExamVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdProbationExamVO res = this.prdProbationExamDao.get(id);
        if (null != res) {
            PrdEvaluateVO pPrdEvaluateVO = this.prdEvaluateService.get(res.getpUserEvalId());
            res.setpPrdEvaluateVO(pPrdEvaluateVO);
            PrdEvaluateVO buPrdEvaluateVO = this.prdEvaluateService.get(res.getBaseBuEvalId());
            res.setBuPrdEvaluateVO(buPrdEvaluateVO);
        }
        return res;
    }

    public PagingVO<PrdProbationExamVO> page(PrdProbationExamQuery prdProbationExamQuery) {
        PagingVO<PrdProbationExamVO> res = this.prdProbationExamDao.page(prdProbationExamQuery);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdProbationExamDao.del(ids);
        return res;
    }

    public List<PrdProbationExamVO> getList(PrdProbationExamQuery prdProbationExamQuery) {
        List<PrdProbationExamVO> res = this.prdProbationExamDao.getList(prdProbationExamQuery);
        return res;
    }

    private void checkData(PrdProbationExamPayload prdProbationExamPayload) {
        if (null == prdProbationExamPayload.getUserId()) {
            throw new BusinessException("\u8003\u6838\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdProbationExamPayload.getType())) {
            throw new BusinessException("\u8003\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateByCondition(PrdProbationExamPayload prdProbationExamPayload) {
        PrdEvaluateVO save;
        Assert.notNull((Object)prdProbationExamPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PrdProbationExamVO prdProbationExamVO = this.get(prdProbationExamPayload.getId());
        if (null == prdProbationExamVO) {
            throw new BusinessException("id\u6709\u8bef\uff0c\u672a\u627e\u5230\u6570\u636e");
        }
        prdProbationExamPayload.setType(prdProbationExamVO.getType());
        Assert.notEmpty((CharSequence)prdProbationExamPayload.getType(), (String)"type\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String itemName = "\u8bd5\u7528\u671f\u8003\u6838-\u672b\u671f";
        if (prdProbationExamPayload.getType().equals(HrBaseEnum.MIDDLE.getCode())) {
            itemName = "\u8bd5\u7528\u671f\u8003\u6838-\u4e2d\u671f";
        }
        if (null != prdProbationExamPayload.getpPrdEvaluatePayload()) {
            PrdEvaluatePayload pPrdEvaluatePayload = prdProbationExamPayload.getpPrdEvaluatePayload();
            pPrdEvaluatePayload.setFromId(prdProbationExamPayload.getId());
            pPrdEvaluatePayload.setItemName(itemName);
            pPrdEvaluatePayload.setState(Integer.valueOf(0));
            save = this.prdEvaluateService.save(pPrdEvaluatePayload);
            prdProbationExamPayload.setpUserEvalId(save.getId());
        }
        if (null != prdProbationExamPayload.getBuPrdEvaluatePayload()) {
            PrdEvaluatePayload buPrdEvaluatePayload = prdProbationExamPayload.getBuPrdEvaluatePayload();
            buPrdEvaluatePayload.setFromId(prdProbationExamPayload.getId());
            buPrdEvaluatePayload.setState(Integer.valueOf(0));
            buPrdEvaluatePayload.setItemName(itemName);
            save = this.prdEvaluateService.save(buPrdEvaluatePayload);
            prdProbationExamPayload.setBaseBuEvalId(save.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)prdProbationExamPayload.getExamRes()) && prdProbationExamPayload.getExamRes().equals("2")) {
            Assert.notNull((Object)prdProbationExamPayload.getUserId(), (String)"userId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Long recommUserId = this.personResService.getJobInternalRecommUserId(prdProbationExamPayload.getUserId());
            prdProbationExamPayload.setRecommendFlag(Boolean.valueOf(null != recommUserId));
            prdProbationExamPayload.setRecommendUserId(recommUserId);
            SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
            setVariablesPayload.setProcInstId(prdProbationExamVO.getProcInstId());
            HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
            variables.put("push", null != recommUserId);
            setVariablesPayload.setVariables(variables);
            this.workflowUtil.setVaribales(setVariablesPayload);
        }
        Long res = this.prdProbationExamDao.update(prdProbationExamPayload);
        return res;
    }

    @Transactional
    public void taskPrdProbationExamMid(String param) {
        LocalDate localDate = LocalDate.now();
        LocalDate localDate3 = localDate.minusMonths(3L);
        List prdOrgEmployeeVOList3 = this.prdOrgEmployeeService.queryByEnrollDate(localDate3);
        for (PrdOrgEmployeeVO prdOrgEmployeeVO : prdOrgEmployeeVOList3) {
            PrdProbationExamPayload prdProbationExamPayload = new PrdProbationExamPayload();
            prdProbationExamPayload.setUserId(prdOrgEmployeeVO.getUserId());
            prdProbationExamPayload.setUserName(prdOrgEmployeeVO.getPersonName());
            prdProbationExamPayload.setPhone(prdOrgEmployeeVO.getMobile());
            prdProbationExamPayload.setEmail(prdOrgEmployeeVO.getEmail());
            prdProbationExamPayload.setApplyUserId(prdOrgEmployeeVO.getUserId());
            prdProbationExamPayload.setApplyUser(prdOrgEmployeeVO.getPersonName());
            prdProbationExamPayload.setFormalData(prdOrgEmployeeVO.getExtDate2());
            prdProbationExamPayload.setProbationStart(prdOrgEmployeeVO.getExtDate6());
            prdProbationExamPayload.setProbationEnd(prdOrgEmployeeVO.getExtDate7());
            List prdOrgDataRefVOS = prdOrgEmployeeVO.getDataRefVOS();
            if (CollUtil.isEmpty((Collection)prdOrgDataRefVOS)) break;
            PrdOrgDataRefVO prdOrgDataRefVO = (PrdOrgDataRefVO)prdOrgDataRefVOS.get(0);
            prdProbationExamPayload.setBaseBuId(prdOrgDataRefVO.getOrgId());
            prdProbationExamPayload.setpUserId(prdOrgDataRefVO.getParentId());
            prdProbationExamPayload.setpUserName(prdOrgDataRefVO.getParentName());
            prdProbationExamPayload.setType(HrBaseEnum.MIDDLE.getCode());
            prdProbationExamPayload.setTaskFlag(Boolean.valueOf(true));
            this.save(prdProbationExamPayload);
        }
    }

    @Transactional
    public void taskPrdProbationExamLate(String param) {
        LocalDate localDate = LocalDate.now();
        LocalDate localDate5 = localDate.minusMonths(5L);
        List prdOrgEmployeeVOList3 = this.prdOrgEmployeeService.queryByEnrollDate(localDate5);
        for (PrdOrgEmployeeVO prdOrgEmployeeVO : prdOrgEmployeeVOList3) {
            PrdProbationExamPayload prdProbationExamPayload = new PrdProbationExamPayload();
            prdProbationExamPayload.setUserId(prdOrgEmployeeVO.getUserId());
            prdProbationExamPayload.setUserName(prdOrgEmployeeVO.getPersonName());
            prdProbationExamPayload.setPhone(prdOrgEmployeeVO.getMobile());
            prdProbationExamPayload.setEmail(prdOrgEmployeeVO.getEmail());
            prdProbationExamPayload.setApplyUserId(prdOrgEmployeeVO.getUserId());
            prdProbationExamPayload.setApplyUser(prdOrgEmployeeVO.getPersonName());
            prdProbationExamPayload.setFormalData(prdOrgEmployeeVO.getExtDate2());
            prdProbationExamPayload.setProbationStart(prdOrgEmployeeVO.getExtDate6());
            prdProbationExamPayload.setProbationEnd(prdOrgEmployeeVO.getExtDate7());
            List prdOrgDataRefVOS = prdOrgEmployeeVO.getDataRefVOS();
            if (CollUtil.isEmpty((Collection)prdOrgDataRefVOS)) break;
            PrdOrgDataRefVO prdOrgDataRefVO = (PrdOrgDataRefVO)prdOrgDataRefVOS.get(0);
            prdProbationExamPayload.setBaseBuId(prdOrgDataRefVO.getOrgId());
            prdProbationExamPayload.setpUserId(prdOrgDataRefVO.getParentId());
            prdProbationExamPayload.setpUserName(prdOrgDataRefVO.getParentName());
            prdProbationExamPayload.setType(HrBaseEnum.LATE.getCode());
            prdProbationExamPayload.setTaskFlag(Boolean.valueOf(true));
            this.save(prdProbationExamPayload);
        }
    }

    public PrdProbationExamServiceImpl(PrdProbationExamDao prdProbationExamDao, PrdProbationExamRepo prdProbationExamRepo, PrdSystemRoleDAO prdSystemRoleDAO, PrdOrgEmployeeDAO prdOrgEmployeeDAO, WorkflowUtil workflowUtil, PrdOrgOrganizationService prdOrgOrganizationService, PrdEvaluateService prdEvaluateService, JavaMailUtil mailUtil, PrdMessageConfigService messageConfigService, PrdOrgEmployeeService prdOrgEmployeeService, PersonResService personResService) {
        this.prdProbationExamDao = prdProbationExamDao;
        this.prdProbationExamRepo = prdProbationExamRepo;
        this.prdSystemRoleDAO = prdSystemRoleDAO;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
        this.workflowUtil = workflowUtil;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.prdEvaluateService = prdEvaluateService;
        this.mailUtil = mailUtil;
        this.messageConfigService = messageConfigService;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.personResService = personResService;
    }
}

