/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.PmsTimesheetExcel;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetExcel;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/my/timesheet"})
@Deprecated
public class TimesheetController {
    private static final Logger log = LoggerFactory.getLogger(TimesheetController.class);
    private final TimesheetService timesheetService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final UdcUtil udcUtil;

    @PostMapping(value={"/batchInsert"})
    @Deprecated
    public TwOutputUtil batchInsert(@RequestBody TimesheetListPayload payload) {
        return TwOutputUtil.ok(this.timesheetService.batchInsert(payload));
    }

    @PutMapping
    @Deprecated
    public TwOutputUtil update(@RequestBody TimesheetPayload payload) {
        return TwOutputUtil.ok(this.timesheetService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.timesheetService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @Deprecated
    public TwOutputUtil paging(TimesheetQuery query) {
        PagingVO paging1 = this.timesheetService.paging(query);
        return TwOutputUtil.ok(paging1);
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @Deprecated
    public TwOutputUtil queryList(TimesheetQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setTsUserId(loginUserId);
        return TwOutputUtil.ok(this.timesheetService.queryList(query));
    }

    @PatchMapping(value={"/updateApproving/{apprUserId}"})
    public TwOutputUtil updateApprovingUser(@RequestBody List<Long> keys, @PathVariable Long apprUserId) {
        this.timesheetService.updateApprovingUser(keys, apprUserId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/getTimesheetOverview"})
    @UdcNameClass
    public TwOutputUtil getTimesheetOverview(TimesheetQuery query) {
        return TwOutputUtil.ok(this.timesheetService.getTimesheetOverview(query));
    }

    @GetMapping(value={"/checkMonthlyTimesheet"})
    @UdcNameClass
    public TwOutputUtil checkMonthlyTimesheet(@RequestParam String checkDate) {
        return TwOutputUtil.ok(this.timesheetService.checkMonthlyTimesheet(checkDate));
    }

    @GetMapping(value={"/approving/count"})
    public TwOutputUtil approvingCount(TimesheetQuery query) {
        query.setApprUserId(GlobalUtil.getLoginUserId());
        long total = this.timesheetService.count(query);
        return TwOutputUtil.ok(total);
    }

    @GetMapping(value={"/approving/paging"})
    @UdcNameClass
    public TwOutputUtil approvingPaging(TimesheetQuery query) {
        List<Long> userIdsByRole;
        query.setTimesheetIdV4IsNull(Boolean.valueOf(true));
        Long loginUserId = GlobalUtil.getLoginUserId();
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!(isSystemAdmin || !CollectionUtils.isEmpty(userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()))) && userIdsByRole.contains(loginUserId))) {
            query.setApprUserId(loginUserId);
        }
        OrderItem orderItem = OrderItem.desc((String)"workDate");
        query.setOrders(Arrays.asList(orderItem));
        return TwOutputUtil.ok(this.timesheetService.pagingSingle(query));
    }

    @GetMapping(value={"/approving/pagingGroup"})
    @UdcNameClass
    public TwOutputUtil approvingPagingGroup(TimesheetQuery query) {
        List<Long> userIdsByRole;
        query.setTimesheetIdV4IsNull(Boolean.valueOf(true));
        Long loginUserId = GlobalUtil.getLoginUserId();
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!(isSystemAdmin || !CollectionUtils.isEmpty(userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()))) && userIdsByRole.contains(loginUserId))) {
            query.setApprUserId(loginUserId);
        }
        return TwOutputUtil.ok(this.timesheetService.pagingGroup(query));
    }

    @GetMapping(value={"/exportList"})
    public void exportMyList(TimesheetQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u5de5\u4f5c\u65e5\u5fd7\u5ba1\u6279";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        this.approvingDataFilterQuery(query);
        List list = this.timesheetService.queryList(query);
        List excelList = TimesheetConvert.INSTANCE.voPmsListVoExcelExport(list);
        excelList = this.udcUtil.translateList(excelList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmCustomerOperationVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, PmsTimesheetExcel.class, null);
        sheet.doWrite(excelList);
    }

    @GetMapping(value={"/approving/exportList"})
    public void exportList(TimesheetQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u5de5\u4f5c\u65e5\u5fd7\u5ba1\u6279";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        this.approvingDataFilterQuery(query);
        List list = this.timesheetService.queryList(query);
        List excelList = TimesheetConvert.INSTANCE.voListVoExcelExport(list);
        excelList = this.udcUtil.translateList(excelList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmCustomerOperationVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, TimesheetExcel.class, null);
        sheet.doWrite(excelList);
    }

    @GetMapping(value={"/approving/exportListGroup"})
    public void exportListGroup(TimesheetQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u5de5\u4f5c\u65e5\u5fd7\u5ba1\u6279";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        this.approvingDataFilterQuery(query);
        List list = this.timesheetService.listGroup(query);
        List excelList = TimesheetConvert.INSTANCE.voListVoExcelExport(list);
        excelList = this.udcUtil.translateList(excelList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmCustomerOperationVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, CrmCustomerOperationExcelExport.class, null);
        sheet.doWrite(excelList);
    }

    private void approvingDataFilterQuery(TimesheetQuery query) {
        List<Long> userIdsByRole;
        Long loginUserId = GlobalUtil.getLoginUserId();
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!(isSystemAdmin || !CollectionUtils.isEmpty(userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()))) && userIdsByRole.contains(loginUserId))) {
            query.setApprUserId(loginUserId);
        }
    }

    @PostMapping(value={"/approving/revoked"})
    @Deprecated
    public TwOutputUtil revoked(Long[] keys) {
        this.timesheetService.revoked(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/approving/approved"})
    @Deprecated
    public TwOutputUtil toApproved(Long[] keys) {
        this.timesheetService.toApproved(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/approving/rejected"})
    @Deprecated
    public TwOutputUtil rejected(Long[] keys, String apprResult) {
        this.timesheetService.rejected(Arrays.asList(keys), apprResult);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/approving/approvedPro"})
    public TwOutputUtil approvedPro(Long[] keys) {
        this.timesheetService.toAdvanced(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.timesheetService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/timesheet/repair"})
    public TwOutputUtil repairTimesheet() {
        this.timesheetService.repairTimesheet();
        return TwOutputUtil.ok();
    }

    public TimesheetController(TimesheetService timesheetService, PrdSystemRoleDAO systemRoleDAO, UdcUtil udcUtil) {
        this.timesheetService = timesheetService;
        this.systemRoleDAO = systemRoleDAO;
        this.udcUtil = udcUtil;
    }
}

