/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributeRespondPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeRespondQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeRespondService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeRespondVO;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.RespondEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsDistributeRespondConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeRespondDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsDistributeRespondDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsDistributeRespondRepo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PmsDistributeRespondServiceImpl
extends BaseServiceImpl
implements PmsDistributeRespondService {
    private static final Logger log = LoggerFactory.getLogger(PmsDistributeRespondServiceImpl.class);
    private final PmsDistributeRespondRepo pmsDistributeRespondRepo;
    private final PmsDistributeRespondDAO pmsDistributeRespondDAO;

    @Transactional(rollbackFor={Exception.class})
    public void respond(List<PmsDistributeRespondPayload> list, String respStatus) {
        Long respondentResId = GlobalUtil.getLoginUserId();
        LocalDateTime respTime = LocalDateTime.now();
        ArrayList<PmsDistributeRespondDO> dos = new ArrayList<PmsDistributeRespondDO>();
        for (PmsDistributeRespondPayload disRespond : list) {
            disRespond.setRespondentResId(respondentResId);
            disRespond.setRespStatus(respStatus);
            disRespond.setRespTime(respTime);
            dos.add(PmsDistributeRespondConvert.INSTANCE.toDo(disRespond));
        }
        if (!ObjectUtil.isEmpty(dos)) {
            this.pmsDistributeRespondDAO.saveAll(dos);
        }
    }

    public void rejectRespond(List<Long> ids) {
        this.pmsDistributeRespondDAO.updateStatus(ids, RespondEnum.REJECTED.getCode());
    }

    public void batchSave(List<PmsDistributeRespondPayload> respondPayloads, Long disId) {
        PmsDistributeRespondQuery query = new PmsDistributeRespondQuery();
        query.setDistId(disId);
        List<PmsDistributeRespondVO> list = this.pmsDistributeRespondDAO.queryListDynamic(query);
        List fromDB = list.stream().map(v -> v.getRespondentResId()).collect(Collectors.toList());
        List<Long> delList = respondPayloads.stream().filter(v -> !fromDB.contains(v.getRespondentResId())).map(v -> v.getId()).collect(Collectors.toList());
        this.pmsDistributeRespondDAO.deleteSoft(delList);
        ArrayList<PmsDistributeRespondDO> dos = new ArrayList<PmsDistributeRespondDO>();
        for (PmsDistributeRespondPayload payload : respondPayloads) {
            dos.add(PmsDistributeRespondConvert.INSTANCE.toDo(payload));
        }
        if (!ObjectUtil.isEmpty(dos)) {
            this.pmsDistributeRespondDAO.saveAll(dos);
        }
    }

    public PagingVO<PmsDistributeRespondVO> queryPaging(PmsDistributeRespondQuery query) {
        return this.pmsDistributeRespondDAO.queryPaging(query);
    }

    public List<PmsDistributeRespondVO> queryListDynamic(PmsDistributeRespondQuery query) {
        return this.pmsDistributeRespondDAO.queryListDynamic(query);
    }

    public PmsDistributeRespondVO queryByKey(Long key) {
        PmsDistributeRespondDO entity = this.pmsDistributeRespondRepo.findById(key).orElseGet(PmsDistributeRespondDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsDistributeRespondVO vo = PmsDistributeRespondConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsDistributeRespondVO insert(PmsDistributeRespondPayload payload) {
        PmsDistributeRespondDO entityDo = PmsDistributeRespondConvert.INSTANCE.toDo(payload);
        return PmsDistributeRespondConvert.INSTANCE.toVo((PmsDistributeRespondDO)this.pmsDistributeRespondRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsDistributeRespondVO update(PmsDistributeRespondPayload payload) {
        PmsDistributeRespondDO entity = this.pmsDistributeRespondRepo.findById(payload.getId()).orElseGet(PmsDistributeRespondDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsDistributeRespondDO entityDo = PmsDistributeRespondConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsDistributeRespondConvert.INSTANCE.toVo((PmsDistributeRespondDO)this.pmsDistributeRespondRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsDistributeRespondPayload payload) {
        PmsDistributeRespondDO entity = this.pmsDistributeRespondRepo.findById(payload.getId()).orElseGet(PmsDistributeRespondDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsDistributeRespondDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsDistributeRespondDAO.deleteSoft(keys);
        }
    }

    public void deleteByDistIds(List<Long> distIds) {
        if (!distIds.isEmpty()) {
            this.pmsDistributeRespondDAO.deleteByDistIds(distIds);
        }
    }

    public PmsDistributeRespondServiceImpl(PmsDistributeRespondRepo pmsDistributeRespondRepo, PmsDistributeRespondDAO pmsDistributeRespondDAO) {
        this.pmsDistributeRespondRepo = pmsDistributeRespondRepo;
        this.pmsDistributeRespondDAO = pmsDistributeRespondDAO;
    }
}

