/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementAssociationService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementResService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementService;
import com.elitesland.tw.tw5.api.prd.purchase.service.ResSetRateService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentDefaultVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.ResSetRateVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.constants.AccountUsageEnum;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementDetailsConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDetailsDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseAgreementEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchaseAgreementServiceImpl
extends BaseServiceImpl
implements PurchaseAgreementService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseAgreementServiceImpl.class);
    @Autowired
    private PurchaseAgreementDetailsService purchaseAgreementDetailsService;
    private final PurchaseAgreementRepo purchaseAgreementRepo;
    private final PurchaseAgreementDAO purchaseAgreementDAO;
    private final PurchaseAgreementDetailsDAO purchaseAgreementDetailsDAO;
    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleService prdSystemRoleService;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    @Value(value="${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    private final TransactionUtilService transactionUtilService;
    private final UdcUtil udcUtil;
    private final BusinessPartnerService businessPartnerService;
    private final BookAccountService bookAccountService;
    private final PurchaseAgreementResService purchaseAgreementResService;
    @Autowired
    private PurchaseAgreementAssociationService purchaseAgreementAssociationService;
    private final ResSetRateService resSetRateService;
    private BeanSearcher beanSearcher;
    private final BusinessSupplierInfoService businessSupplierInfoService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.BUSINESS_OPPORTUNITY);
    }

    public PagingVO<PurchaseAgreementVO> queryPaging(PurchaseAgreementQuery query) {
        PagingVO<PurchaseAgreementVO> pagingVO = this.purchaseAgreementDAO.queryPaging(query);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return pagingVO;
        }
        List purchaseAgreementVOS = pagingVO.getRecords();
        this.transSysSelectionAndName(purchaseAgreementVOS);
        return pagingVO;
    }

    public PagingVO<PurchaseAgreementVO> permissionPaging(PurchaseAgreementQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(PurchaseAgreementVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List purchaseAgreementVOS = this.beanSearcher.searchList(PurchaseAgreementVO.class, mapBuilder.build());
        this.transSysSelectionAndName(purchaseAgreementVOS);
        return PagingVO.builder().records(purchaseAgreementVOS).total(((Long)totalNum).longValue()).build();
    }

    private MapBuilder pageWhereBuilder(PurchaseAgreementQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseAgreementNmNo())) {
            String likeStr = "%" + query.getPurchaseAgreementNmNo() + "%";
            ((MapBuilder)builder.field(PurchaseAgreementVO::getPurchaseAgreementName, new FieldFns.FieldFn[]{PurchaseAgreementVO::getPurchaseAgreementNo})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getAgreementType())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getAgreementType, new Object[]{query.getAgreementType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignDate())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getSignDate, new Object[]{query.getSignDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getAgreementStatus())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getAgreementStatus, new Object[]{query.getAgreementStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSupplierBookId())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getSupplierBookId, new Object[]{query.getSupplierBookId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignCompanyBookId())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getSignCompanyBookId, new Object[]{query.getSignCompanyBookId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignBuId())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getSignBuId, new Object[]{query.getSignBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getAcceptanceType())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getAcceptanceType, new Object[]{query.getAcceptanceType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getCreateUserId, new Object[]{query.getCreateUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getCreateTime, new Object[]{query.getCreateTimeStart()})).op((FieldOp)FieldOps.GreaterEqual);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getCreateTime, new Object[]{query.getCreateTimeEnd()})).op((FieldOp)FieldOps.LessEqual);
        }
        if (!ObjectUtils.isEmpty((Object)query.getIds())) {
            ((MapBuilder)builder.field(PurchaseAgreementVO::getId, (Collection)query.getIds())).op((FieldOp)FieldOps.InList);
        }
        ((MapBuilder)builder.field(PurchaseAgreementVO::getDeleteFlag, new Object[]{0})).op((FieldOp)FieldOps.Equal);
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public List<PurchaseAgreementVO> queryListDynamic(PurchaseAgreementQuery query) {
        List<PurchaseAgreementVO> managerVOS = this.purchaseAgreementDAO.queryListDynamic(query);
        if (CollectionUtils.isEmpty(managerVOS)) {
            return managerVOS;
        }
        this.transSysSelectionAndName(managerVOS);
        return managerVOS;
    }

    public PurchaseAgreementVO queryByKey(Long key) {
        BusinessSupplierInfoVO businessSupplierInfoVO;
        PurchaseAgreementDO entity = this.purchaseAgreementRepo.findById(key).orElseGet(PurchaseAgreementDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PurchaseAgreementVO vo = PurchaseAgreementConvert.INSTANCE.toVo(entity);
        vo.setPricecompereFile(this.fileUtil.getFileDatas(vo.getPricecompereFileCodes()));
        vo.setAgreementFile(this.fileUtil.getFileDatas(vo.getAgreementFileCodes()));
        vo.setStampFile(this.fileUtil.getFileDatas(vo.getStampFileCodes()));
        PurchaseAgreementDetailsQuery purchaseAgreementDetailsQuery = new PurchaseAgreementDetailsQuery();
        purchaseAgreementDetailsQuery.setAgreementId(key);
        List purchaseAgreementDetailsVOS = this.purchaseAgreementDetailsService.queryListDynamic(purchaseAgreementDetailsQuery);
        vo.setDetails(purchaseAgreementDetailsVOS);
        this.transSysSelectionAndName(Collections.singletonList(vo));
        if (vo.getCreateUserId() != null) {
            PrdOrgEmployeeVO employee;
            Long defaultOrgIdByUserId = this.cacheUtil.getDefaultOrgIdByUserId(vo.getCreateUserId());
            if (defaultOrgIdByUserId != null) {
                String orgName = this.cacheUtil.getOrgName(defaultOrgIdByUserId);
                vo.setBuName(orgName);
            }
            if ((employee = this.cacheUtil.getEmployee(vo.getCreateUserId())) != null) {
                vo.setGrade(employee.getExtString1());
            }
        }
        if (vo.getSupplierBookId() != null && (businessSupplierInfoVO = this.businessSupplierInfoService.quertByBookId(vo.getSupplierBookId())) != null) {
            vo.setSupplierStatus(businessSupplierInfoVO.getSupplierStatus());
            vo.setSupplierParentId(businessSupplierInfoVO.getPartnerId());
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseAgreementVO insert(PurchaseAgreementPayload payload) {
        this.checkData(payload);
        if (this.purchaseAgreementDAO.queryByName(payload)) {
            throw TwException.error("", "\u91c7\u8d2d\u534f\u8bae\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        payload.setPurchaseAgreementNo(this.generateSeqNum("PURCHASE_AGREEMENT_NO", new String[0]));
        payload.setAgreementStatus(PurchaseAgreementEnum.AgreementStatus.CREATE.getCode());
        PurchaseAgreementDO entityDo = PurchaseAgreementConvert.INSTANCE.toDo(payload);
        this.countTax(payload.getDetails(), entityDo);
        PurchaseAgreementDO save = (PurchaseAgreementDO)this.purchaseAgreementRepo.save(entityDo);
        List details = payload.getDetails();
        details.forEach(e -> e.setAgreementId(save.getId()));
        this.updateDetails(payload, save);
        return PurchaseAgreementConvert.INSTANCE.toVo(save);
    }

    private void checkData(PurchaseAgreementPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getPurchaseAgreementName())) {
            throw TwException.error("", "\u91c7\u8d2d\u534f\u8bae\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getDetails())) {
            throw TwException.error("", "\u91c7\u8d2d\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    private void updateDetails(PurchaseAgreementPayload payload, PurchaseAgreementDO entityDo) {
        if (ObjectUtils.isEmpty((Object)payload.getDetails())) {
            throw TwException.error("", "\u91c7\u8d2d\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List details = payload.getDetails();
        List<PurchaseAgreementDetailsDO> dDetails = PurchaseAgreementDetailsConvert.INSTANCE.toDoList(details);
        dDetails.forEach(detail -> detail.setAgreementId(entityDo.getId()));
        PurchaseAgreementDetailsConvert.INSTANCE.toVoList(dDetails);
        this.purchaseAgreementDetailsDAO.saveAll(dDetails);
    }

    public void countTax(List<PurchaseAgreementDetailsPayload> details, PurchaseAgreementDO entityDo) {
        String min;
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal taxTotal = BigDecimal.ZERO;
        for (PurchaseAgreementDetailsPayload detail : details) {
            BigDecimal taxAmt = detail.getQuantity().multiply(detail.getTaxPrice());
            BigDecimal taxNotAmt = taxAmt.subtract(detail.getQuantity().multiply(detail.getTaxPrice()).multiply(new BigDecimal(detail.getTaxRate())).multiply(new BigDecimal("0.01")));
            detail.setTaxAmt(taxAmt);
            detail.setTaxNotAmt(taxNotAmt);
            total = total.add(taxAmt);
            taxTotal = taxTotal.add(taxNotAmt);
        }
        entityDo.setAmt(total);
        entityDo.setTaxAmt(total.subtract(taxTotal));
        if (total.equals(BigDecimal.ZERO)) {
            entityDo.setTaxRate("0%");
            return;
        }
        String max = details.stream().map(PurchaseAgreementDetailsPayload::getTaxRate).max(Comparator.comparingInt(Integer::parseInt)).orElse("0");
        if (max.equals(min = details.stream().map(PurchaseAgreementDetailsPayload::getTaxRate).min(Comparator.comparingInt(Integer::parseInt)).orElse("0"))) {
            entityDo.setTaxRate(min + "%");
        } else {
            entityDo.setTaxRate(min + "%~" + max + "%");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseAgreementVO update(PurchaseAgreementPayload payload) {
        PurchaseAgreementDO entity = this.purchaseAgreementRepo.findById(payload.getId()).orElseGet(PurchaseAgreementDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        String name = payload.getPurchaseAgreementName();
        if (StringUtils.hasText((String)name)) {
            List collect;
            PurchaseAgreementQuery query = new PurchaseAgreementQuery();
            query.setPurchaseAgreementNameEq(name);
            PagingVO<PurchaseAgreementVO> queryPaging = this.purchaseAgreementDAO.queryPaging(query);
            List records = queryPaging.getRecords();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)records) && !org.springframework.util.CollectionUtils.isEmpty(collect = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList()))) {
                throw TwException.warn("", "\u534f\u8bae\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff01");
            }
        }
        PurchaseAgreementDO entityDo = PurchaseAgreementConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        this.countTax(payload.getDetails(), entity);
        PurchaseAgreementDO save = (PurchaseAgreementDO)this.purchaseAgreementRepo.save(entityDo);
        List details = payload.getDetails();
        details.forEach(e -> e.setAgreementId(save.getId()));
        this.updateDetails(payload, save);
        return PurchaseAgreementConvert.INSTANCE.toVo((PurchaseAgreementDO)this.purchaseAgreementRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PurchaseAgreementPayload payload) {
        PurchaseAgreementDO entity = this.purchaseAgreementRepo.findById(payload.getId()).orElseGet(PurchaseAgreementDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.purchaseAgreementDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.purchaseAgreementDAO.deleteSoft(keys);
            this.purchaseAgreementResService.deleteSoftByDocumentIdList(keys);
            this.purchaseAgreementDetailsService.deleteSoftByDocumentIdList(keys);
            this.purchaseAgreementAssociationService.deleteSoftByDocumentIdList(keys);
            this.resSetRateService.deleteSoftByDocumentIdList(keys);
        }
    }

    public void active(Long id) {
        PurchaseAgreementVO purchaseAgreementVO = this.purchaseAgreementDAO.queryByKey(id);
        if (ObjectUtils.isEmpty((Object)purchaseAgreementVO)) {
            throw TwException.error("", "\u91c7\u8d2d\u534f\u8bae\u4e0d\u5b58\u5728\uff01");
        }
        this.activeProc(purchaseAgreementVO);
    }

    @Transactional
    public void pending(List<Long> ids) {
        PurchaseAgreementQuery query = new PurchaseAgreementQuery();
        query.setIds(ids);
        List<PurchaseAgreementVO> purchaseAgreementVOS = this.purchaseAgreementDAO.queryListDynamic(query);
        List notActiveList = purchaseAgreementVOS.stream().filter(e -> !PurchaseAgreementEnum.AgreementStatus.ACTIVE.getCode().equalsIgnoreCase(e.getAgreementStatus())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notActiveList)) {
            throw TwException.error("", "\u6fc0\u6d3b\u72b6\u6001\u624d\u53ef\u4ee5\u6682\u6302\uff01");
        }
        this.purchaseAgreementDAO.updateStatusByIds(ids, PurchaseAgreementEnum.AgreementStatus.PENDING.getCode());
    }

    @Transactional
    public void purAgreementBreak(List<Long> ids, String overReason) {
        PurchaseAgreementQuery query = new PurchaseAgreementQuery();
        query.setIds(ids);
        List<PurchaseAgreementVO> purchaseAgreementVOS = this.purchaseAgreementDAO.queryListDynamic(query);
        List notActiveList = purchaseAgreementVOS.stream().filter(e -> !PurchaseAgreementEnum.AgreementStatus.ACTIVE.getCode().equalsIgnoreCase(e.getAgreementStatus())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notActiveList)) {
            throw TwException.error("", "\u6fc0\u6d3b\u72b6\u6001\u624d\u53ef\u4ee5\u7ec8\u6b62\uff01");
        }
        this.purchaseAgreementDAO.purAgreementBreakByIds(ids, overReason);
    }

    public void download(HttpServletResponse response, PurchaseAgreementQuery query) {
        try {
            log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
            PagingVO<PurchaseAgreementVO> paging = this.queryPaging(query);
            log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
            List records = paging.getRecords();
            this.download(this.udcUtil.translateList(records), response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void permissionDownload(PurchaseAgreementQuery query, HttpServletResponse response) {
        try {
            log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
            PagingVO<PurchaseAgreementVO> paging = this.permissionPaging(query);
            log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
            List records = paging.getRecords();
            this.download(this.udcUtil.translateList(records), response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download(List<PurchaseAgreementVO> records, HttpServletResponse response) throws IOException {
        String sheetName = "\u91c7\u8d2d\u534f\u8bae\u6570\u636e";
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PurchaseAgreementVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, PurchaseAgreementVO.class, null);
        sheet.doWrite(records);
    }

    private void transSysSelectionAndName(List<PurchaseAgreementVO> purchaseAgreementVOList) {
        ArrayList bookIdList = new ArrayList();
        purchaseAgreementVOList.forEach(purchaseAgreementVO -> {
            bookIdList.add(purchaseAgreementVO.getInvoice());
            bookIdList.add(purchaseAgreementVO.getSupplierBookId());
            bookIdList.add(purchaseAgreementVO.getSignCompanyBookId());
        });
        Map nameByBookIds = this.businessPartnerService.findNameByBookIds(bookIdList);
        purchaseAgreementVOList.forEach(purchaseAgreementVO -> {
            purchaseAgreementVO.setInvoiceName((String)nameByBookIds.get(purchaseAgreementVO.getInvoice()));
            purchaseAgreementVO.setSupplierName((String)nameByBookIds.get(purchaseAgreementVO.getSupplierBookId()));
            purchaseAgreementVO.setSignCompanyName((String)nameByBookIds.get(purchaseAgreementVO.getSignCompanyBookId()));
            purchaseAgreementVO.setCreateUserName(this.cacheUtil.getUserName(purchaseAgreementVO.getCreateUserId()));
        });
    }

    private void activeProc(PurchaseAgreementVO agreementVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = PurchaseAgreementEnum.AgreementStatus.CREATE.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = PurchaseAgreementEnum.AgreementStatus.APPROVING.getCode();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            Long signBuManageUserId = null;
            if (agreementVO.getSignBuId() != null) {
                signBuManageUserId = this.daoOrg.queryManageIdById(agreementVO.getSignBuId());
            }
            variables.put("Activity_0i7952g", signBuManageUserId);
            variables.put("Activity_128wjc7", this.prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.PA_AGREEMENT_ACTIVE.name(), (String)(agreementVO.getPurchaseAgreementName() + "-\u91c7\u8d2d\u534f\u8bae\u6fc0\u6d3b\u5ba1\u6279\u6d41\u7a0b"), (String)("" + agreementVO.getId()), variables), new Long[0]);
        }
        PurchaseAgreementPayload payload = new PurchaseAgreementPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(agreementVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setAgreementStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.purchaseAgreementDAO.updateByKeyDynamic(payload));
    }

    public PurchasePaymentDefaultVO findPaymentDefaultByDocNo(String docNo) {
        PurchasePaymentDefaultVO purchasePaymentDefaultVO = new PurchasePaymentDefaultVO();
        PurchaseAgreementVO byPurchaseAgreementNo = this.purchaseAgreementDAO.findByPurchaseAgreementNo(docNo);
        if (byPurchaseAgreementNo != null) {
            BookAccountVO bookAccountVO;
            if (byPurchaseAgreementNo.getReceivingUnitBookId() != null && (bookAccountVO = this.bookAccountService.queryDefaultByBookId(byPurchaseAgreementNo.getReceivingUnitBookId())) != null && AccountUsageEnum.RECEIVE.getCode().equals(bookAccountVO.getAccountUsage())) {
                purchasePaymentDefaultVO.setReceivingId(String.valueOf(bookAccountVO.getId()));
                purchasePaymentDefaultVO.setReceivingBank(bookAccountVO.getDepositBank());
            }
            purchasePaymentDefaultVO.setDocId(byPurchaseAgreementNo.getId());
            purchasePaymentDefaultVO.setAcceptanceType(byPurchaseAgreementNo.getAcceptanceType());
            purchasePaymentDefaultVO.setCurrCode(byPurchaseAgreementNo.getCurrCode());
            purchasePaymentDefaultVO.setDocNo(byPurchaseAgreementNo.getPurchaseAgreementNo());
            purchasePaymentDefaultVO.setDocName(byPurchaseAgreementNo.getPurchaseAgreementName());
            purchasePaymentDefaultVO.setSupplierBookId(byPurchaseAgreementNo.getSupplierBookId());
            purchasePaymentDefaultVO.setReceivingUnitBookId(byPurchaseAgreementNo.getReceivingUnitBookId());
            purchasePaymentDefaultVO.setPayMethod(byPurchaseAgreementNo.getPayMethod());
            purchasePaymentDefaultVO.setDemandNo(byPurchaseAgreementNo.getDemandNo());
            purchasePaymentDefaultVO.setPaymentCompanyBooKId(byPurchaseAgreementNo.getSignCompanyBookId());
            purchasePaymentDefaultVO.setPaymentAmt(byPurchaseAgreementNo.getAmt());
        }
        return purchasePaymentDefaultVO;
    }

    public Long findIdByNo(String docNo) {
        return this.purchaseAgreementDAO.findIdByNo(docNo);
    }

    public PurchaseAgreementVO queryByNo(String docNo) {
        return this.purchaseAgreementDAO.queryByNo(docNo);
    }

    public BigDecimal getRateByAgreementId(Long agreementId, BigDecimal amt) {
        List resSetRateVOS = this.resSetRateService.findByAgreementId(agreementId);
        return resSetRateVOS.stream().filter(e -> e.getEndAtm().compareTo(amt) >= 0 && e.getStartAtm().compareTo(amt) <= 0).findFirst().map(ResSetRateVO::getServiceRate).orElseThrow(() -> {
            log.error("[PAYMENT_APPLY]===\u83b7\u53d6\u8d39\u7387\u5f02\u5e38===");
            return TwException.error("", "\u83b7\u53d6\u8d39\u7387\u5f02\u5e38");
        });
    }

    public PurchaseAgreementServiceImpl(PurchaseAgreementRepo purchaseAgreementRepo, PurchaseAgreementDAO purchaseAgreementDAO, PurchaseAgreementDetailsDAO purchaseAgreementDetailsDAO, FileUtil fileUtil, CacheUtil cacheUtil, PrdSystemRoleService prdSystemRoleService, WorkflowUtil workflowUtil, PrdOrgOrganizationDAO daoOrg, TransactionUtilService transactionUtilService, UdcUtil udcUtil, BusinessPartnerService businessPartnerService, BookAccountService bookAccountService, PurchaseAgreementResService purchaseAgreementResService, ResSetRateService resSetRateService, BusinessSupplierInfoService businessSupplierInfoService) {
        this.purchaseAgreementRepo = purchaseAgreementRepo;
        this.purchaseAgreementDAO = purchaseAgreementDAO;
        this.purchaseAgreementDetailsDAO = purchaseAgreementDetailsDAO;
        this.fileUtil = fileUtil;
        this.cacheUtil = cacheUtil;
        this.prdSystemRoleService = prdSystemRoleService;
        this.workflowUtil = workflowUtil;
        this.daoOrg = daoOrg;
        this.transactionUtilService = transactionUtilService;
        this.udcUtil = udcUtil;
        this.businessPartnerService = businessPartnerService;
        this.bookAccountService = bookAccountService;
        this.purchaseAgreementResService = purchaseAgreementResService;
        this.resSetRateService = resSetRateService;
        this.businessSupplierInfoService = businessSupplierInfoService;
    }
}

