/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.schedule.convert;

import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdActivityCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdActivityCalendarVO;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdActivityCalendarConvert;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdActivityCalendarDO;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class PrdActivityCalendarConvertImpl
implements PrdActivityCalendarConvert {
    private final DatatypeFactory datatypeFactory;

    public PrdActivityCalendarConvertImpl() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public PrdActivityCalendarDO toEntity(PrdActivityCalendarVO dto) {
        if (dto == null) {
            return null;
        }
        PrdActivityCalendarDO prdActivityCalendarDO = new PrdActivityCalendarDO();
        prdActivityCalendarDO.setId(dto.getId());
        prdActivityCalendarDO.setTenantId(dto.getTenantId());
        prdActivityCalendarDO.setRemark(dto.getRemark());
        prdActivityCalendarDO.setCreateUserId(dto.getCreateUserId());
        prdActivityCalendarDO.setCreator(dto.getCreator());
        prdActivityCalendarDO.setCreateTime(dto.getCreateTime());
        prdActivityCalendarDO.setModifyUserId(dto.getModifyUserId());
        prdActivityCalendarDO.setUpdater(dto.getUpdater());
        prdActivityCalendarDO.setModifyTime(dto.getModifyTime());
        prdActivityCalendarDO.setDeleteFlag(dto.getDeleteFlag());
        prdActivityCalendarDO.setAuditDataVersion(dto.getAuditDataVersion());
        prdActivityCalendarDO.setTitle(dto.getTitle());
        prdActivityCalendarDO.setType(dto.getType());
        prdActivityCalendarDO.setStartTime(dto.getStartTime());
        prdActivityCalendarDO.setEndTime(dto.getEndTime());
        prdActivityCalendarDO.setCity(dto.getCity());
        prdActivityCalendarDO.setLocation(dto.getLocation());
        prdActivityCalendarDO.setScale(dto.getScale());
        prdActivityCalendarDO.setManageUserId(dto.getManageUserId());
        prdActivityCalendarDO.setParticipants(dto.getParticipants());
        prdActivityCalendarDO.setLiveUrl(dto.getLiveUrl());
        prdActivityCalendarDO.setScheduleId(dto.getScheduleId());
        return prdActivityCalendarDO;
    }

    @Override
    public List<PrdActivityCalendarDO> toEntity(List<PrdActivityCalendarVO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<PrdActivityCalendarDO> list = new ArrayList<PrdActivityCalendarDO>(dtoList.size());
        for (PrdActivityCalendarVO prdActivityCalendarVO : dtoList) {
            list.add(this.toEntity(prdActivityCalendarVO));
        }
        return list;
    }

    @Override
    public List<PrdActivityCalendarVO> toVoList(List<PrdActivityCalendarDO> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<PrdActivityCalendarVO> list = new ArrayList<PrdActivityCalendarVO>(entityList.size());
        for (PrdActivityCalendarDO prdActivityCalendarDO : entityList) {
            list.add(this.toVo(prdActivityCalendarDO));
        }
        return list;
    }

    @Override
    public PrdActivityCalendarDO toDo(PrdActivityCalendarPayload payload) {
        if (payload == null) {
            return null;
        }
        PrdActivityCalendarDO prdActivityCalendarDO = new PrdActivityCalendarDO();
        prdActivityCalendarDO.setId(payload.getId());
        prdActivityCalendarDO.setRemark(payload.getRemark());
        prdActivityCalendarDO.setCreateUserId(payload.getCreateUserId());
        prdActivityCalendarDO.setCreator(payload.getCreator());
        prdActivityCalendarDO.setCreateTime(payload.getCreateTime());
        prdActivityCalendarDO.setModifyUserId(payload.getModifyUserId());
        prdActivityCalendarDO.setModifyTime(payload.getModifyTime());
        prdActivityCalendarDO.setDeleteFlag(payload.getDeleteFlag());
        prdActivityCalendarDO.setTitle(payload.getTitle());
        prdActivityCalendarDO.setType(payload.getType());
        prdActivityCalendarDO.setStartTime(payload.getStartTime());
        prdActivityCalendarDO.setEndTime(payload.getEndTime());
        prdActivityCalendarDO.setCity(payload.getCity());
        prdActivityCalendarDO.setLocation(payload.getLocation());
        prdActivityCalendarDO.setScale(payload.getScale());
        prdActivityCalendarDO.setManageUserId(payload.getManageUserId());
        prdActivityCalendarDO.setParticipants(payload.getParticipants());
        prdActivityCalendarDO.setLiveUrl(payload.getLiveUrl());
        return prdActivityCalendarDO;
    }

    @Override
    public PrdActivityCalendarVO toVo(PrdActivityCalendarDO ado) {
        if (ado == null) {
            return null;
        }
        PrdActivityCalendarVO prdActivityCalendarVO = new PrdActivityCalendarVO();
        prdActivityCalendarVO.setId(ado.getId());
        prdActivityCalendarVO.setTenantId(ado.getTenantId());
        prdActivityCalendarVO.setRemark(ado.getRemark());
        prdActivityCalendarVO.setCreateUserId(ado.getCreateUserId());
        prdActivityCalendarVO.setCreator(ado.getCreator());
        prdActivityCalendarVO.setCreateTime(ado.getCreateTime());
        prdActivityCalendarVO.setModifyUserId(ado.getModifyUserId());
        prdActivityCalendarVO.setUpdater(ado.getUpdater());
        prdActivityCalendarVO.setModifyTime(ado.getModifyTime());
        prdActivityCalendarVO.setDeleteFlag(ado.getDeleteFlag());
        prdActivityCalendarVO.setAuditDataVersion(ado.getAuditDataVersion());
        prdActivityCalendarVO.setTitle(ado.getTitle());
        prdActivityCalendarVO.setType(ado.getType());
        prdActivityCalendarVO.setStartTime(ado.getStartTime());
        prdActivityCalendarVO.setEndTime(ado.getEndTime());
        prdActivityCalendarVO.setCity(ado.getCity());
        prdActivityCalendarVO.setLocation(ado.getLocation());
        prdActivityCalendarVO.setScale(ado.getScale());
        prdActivityCalendarVO.setManageUserId(ado.getManageUserId());
        prdActivityCalendarVO.setParticipants(ado.getParticipants());
        prdActivityCalendarVO.setLiveUrl(ado.getLiveUrl());
        prdActivityCalendarVO.setScheduleId(ado.getScheduleId());
        return prdActivityCalendarVO;
    }

    @Override
    public PrdActivityCalendarPayload toPayload(PrdActivityCalendarVO vo) {
        if (vo == null) {
            return null;
        }
        PrdActivityCalendarPayload prdActivityCalendarPayload = new PrdActivityCalendarPayload();
        prdActivityCalendarPayload.setId(vo.getId());
        prdActivityCalendarPayload.setRemark(vo.getRemark());
        prdActivityCalendarPayload.setCreateUserId(vo.getCreateUserId());
        prdActivityCalendarPayload.setCreator(vo.getCreator());
        prdActivityCalendarPayload.setCreateTime(vo.getCreateTime());
        prdActivityCalendarPayload.setModifyUserId(vo.getModifyUserId());
        prdActivityCalendarPayload.setModifyTime(vo.getModifyTime());
        prdActivityCalendarPayload.setDeleteFlag(vo.getDeleteFlag());
        prdActivityCalendarPayload.setTitle(vo.getTitle());
        prdActivityCalendarPayload.setType(vo.getType());
        prdActivityCalendarPayload.setStartTime(vo.getStartTime());
        prdActivityCalendarPayload.setEndTime(vo.getEndTime());
        prdActivityCalendarPayload.setCity(vo.getCity());
        prdActivityCalendarPayload.setLocation(vo.getLocation());
        prdActivityCalendarPayload.setScale(vo.getScale());
        prdActivityCalendarPayload.setManageUserId(vo.getManageUserId());
        List list = vo.getParticipantsList();
        if (list != null) {
            prdActivityCalendarPayload.setParticipantsList(new ArrayList(list));
        }
        prdActivityCalendarPayload.setParticipants(vo.getParticipants());
        prdActivityCalendarPayload.setLiveUrl(vo.getLiveUrl());
        return prdActivityCalendarPayload;
    }

    @Override
    public List<PrdActivityCalendarVO> actVosToVos(List<CrmActActivityVO> crmActActivityVOList) {
        if (crmActActivityVOList == null) {
            return null;
        }
        ArrayList<PrdActivityCalendarVO> list = new ArrayList<PrdActivityCalendarVO>(crmActActivityVOList.size());
        for (CrmActActivityVO crmActActivityVO : crmActActivityVOList) {
            list.add(this.crmActActivityVOToPrdActivityCalendarVO(crmActActivityVO));
        }
        return list;
    }

    private XMLGregorianCalendar localDateToXmlGregorianCalendar(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return this.datatypeFactory.newXMLGregorianCalendarDate(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth(), Integer.MIN_VALUE);
    }

    private static LocalDateTime xmlGregorianCalendarToLocalDateTime(XMLGregorianCalendar xcal) {
        if (xcal == null) {
            return null;
        }
        if (xcal.getYear() != Integer.MIN_VALUE && xcal.getMonth() != Integer.MIN_VALUE && xcal.getDay() != Integer.MIN_VALUE && xcal.getHour() != Integer.MIN_VALUE && xcal.getMinute() != Integer.MIN_VALUE) {
            if (xcal.getSecond() != Integer.MIN_VALUE && xcal.getMillisecond() != Integer.MIN_VALUE) {
                return LocalDateTime.of(xcal.getYear(), xcal.getMonth(), xcal.getDay(), xcal.getHour(), xcal.getMinute(), xcal.getSecond(), Duration.ofMillis(xcal.getMillisecond()).getNano());
            }
            if (xcal.getSecond() != Integer.MIN_VALUE) {
                return LocalDateTime.of(xcal.getYear(), xcal.getMonth(), xcal.getDay(), xcal.getHour(), xcal.getMinute(), xcal.getSecond());
            }
            return LocalDateTime.of(xcal.getYear(), xcal.getMonth(), xcal.getDay(), xcal.getHour(), xcal.getMinute());
        }
        return null;
    }

    protected PrdActivityCalendarVO crmActActivityVOToPrdActivityCalendarVO(CrmActActivityVO crmActActivityVO) {
        if (crmActActivityVO == null) {
            return null;
        }
        PrdActivityCalendarVO prdActivityCalendarVO = new PrdActivityCalendarVO();
        prdActivityCalendarVO.setId(crmActActivityVO.getId());
        prdActivityCalendarVO.setTenantId(crmActActivityVO.getTenantId());
        prdActivityCalendarVO.setRemark(crmActActivityVO.getRemark());
        prdActivityCalendarVO.setCreateUserId(crmActActivityVO.getCreateUserId());
        prdActivityCalendarVO.setCreator(crmActActivityVO.getCreator());
        prdActivityCalendarVO.setCreateTime(crmActActivityVO.getCreateTime());
        prdActivityCalendarVO.setModifyUserId(crmActActivityVO.getModifyUserId());
        prdActivityCalendarVO.setUpdater(crmActActivityVO.getUpdater());
        prdActivityCalendarVO.setModifyTime(crmActActivityVO.getModifyTime());
        prdActivityCalendarVO.setDeleteFlag(crmActActivityVO.getDeleteFlag());
        prdActivityCalendarVO.setAuditDataVersion(crmActActivityVO.getAuditDataVersion());
        prdActivityCalendarVO.setStartTime(PrdActivityCalendarConvertImpl.xmlGregorianCalendarToLocalDateTime(this.localDateToXmlGregorianCalendar(crmActActivityVO.getStartTime())));
        prdActivityCalendarVO.setEndTime(PrdActivityCalendarConvertImpl.xmlGregorianCalendarToLocalDateTime(this.localDateToXmlGregorianCalendar(crmActActivityVO.getEndTime())));
        prdActivityCalendarVO.setManageUserId(crmActActivityVO.getManageUserId());
        prdActivityCalendarVO.setManageUserName(crmActActivityVO.getManageUserName());
        prdActivityCalendarVO.setProjectName(crmActActivityVO.getProjectName());
        prdActivityCalendarVO.setActivityAddr(crmActActivityVO.getActivityAddr());
        prdActivityCalendarVO.setStatus(crmActActivityVO.getStatus());
        prdActivityCalendarVO.setScheduleId(crmActActivityVO.getScheduleId());
        return prdActivityCalendarVO;
    }
}

