/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFieldPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFunctionObjectPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionFunctionObjectService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemBusinessObjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFunctionObjectVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemPermissionFunctionObjectConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemBusinessObjectDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemPermissionFieldDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemPermissionFieldObjRoleFunctionDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemPermissionFunctionObjectDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemPermissionTableFieldsDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemNewFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionFieldDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionFieldObjRoleFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionFunctionObjectDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionTableFieldsDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemNewFunctionRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionFieldObjRoleFunctionRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionFieldRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionFunctionObjectRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionTableFieldsRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PrdSystemPermissionFunctionObjectServiceImpl
implements PrdSystemPermissionFunctionObjectService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemPermissionFunctionObjectServiceImpl.class);
    private final PrdSystemPermissionFunctionObjectRepo repo;
    private final PrdSystemPermissionFunctionObjectDAO dao;
    private final PrdSystemPermissionFieldRepo fieldRepo;
    private final PrdSystemPermissionFieldDAO fieldDao;
    private final PrdSystemNewFunctionRepo functionRepo;
    private final PrdSystemBusinessObjectDAO businessObjectDAO;
    private final PrdSystemPermissionTableFieldsRepo businessTableFieldsRepo;
    private final PrdSystemPermissionTableFieldsDAO tableFieldsDAO;
    private final PrdSystemPermissionFieldObjRoleFunctionDAO fieldObjRoleFunctionDAO;
    private final PrdSystemPermissionFieldObjRoleFunctionRepo fieldObjRoleFunctionRepo;

    @Transactional(rollbackFor={Exception.class})
    public void autoCreate(Map<String, List<PrdSystemPermissionFunctionObjectPayload>> functionMap) {
        ArrayList<String> objectCodes = new ArrayList<String>(functionMap.keySet());
        List<PrdSystemBusinessObjectVO> objectList = this.businessObjectDAO.queryByObjectCodes(objectCodes);
        Map<String, PrdSystemBusinessObjectVO> objectMap = objectList.stream().collect(Collectors.toMap(PrdSystemBusinessObjectVO::getObjectCode, e -> e, (l, r) -> r));
        List<String> functionCodes = functionMap.values().stream().flatMap(Collection::stream).map(PrdSystemPermissionFunctionObjectPayload::getFunctionCodes).flatMap(Collection::stream).distinct().toList();
        List<PrdSystemNewFunctionDO> functionList = this.functionRepo.findAllByFunctionCodeIn(functionCodes);
        Map<String, PrdSystemNewFunctionDO> existFunctionMap = functionList.stream().collect(Collectors.toMap(PrdSystemNewFunctionDO::getFunctionCode, e -> e, (l, r) -> l));
        List<Long> objectIds = objectList.stream().map(BaseViewModel::getId).toList();
        List<PrdSystemPermissionFunctionObjectDO> existFunctionObjectList = this.repo.findAllByObjectIdIn(objectIds);
        List<PrdSystemPermissionFieldDO> existFieldList = this.fieldRepo.findAllByObjectIdIn(objectIds);
        ArrayList updateList = new ArrayList();
        ArrayList insertList = new ArrayList();
        ArrayList syncInsertList = new ArrayList();
        ArrayList<Long> deleteList = new ArrayList<Long>();
        ArrayList<Long> syncDeleteList = new ArrayList<Long>();
        HashSet functionSet = new HashSet();
        HashSet distinctFunctionObject = new HashSet();
        functionMap.forEach((k, v) -> {
            if (objectMap.containsKey(k)) {
                PrdSystemBusinessObjectVO businessObject = (PrdSystemBusinessObjectVO)objectMap.get(k);
                v.forEach(functionObject -> functionObject.getFunctionCodes().forEach(functionCode -> {
                    if (!existFunctionMap.containsKey(functionCode)) {
                        return;
                    }
                    PrdSystemNewFunctionDO prdSystemNewFunctionDO = (PrdSystemNewFunctionDO)((Object)((Object)((Object)((Object)existFunctionMap.get(functionCode)))));
                    Long functionId = prdSystemNewFunctionDO.getId();
                    Optional<PrdSystemPermissionFunctionObjectDO> functionObjectOptional = existFunctionObjectList.stream().filter(item -> functionId.equals(item.getFunctionId()) && functionObject.getClassName().equals(item.getClassName())).findFirst();
                    if (functionObjectOptional.isPresent()) {
                        PrdSystemPermissionFunctionObjectDO existFunctionObject = functionObjectOptional.get();
                        existFunctionObject.setClassPathName(prdSystemNewFunctionDO.getFunctionName());
                        existFunctionObject.setFunctionId(functionId);
                        this.repo.save((Object)existFunctionObject);
                        functionObject.getFields().forEach(field -> {
                            Optional<PrdSystemPermissionFieldDO> optional = existFieldList.stream().filter(item -> item.getFunctionObjectId().equals(existFunctionObject.getId()) && item.getObjectId().equals(businessObject.getId()) && item.getField().equals(field.getField())).findFirst();
                            if (optional.isPresent()) {
                                PrdSystemPermissionFieldDO prdSystemPermissionFieldDO = optional.get();
                                prdSystemPermissionFieldDO.setFieldName(field.getFieldName());
                                prdSystemPermissionFieldDO.setFieldType(field.getFieldType());
                                updateList.add(prdSystemPermissionFieldDO);
                            } else {
                                PrdSystemPermissionFieldDO prdSystemPermissionFieldDO = PrdSystemPermissionFunctionObjectConvert.INSTANCE.fieldPayload2DO((PrdSystemPermissionFieldPayload)field);
                                prdSystemPermissionFieldDO.setObjectId(businessObject.getId());
                                prdSystemPermissionFieldDO.setFunctionObjectId(existFunctionObject.getId());
                                insertList.add(prdSystemPermissionFieldDO);
                                PrdSystemPermissionTableFieldsDO tableFieldsDO = new PrdSystemPermissionTableFieldsDO();
                                this.fillBusinessTableFieldDO(tableFieldsDO, prdSystemPermissionFieldDO, existFunctionObject);
                                syncInsertList.add(tableFieldsDO);
                            }
                        });
                        List<String> fieldList = functionObject.getFields().stream().map(PrdSystemPermissionFieldPayload::getField).toList();
                        List<PrdSystemPermissionFieldDO> deleteField = existFieldList.stream().filter(item -> item.getFunctionObjectId().equals(existFunctionObject.getId()) && item.getObjectId().equals(businessObject.getId()) && !fieldList.contains(item.getField())).toList();
                        if (!CollectionUtils.isEmpty(deleteField)) {
                            List<Long> funcObjIds = deleteField.stream().map(PrdSystemPermissionFieldDO::getFunctionObjectId).toList();
                            List<PrdSystemPermissionFunctionObjectVO> fobj = this.dao.getByV2Ids(funcObjIds);
                            Map<Object, Object> funcMap = new HashMap();
                            if (!CollectionUtils.isEmpty(fobj)) {
                                funcMap = fobj.stream().collect(Collectors.toMap(BaseViewModel::getId, PrdSystemPermissionFunctionObjectVO::getFunctionId));
                            }
                            List<Long> deleteFieldIds = deleteField.stream().map(BaseModel::getId).toList();
                            deleteList.addAll(deleteFieldIds);
                            HashMap fieldMap = new HashMap();
                            for (PrdSystemPermissionFieldDO prdSystemPermissionFieldDO : deleteField) {
                                List<String> strs;
                                Long funcId = (Long)funcMap.get(prdSystemPermissionFieldDO.getFunctionObjectId());
                                if (fieldMap.containsKey(funcId)) {
                                    strs = (List)fieldMap.get(funcId);
                                    strs.add(this.humpToUnderline(prdSystemPermissionFieldDO.getField()));
                                    continue;
                                }
                                strs = new ArrayList();
                                strs.add(this.humpToUnderline(prdSystemPermissionFieldDO.getField()));
                                fieldMap.put(funcId, strs);
                            }
                            for (Map.Entry entry : fieldMap.entrySet()) {
                                List<Long> businessFieldIds = this.tableFieldsDAO.queryListByTableIdAndField((Long)entry.getKey(), (List)entry.getValue());
                                if (CollectionUtils.isEmpty(businessFieldIds)) continue;
                                syncDeleteList.addAll(businessFieldIds);
                            }
                        }
                    } else {
                        PrdSystemPermissionFunctionObjectDO functionObjectDO = PrdSystemPermissionFunctionObjectConvert.INSTANCE.functionPayload2DO((PrdSystemPermissionFunctionObjectPayload)functionObject);
                        functionObjectDO.setObjectId(businessObject.getId());
                        functionObjectDO.setFunctionId(functionId);
                        functionObjectDO.setClassPathName(prdSystemNewFunctionDO.getFunctionName());
                        String element = functionObjectDO.getObjectId() + "_" + functionObjectDO.getFunctionId() + "_" + functionObjectDO.getClassPathName();
                        if (distinctFunctionObject.add(element)) {
                            this.repo.save((Object)functionObjectDO);
                            functionObject.getFields().forEach(field -> {
                                PrdSystemPermissionFieldDO prdSystemPermissionFieldDO = PrdSystemPermissionFunctionObjectConvert.INSTANCE.fieldPayload2DO((PrdSystemPermissionFieldPayload)field);
                                prdSystemPermissionFieldDO.setObjectId(businessObject.getId());
                                prdSystemPermissionFieldDO.setFunctionObjectId(functionObjectDO.getId());
                                insertList.add(prdSystemPermissionFieldDO);
                                PrdSystemPermissionTableFieldsDO tableFieldsDO = new PrdSystemPermissionTableFieldsDO();
                                this.fillBusinessTableFieldDO(tableFieldsDO, prdSystemPermissionFieldDO, functionObjectDO);
                                syncInsertList.add(tableFieldsDO);
                            });
                        }
                    }
                }));
            }
        });
        List classNameFunctionIds = functionMap.values().stream().flatMap(Collection::stream).map(functionObject -> functionObject.getFunctionCodes().stream().map(functionCode -> {
            if (existFunctionMap.containsKey(functionCode)) {
                Long functionId = ((PrdSystemNewFunctionDO)((Object)((Object)((Object)existFunctionMap.get(functionCode))))).getId();
                return functionObject.getClassName() + "_" + functionId;
            }
            return null;
        }).filter(Objects::nonNull).toList()).flatMap(Collection::stream).distinct().toList();
        List<Long> deleteFunctionObjectIds = existFunctionObjectList.stream().filter(item -> !classNameFunctionIds.contains(item.getClassName() + "_" + item.getFunctionId())).map(prdSystemPermissionFunctionObjectDO -> {
            functionSet.add(prdSystemPermissionFunctionObjectDO.getFunctionId());
            return prdSystemPermissionFunctionObjectDO.getId();
        }).toList();
        if (!CollectionUtils.isEmpty(deleteFunctionObjectIds)) {
            List<Long> funcIds = this.dao.getByIds(deleteFunctionObjectIds);
            this.dao.deleteByIds(deleteFunctionObjectIds);
            this.fieldDao.deleteByFunctionObjectIds(deleteFunctionObjectIds);
            List<Long> businessFieldIds = this.tableFieldsDAO.queryListByTableIds(funcIds);
            if (!CollectionUtils.isEmpty(businessFieldIds)) {
                this.tableFieldsDAO.deleteSoftCopy(businessFieldIds);
            }
            this.fieldObjRoleFunctionDAO.deleteByFunctionObjectIds(deleteFunctionObjectIds);
        }
        if (!CollectionUtils.isEmpty(insertList)) {
            List fieldDOS = this.fieldRepo.saveAll(insertList);
            List<Long> functionObjectIds = fieldDOS.stream().map(PrdSystemPermissionFieldDO::getFunctionObjectId).collect(Collectors.toList());
            List<Long> roleIds = this.fieldObjRoleFunctionDAO.queryRoleIdsByFunctionObjectIds(functionObjectIds);
            ArrayList<PrdSystemPermissionFieldObjRoleFunctionDO> list = new ArrayList<PrdSystemPermissionFieldObjRoleFunctionDO>();
            for (Long roleId : roleIds) {
                for (PrdSystemPermissionFieldDO fieldDO : fieldDOS) {
                    PrdSystemPermissionFieldObjRoleFunctionDO fieldObjRoleFunctionDO = new PrdSystemPermissionFieldObjRoleFunctionDO();
                    fieldObjRoleFunctionDO.setFieldId(fieldDO.getId());
                    fieldObjRoleFunctionDO.setFunctionObjectId(fieldDO.getFunctionObjectId());
                    fieldObjRoleFunctionDO.setRoleId(roleId);
                    fieldObjRoleFunctionDO.setIsVisible(0);
                    fieldObjRoleFunctionDO.setIsEdit(1);
                    list.add(fieldObjRoleFunctionDO);
                }
            }
            this.fieldObjRoleFunctionRepo.saveAll(list);
        }
        if (!CollectionUtils.isEmpty(syncInsertList)) {
            this.businessTableFieldsRepo.saveAll(syncInsertList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.fieldRepo.saveAll(updateList);
        }
        if (!CollectionUtils.isEmpty(deleteList)) {
            this.fieldDao.deleteByIds(deleteList);
        }
        if (!CollectionUtils.isEmpty(deleteList)) {
            this.fieldObjRoleFunctionDAO.deleteByFieldIds(deleteList);
        }
        if (!CollectionUtils.isEmpty(syncDeleteList)) {
            this.tableFieldsDAO.deleteSoftCopy(syncDeleteList);
        }
    }

    public List<PrdSystemPermissionFunctionObjectVO> queryByFunctionId(List<Long> functionIds) {
        return this.dao.queryByFunctionId(functionIds);
    }

    private void fillBusinessTableFieldDO(PrdSystemPermissionTableFieldsDO tableFieldsDO, PrdSystemPermissionFieldDO fieldDO, PrdSystemPermissionFunctionObjectDO functionObjectDO) {
        tableFieldsDO.setTableId(functionObjectDO.getFunctionId());
        tableFieldsDO.setType(fieldDO.getMappingField());
        tableFieldsDO.setExt3(fieldDO.getFieldType());
        tableFieldsDO.setField(this.humpToUnderline(fieldDO.getField()));
        tableFieldsDO.setFieldKey(fieldDO.getField());
        tableFieldsDO.setFieldName(fieldDO.getFieldName());
        tableFieldsDO.setShowName(fieldDO.getFieldName());
        tableFieldsDO.setBusinessFlag(true);
        tableFieldsDO.setNotNull(false);
    }

    private String humpToUnderline(String field) {
        String regex = "([A-Z])";
        Matcher matcher = Pattern.compile(regex).matcher(field);
        while (matcher.find()) {
            String group = matcher.group();
            field = field.replaceAll(group, "_" + group.toLowerCase());
        }
        return field;
    }

    public PrdSystemPermissionFunctionObjectServiceImpl(PrdSystemPermissionFunctionObjectRepo repo, PrdSystemPermissionFunctionObjectDAO dao, PrdSystemPermissionFieldRepo fieldRepo, PrdSystemPermissionFieldDAO fieldDao, PrdSystemNewFunctionRepo functionRepo, PrdSystemBusinessObjectDAO businessObjectDAO, PrdSystemPermissionTableFieldsRepo businessTableFieldsRepo, PrdSystemPermissionTableFieldsDAO tableFieldsDAO, PrdSystemPermissionFieldObjRoleFunctionDAO fieldObjRoleFunctionDAO, PrdSystemPermissionFieldObjRoleFunctionRepo fieldObjRoleFunctionRepo) {
        this.repo = repo;
        this.dao = dao;
        this.fieldRepo = fieldRepo;
        this.fieldDao = fieldDao;
        this.functionRepo = functionRepo;
        this.businessObjectDAO = businessObjectDAO;
        this.businessTableFieldsRepo = businessTableFieldsRepo;
        this.tableFieldsDAO = tableFieldsDAO;
        this.fieldObjRoleFunctionDAO = fieldObjRoleFunctionDAO;
        this.fieldObjRoleFunctionRepo = fieldObjRoleFunctionRepo;
    }
}

