/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionRuleDetailPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionRulePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionRuleQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissonRuleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldObjRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleDetailVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionFieldType;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionRuleSubTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionRuleType;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemPermissionRuleConvert;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemPermissionRuleDetailConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemPermissionRuleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemBusinessObjectDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemNewFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionRuleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionRuleDetailDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemBusinessObjectRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemNewFunctionRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionRuleDetailRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionRuleRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdSystemPermissionRuleServiceImpl
implements PrdSystemPermissonRuleService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemPermissionRuleServiceImpl.class);
    private final PrdSystemPermissionRuleDAO dao;
    private final PrdSystemPermissionRuleRepo repo;
    private final PrdSystemPermissionRuleDetailRepo detailRepo;
    private final RedisUtils redisUtils;
    private final PrdSystemBusinessObjectRepo objectRepo;
    private final PrdSystemNewFunctionRepo functionRepo;
    private static final String RULE_CACHE_PREFIX = "sys:permission:rule:";
    private static final String FIELD_RULE_CACHE_PREFIX = "sys:permission:field:rule:";

    @Transactional(rollbackFor={Exception.class})
    public void insert(PrdSystemPermissionRulePayload payload) {
        this.checkBindDataRule(payload);
        HashMap<String, String> map = new HashMap<String, String>();
        PrdSystemPermissionRuleDO entity = this.dao.queryPermissionRuleByCode(payload.getRuleCode());
        Assert.isNull((Object)((Object)entity), (String)"ruleCode\u4e0d\u80fd\u91cd\u590d");
        PrdSystemPermissionRuleDO entityDO = PrdSystemPermissionRuleConvert.INSTANCE.toDo(payload);
        entityDO.setRuleTypeName(Objects.requireNonNull(PermissionRuleType.find(entityDO.getRuleType())).getDesc());
        PrdSystemPermissionRuleDO entitySave = this.dao.saveBusinessObjectDataRule(entityDO);
        List detailList = payload.getDetailList();
        if (!CollectionUtils.isEmpty((Collection)detailList)) {
            for (PrdSystemPermissionRuleDetailPayload detailPayload : detailList) {
                if (!map.containsKey(detailPayload.getRuleDetailCode())) {
                    PrdSystemPermissionRuleDetailDO detailEntityDO = PrdSystemPermissionRuleDetailConvert.INSTANCE.toDo(detailPayload);
                    detailEntityDO.setRuleId(entitySave.getId());
                    this.dao.saveBusinessObjectDataRuleDetail(detailEntityDO);
                    map.put(detailPayload.getRuleDetailCode(), detailPayload.getRuleDetailCode());
                    continue;
                }
                Assert.isNull(map, (String)"ruleDetailCode\u4e0d\u80fd\u91cd\u590d");
            }
        }
        PrdSystemNewFunctionDO functionDO = this.functionRepo.findById(payload.getFunctionId()).orElseGet(PrdSystemNewFunctionDO::new);
        this.removeRuleCache(functionDO.getFunctionCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Long[] keys) {
        List ruleDOS = this.repo.findAllById(Arrays.asList(keys));
        this.dao.deletePermissonRuleByIds(keys);
        for (PrdSystemPermissionRuleDO ruleDO : ruleDOS) {
            PrdSystemNewFunctionDO newFunctionDO = this.functionRepo.findById(ruleDO.getFunctionId()).orElseGet(PrdSystemNewFunctionDO::new);
            this.removeRuleCache(newFunctionDO.getFunctionCode());
            List<Long> detailIds = this.dao.queryPermissionRuleDetailIdsByRuleId(ruleDO.getId());
            this.dao.deletePermissionRuleDetailByIds(detailIds);
        }
    }

    public PagingVO<PrdSystemPermissionRuleVO> paging(PrdSystemPermissionRuleQuery query) {
        this.checkQuery(query);
        return this.dao.queryPermissionRule(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(PrdSystemPermissionRulePayload payload) {
        this.checkUpdate(payload);
        PrdSystemPermissionRuleDO entity = this.repo.findById(payload.getId()).orElseGet(PrdSystemPermissionRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (StringUtils.hasText((String)payload.getRuleCode()) && !entity.getRuleCode().equals(payload.getRuleCode())) {
            Assert.isNull((Object)((Object)this.dao.queryPermissionRuleByCode(payload.getRuleCode())), (String)"ruleCode\u4e0d\u80fd\u91cd\u590d");
        }
        PrdSystemPermissionRuleDO entityDO = PrdSystemPermissionRuleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDO);
        this.changeEntity(entityDO, entity);
        entity.setRuleTypeName(Objects.requireNonNull(PermissionRuleType.find(entityDO.getRuleType())).getDesc());
        this.repo.save((Object)entity);
        List<Long> ids = this.dao.queryPermissionRuleDetailIdsByRuleId(entity.getId());
        this.detailRepo.deleteAllById(ids);
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<PrdSystemPermissionRuleDetailDO> list = new ArrayList<PrdSystemPermissionRuleDetailDO>();
        if (!CollectionUtils.isEmpty((Collection)payload.getDetailList())) {
            for (PrdSystemPermissionRuleDetailPayload detailPayload : payload.getDetailList()) {
                PrdSystemPermissionRuleDetailDO detailEntityDO = this.insertEntity(detailPayload, entity);
                if (!map.containsKey(detailEntityDO.getRuleDetailCode())) {
                    list.add(detailEntityDO);
                    map.put(detailEntityDO.getRuleDetailCode(), detailEntityDO.getRuleDetailCode());
                    continue;
                }
                Assert.isNull(map, (String)"ruleDetailCode\u4e0d\u80fd\u91cd\u590d");
            }
        }
        this.detailRepo.saveAll(list);
        PrdSystemNewFunctionDO functionDO = this.functionRepo.findById(payload.getFunctionId()).orElseGet(PrdSystemNewFunctionDO::new);
        this.removeRuleCache(functionDO.getFunctionCode());
    }

    private void changeEntity(PrdSystemPermissionRuleDO entityDO, PrdSystemPermissionRuleDO entity) {
        if (PermissionRuleType.USER.getName().equals(entityDO.getRuleType())) {
            entity.setRuleSubType(null);
            entity.setRuleSubTypeName(null);
            entity.setLevelScope(null);
            entity.setLevelScopeName(null);
        } else if (PermissionRuleType.ORG.getName().equals(entityDO.getRuleType())) {
            entity.setRuleSubType(null);
            entity.setRuleSubTypeName(null);
        } else if (PermissionRuleType.ROLE.getName().equals(entityDO.getRuleType()) && PermissionRuleSubTypeEnum.BUSINESS_ROLE.getName().equals(entityDO.getRuleSubType())) {
            entity.setLevelScope(null);
            entity.setLevelScopeName(null);
        }
    }

    private PrdSystemPermissionRuleDetailDO insertEntity(PrdSystemPermissionRuleDetailPayload detailPayload, PrdSystemPermissionRuleDO payload) {
        this.checkInsertEntity(detailPayload, payload);
        PrdSystemPermissionRuleDetailDO detailEntityDO = PrdSystemPermissionRuleDetailConvert.INSTANCE.toDo(detailPayload);
        return detailEntityDO;
    }

    private void checkInsertEntity(PrdSystemPermissionRuleDetailPayload detailPayload, PrdSystemPermissionRuleDO payload) {
        if (!StringUtils.hasText((String)detailPayload.getRuleDetailCode())) {
            throw TwException.error("", "detailCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public PrdSystemPermissionRuleVO get(Long key) {
        PrdSystemPermissionRuleDO ruleDO = this.repo.findById(key).orElseGet(PrdSystemPermissionRuleDO::new);
        PrdSystemPermissionRuleVO ruleVO = PrdSystemPermissionRuleConvert.INSTANCE.toVo(ruleDO);
        List<PrdSystemPermissionRuleDetailVO> ruleDetailVOS = this.dao.queryPermissionRuleDetailByRuleId(ruleVO.getId());
        String groupExpr = ruleVO.getGroupExpr().trim();
        for (int i = 0; i < ruleDetailVOS.size(); ++i) {
            if (i != 0) {
                ruleDetailVOS.get(i).setExpr(groupExpr.substring(0, 1));
                groupExpr = groupExpr.substring(ruleDetailVOS.get(i).getRuleDetailCode().length() + 1);
                continue;
            }
            groupExpr = groupExpr.substring(ruleDetailVOS.get(i).getRuleDetailCode().length());
        }
        ruleVO.setDetailList(ruleDetailVOS);
        return ruleVO;
    }

    private void checkUpdate(PrdSystemPermissionRulePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            throw TwException.error("", "\u6743\u9650\u89c4\u5219\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkQuery(PrdSystemPermissionRuleQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getFunctionId())) {
            throw TwException.error("", "functionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkBindDataRule(PrdSystemPermissionRulePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getFunctionId())) {
            throw TwException.error("", "functionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)payload.getRuleCode())) {
            throw TwException.error("", "ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public List<PrdSystemPermissionRuleVO> getAllByFunctionCode(String functionCode) {
        String redisKey = RULE_CACHE_PREFIX + functionCode;
        if (this.redisUtils.hasKey(redisKey)) {
            return (List)this.redisUtils.get(redisKey);
        }
        List<PrdSystemPermissionRuleVO> allByObjectCode = this.dao.getAllByFunctionCode(functionCode);
        if (CollectionUtils.isEmpty(allByObjectCode)) {
            return Collections.emptyList();
        }
        allByObjectCode.forEach(rule -> rule.setDetailList(this.dao.queryPermissionRuleDetailByRuleId(rule.getId())));
        this.redisUtils.set(redisKey, allByObjectCode);
        return allByObjectCode;
    }

    public PagingVO<PrdSystemPermissionRuleVO> pagingByUser(PrdSystemPermissionRuleQuery query) {
        this.checkQueryByUser(query);
        HashMap<Long, String> map = new HashMap<Long, String>();
        List<Long> orgLongs = this.dao.getAllOrgByUserId(query);
        query.setOrgIds(orgLongs.stream().map(String::valueOf).collect(Collectors.toList()));
        PagingVO<PrdSystemPermissionRuleVO> pagingVO = this.dao.queryPermissionRuleByUser(query);
        List records = pagingVO.getRecords();
        for (PrdSystemPermissionRuleVO record : records) {
            if (map.containsKey(record.getObjectId())) {
                record.setObjectName((String)map.get(record.getObjectId()));
                continue;
            }
            PrdSystemBusinessObjectDO objectDO = this.objectRepo.findById(record.getObjectId()).orElseGet(PrdSystemBusinessObjectDO::new);
            record.setObjectName(objectDO.getObjectName());
            map.put(objectDO.getId(), objectDO.getObjectName());
        }
        return pagingVO;
    }

    public List<PrdSystemPermissionFieldVO> listField(PrdSystemPermissionFieldQuery query) {
        this.checkListField(query);
        HashMap map = new HashMap();
        ArrayList<PrdSystemPermissionFieldVO> result = new ArrayList<PrdSystemPermissionFieldVO>();
        List<PrdSystemPermissionFieldVO> list = this.dao.queryPermissionFieldByFunctionId(query);
        for (PrdSystemPermissionFieldVO fieldVO : list) {
            if (map.containsKey(fieldVO.getFieldType())) {
                List fieldVOS = (List)map.get(fieldVO.getFieldType());
                fieldVOS.add(fieldVO);
                continue;
            }
            PrdSystemPermissionFieldVO fieldVO1 = new PrdSystemPermissionFieldVO();
            fieldVO1.setFieldType(fieldVO.getFieldType());
            ArrayList<PrdSystemPermissionFieldVO> fieldVOS = new ArrayList<PrdSystemPermissionFieldVO>();
            fieldVOS.add(fieldVO);
            fieldVO1.setList(fieldVOS);
            fieldVO1.setField(fieldVO.getFieldType());
            fieldVO1.setFieldName(PermissionFieldType.find(fieldVO.getFieldType()).getDesc());
            result.add(fieldVO1);
            map.put(fieldVO.getFieldType(), fieldVOS);
        }
        return result;
    }

    private void checkListField(PrdSystemPermissionFieldQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getFunctionId())) {
            throw TwException.error("", "functionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkQueryByUser(PrdSystemPermissionRuleQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getUserId())) {
            throw TwException.error("", "userId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)query.getRoleId())) {
            throw TwException.error("", "roleId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void removeRuleCache(String functionCode) {
        String redisKey = RULE_CACHE_PREFIX + functionCode;
        if (this.redisUtils.hasKey(redisKey)) {
            this.redisUtils.del(redisKey);
        }
    }

    public List<PrdSystemPermissionFieldObjRoleFunctionVO> getPermissionFieldRule(String objectCode, String className, String functionCode) {
        Object result;
        String redisKey = FIELD_RULE_CACHE_PREFIX + objectCode;
        if (this.redisUtils.hasKey(redisKey) && Objects.nonNull(result = this.redisUtils.hget(redisKey, functionCode + "_" + className))) {
            return (List)result;
        }
        List<PrdSystemPermissionFieldObjRoleFunctionVO> permissionFieldRule = this.dao.getPermissionFieldRule(objectCode, className, functionCode);
        if (CollectionUtils.isEmpty(permissionFieldRule)) {
            return Collections.emptyList();
        }
        this.redisUtils.hset(redisKey, functionCode + "_" + className, permissionFieldRule);
        return permissionFieldRule;
    }

    private void removeFieldRuleCache(String objectCode) {
        String redisKey = FIELD_RULE_CACHE_PREFIX + objectCode;
        if (this.redisUtils.hasKey(redisKey)) {
            this.redisUtils.del(redisKey);
        }
    }

    public PrdSystemPermissionRuleServiceImpl(PrdSystemPermissionRuleDAO dao, PrdSystemPermissionRuleRepo repo, PrdSystemPermissionRuleDetailRepo detailRepo, RedisUtils redisUtils, PrdSystemBusinessObjectRepo objectRepo, PrdSystemNewFunctionRepo functionRepo) {
        this.dao = dao;
        this.repo = repo;
        this.detailRepo = detailRepo;
        this.redisUtils = redisUtils;
        this.objectRepo = objectRepo;
        this.functionRepo = functionRepo;
    }
}

