/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRoleGroupPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleGroupQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleGroupService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleGroupVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemRoleConvert;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemRoleGroupConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleGroupDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleGroupDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleGroupRoleDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemRoleGroupRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemRoleRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdSystemRoleGroupServiceImpl
implements PrdSystemRoleGroupService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemRoleGroupServiceImpl.class);
    private final PrdSystemRoleGroupRepo repo;
    private final PrdSystemRoleGroupDAO dao;
    private final PrdSystemRoleRepo roleRepo;

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemRoleGroupVO insert(PrdSystemRoleGroupPayload payload) {
        this.check(payload);
        PrdSystemRoleGroupDO entityDo = PrdSystemRoleGroupConvert.INSTANCE.toDo(payload);
        this.repo.save(entityDo);
        return PrdSystemRoleGroupConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemRoleGroupVO update(PrdSystemRoleGroupPayload payload) {
        this.checkUpdate(payload);
        PrdSystemRoleGroupDO entity = this.repo.findById(payload.getId()).orElseGet(PrdSystemRoleGroupDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemRoleGroupDO entityDo = PrdSystemRoleGroupConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PrdSystemRoleGroupDO save = (PrdSystemRoleGroupDO)this.repo.save(entity);
        return PrdSystemRoleGroupConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!CollectionUtils.isEmpty(keys)) {
            this.repo.deleteSoft(keys);
        }
    }

    public PrdSystemRoleGroupVO get(Long id) {
        PrdSystemRoleGroupDO entity = this.repo.findById(id).orElseGet(PrdSystemRoleGroupDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemRoleGroupVO prdSystemRoleGroupVO = PrdSystemRoleGroupConvert.INSTANCE.toVo(entity);
        List<PrdSystemRoleGroupRoleDO> roleGroupRoleDOS = this.dao.queryByRole(id);
        ArrayList<PrdSystemRoleVO> roles = new ArrayList<PrdSystemRoleVO>();
        for (PrdSystemRoleGroupRoleDO roleGroupRoleDO : roleGroupRoleDOS) {
            PrdSystemRoleDO role = this.roleRepo.findById(roleGroupRoleDO.getRoleId()).orElseGet(PrdSystemRoleDO::new);
            PrdSystemRoleVO roleVO = PrdSystemRoleConvert.INSTANCE.toVo(role);
            roles.add(roleVO);
        }
        prdSystemRoleGroupVO.setRoleList(roles);
        return prdSystemRoleGroupVO;
    }

    public List<PrdSystemRoleGroupVO> listGroup(PrdSystemRoleGroupQuery query) {
        List<PrdSystemRoleGroupVO> roleGroupVOS = this.dao.queryByRoleGroupType(query.getRoleGroupType());
        List<PrdSystemRoleGroupRoleDO> roleGroupRoleDOS = this.dao.queryByRoles(roleGroupVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList()));
        List roleList = this.roleRepo.findAllById(roleGroupRoleDOS.stream().map(PrdSystemRoleGroupRoleDO::getRoleId).collect(Collectors.toSet()));
        Map<Long, PrdSystemRoleDO> collect = roleList.stream().collect(Collectors.toMap(BaseModel::getId, prdSystemRoleDO -> prdSystemRoleDO));
        for (PrdSystemRoleGroupVO next : roleGroupVOS) {
            ArrayList<PrdSystemRoleVO> roles = new ArrayList<PrdSystemRoleVO>();
            for (PrdSystemRoleGroupRoleDO roleGroupRoleDO : roleGroupRoleDOS) {
                PrdSystemRoleDO prdSystemRoleDO2;
                if (!next.getId().equals(roleGroupRoleDO.getRoleGroupId()) || ObjectUtils.isEmpty((Object)(prdSystemRoleDO2 = collect.get(roleGroupRoleDO.getRoleId())))) continue;
                roles.add(PrdSystemRoleConvert.INSTANCE.toVo(prdSystemRoleDO2));
            }
            next.setRoleList(roles);
        }
        return roleGroupVOS;
    }

    public List<PrdSystemRoleGroupVO> list(String roleGroupType) {
        return this.dao.queryByRoleGroupType(roleGroupType);
    }

    private void checkUpdate(PrdSystemRoleGroupPayload payload) {
        if (payload.getId() == null) {
            throw TwException.error("", "id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void check(PrdSystemRoleGroupPayload payload) {
        if (!StringUtils.hasText((String)payload.getRoleGroupName())) {
            throw TwException.error("", "roleGroupName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)payload.getRoleGroupType())) {
            throw TwException.error("", "roleGroupType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public PrdSystemRoleGroupServiceImpl(PrdSystemRoleGroupRepo repo, PrdSystemRoleGroupDAO dao, PrdSystemRoleRepo roleRepo) {
        this.repo = repo;
        this.dao = dao;
        this.roleRepo = roleRepo;
    }
}

