/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskSettleTimesheetPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskSettleTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5.server.prd.task.entity.QTaskInfoDO;
import com.elitesland.tw.tw5.server.prd.task.entity.QTaskPackageDO;
import com.elitesland.tw.tw5.server.prd.task.entity.QTaskSettleTimesheetDO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskSettleTimesheetDO;
import com.elitesland.tw.tw5.server.prd.task.repo.TaskSettleTimesheetRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class TaskSettleTimesheetDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final TaskSettleTimesheetRepo repo;
    private final QTaskSettleTimesheetDO qdo = QTaskSettleTimesheetDO.taskSettleTimesheetDO;
    private final QTaskInfoDO qTaskInfoDO = QTaskInfoDO.taskInfoDO;
    private final QTimesheetDO qTimesheetDO = QTimesheetDO.timesheetDO;
    private final QTaskPackageDO packageQdo = QTaskPackageDO.taskPackageDO;

    public List<TaskSettleTimesheetVO> queryTaskByReason(String reasonType, Long reasonId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TaskSettleTimesheetVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.relatedActId, this.qdo.eqva, this.qdo.taskId, this.qTaskInfoDO.taskName, this.packageQdo.reasonType, this.packageQdo.reasonId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qTaskInfoDO)).on((Predicate)this.qdo.taskId.eq(this.qTaskInfoDO.id))).leftJoin((EntityPath)this.packageQdo)).on((Predicate)this.qTaskInfoDO.taskPackageId.eq(this.packageQdo.id))).where((Predicate)this.packageQdo.reasonType.eq((Object)reasonType))).where((Predicate)this.packageQdo.reasonId.eq((Object)reasonId));
        return jpaQuery.fetch();
    }

    public List<TaskSettleTimesheetVO> queryTaskByReasons(List<String> reasonTypes, List<Long> reasonIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TaskSettleTimesheetVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.relatedActId, this.qdo.eqva, this.qdo.taskId, this.qTaskInfoDO.taskName, this.packageQdo.reasonType, this.packageQdo.reasonId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qTaskInfoDO)).on((Predicate)this.qdo.taskId.eq(this.qTaskInfoDO.id))).leftJoin((EntityPath)this.packageQdo)).on((Predicate)this.qTaskInfoDO.taskPackageId.eq(this.packageQdo.id))).where((Predicate)this.packageQdo.reasonType.in(reasonTypes))).where((Predicate)this.packageQdo.reasonId.in(reasonIds));
        return jpaQuery.fetch();
    }

    private JPAQuery<TaskSettleTimesheetVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TaskSettleTimesheetVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.taskId, this.qTaskInfoDO.taskName, this.qdo.settleId, this.qdo.timesheetId, this.qTimesheetDO.tsUserId, this.qdo.workHour, this.qdo.eqva, this.qdo.workDate, this.qdo.workDesc, this.qdo.settleFlag})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qTaskInfoDO)).on((Predicate)this.qdo.taskId.eq(this.qTaskInfoDO.id))).leftJoin((EntityPath)this.qTimesheetDO)).on((Predicate)this.qdo.timesheetId.eq(this.qTimesheetDO.id));
    }

    private JPAQuery<TaskSettleTimesheetVO> getJpaQueryWhere(TaskSettleTimesheetQuery query) {
        JPAQuery<TaskSettleTimesheetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(TaskSettleTimesheetQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qTaskInfoDO)).on((Predicate)this.qdo.taskId.eq(this.qTaskInfoDO.id))).leftJoin((EntityPath)this.qTimesheetDO)).on((Predicate)this.qdo.timesheetId.eq(this.qTimesheetDO.id));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(TaskSettleTimesheetQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskId())) {
            list.add(this.qdo.taskId.eq((Object)query.getTaskId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskIds())) {
            list.add(this.qdo.taskId.in((Collection)query.getTaskIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettleId())) {
            list.add(this.qdo.settleId.eq((Object)query.getSettleId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettleIds())) {
            list.add(this.qdo.settleId.in((Collection)query.getSettleIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTimesheetId())) {
            list.add(this.qdo.timesheetId.eq((Object)query.getTimesheetId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkHour())) {
            list.add(this.qdo.workHour.eq((Object)query.getWorkHour()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEqva())) {
            list.add(this.qdo.eqva.eq((Object)query.getEqva()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkDate())) {
            list.add(this.qdo.workDate.eq((Object)query.getWorkDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkDesc())) {
            list.add(this.qdo.workDesc.like(SqlUtil.toSqlLikeString(query.getWorkDesc())));
        }
        if (query.getSettleFlag() != null) {
            list.add(this.qdo.settleFlag.eq((Object)query.getSettleFlag()));
        }
        return ExpressionUtils.allOf(list);
    }

    public TaskSettleTimesheetVO queryByKey(Long id) {
        JPAQuery<TaskSettleTimesheetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (TaskSettleTimesheetVO)jpaQuery.fetchFirst();
    }

    public TaskSettleTimesheetVO queryByTimesheetId(Long timesheetId) {
        JPAQuery<TaskSettleTimesheetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.timesheetId.eq((Object)timesheetId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (TaskSettleTimesheetVO)jpaQuery.fetchFirst();
    }

    public List<TaskSettleTimesheetVO> queryListDynamic(TaskSettleTimesheetQuery query) {
        JPAQuery<TaskSettleTimesheetVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public List<TaskSettleTimesheetDO> queryList(TaskSettleTimesheetQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    public PagingVO<TaskSettleTimesheetVO> queryPaging(TaskSettleTimesheetQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<TaskSettleTimesheetVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public TaskSettleTimesheetDO save(TaskSettleTimesheetDO ado) {
        return (TaskSettleTimesheetDO)this.repo.save(ado);
    }

    public List<TaskSettleTimesheetDO> saveAll(List<TaskSettleTimesheetDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(TaskSettleTimesheetPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getTaskId() != null) {
            update.set(this.qdo.taskId, (Object)payload.getTaskId());
        }
        if (payload.getSettleId() != null) {
            update.set(this.qdo.settleId, (Object)payload.getSettleId());
        }
        if (payload.getTimesheetId() != null) {
            update.set(this.qdo.timesheetId, (Object)payload.getTimesheetId());
        }
        if (payload.getWorkHour() != null) {
            update.set(this.qdo.workHour, (Object)payload.getWorkHour());
        }
        if (payload.getEqva() != null) {
            update.set(this.qdo.eqva, (Object)payload.getEqva());
        }
        if (payload.getWorkDate() != null) {
            update.set(this.qdo.workDate, (Object)payload.getWorkDate());
        }
        if (payload.getWorkDesc() != null) {
            update.set((Path)this.qdo.workDesc, (Object)payload.getWorkDesc());
        }
        if (payload.getSettleFlag() != null) {
            update.set(this.qdo.settleFlag, (Object)payload.getSettleFlag());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("taskId")) {
                update.setNull(this.qdo.taskId);
            }
            if (nullFields.contains("settleId")) {
                update.setNull(this.qdo.settleId);
            }
            if (nullFields.contains("timesheetId")) {
                update.setNull(this.qdo.timesheetId);
            }
            if (nullFields.contains("workHour")) {
                update.setNull(this.qdo.workHour);
            }
            if (nullFields.contains("eqva")) {
                update.setNull(this.qdo.eqva);
            }
            if (nullFields.contains("workDate")) {
                update.setNull(this.qdo.workDate);
            }
            if (nullFields.contains("workDesc")) {
                update.setNull((Path)this.qdo.workDesc);
            }
            if (nullFields.contains("settleFlag")) {
                update.setNull(this.qdo.settleFlag);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public TaskSettleTimesheetDAO(JPAQueryFactory jpaQueryFactory, TaskSettleTimesheetRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

