/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectMembersService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPackagePayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskPackageConvert;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskPackageDAO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskPackageDO;
import com.elitesland.tw.tw5.server.prd.task.repo.TaskPackageRepo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class TaskPackageServiceImpl
extends BaseServiceImpl
implements TaskPackageService {
    private static final Logger log = LoggerFactory.getLogger(TaskPackageServiceImpl.class);
    private final TaskPackageRepo taskPackageRepo;
    private final TaskPackageDAO taskPackageDAO;
    private final TaskInfoDAO taskInfoDAO;
    private final TaskInfoService taskInfoService;
    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;
    private final PrdCompositeAbilityService prdCompositeAbilityService;
    private final CacheUtil cacheUtil;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final PmsProjectMembersService pmsProjectMembersService;
    private final PrjProjectDAO projectDAO;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    public TaskPackageVO initTaskPackage(String reasonType, Long reasonId, Long receiverResId) {
        if (ObjectUtils.isEmpty((Object)reasonType)) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reasonId)) {
            throw TwException.error("", "\u4e8b\u7531ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)receiverResId)) {
            throw TwException.error("", "\u63a5\u4fdd\u8d44\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        TaskPackageVO taskPackageVO = new TaskPackageVO();
        taskPackageVO.setTaskPackageStatus(TaskStatusEnum.CREATE.getCode());
        taskPackageVO.setDisterResId(GlobalUtil.getLoginUserId());
        taskPackageVO.setReceiverResId(receiverResId);
        taskPackageVO.setReceiverBuId(this.cacheUtil.getDefaultOrgIdByUserId(receiverResId));
        taskPackageVO.setReasonId(reasonId);
        taskPackageVO.setReasonType(reasonType);
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.querySimpleProjectByKey(reasonId);
            if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
                throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            taskPackageVO.setReasonName(pmsProjectVO.getProjName());
            taskPackageVO.setSettlePrice(pmsProjectVO.getEqvaPrice());
            taskPackageVO.setAcceptorId(pmsProjectVO.getPmResId());
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = this.buProjectService.queryByKey(reasonId);
            if (ObjectUtils.isEmpty((Object)buProjectVO)) {
                throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            taskPackageVO.setReasonName(buProjectVO.getProjName());
            taskPackageVO.setSettlePrice(buProjectVO.getEqvaPrice());
            taskPackageVO.setAcceptorId(buProjectVO.getPmResId());
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery query = new CrmOpportunityQuery();
            query.setProjectId(reasonId);
            List crmOpportunityListVOS = this.opportunityService.queryListDynamic(query);
            if (ObjectUtils.isEmpty((Object)crmOpportunityListVOS)) {
                throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            CrmOpportunityListVO crmOpportunityListVO = (CrmOpportunityListVO)crmOpportunityListVOS.get(0);
            taskPackageVO.setReasonName(crmOpportunityListVO.getProjectName());
            taskPackageVO.setSettlePrice(crmOpportunityListVO.getEqvaPrice());
            taskPackageVO.setAcceptorId(crmOpportunityListVO.getPreSaleUserId());
        }
        if (taskPackageVO.getSettlePrice() == null) {
            taskPackageVO.setSettlePrice(BigDecimal.valueOf(2000L));
        }
        PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery = new PrdEmployeCompositeAbilityQuery();
        prdEmployeCompositeAbilityQuery.setUserId(receiverResId);
        prdEmployeCompositeAbilityQuery.setMainFlag(Boolean.valueOf(true));
        List employeCompositeAbilityVOS = this.prdEmployeCompositeAbilityService.getList(prdEmployeCompositeAbilityQuery);
        if (!ObjectUtils.isEmpty((Object)employeCompositeAbilityVOS)) {
            PrdEmployeCompositeAbilityVO employeCompositeAbilityVO = (PrdEmployeCompositeAbilityVO)employeCompositeAbilityVOS.get(0);
            taskPackageVO.setCompositeAbilityId(employeCompositeAbilityVO.getAbilityId());
            taskPackageVO.setCompositeAbilityName(employeCompositeAbilityVO.getAbilityName());
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setDocNo(employeCompositeAbilityVO.getDocNo());
            List compositeAbilityVOS = this.prdCompositeAbilityService.getList(prdCompositeAbilityQuery);
            if (!ObjectUtils.isEmpty((Object)compositeAbilityVOS)) {
                PrdCompositeAbilityVO compositeAbilityVO = (PrdCompositeAbilityVO)compositeAbilityVOS.get(0);
                taskPackageVO.setJobType1(compositeAbilityVO.getJobType1());
                taskPackageVO.setJobType2(compositeAbilityVO.getJobType2());
            }
        }
        return taskPackageVO;
    }

    public TaskPackageVO queryByKey(Long key, Boolean needTasks) {
        PrdCompositeAbilityVO compositeAbilityVO;
        TaskPackageVO taskPackageVO = this.taskPackageDAO.queryByKey(key);
        if (ObjectUtils.isEmpty((Object)taskPackageVO)) {
            throw TwException.error("", "\u4efb\u52a1\u5305\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!ObjectUtils.isEmpty((Object)taskPackageVO.getCompositeAbilityId()) && !ObjectUtils.isEmpty((Object)(compositeAbilityVO = this.prdCompositeAbilityService.get(taskPackageVO.getCompositeAbilityId())))) {
            taskPackageVO.setCompositeAbilityName(compositeAbilityVO.getName());
        }
        if (needTasks != null && needTasks.booleanValue()) {
            List<TaskInfoVO> taskInfoVOS = this.taskInfoDAO.queryByTaskPackageId(key);
            if (!ObjectUtils.isEmpty(taskInfoVOS)) {
                BigDecimal totalEqva = taskInfoVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getTotalEqva())).map(TaskInfoVO::getTotalEqva).reduce(BigDecimal.ZERO, BigDecimal::add);
                taskPackageVO.setTotalEqva(totalEqva);
                taskPackageVO.setTotalAmt(totalEqva.multiply(taskPackageVO.getIncomePrice()));
                taskPackageVO.setTaskInfoVOS(taskInfoVOS);
            }
        } else {
            BigDecimal totalEqva = this.taskInfoDAO.queryTotalEqvaByTaskPackageId(key);
            if (totalEqva != null) {
                taskPackageVO.setTotalEqva(totalEqva);
                taskPackageVO.setTotalAmt(totalEqva.multiply(taskPackageVO.getIncomePrice()));
            }
        }
        return taskPackageVO;
    }

    public PagingVO<TaskPackageVO> queryPaging(TaskPackageQuery query) {
        PagingVO<TaskPackageVO> taskPackageVO = this.taskPackageDAO.queryPaging(query);
        if (taskPackageVO.getTotal() > 0L) {
            List<Long> collect = taskPackageVO.getRecords().stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<TaskInfoVO> taskInfoVOS = this.taskInfoDAO.queryByTaskPackageIds(collect);
            taskPackageVO.getRecords().forEach(packageVO -> {
                BigDecimal totalEqva = taskInfoVOS.stream().filter(taskInfoVO -> taskInfoVO.getTaskPackageId().equals(packageVO.getId())).map(TaskInfoVO::getTotalEqva).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                packageVO.setTotalEqva(totalEqva);
                packageVO.setTotalAmt(totalEqva.multiply(packageVO.getIncomePrice()));
            });
        }
        return taskPackageVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskPackageVO addTaskPackageByMember(TaskPackagePayload taskPackagePayload) {
        this.checkData(taskPackagePayload);
        String reasonType = taskPackagePayload.getReasonType();
        Long reasonId = taskPackagePayload.getReasonId();
        String reasonName = taskPackagePayload.getReasonName();
        Long receiverResId = taskPackagePayload.getReceiverResId();
        LocalDate startDate = taskPackagePayload.getStartDate();
        LocalDate endDate = taskPackagePayload.getEndDate();
        taskPackagePayload.setReceiverBuId(this.cacheUtil.getDefaultOrgIdByUserId(receiverResId));
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getAcceptorId())) {
            taskPackagePayload.setAcceptorId(GlobalUtil.getLoginUserId());
        }
        taskPackagePayload.setTaskPackageStatus(TaskStatusEnum.CREATE.getCode());
        List taskInfoPayloads = taskPackagePayload.getTaskInfoPayloads();
        String taskPackageName = reasonName + "\u4efb\u52a1\u5305-" + this.cacheUtil.getUserName(receiverResId) + "-" + startDate.toString() + "~" + endDate.toString();
        taskPackagePayload.setTaskPackageName(taskPackageName);
        TaskPackageDO taskPackageDO = TaskPackageConvert.INSTANCE.toDo(taskPackagePayload);
        taskPackageDO = this.taskPackageDAO.save(taskPackageDO);
        Long taskPackageId = taskPackageDO.getId();
        if (!ObjectUtils.isEmpty((Object)taskInfoPayloads)) {
            taskInfoPayloads.forEach(taskInfoPayload -> {
                taskInfoPayload.setTaskPackageId(taskPackageId);
                taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                taskInfoPayload.setTaskResId(receiverResId);
                taskInfoPayload.setTaskApplyFlag(Integer.valueOf(0));
                taskInfoPayload.setReasonType(reasonType);
                taskInfoPayload.setReasonId(reasonId);
                taskInfoPayload.setDisterResId(null);
            });
            this.taskInfoService.batchSave(taskInfoPayloads);
        }
        return TaskPackageConvert.INSTANCE.toVo(taskPackageDO);
    }

    public TaskPackageVO addTaskPackage(TaskPackagePayload taskPackagePayload) {
        taskPackagePayload.setId(null);
        this.checkData(taskPackagePayload);
        Long receiverResId = taskPackagePayload.getReceiverResId();
        taskPackagePayload.setReceiverBuId(this.cacheUtil.getDefaultOrgIdByUserId(receiverResId));
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getAcceptorId())) {
            taskPackagePayload.setAcceptorId(taskPackagePayload.getDisterResId());
        }
        taskPackagePayload.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
        String taskPackageName = taskPackagePayload.getReasonName() + "\u4efb\u52a1\u5305-" + this.cacheUtil.getUserName(receiverResId) + "-" + taskPackagePayload.getStartDate().toString() + "~" + taskPackagePayload.getEndDate().toString();
        taskPackagePayload.setTaskPackageName(taskPackageName);
        TaskPackageDO taskPackageDO = TaskPackageConvert.INSTANCE.toDo(taskPackagePayload);
        taskPackageDO = this.taskPackageDAO.save(taskPackageDO);
        if (taskPackagePayload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            this.pmsProjectMembersService.insertFromTask(taskPackagePayload.getReasonId(), receiverResId);
        }
        return TaskPackageConvert.INSTANCE.toVo(taskPackageDO);
    }

    void checkData(TaskPackagePayload taskPackagePayload) {
        BigDecimal eqvaRatio;
        if (!ObjectUtils.isEmpty((Object)taskPackagePayload.getId())) {
            TaskPackageVO taskPackageVO = this.taskPackageDAO.queryByKey(taskPackagePayload.getId());
            if (taskPackageVO == null) {
                throw TwException.error("", "\u7f16\u8f91\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
            }
            if (!taskPackageVO.getTaskPackageStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u4fee\u6539");
            }
        }
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getReasonType())) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getReasonId())) {
            throw TwException.error("", "\u4e8b\u7531ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getReceiverResId())) {
            throw TwException.error("", "\u63a5\u6536\u8d44\u6e90ID\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getStartDate())) {
            throw TwException.error("", "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getEndDate())) {
            throw TwException.error("", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getAcceptMethod())) {
            throw TwException.error("", "\u9a8c\u6536\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getPricingMethod())) {
            throw TwException.error("", "\u8ba1\u4ef7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getIncomePrice())) {
            throw TwException.error("", "\u5f53\u91cf\u6536\u5165\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskPackagePayload.getSettlePrice())) {
            throw TwException.error("", "\u9884\u7b97\u6536\u5165\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        BigDecimal guaranteeRate = taskPackagePayload.getGuaranteeRate();
        if (ObjectUtils.isEmpty((Object)guaranteeRate)) {
            taskPackagePayload.setGuaranteeRate(BigDecimal.ZERO);
        } else {
            if (guaranteeRate.compareTo(BigDecimal.ZERO) < 0) {
                throw TwException.error("", "\u8d28\u4fdd\u91d1\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e0%\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (guaranteeRate.compareTo(BigDecimal.ONE) >= 0) {
                throw TwException.error("", "\u8d28\u4fdd\u91d1\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e100%\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        }
        if (taskPackagePayload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(taskPackagePayload.getReasonId());
            if (pmsProjectVO == null) {
                throw TwException.error("", "\u6d3e\u53d1\u9879\u76ee\u5b58\u5728");
            }
            if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u9879\u76ee\u6fc0\u6d3b\u72b6\u6001\u6d3e\u53d1");
            }
            taskPackagePayload.setReasonName(pmsProjectVO.getProjName());
            taskPackagePayload.setDisterResId(pmsProjectVO.getPmResId());
        }
        if (taskPackagePayload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery query = new CrmOpportunityQuery();
            query.setProjectId(taskPackagePayload.getReasonId());
            List crmOpportunityListVOS = this.opportunityService.queryListDynamic(query);
            if (ObjectUtils.isEmpty((Object)crmOpportunityListVOS)) {
                throw TwException.error("", "\u4e8b\u7531\u4e0d\u5b58\u5728");
            }
            CrmOpportunityListVO crmOpportunityVO = (CrmOpportunityListVO)crmOpportunityListVOS.get(0);
            if (!crmOpportunityVO.getProjectStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u9879\u76ee\u6fc0\u6d3b\u72b6\u6001\u6d3e\u53d1");
            }
            taskPackagePayload.setReasonName(crmOpportunityVO.getProjectName());
            taskPackagePayload.setDisterResId(crmOpportunityVO.getPreSaleUserId());
        }
        if (taskPackagePayload.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = this.buProjectService.queryByKey(taskPackagePayload.getReasonId());
            if (buProjectVO == null) {
                throw TwException.error("", "\u6d3e\u53d1\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            if (!buProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u6fc0\u6d3b\u9879\u76ee\u6d3e\u53d1");
            }
            if (buProjectVO.getProjYear().intValue() != LocalDate.now().getYear()) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u672c\u5e74\u5ea6\u9879\u76ee\u6d3e\u53d1");
            }
            taskPackagePayload.setReasonName(buProjectVO.getProjName());
            taskPackagePayload.setDisterResId(buProjectVO.getPmResId());
        }
        if ((eqvaRatio = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(taskPackagePayload.getReceiverResId(), null)) == null) {
            throw TwException.error("", "\u5f53\u91cf\u7cfb\u6570\u83b7\u53d6\u5931\u8d25");
        }
        taskPackagePayload.setEqvaRatio(eqvaRatio);
    }

    public List<TaskPackageVO> taskPackageList(TaskPackageQuery taskPackageQuery) {
        List<TaskPackageVO> taskPackageVOS = this.taskPackageDAO.queryListDynamic(taskPackageQuery);
        if (!ObjectUtils.isEmpty(taskPackageVOS) && taskPackageQuery.getReceiverResId() != null && TaskStatusEnum.INPROCESS.getCode().equals(taskPackageQuery.getTaskPackageStatus())) {
            BigDecimal eqvaRatio = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(taskPackageQuery.getReceiverResId(), LocalDate.now());
            taskPackageVOS.forEach(vo -> {
                Boolean createTaskFlage = false;
                if ((vo.getEqvaRatio() == null ? BigDecimal.ZERO : vo.getEqvaRatio()).compareTo(eqvaRatio) == 0) {
                    createTaskFlage = true;
                }
                vo.setCreateTaskFlag(createTaskFlage);
            });
        }
        return taskPackageVOS;
    }

    public long taskPackageCount(TaskPackageQuery taskPackageQuery) {
        return this.taskPackageDAO.count(taskPackageQuery);
    }

    public List<TaskPackageVO> taskMyPackageList(TaskPackageQuery taskPackageQuery) {
        taskPackageQuery.setReceiverResId(GlobalUtil.getLoginUserId());
        taskPackageQuery.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
        if (taskPackageQuery.getReasonId() != null) {
            if (taskPackageQuery.getReasonId() == 0L) {
                taskPackageQuery.setReasonId(null);
                List<String> strings = Arrays.asList(PmsReasonTypeEnum.PROJ_BU.getCode(), PmsReasonTypeEnum.PROJ_OPPO.getCode());
                taskPackageQuery.setReasonTypes(strings);
            } else {
                taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            }
        }
        return this.taskPackageDAO.queryListDynamic(taskPackageQuery);
    }

    public List<TaskPackageVO> taskMyPackageListDib(TaskPackageQuery taskPackageQuery) {
        taskPackageQuery.setReceiverResId(GlobalUtil.getLoginUserId());
        taskPackageQuery.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
        return this.taskPackageDAO.queryListDynamic(taskPackageQuery);
    }

    public long updateByKeyDynamic(TaskPackagePayload payload) {
        return this.taskPackageDAO.updateByKeyDynamic(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<TaskPackageVO> taskPackageVOS = this.taskPackageDAO.queryByKeys(keys);
            long count = taskPackageVOS.stream().filter(vo -> !vo.getTaskPackageStatus().equals(TaskStatusEnum.CREATE.getCode())).count();
            if (count > 0L) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u4e0b\u7684\u4efb\u52a1\u5305\u5220\u9664");
            }
            this.taskPackageDAO.deleteSoft(keys);
            this.taskInfoDAO.deleteSoftByPackageIds(keys);
        }
    }

    public TaskPackageServiceImpl(TaskPackageRepo taskPackageRepo, TaskPackageDAO taskPackageDAO, TaskInfoDAO taskInfoDAO, TaskInfoService taskInfoService, PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService, PrdCompositeAbilityService prdCompositeAbilityService, CacheUtil cacheUtil, PmsProjectService pmsProjectService, BuProjectService buProjectService, CrmOpportunityService opportunityService, PmsProjectMembersService pmsProjectMembersService, PrjProjectDAO projectDAO, PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService) {
        this.taskPackageRepo = taskPackageRepo;
        this.taskPackageDAO = taskPackageDAO;
        this.taskInfoDAO = taskInfoDAO;
        this.taskInfoService = taskInfoService;
        this.prdEmployeCompositeAbilityService = prdEmployeCompositeAbilityService;
        this.prdCompositeAbilityService = prdCompositeAbilityService;
        this.cacheUtil = cacheUtil;
        this.pmsProjectService = pmsProjectService;
        this.buProjectService = buProjectService;
        this.opportunityService = opportunityService;
        this.pmsProjectMembersService = pmsProjectMembersService;
        this.projectDAO = projectDAO;
        this.prdOrgEmployeeEqvaRatioService = prdOrgEmployeeEqvaRatioService;
    }
}

