/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConWorkTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStageEnum;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/SALE_CON_ACTIVE/callBack"})
@Transactional
public class SaleConActiveWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(SaleConActiveWorkflowCallBackController.class);
    private final SaleConContractService saleConContractService;
    private final SaleConContractDAO saleConContractDAO;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final BusinessPartnerService businessPartnerService;
    private final PmsProjectService pmsProjectService;
    private final SaleConExecConditionService saleConExecConditionService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        Long id = Long.parseLong(payload.getBusinessKey());
        String bizManagerKey = "Activity_0mg79e2";
        String bizManagerPreApproveKey = "Activity_0bde39j";
        if ("Activity_0mg79e2".equals(payload.getTaskKey()) && !ObjectUtils.isEmpty((Object)payload.getBusinessKey())) {
            BusinessPartnerVO businessPartnerVO;
            SaleConContractPayload saleConContractPayload = new SaleConContractPayload();
            saleConContractPayload.setId(id);
            saleConContractPayload.setStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            saleConContractPayload.setProcInstStatus(ProcInstStatus.APPROVED);
            saleConContractPayload.setAcitveDate(LocalDate.now());
            saleConContractPayload.setApprovedTime(LocalDateTime.now());
            this.saleConContractDAO.updateByKeyDynamic(saleConContractPayload);
            this.saleConContractService.activeVirtualContractCompleted(id);
            SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(Long.valueOf(payload.getBusinessKey()), new Boolean[0]);
            Long custId = saleConContractVO.getCustId();
            if (custId != null && (businessPartnerVO = this.businessPartnerService.queryCustomerByBookId(custId)) != null) {
                BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
                businessCustomerInfoPayload.setId(businessPartnerVO.getBusinessCustomerInfoId());
                businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.OFFICIAL.getCode());
                this.businessCustomerInfoService.update(businessCustomerInfoPayload);
            }
            SaleConWorkTypeEnum saleConWorkTypeEnum = null;
            saleConWorkTypeEnum = SaleConWorkTypeEnum.TM.getCode().equals(saleConContractVO.getWorkType()) ? SaleConWorkTypeEnum.TM : SaleConWorkTypeEnum.valueOf(saleConContractVO.getWorkType());
            switch (saleConWorkTypeEnum) {
                case PURETRADE: 
                case INDEPENDENT: {
                    PmsProjectPayload pmsProjectPayload = this.pmsProjectService.autoCreateProject(saleConContractVO);
                    log.info("\u9879\u76ee\u7ec4\u88c5\u5b8c\u6210----------------");
                    log.info("pmsProjectPayload:::::::" + pmsProjectPayload.toString());
                    this.pmsProjectService.insertOrUpdate(pmsProjectPayload);
                    log.info("\u9879\u76ee\u63d2\u5165\u6210\u529f-----------------");
                    break;
                }
            }
        }
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        WorkFlowStatusEnum initStatus;
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        SaleConContractPayload saleConContractPayload = new SaleConContractPayload();
        saleConContractPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(Long.valueOf(businessKey), new Boolean[0]);
        WorkFlowStatusEnum workFlowStatusEnum = initStatus = saleConContractVO.getPlatType().equals(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode()) ? WorkFlowStatusEnum.ACTIVE_WAITING : WorkFlowStatusEnum.CREATE_WORK;
        if (saleConContractVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    saleConContractPayload.setStatus(initStatus.getCode());
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    saleConContractPayload.setStatus(initStatus.getCode());
                    saleConContractPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    saleConContractPayload.setStatus(initStatus.getCode());
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    initStatus = saleConContractVO.getPlatType().equals(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode()) ? WorkFlowStatusEnum.ACTIVE_WAITING : WorkFlowStatusEnum.REJECTED_WORK;
                    saleConContractPayload.setStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    break;
                }
                case APPROVING: {
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    saleConContractPayload.setStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.saleConContractDAO.updateByKeyDynamic(saleConContractPayload);
        }
        return WorkflowResult.success(null);
    }

    public SaleConActiveWorkflowCallBackController(SaleConContractService saleConContractService, SaleConContractDAO saleConContractDAO, BusinessCustomerInfoService businessCustomerInfoService, BusinessPartnerService businessPartnerService, PmsProjectService pmsProjectService, SaleConExecConditionService saleConExecConditionService) {
        this.saleConContractService = saleConContractService;
        this.saleConContractDAO = saleConContractDAO;
        this.businessCustomerInfoService = businessCustomerInfoService;
        this.businessPartnerService = businessPartnerService;
        this.pmsProjectService = pmsProjectService;
        this.saleConExecConditionService = saleConExecConditionService;
    }
}

