/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.yeedoc.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.server.common.util.JwtUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class YeedocServiceImpl
implements YeedocService {
    private static final Logger log = LoggerFactory.getLogger(YeedocServiceImpl.class);
    private final ApiRequestLogService apiRequestLogService;
    private final YeedocProperties yeedocProperties;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    @Override
    public String createFolder(Map<String, Object> map, String authToken) {
        String createFolderUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/CreatrFolderForTw";
        log.info("[\u6613\u9053\u58f3]-createFolderUrl:{}", (Object)createFolderUrl);
        return this.executePost(createFolderUrl, map, authToken);
    }

    @Override
    public String createFolder(Map<String, Object> map) {
        String yeedocJwt = this.getYeedocJwt();
        String createFolderUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/CreatrFolderForTw";
        log.info("[\u6613\u9053\u58f3]-createFolderUrl:{}", (Object)createFolderUrl);
        return this.executePost(createFolderUrl, map, yeedocJwt);
    }

    @Override
    public String reNameFolder(Map<String, Object> map, String authToken) {
        String reNameFolderUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/ReName";
        log.info("[\u6613\u9053\u58f3]-createFolderUrl:{}", (Object)reNameFolderUrl);
        return this.executePost(reNameFolderUrl, map, authToken);
    }

    @Override
    public String reNameFolder(Map<String, Object> map) {
        String yeedocJwt = this.getYeedocJwt();
        String reNameFolderUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/ReName";
        log.info("[\u6613\u9053\u58f3]-createFolderUrl:{}", (Object)reNameFolderUrl);
        return this.executePost(reNameFolderUrl, map, yeedocJwt);
    }

    @Override
    public String newUploadFilesSave(Map<String, Object> map, String authToken) {
        String newUploadFilesSaveUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/NewUploadFilesSave";
        log.info("[\u6613\u9053\u58f3]-newUploadFilesSave:{}", (Object)newUploadFilesSaveUrl);
        return this.executePost(newUploadFilesSaveUrl, map, authToken);
    }

    @Override
    public String getCaCheKeyItemId(Map<String, Object> map, String authToken) {
        String getCaCheKeyItemIdUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetCaCheKeyItemId";
        log.info("[\u6613\u9053\u58f3]-getCaCheKeyItemId:{}", (Object)getCaCheKeyItemIdUrl);
        return this.executePost(getCaCheKeyItemIdUrl, map, authToken);
    }

    @Override
    public String setPermission(String itemId, List<String> permissionIds) {
        String yeedocJwt = this.getYeedocJwt();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("itemid", itemId);
        map.put("PermissionIds", permissionIds);
        String setPermissionUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/SetPermissionObject";
        log.info("[\u9879\u76ee\u6587\u6863-\u6613\u9053\u58f3]-setPermissionUrl:{}", (Object)setPermissionUrl);
        return this.executePost(setPermissionUrl, map, yeedocJwt);
    }

    @Override
    public String preViewItem(String itemId) {
        String token = this.getToken();
        String externalToken = this.base64Encrypt(token);
        String preViewItemUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/api/item/external/previewitem/" + itemId + "?ExternalSource=" + this.yeedocProperties.getExternalSource() + "&ExternalToken=" + externalToken;
        log.debug("[\u6613\u9053\u58f3]-preViewItemUrl:{}", (Object)preViewItemUrl);
        return this.executePost(preViewItemUrl, new HashMap<String, Object>(3));
    }

    @Override
    public String preViewItemPro(String itemId) {
        String yeedocJwt = this.getYeedocJwt();
        String preViewItemUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetItemDetailForTwCrm";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ItemId", itemId);
        log.info("[\u9879\u76ee\u6587\u6863-\u6613\u9053\u58f3]-preViewItemUrl:{}", (Object)preViewItemUrl);
        return this.executePost(preViewItemUrl, map, yeedocJwt);
    }

    @Override
    public String deleteItem(String itemId) {
        String yeedocJwt = this.getYeedocJwt();
        return this.deleteItem(itemId, yeedocJwt);
    }

    @Override
    public String deleteItem(String itemId, String authToken) {
        String deleteItemUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/ItemRecycled";
        log.info("[\u9879\u76ee\u6587\u6863-\u6613\u9053\u58f3]-deleteItemUrl:{}", (Object)deleteItemUrl);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ItemId", Collections.singletonList(itemId));
        return this.executePost(deleteItemUrl, map, authToken);
    }

    @Override
    public String getYeedocJwt(SysUserDTO loginUser) {
        String sercretKey = this.yeedocProperties.getSercretKey();
        HashMap<String, String> payloadMap = new HashMap<String, String>();
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        userInfoMap.put("LoginName", loginUser.getEmail());
        userInfoMap.put("UserName", loginUser.getUsername());
        userInfoMap.put("UserMail", loginUser.getEmail());
        payloadMap.put("jwt", JSONUtil.toJsonStr(userInfoMap));
        payloadMap.put("exp", (String)DateUtil.offsetDay((Date)new Date(), (int)30));
        String token = JwtUtil.getToken(null, payloadMap, sercretKey);
        return token;
    }

    @Override
    public String getYeedocJwt() {
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        return this.getYeedocJwt(loginUser);
    }

    @Override
    public String getAllItemsInfo(List<String> fileCodes) {
        String yeedocJwt = this.getYeedocJwt();
        String itemsInfoUrl = this.yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetAllItemsInfo";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ItemIds", fileCodes);
        log.info("\u83b7\u53d6\u6613\u7a3b\u58f3\u6587\u4ef6\u8be6\u60c5url:{}", (Object)itemsInfoUrl);
        return this.executePost(itemsInfoUrl, map, yeedocJwt);
    }

    private String getToken() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeDO prdOrgEmployeeDO = this.prdOrgEmployeeDAO.queryByUserId(userId);
        Assert.notNull((Object)prdOrgEmployeeDO, (String)"\u5458\u5de5\u4fe1\u606f\u672a\u7ef4\u62a4", (Object[])new Object[0]);
        return prdOrgEmployeeDO.getPcLoginTicket();
    }

    private String base64Encrypt(String value) {
        String s = null;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        byte[] b = value.getBytes(StandardCharsets.UTF_8);
        if (b != null) {
            s = Base64.getEncoder().encodeToString(b);
        }
        return s;
    }

    private String executePost(String url, Map<String, Object> map) {
        String result;
        String param = JSONObject.toJSONString(map);
        String status = "200";
        long start = System.currentTimeMillis();
        try {
            result = ((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json;charset=utf-8")).body(param, "application/json").timeout(20000).execute().body();
        }
        catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, "", finalResult, finalStatus, time);
        return result;
    }

    @Deprecated
    private String executePost(String url, Object object) {
        String result;
        String param = JSONObject.toJSONString((Object)object);
        String status = "200";
        long start = System.currentTimeMillis();
        try {
            result = ((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json;charset=utf-8")).body(param, "application/json").timeout(20000).execute().body();
        }
        catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, "", finalResult, finalStatus, time);
        return result;
    }

    private String executePost(String url, Map<String, Object> map, String authToken) {
        String result;
        String param = JSONObject.toJSONString(map);
        String status = "200";
        long start = System.currentTimeMillis();
        Map headers = new HashMap();
        try {
            HttpRequest header = (HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json;charset=utf-8")).header("Source", this.yeedocProperties.getSource())).header("AuthToken", authToken);
            headers = header.headers();
            result = header.body(param, "application/json").timeout(20000).execute().body();
        }
        catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u5934\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{url, param, JSONUtil.toJsonStr(headers), result});
        this.apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, JSONUtil.toJsonStr(headers), finalResult, finalStatus, time);
        return result;
    }

    public YeedocServiceImpl(ApiRequestLogService apiRequestLogService, YeedocProperties yeedocProperties, PrdOrgEmployeeDAO prdOrgEmployeeDAO) {
        this.apiRequestLogService = apiRequestLogService;
        this.yeedocProperties = yeedocProperties;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
    }
}

