package com.elitesland.tw.tw5.server.common.permission.strategy.execute;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.strategy.OrgUserStrategyService;
import org.springframework.stereotype.Service;

import java.util.Set;

/**
 * @Author Quruiqizz
 * @Date 2023/11/9 10:00
 **/
@Service(value = "ORG_ALL_USERS_IN_ORGANIZATION")
public class OrgUserAllUsersInOrg implements OrgUserStrategyService {

    /**
     * 本机组织下的所有用户情况下的执行
     *
     * @param rule  权限规则
     * @param defaultOrgId  用户默认组织
     * @param childOrgSet   用户组织及子组织
     * @return
     */
    @Override
    public boolean execute(PrdSystemPermissionRuleVO rule, Long defaultOrgId, Set<Long> childOrgSet) {
        return rule.getRuleScope().equals(defaultOrgId.toString());
    }

}
