package com.elitesland.tw.tw5.server.common.workFlow.events;

import com.elitesland.tw.tw5.server.common.workFlow.CommonWorkflowEvent;
import com.elitesland.tw.tw5.server.common.workFlow.TwWorkflowEventAnnotation;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import lombok.RequiredArgsConstructor;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@TwWorkflowEventAnnotation(
        name = "消息发送事件",
        code = "MessageSendEvent",
        scope = "COMMON",
        tableName = "",
        params = "messageNo",
        description = "用作消息发送，参数需要提供一个消息模版",
        enabled = true)
@Slf4j
@ToString(callSuper = true)
@RequiredArgsConstructor
@Component(CommonWorkflowEvent.SERVICE_NAME_PREFIX + "MessageSendEvent")
public class MessageSendEvent extends CommonWorkflowEvent {

//    private final
    private String messageNo;

    @Override
    public void setProps(TaskCompletedPayload payload, String[] props) {
        super.payload = payload;
        this.messageNo = props[0];
    }

    public void execute() {
        log.info("MessageSendEvent execute, payload:{}, messageNo:{}", payload, messageNo);

    }
}
