package com.elitesland.tw.tw5.server.prd.cal.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 核算-账号功能管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Entity
@Table(name = "cal_account", indexes = {
        @Index(name = "au_type_id_index", columnList = "au_type,au_id"),
        @Index(name = "ledger_index", columnList = "ledger_no")
})
@org.hibernate.annotations.Table(appliesTo = "cal_account", comment = "核算-账号功能管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CalAccountDO extends BaseModel implements Serializable {
    /**
     * 账号年度
     */
    @Comment("账号年度")
    @Column()
    private Integer ledgerYear;
    /**
     * 账户名称
     */
    @Comment("账户名称")
    @Column()
    private String ledgerName;
    /**
     * 账户状态(1有效 0无效)
     */
    @Comment("账户状态(1有效 0无效)")
    @Column()
    private Integer ledgerStatus;
    /**
     * （账户类型）核算主体类型
     */
    @Comment("（账户类型）核算主体类型")
    @Column(name = "au_type")
    private String auType;
    /**
     * 核算主体id
     */
    @Comment("核算主体id")
    @Column(name = "au_id")
    private Long auId;
    /**
     * 账号编号
     */
    @Comment("账号编号")
    @Column(name = "ledger_no")
    private String ledgerNo;
    /**
     * ledgerType 1：平台账户，0：否
     */
    @Comment("ledgerType")
    @Column()
    private String ledgerType;
    /**
     * 币种
     */
    @Comment("币种")
    @Column()
    private String currCode;
    /**
     * 总数量
     */
    @Comment("总数量")
    @Column()
    private BigDecimal totalQty;
    /**
     * 冻结数量
     */
    @Comment("冻结数量")
    @Column()
    private BigDecimal frozenQty;
    /**
     * 可用数量
     */
    @Comment("可用数量")
    @Column()
    private BigDecimal avalQty;
    /**
     * 总金额
     */
    @Comment("总金额")
    @Column()
    private BigDecimal totalAmt;
    /**
     * 冻结金额
     */
    @Comment("冻结金额")
    @Column()
    private BigDecimal frozenAmt;
    /**
     * 可用金额
     */
    @Comment("可用金额")
    @Column()
    private BigDecimal avalAmt;

    public void copy(CalAccountDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
