package com.elitesland.tw.tw5.server.prd.cal.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 当量收入配置变更记录
 *
 * @author wangly
 * @date 2024-02-22
 */
@Entity
@Table(name = "cal_eqva_income_log", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "cal_eqva_income_log", comment = "当量收入配置变更记录")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CalEqvaIncomeLogDO extends BaseModel implements Serializable  {
    /** 当量收入配置主键 */
    @Comment("当量收入配置主键")
    @Column()
    private Long relateId;
    /** 单位当量收入 */
    @Comment("单位当量收入")
    @Column()
    private BigDecimal preeqvaAmt;
    /** 状态 */
    @Comment("状态")
    @Column()
    private String lineStatus;
    /** 项目id */
    @Comment("项目id")
    @Column()
    private Long projId;
    /** 项目名称 */
    @Comment("项目名称")
    @Column()
    private String projName;
    /** 资源id */
    @Comment("资源id")
    @Column()
    private Long resId;
    /** 资源类型1内部，0外部 */
    @Comment("资源类型1内部，0外部")
    @Column()
    private String resType;
    /** 版本号 */
    @Comment("版本号")
    @Column()
    private Integer version;
    /** 起始日期 */
    @Comment("起始日期")
    @Column()
    private LocalDate startDate;
    /** 失效日期 */
    @Comment("失效日期")
    @Column()
    private LocalDate endDate;
    /** 结算方式 */
    @Comment("结算方式")
    @Column()
    private String settleType;

    public void copy(CalEqvaIncomeLogDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
