package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaIncomeLogPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaIncomeLogQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaIncomeLogService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaIncomeLogVO;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalEqvaIncomeLogConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalEqvaIncomeLogDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalEqvaIncomeLogDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalEqvaIncomeLogRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 当量收入配置变更记录
 *
 * @author wangly
 * @date 2024-02-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CalEqvaIncomeLogServiceImpl extends BaseServiceImpl implements CalEqvaIncomeLogService {

    private final CalEqvaIncomeLogRepo calEqvaIncomeLogRepo;
    private final CalEqvaIncomeLogDAO calEqvaIncomeLogDAO;

    @Override
    public PagingVO<CalEqvaIncomeLogVO> queryPaging(CalEqvaIncomeLogQuery query){
        return calEqvaIncomeLogDAO.queryPaging(query);
    }

    @Override
    public List<CalEqvaIncomeLogVO> queryListDynamic(CalEqvaIncomeLogQuery query){
        return calEqvaIncomeLogDAO.queryListDynamic(query);
    }

    @Override
    public CalEqvaIncomeLogVO queryByKey(Long key) {
        CalEqvaIncomeLogDO entity = calEqvaIncomeLogRepo.findById(key).orElseGet(CalEqvaIncomeLogDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CalEqvaIncomeLogVO vo = CalEqvaIncomeLogConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    public CalEqvaIncomeLogVO queryFirstByRelateId(Long key) {
        return calEqvaIncomeLogDAO.queryFirstByRelateId(key);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CalEqvaIncomeLogVO insert(CalEqvaIncomeLogPayload payload) {
        CalEqvaIncomeLogDO entityDo = CalEqvaIncomeLogConvert.INSTANCE.toDo(payload);
        return CalEqvaIncomeLogConvert.INSTANCE.toVo(calEqvaIncomeLogRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CalEqvaIncomeLogVO update(CalEqvaIncomeLogPayload payload) {
        CalEqvaIncomeLogDO entity = calEqvaIncomeLogRepo.findById(payload.getId()).orElseGet(CalEqvaIncomeLogDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CalEqvaIncomeLogDO entityDo = CalEqvaIncomeLogConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CalEqvaIncomeLogConvert.INSTANCE.toVo(calEqvaIncomeLogRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(CalEqvaIncomeLogPayload payload) {
        CalEqvaIncomeLogDO entity = calEqvaIncomeLogRepo.findById(payload.getId()).orElseGet(CalEqvaIncomeLogDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = calEqvaIncomeLogDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            calEqvaIncomeLogDAO.deleteSoft(keys);
        }
    }

}
