package com.elitesland.tw.tw5.server.prd.cas.controller;


import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.cas.payload.PrdCasSettingPayload;
import com.elitesland.tw.tw5.api.prd.cas.query.PrdCasSettingQuery;
import com.elitesland.tw.tw5.api.prd.cas.service.PrdCasSettingService;
import com.elitesland.tw.tw5.api.prd.cas.vo.PrdCasSettingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * cas_setting
 *
 * @author zoey
 * @date 2024-01-25
 */
@Api(tags = "cas_setting")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/prdCasSetting")
@Slf4j
public class PrdCasSettingController {

private final PrdCasSettingService prdCasSettingService;

    /**
     * cas_setting-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("cas_setting-新增")
    public TwOutputUtil<PrdCasSettingVO> insert(@RequestBody PrdCasSettingPayload payload){
         return TwOutputUtil.ok(prdCasSettingService.insert(payload));
    }

    /**
     * cas_setting-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("cas_setting-更新")
    public TwOutputUtil<PrdCasSettingVO> update(@RequestBody PrdCasSettingPayload payload){
        return TwOutputUtil.ok(prdCasSettingService.update(payload));
    }

    /**
     * cas_setting-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("cas_setting-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PrdCasSettingPayload payload){
        return TwOutputUtil.ok(prdCasSettingService.updateByKeyDynamic(payload));
    }

    /**
     * cas_setting-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("cas_setting-主键查询")
    public TwOutputUtil<PrdCasSettingVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdCasSettingService.queryByKey(key));
    }

    /**
     * cas_setting-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("cas_setting-分页")
    public TwOutputUtil<PagingVO<PrdCasSettingVO>> paging(PrdCasSettingQuery query) {
        return TwOutputUtil.ok(prdCasSettingService.queryPaging(query));
    }

    /**
     * cas_setting-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("cas_setting-查询列表")
    public TwOutputUtil<List<PrdCasSettingVO>> queryList(PrdCasSettingQuery query) {
        return TwOutputUtil.ok(prdCasSettingService.queryListDynamic(query));
    }

    /**
     * cas_setting-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("cas_setting-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         prdCasSettingService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

