package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeopleEducatePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleEducateService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleEducateVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 人脉-教育经历
 *
 * @author carl
 * @date 2022/12/07
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmPeopleEducateController {

    private final CrmPeopleEducateService service;

    /**
     * 新增或更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/peopleEducate")
    public TwOutputUtil insertOrUpdate(CrmPeopleEducatePayload payload) {
        return TwOutputUtil.ok(service.insertOrUpdate(payload));
    }


    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/peopleEducate/{key}")
    //@UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmPeopleEducateVO prdFileVO = service.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }


    /**
     * 查询列表
     *
     * @param peopleId 人脉id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/peopleEducate/list")
    //@UdcNameClass
    public TwOutputUtil queryList(Long peopleId) {
        List<CrmPeopleEducateVO> vos = service.queryList(peopleId);
        return TwOutputUtil.ok(vos);
    }


    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/peopleEducate/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
