package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 商机成单率计算指标
 *
 * @author likunpeng
 * @date 2023-11-03
 */
@Entity
@Table(name = "crm_opportunity_measure", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_measure", comment = "商机成单率计算指标")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityMeasureDO extends BaseModel implements Serializable  {
    /** 商机数据源字段表ID */
    @Comment("商机数据源字段表ID")
    @Column()
    private Long dataSourceFieldsId;
    /** 权重 */
    @Comment("权重")
    @Column()
    private BigDecimal weights;

    public void copy(CrmOpportunityMeasureDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
