package com.elitesland.tw.tw5.server.prd.humanresources.ability.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-10-18
 * @desc : 级别维护表
 */

@Entity
@Table(name="prd_level_config")
@org.hibernate.annotations.Table(appliesTo = "prd_level_config", comment = "级别维护表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdLevelConfigDO extends BaseModel {


    /**
     * 级别名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '级别名称'")
    private String name;

    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "int(11) comment '状态'")
    private Integer state;

    /**
     * 是否默认
     */
    @Column(name = "def_flag", columnDefinition = "tinyint(1) comment '是否默认'")
    private Boolean defFlag;

    /**
     * 级别编号
     */
    @Column(name = "doc_no", columnDefinition = "varchar(255) comment '级别编号'")
    private String docNo;

    /**
     * 序号
     */
    @Column(name = "sort", columnDefinition = "int(11) comment '序号'")
    private Integer sort;
}

