package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempGradeService;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdExamTempGradeConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdExamTempGradeDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempGradePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempGradeQuery;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdExamTempGradeRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdExamTempGradeDao;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempGradeVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.util.List;


 /**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板等级Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdExamTempGradeServiceImpl implements PrdExamTempGradeService {
    
    
    private final PrdExamTempGradeDao prdExamTempGradeDao;
    
    private final PrdExamTempGradeRepo prdExamTempGradeRepo;
    
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdExamTempGradeVO save(PrdExamTempGradePayload prdExamTempGradePayload) {
    
        checkData(prdExamTempGradePayload);
        PrdExamTempGradeDO prdExamTempGradeDO = new PrdExamTempGradeDO();
        prdExamTempGradeDO = PrdExamTempGradeConvert.INSTANCE.p2d(prdExamTempGradePayload);
        PrdExamTempGradeDO res = prdExamTempGradeRepo.save(prdExamTempGradeDO);
        return PrdExamTempGradeConvert.INSTANCE.d2v(res);
        
    }
    
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdExamTempGradeVO update(PrdExamTempGradePayload prdExamTempGradePayload) {
    
        Assert.notNull(prdExamTempGradePayload.getId(), "id is null");
        PrdExamTempGradeVO res = save(prdExamTempGradePayload);
        return res;
        
    }
    
    
    @Override
    public PrdExamTempGradeVO get(Long id) {
    
        if (null == id) {
            return null;
        }
        PrdExamTempGradeVO res = prdExamTempGradeDao.get(id);
        return res;
        
    }
    
    
    @Override
    public PagingVO<PrdExamTempGradeVO> page(PrdExamTempGradeQuery prdExamTempGradeQuery) {
        
        PagingVO<PrdExamTempGradeVO> res = prdExamTempGradeDao.page(prdExamTempGradeQuery);
        return res;
        
    }
    
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {
    
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdExamTempGradeDao.del(ids);
        return res;
        
    }
    
    @Override
    public List<PrdExamTempGradeVO> getList(PrdExamTempGradeQuery prdExamTempGradeQuery) {
        
        List<PrdExamTempGradeVO> res = prdExamTempGradeDao.getList(prdExamTempGradeQuery);
        return res;
    
    }
    
    
    /**
     * 数据校验
     * @param prdExamTempGradePayload
     */
    private void checkData(PrdExamTempGradePayload prdExamTempGradePayload) {
    
//        if (StringUtils.isBlank(prdExamTempGradePayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }
    
    }
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdExamTempGradePayload prdExamTempGradePayload) {
        Assert.notNull(prdExamTempGradePayload.getId(), "id不能为空");
        Long res = prdExamTempGradeDao.update(prdExamTempGradePayload);
        return res;
    }

     @Override
     @Transactional(rollbackFor = Exception.class)
     public void delByTempId(Long id) {
         prdExamTempGradeDao.delByTempId(id);
     }


 }

