package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResDtlVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdPerformanceExamResDtlConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdPerformanceExamResDtlDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamResDtlDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdPerformanceExamResDtlRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;

import com.elitescloud.boot.exception.BusinessException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.boot.exception.BusinessException;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果明细Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdPerformanceExamResDtlServiceImpl implements PrdPerformanceExamResDtlService {


    private final PrdPerformanceExamResDtlDao prdPerformanceExamResDtlDao;

    private final PrdPerformanceExamResDtlRepo prdPerformanceExamResDtlRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamResDtlVO save(PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload) {

        checkData(prdPerformanceExamResDtlPayload);
        PrdPerformanceExamResDtlDO prdPerformanceExamResDtlDO = new PrdPerformanceExamResDtlDO();
        prdPerformanceExamResDtlDO = PrdPerformanceExamResDtlConvert.INSTANCE.p2d(prdPerformanceExamResDtlPayload);
        PrdPerformanceExamResDtlDO res = prdPerformanceExamResDtlRepo.save(prdPerformanceExamResDtlDO);
        return PrdPerformanceExamResDtlConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamResDtlVO update(PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload) {

        Assert.notNull(prdPerformanceExamResDtlPayload.getId(), "id is null");
        PrdPerformanceExamResDtlVO res = save(prdPerformanceExamResDtlPayload);
        return res;

    }


    @Override
    public PrdPerformanceExamResDtlVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdPerformanceExamResDtlVO res = prdPerformanceExamResDtlDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdPerformanceExamResDtlVO> page(PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery) {

        PagingVO<PrdPerformanceExamResDtlVO> res = prdPerformanceExamResDtlDao.page(prdPerformanceExamResDtlQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdPerformanceExamResDtlDao.del(ids);
        return res;

    }

    @Override
    public List<PrdPerformanceExamResDtlVO> getList(PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery) {

        List<PrdPerformanceExamResDtlVO> res = prdPerformanceExamResDtlDao.getList(prdPerformanceExamResDtlQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdPerformanceExamResDtlPayload
     */
    private void checkData(PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload) {

//        if (StringUtils.isBlank(prdPerformanceExamResDtlPayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload) {
        Assert.notNull(prdPerformanceExamResDtlPayload.getId(), "id不能为空");
//        Assert.notNull(prdPerformanceExamResDtlPayload.getScoreRes(), "评分结果不能为空");
        if (StringUtils.isNotBlank(prdPerformanceExamResDtlPayload.getSelfEval())) {
            prdPerformanceExamResDtlPayload.setEvalDesc(prdPerformanceExamResDtlPayload.getSelfEval());
        }
        Long res = prdPerformanceExamResDtlDao.update(prdPerformanceExamResDtlPayload);
        return res;
    }


}

