package com.elitesland.tw.tw5.server.prd.humanresources.personnel.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.EmployeeDepartPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeDepartApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.EmployeeDepartService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyBSVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartCheckVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@Api(tags = "员工离职管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/org")
@Slf4j
@PermissionDomain(domain = PermissionDomainEnum.EMPLOYEE_DEPART_APPLY)
public class EmployeeDepartController {

    private final EmployeeDepartService service;

    private final SysUserRpcService userRpcService;

    /**
     * 员工离职
     *
     * @param payload
     * @return result
     */
    @ApiOperation("员工离职")
    @PutMapping("/employee/depart")
    @GlobalTransactional
    public TwOutputUtil employeeDepart(@RequestBody EmployeeDepartPayload payload) {
        service.employeeDepart(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 员工离职申请信息
     *
     * @param procId
     * @return result
     */
    @ApiOperation("员工离职申请信息")
    @GetMapping("/employee/depart/apply")
    @UdcNameClass
    public TwOutputUtil<EmployeeDepartApplyVO> employeeDepartApply(String procId) {
        return TwOutputUtil.ok(service.queryEmployeeDepart(procId));
    }

    /**
     * 员工离职检查
     *
     * @param employeeId
     * @return result
     */
    @ApiOperation("员工离职检查")
    @GetMapping("/employee/depart/check/{employeeId}")
    public TwOutputUtil<EmployeeDepartCheckVO> employeeDepartCheck(@PathVariable Long employeeId) {
        return TwOutputUtil.ok(service.employeeDepartCheck(employeeId));
    }

    /**
     * 员工离职列表
     *
     * @param
     * @return result
     */
    @ApiOperation("员工离职申请列表")
    @GetMapping("/employee/depart/apply/list")
    @UdcNameClass
    public TwOutputUtil employeeDepartList(EmployeeDepartApplyQuery query) {
        return TwOutputUtil.ok(service.employeeDepartApplyList(query));
    }


    @GetMapping("/permission/employee/depart/apply/list")
    @UdcNameClass
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.EMPLOYEE_DEPART_APPLY, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    @ApiOperation("权限-员工离职申请列表")
    public TwOutputUtil<PagingVO<EmployeeDepartApplyBSVO>> permissionPaging(@RequestBody EmployeeDepartApplyQuery query) {
        PagingVO<EmployeeDepartApplyBSVO> res = service.permissionPaging(query);
        return TwOutputUtil.ok(res);
    }


    /**
     * 员工离职账号禁用
     *
     * @param
     * @return result
     */
    @ApiOperation("员工离职账号禁用")
    @GetMapping("/employee/depart/enable/{userId}")
    public TwOutputUtil employeeDepartEnable(@PathVariable Long userId) {
        SysUserBatchSwitchParam sysUserBatchSwitchParam = new SysUserBatchSwitchParam();
        List<Long> userIds = new ArrayList<>();
        userIds.add(userId);
        sysUserBatchSwitchParam.setEnable(false);
        sysUserBatchSwitchParam.setUserIds(userIds);
        userRpcService.batchSwitchUserStatus(sysUserBatchSwitchParam);
        return TwOutputUtil.ok();
    }

    /**
     * 员工离职申请信息
     *
     * @param applyId
     * @return result
     */
    @ApiOperation("员工离职申请信息")
    @GetMapping("/employee/depart/queryByKey/{applyId}")
    @UdcNameClass
    public TwOutputUtil<EmployeeDepartApplyVO> queryByKey(@PathVariable Long applyId) {
        return TwOutputUtil.ok(service.queryByKey(applyId));
    }
}
