package com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@Entity
@Table(name = "person_project_experience", indexes = {
        @Index(name = "person_index", columnList = "person_id"),
})
@org.hibernate.annotations.Table(appliesTo = "person_project_experience", comment = "人员-项目履历表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PersonProjectExperienceDO extends BaseModel {

    @Comment("自然人ID")
    @Column(name = "person_id", nullable = false)
    private Long personId;

    @Comment("开始日期")
    @Column(name = "date_from")
    private String dateFrom;

    @Comment("结束日期")
    @Column(name = "date_to")
    private String dateTo;

    @Comment("项目名称")
    @Column(name = "proj_name")
    private String projName;

    @Comment("产品")
    @Column(name = "product")
    private String product;

    @Comment("相关行业")
    @Column(name = "industry")
    private String industry;

    @Comment("项目角色")
    @Column(name = "proj_role")
    private String projRole;

    @Comment("所在公司")
    @Column(name = "company")
    private String company;

    @Comment("项目简介")
    @Column(name = "proj_intro", columnDefinition = "longtext")
    private String projIntro;

    @Comment("职责业绩")
    @Column(name = "duty_achv", columnDefinition = "longtext")
    private String dutyAchv;

    @Comment("是否平台内项目")
    @Column(name = "plat_proj_flag")
    private String platProjFlag;

    @Comment("项目id")
    @Column(name = "proj_id")
    private Long projId;

    @Comment("职责")
    @Column(name = "responsibility")
    private String responsibility;

    @Comment("行业标签")
    @Column(name = "industry_label")
    private String industryLabel;

    @Comment("来源类型")
    @Column(name = "source_type")
    private String sourceType;
}
