package com.elitesland.tw.tw5.server.prd.inv.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 发票明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Entity
@Table(name = "inv_invoice_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "inv_invoice_detail", comment = "发票明细表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class InvInvoiceDetailDO extends BaseModel implements Serializable  {
    /** 发票ID */
    @Comment("发票ID")
    @Column()
    private Long invId;
    /** 百望系统发票ID */
    @Comment("百望系统发票ID")
    @Column()
    private Long baiwangInvId;
    /** 百望系统发票明细表ID */
    @Comment("百望系统发票明细表ID")
    @Column()
    private Long baiwangId;
    /** 行号:通用行号 */
    @Comment("行号:通用行号")
    @Column()
    private String rowNo;
    /** 商品编码:通用商品编码 */
    @Comment("商品编码:通用商品编码")
    @Column()
    private String commodityCode;
    /** 货物或应税劳务名称:1.专普电/通行费:货物或应税劳务、服务名称；2.卷票:项目 */
    @Comment("货物或应税劳务名称:1.专普电/通行费:货物或应税劳务、服务名称；2.卷票:项目")
    @Column()
    private String commodityName;
    /** 规格型号:专普电（不含通行费） */
    @Comment("规格型号:专普电（不含通行费）")
    @Column()
    private String specificationModel;
    /** 单位:单位 */
    @Comment("单位:单位")
    @Column()
    private String unit;
    /** 数量:数量 */
    @Comment("数量:数量")
    @Column()
    private BigDecimal quantity;
    /** 单价:单价 */
    @Comment("单价:单价")
    @Column()
    private BigDecimal unitPrice;
    /** 金额:金额 */
    @Comment("金额:金额")
    @Column()
    private BigDecimal amount;
    /** 税率:税率 */
    @Comment("税率:税率")
    @Column()
    private BigDecimal taxRate;
    /** 税额:税额 */
    @Comment("税额:税额")
    @Column()
    private BigDecimal tax;
    /** 通行日期起:通行日期起yyyy-MM-ddHH:mm:ss */
    @Comment("通行日期起:通行日期起yyyy-MM-ddHH:mm:ss")
    @Column()
    private String currentDateStart;
    /** 通行日期止:通行日期止yyyy-MM-ddHH:mm:ss */
    @Comment("通行日期止:通行日期止yyyy-MM-ddHH:mm:ss")
    @Column()
    private String currentDateEnd;
    /** 车牌号:车牌号 */
    @Comment("车牌号:车牌号")
    @Column()
    private String licensePlateNum;
    /** 类型:类型，明细中的类型，商品类型 */
    @Comment("类型:类型，明细中的类型，商品类型")
    @Column()
    private String goodsType;
    /** 类型:类型，明细中的类型，商品类型 */
    @Comment("类型:类型，明细中的类型，商品类型")
    @Column()
    private Integer detailType;
    /** 特殊政策标记:特殊政策标记 0、正常票 1、免税 ，2 不征税 3零税率 */
    @Comment("特殊政策标记:特殊政策标记 0、正常票 1、免税 ，2 不征税 3零税率")
    @Column()
    private Integer specialMark;
    /** 是否删除:是否删除，0-否，1-是 */
    @Comment("是否删除:是否删除，0-否，1-是")
    @Column()
    private Integer isDel;

    public void copy(InvInvoiceDetailDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
