package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanTempListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanTempPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetPlanTempService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 工作计划模板
 *
 * @author duwh
 * @date 2022-12-14
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/my/timesheetPlanTemp")
@Slf4j
public class PmsTimesheetPlanTempController {

    private final PmsTimesheetPlanTempService pmsTimesheetPlanTempService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    public TwOutputUtil insert(@RequestBody TimesheetPlanTempPayload payload) {
        return TwOutputUtil.ok(pmsTimesheetPlanTempService.insert(payload));
    }

    /**
     * 批量插入
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/batchInsert")
    public TwOutputUtil batchInsert(@RequestBody TimesheetPlanTempListPayload payload) {
        return TwOutputUtil.ok(pmsTimesheetPlanTempService.batchInsert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    public TwOutputUtil update(@RequestBody TimesheetPlanTempPayload payload) {
        return TwOutputUtil.ok(pmsTimesheetPlanTempService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsTimesheetPlanTempService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(TimesheetPlanTempQuery query) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        query.setCreateUserId(loginUserId);
        return TwOutputUtil.ok(pmsTimesheetPlanTempService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(TimesheetPlanTempQuery query) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        query.setCreateUserId(loginUserId);
        return TwOutputUtil.ok(pmsTimesheetPlanTempService.queryList(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsTimesheetPlanTempService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
