package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitesland.tw.tw5.api.prd.my.payload.TMoneyTransferPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TMoneyTransferQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TMoneyTransferVO;
import com.elitesland.tw.tw5.server.prd.my.entity.TMoneyTransferDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTMoneyTransferDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TMoneyTransferRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 资金划款
 *
 * @author wangluyu
 * @date 2024-02-27
 */
@Repository
@RequiredArgsConstructor
public class TMoneyTransferDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TMoneyTransferRepo repo;
    private final QTMoneyTransferDO qdo = QTMoneyTransferDO.tMoneyTransferDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TMoneyTransferVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TMoneyTransferVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 编号
                qdo.transferNo,
                // 申请人
                qdo.applicantUserId,
                // 申请日期
                qdo.applicantTime,
                // 申请人所属bu
                qdo.applicantBuId,
                // 划款公司
                qdo.transferCompany,
                // 划款公司bookid
                qdo.transferCompanyBookId,
                // 划款账号
                qdo.transferAccount,
                // 收款公司
                qdo.collectionCompany,
                // 收款公司bookid
                qdo.collectionCompanyBookId,
                // 收款账号
                qdo.collectionAccount,
                // 划款金额
                qdo.transferMoney,
                // 支付方式
                qdo.payWay,
                // 划款说明
                qdo.transferNote,
                // 划款状态
                qdo.transferStatus,
                // 附件
                qdo.fileCodes,
                // 审批状态
                qdo.apprStatus,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime,
                // 网银提交标识 1.已提交 2.未提交
                qdo.bankFlag,
                // 网银提交时间
                qdo.bankTime,
                // 银企失败原因
                qdo.bankErrmsg,
                // 支付状态：S 成功、F 失败、C撤销、D 过期、R 否决 G退票
                qdo.payStatus,
                // 支付用途
                qdo.payPurpose,
                // 支付时间
                qdo.payTime,
                // 支付方式
                qdo.payMode,
                // 内部往来凭证
                qdo.jdeDocNo,
                qdo.jdeDocNo2,
                qdo.jdeSummary,
                qdo.jdeDocTime,
                qdo.jdeDocState,
                // 内部往来凭证失败原因
                qdo.jdeErrMsg

        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TMoneyTransferVO> getJpaQueryWhere(TMoneyTransferQuery query) {
        JPAQuery<TMoneyTransferVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TMoneyTransferQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TMoneyTransferQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /**
         * 主键ids
         */
        if (!ObjectUtils.isEmpty(query.getIds())) {
            list.add(qdo.id.in(query.getIds()));
        }
        /**
         * 支付方式
         */
        if (!ObjectUtils.isEmpty(query.getPayMode())) {
            list.add(qdo.payMode.eq(query.getPayMode()));
        }
        /**
         * 支付状态
         */
        if (!ObjectUtils.isEmpty(query.getPayStatus())) {
            list.add(qdo.payStatus.in(query.getPayStatus()));
        }
        /**
         * 内部往来凭证2
         */
        if (!ObjectUtils.isEmpty(query.getJdeDocNo())) {
            list.add(qdo.jdeDocNo.in(query.getJdeDocNo()));
        }
        if (!ObjectUtils.isEmpty(query.getJdeDocNo2())) {
            list.add(qdo.jdeDocNo2.in(query.getJdeDocNo2()));
        }
        /** 编号 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferNo())) {
            list.add(qdo.transferNo.eq(query.getTransferNo()));
        }
        /** 申请人 精确 */
        if (!ObjectUtils.isEmpty(query.getApplicantUserId())) {
            list.add(qdo.applicantUserId.eq(query.getApplicantUserId()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplicantTime())) {
            list.add(qdo.applicantTime.eq(query.getApplicantTime()));
        }
        /** 申请人所属bu 精确 */
        if (!ObjectUtils.isEmpty(query.getApplicantBuId())) {
            list.add(qdo.applicantBuId.eq(query.getApplicantBuId()));
        }
        /** 划款公司 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferCompany())) {
            list.add(qdo.transferCompany.eq(query.getTransferCompany()));
        }
        /** 划款公司bookid 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferCompanyBookId())) {
            list.add(qdo.transferCompanyBookId.eq(query.getTransferCompanyBookId()));
        }
        /** 划款账号 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferAccount())) {
            list.add(qdo.transferAccount.eq(query.getTransferAccount()));
        }
        /** 收款公司 精确 */
        if (!ObjectUtils.isEmpty(query.getCollectionCompany())) {
            list.add(qdo.collectionCompany.eq(query.getCollectionCompany()));
        }
        /** 收款公司bookid 精确 */
        if (!ObjectUtils.isEmpty(query.getCollectionCompanyBookId())) {
            list.add(qdo.collectionCompanyBookId.eq(query.getCollectionCompanyBookId()));
        }
        /** 收款账号 精确 */
        if (!ObjectUtils.isEmpty(query.getCollectionAccount())) {
            list.add(qdo.collectionAccount.eq(query.getCollectionAccount()));
        }
        /** 划款金额 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferMoney())) {
            list.add(qdo.transferMoney.eq(query.getTransferMoney()));
        }
        /** 支付方式 精确 */
        if (!ObjectUtils.isEmpty(query.getPayWay())) {
            list.add(qdo.payWay.eq(query.getPayWay()));
        }
        /** 划款说明 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferNote())) {
            list.add(qdo.transferNote.eq(query.getTransferNote()));
        }
        /** 划款状态 精确 */
        if (!ObjectUtils.isEmpty(query.getTransferStatus())) {
            list.add(qdo.transferStatus.eq(query.getTransferStatus()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TMoneyTransferVO queryByKey(Long id) {
        JPAQuery<TMoneyTransferVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TMoneyTransferVO> queryListDynamic(TMoneyTransferQuery query) {
        JPAQuery<TMoneyTransferVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TMoneyTransferVO> queryPaging(TMoneyTransferQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<TMoneyTransferVO> jpaQuery = getJpaQueryWhere(query);
        List<TMoneyTransferVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TMoneyTransferVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TMoneyTransferDO save(TMoneyTransferDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TMoneyTransferDO> saveAll(List<TMoneyTransferDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TMoneyTransferPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 编号
        if (payload.getTransferNo() != null) {
            update.set(qdo.transferNo, payload.getTransferNo());
        }
        // 申请人
        if (payload.getApplicantUserId() != null) {
            update.set(qdo.applicantUserId, payload.getApplicantUserId());
        }
        // 申请日期
        if (payload.getApplicantTime() != null) {
            update.set(qdo.applicantTime, payload.getApplicantTime());
        }
        // 申请人所属bu
        if (payload.getApplicantBuId() != null) {
            update.set(qdo.applicantBuId, payload.getApplicantBuId());
        }
        // 划款公司
        if (payload.getTransferCompany() != null) {
            update.set(qdo.transferCompany, payload.getTransferCompany());
        }
        // 划款公司bookid
        if (payload.getTransferCompanyBookId() != null) {
            update.set(qdo.transferCompanyBookId, payload.getTransferCompanyBookId());
        }
        // 划款账号
        if (payload.getTransferAccount() != null) {
            update.set(qdo.transferAccount, payload.getTransferAccount());
        }
        // 收款公司
        if (payload.getCollectionCompany() != null) {
            update.set(qdo.collectionCompany, payload.getCollectionCompany());
        }
        // 收款公司bookid
        if (payload.getCollectionCompanyBookId() != null) {
            update.set(qdo.collectionCompanyBookId, payload.getCollectionCompanyBookId());
        }
        // 收款账号
        if (payload.getCollectionAccount() != null) {
            update.set(qdo.collectionAccount, payload.getCollectionAccount());
        }
        // 划款金额
        if (payload.getTransferMoney() != null) {
            update.set(qdo.transferMoney, payload.getTransferMoney());
        }
        // 支付方式
        if (payload.getPayWay() != null) {
            update.set(qdo.payWay, payload.getPayWay());
        }
        // 划款说明
        if (payload.getTransferNote() != null) {
            update.set(qdo.transferNote, payload.getTransferNote());
        }
        // 划款状态
        if (payload.getTransferStatus() != null) {
            update.set(qdo.transferStatus, payload.getTransferStatus());
        }
        // 划款状态
        if (payload.getFileCodes() != null) {
            update.set(qdo.fileCodes, payload.getFileCodes());
        }
        // 审批状态
        if (payload.getApprStatus() != null) {
            update.set(qdo.apprStatus, payload.getApprStatus());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getPayStatus() != null) {
            update.set(qdo.payStatus, payload.getPayStatus());
        }
        if (payload.getPayTime() != null) {
            update.set(qdo.payTime, payload.getPayTime());
        }
        if (payload.getPayMode() != null) {
            update.set(qdo.payMode, payload.getPayMode());
        }
        if (payload.getPayWay() != null) {
            update.set(qdo.payWay, payload.getPayWay());
        }
        if (payload.getPayPurpose() != null) {
            update.set(qdo.payPurpose, payload.getPayPurpose());
        }
        if (payload.getJdeDocNo() != null) {
            update.set(qdo.jdeDocNo, payload.getJdeDocNo());
        }
        if (payload.getJdeDocNo2() != null) {
            update.set(qdo.jdeDocNo2, payload.getJdeDocNo2());
        }
        if (payload.getJdeDocState() != null) {
            update.set(qdo.jdeDocState, payload.getJdeDocState());
        }
        if (payload.getJdeSummary() != null) {
            update.set(qdo.jdeSummary, payload.getJdeSummary());
        }
        if (payload.getJdeErrMsg() != null) {
            update.set(qdo.jdeErrMsg, payload.getJdeErrMsg());
        }
        if (payload.getJdeDocTime() != null) {
            update.set(qdo.jdeDocTime, payload.getJdeDocTime());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 编号
            if (nullFields.contains("transferNo")) {
                update.setNull(qdo.transferNo);
            }
            // 申请人
            if (nullFields.contains("applicantUserId")) {
                update.setNull(qdo.applicantUserId);
            }
            // 申请日期
            if (nullFields.contains("applicantTime")) {
                update.setNull(qdo.applicantTime);
            }
            // 申请人所属bu
            if (nullFields.contains("applicantBuId")) {
                update.setNull(qdo.applicantBuId);
            }
            // 划款公司
            if (nullFields.contains("transferCompany")) {
                update.setNull(qdo.transferCompany);
            }
            // 划款公司bookid
            if (nullFields.contains("transferCompanyBookId")) {
                update.setNull(qdo.transferCompanyBookId);
            }
            // 划款账号
            if (nullFields.contains("transferAccount")) {
                update.setNull(qdo.transferAccount);
            }
            // 收款公司
            if (nullFields.contains("collectionCompany")) {
                update.setNull(qdo.collectionCompany);
            }
            // 收款公司bookid
            if (nullFields.contains("collectionCompanyBookId")) {
                update.setNull(qdo.collectionCompanyBookId);
            }
            // 收款账号
            if (nullFields.contains("collectionAccount")) {
                update.setNull(qdo.collectionAccount);
            }
            // 划款金额
            if (nullFields.contains("transferMoney")) {
                update.setNull(qdo.transferMoney);
            }
            // 支付方式
            if (nullFields.contains("payWay")) {
                update.setNull(qdo.payWay);
            }
            // 划款说明
            if (nullFields.contains("transferNote")) {
                update.setNull(qdo.transferNote);
            }
            // 划款状态
            if (nullFields.contains("transferStatus")) {
                update.setNull(qdo.transferStatus);
            }
            // 附件
            if (nullFields.contains("fileCodes")) {
                update.setNull(qdo.fileCodes);
            }
            // 审批状态
            if (nullFields.contains("apprStatus")) {
                update.setNull(qdo.apprStatus);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

