package com.elitesland.tw.tw5.server.prd.my.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = "t_attendance_normal_date", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_attendance_normal_date", comment = "打卡工作日表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TAttendanceNormalDateDO extends BaseModel {


    @Comment("规则ID")
    @Column()
    private Long attendanceRuleId;

    @Comment("周一是否打卡")
    @Column()
    private Boolean attendanceDateMon;

    @Comment("周二是否打卡")
    @Column()
    private Boolean attendanceDateTue;

    @Comment("周三是否打卡")
    @Column()
    private Boolean attendanceDateWed;

    @Comment("周四是否打卡")
    @Column()
    private Boolean attendanceDateThu;

    @Comment("周五是否打卡")
    @Column()
    private Boolean attendanceDateFri;

    @Comment("周六是否打卡")
    @Column()
    private Boolean attendanceDateSat;

    @Comment("周日是否打卡")
    @Column()
    private Boolean attendanceDateSun;

    @Comment("允许迟到分钟数")
    @Column()
    private Long allowLateTimeNum;

    @Comment("允许早退分钟数")
    @Column()
    private Long allowLeaveTimeNum;

    @Comment("在此时间前可打上班卡")
    @Column()
    private String punchLimitStartTime;

    @Comment("上班打卡限制时间")
    @Column()
    private String punchLimitStartSecondTime;

    @Comment("在此时间后可打下班卡")
    @Column()
    private String punchLimitEndTime;

    @Comment("在此时间后可打下班打卡限制卡")
    @Column()
    private String punchLimitEndSecondTime;

}
