package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TBusiSignetApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusiSignetApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TBusiSignetApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiSignetApplyVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeLeaderQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SignetTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowRoleCodeEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TBusiSignetApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TBusiSignetApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TBusiSignetApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TBusiSignetApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 用印申请
 *
 * @author wangly
 * @date 2023-09-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TBusiSignetApplyServiceImpl extends BaseServiceImpl implements TBusiSignetApplyService {

    private final TBusiSignetApplyRepo tBusiSignetApplyRepo;
    private final TBusiSignetApplyDAO tBusiSignetApplyDAO;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    private final WorkflowUtil workflowUtil;

    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;

    private final PrdOrgEmployeeDAO employeeDAO;

    private final PrdSystemRoleDAO systemRoleDAO;

    private final FileUtil fileUtil;

    private final PrdOrgOrganizationDAO daoOrg;

    @Value("${tw5.workflow.orgId}")
    private Long workflow_orgId;

    @Override
    public PagingVO<TBusiSignetApplyVO> queryPaging(TBusiSignetApplyQuery query) {
        PagingVO<TBusiSignetApplyVO> tBusiSignetApplyVOPagingVO = tBusiSignetApplyDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty(tBusiSignetApplyVOPagingVO.getRecords())) {
            //翻译申请印章字段
            tBusiSignetApplyVOPagingVO.stream().forEach(p -> translate(p));
        }
        return tBusiSignetApplyVOPagingVO;
    }

    @Override
    public List<TBusiSignetApplyVO> queryListDynamic(TBusiSignetApplyQuery query) {
        List<TBusiSignetApplyVO> tBusiSignetApplyVOS = tBusiSignetApplyDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(tBusiSignetApplyVOS)) {
            //翻译申请印章字段
            tBusiSignetApplyVOS.stream().forEach(p -> translate(p));
        }
        return tBusiSignetApplyVOS;
    }

    @Override
    public TBusiSignetApplyVO queryByKey(Long key) {
        TBusiSignetApplyDO entity = tBusiSignetApplyRepo.findById(key).orElseGet(TBusiSignetApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TBusiSignetApplyVO vo = TBusiSignetApplyConvert.INSTANCE.toVo(entity);
        //翻译申请印章字段
        translate(vo);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TBusiSignetApplyVO insert(TBusiSignetApplyPayload payload) {
        TBusiSignetApplyDO entityDo = TBusiSignetApplyConvert.INSTANCE.toDo(payload);
        TBusiSignetApplyDO tBusiSignetApplyDO = tBusiSignetApplyRepo.save(entityDo);
        busiSignetApplyProc(tBusiSignetApplyDO);
        return TBusiSignetApplyConvert.INSTANCE.toVo(tBusiSignetApplyDO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TBusiSignetApplyVO update(TBusiSignetApplyPayload payload) {
        TBusiSignetApplyDO entity = tBusiSignetApplyRepo.findById(payload.getId()).orElseGet(TBusiSignetApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TBusiSignetApplyDO entityDo = TBusiSignetApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TBusiSignetApplyConvert.INSTANCE.toVo(tBusiSignetApplyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TBusiSignetApplyPayload payload) {
        TBusiSignetApplyDO entity = tBusiSignetApplyRepo.findById(payload.getId()).orElseGet(TBusiSignetApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tBusiSignetApplyDAO.updateByKeyDynamic(payload);
        if (payload.getSubmit() != null && payload.getSubmit()) {
            //是否是新增推流程
            if (entity.getProcInstId() == null) {
                TBusiSignetApplyDO entityDo = TBusiSignetApplyConvert.INSTANCE.toDo(payload);
                entity.copy(entityDo);
                busiSignetApplyProc(entity);
            } else {
                Boolean workFlag = false;
                SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
                setVariablesPayload.setProcInstId(entity.getProcInstId());
                //是否外借更改
                if ((payload.getLendFlag() != null && !payload.getLendFlag().equals(entity.getLendFlag()))) {
                    workFlag = true;
                }
                //是否打印更改
                if ((payload.getPrintFlag() != null && !payload.getPrintFlag().equals(entity.getPrintFlag()))) {
                    workFlag = true;
                }
                //印章类型更改
                if ((payload.getSignetType() != null && !payload.getSignetType().equals(entity.getSignetType()))) {
                    workFlag = true;
                }
                if (workFlag) {
                    TBusiSignetApplyDO entityDo = TBusiSignetApplyConvert.INSTANCE.toDo(payload);
                    entity.copy(entityDo);
                    HashMap variables = dealWorkFlowVariables(entity);
                    setVariablesPayload.setVariables(variables);
                    workflowUtil.setVaribales(setVariablesPayload);
                }
//                ApprovePayload approvePayload = new ApprovePayload();
//                approvePayload.setProcInstId(entity.getProcInstId());
//                approvePayload.setAction(ApproveAction.AGREE);
//                approvePayload.setCurrentUserId(GlobalUtil.getLoginUserId());
//                workflowUtil.approve(approvePayload);
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tBusiSignetApplyDAO.deleteSoft(keys);
        }
    }

    /**
     * 权限申请流程
     *
     * @param permissionApplyDO
     */
    private void busiSignetApplyProc(TBusiSignetApplyDO permissionApplyDO) {
        ProcessInfo processInfo = new ProcessInfo();
        if (workflow_enabled) {
            //获取申请人
            String applyResName = cacheUtil.getUserName(permissionApplyDO.getApplyResId());
            HashMap variables = dealWorkFlowVariables(permissionApplyDO);
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.BUSI_SIGNET_APPLY.name(),
                    applyResName + "-用印申请流程",
                    permissionApplyDO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        TBusiSignetApplyPayload payload = new TBusiSignetApplyPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(permissionApplyDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            tBusiSignetApplyDAO.updateByKeyDynamic(payload);
        });
    }

    /**
     * 字段udc翻译
     *
     * @param vo 用印申请vo
     */
    public void translate(TBusiSignetApplyVO vo) {
        if (vo != null) {
            if (StringUtils.hasText(vo.getRelatedSignet())) {
                StringBuilder stringBuilder = new StringBuilder("");
                Arrays.stream(vo.getRelatedSignet().split(",")).forEach(p -> {
                    stringBuilder.append(cacheUtil.transferSystemSelection(FunctionSelectionEnum.RELATED_SIGNET.getCode(), p) + ",");
                });
                if (stringBuilder.length() > 0) {
                    vo.setRelatedSignet(stringBuilder.substring(0, stringBuilder.length() - 1));
                }
                if (StringUtils.hasText(vo.getFileCode())) {
                    vo.setFileData(fileUtil.getFileDatas(vo.getFileCode()));
                }
            }
        }
    }

    //处理流程参数
    public HashMap dealWorkFlowVariables(TBusiSignetApplyDO permissionApplyDO) {
        HashMap<String, Object> variables = new HashMap<>();
        //部门负责人
        Boolean isDepartmentHead = false;
        //人事专用章
        Boolean isPersonnel = false;

        // 本部门负责人
        List<PrdOrgEmployeeLeaderQuery> prdOrgEmployeeLeaderQueryList = employeeDAO.queryOrgLeaderByUserId(permissionApplyDO.getApplyResId());
        if (CollectionUtils.isEmpty(prdOrgEmployeeLeaderQueryList)) {
            throw TwException.error("", "当前登录人的部门负责人不存在，请维护");
        }
        List<Long> leaderIdList = prdOrgEmployeeLeaderQueryList.stream().filter(p -> p.getOrgLeaderId() != null).map(x -> x.getOrgLeaderId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(leaderIdList)) {
            throw TwException.error("", "当前登录人的部门负责人不存在，请维护");
        }
        if (leaderIdList.contains(permissionApplyDO.getApplyResId())) {
            isDepartmentHead = true;
        }
        //部门负责人
        variables.put("Activity_1ff34gj", leaderIdList.get(0));
        //人事专用印章保管员
        PrdOrgRoleVO personnelSignetCustody = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PERSONNEL_SIGNET_CUSTODY.getCode());
        if (ObjectUtils.isEmpty(personnelSignetCustody)) {
            throw new BusinessException("人事专用印章保管员不存在！");
        }
        String[] splitByPersonnelSignetCustody = personnelSignetCustody.getRoleEmployees().split(",");
        variables.put("Activity_03oy8as", Arrays.asList(splitByPersonnelSignetCustody));

        //打印人员审批
        String printWorkFlowRoleCode = dealPrintPersonnel(permissionApplyDO.getSignetType());
        if (!StringUtils.hasText(printWorkFlowRoleCode)) {
            throw new BusinessException("印章类型不存在，请联系管理员");
        }
        PrdOrgRoleVO printManage = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, printWorkFlowRoleCode);
        if (ObjectUtils.isEmpty(printManage)) {
            throw new BusinessException(WorkFlowRoleCodeEnum.valueOf(printWorkFlowRoleCode).getDesc() + "不存在！");
        }
        String[] splitByPrintManage = printManage.getRoleEmployees().split(",");
        variables.put("Activity_01c620f", Arrays.asList(splitByPrintManage));

        // 印章保管员审批(傅晓峰)
        PrdOrgRoleVO signetCustody = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_SIGNET_CUSTODY.getCode());
        if (ObjectUtils.isEmpty(signetCustody)) {
            throw new BusinessException(WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_SIGNET_CUSTODY.getDesc() + "不存在！");
        }
        String[] splitBySignetCustody = signetCustody.getRoleEmployees().split(",");
        variables.put("Activity_0rjplkf", Arrays.asList(splitBySignetCustody));

        //印章归还确认(傅晓峰)
        PrdOrgRoleVO signetReturn = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_RETURN.getCode());
        if (ObjectUtils.isEmpty(signetReturn)) {
            throw new BusinessException(WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_RETURN.getDesc() + "不存在！");
        }
        String[] splitBySignetReturn = signetReturn.getRoleEmployees().split(",");
        variables.put("Activity_1u28a42", Arrays.asList(splitBySignetReturn));

        //条件判断
        variables.put("isDepartmentHead", isDepartmentHead);
        variables.put("lendFlag", permissionApplyDO.getLendFlag());

        //是否人事专用章
        if (StringUtils.hasText(permissionApplyDO.getSignetType()) && SignetTypeEnum.PERSONNEL.getCode().equals(permissionApplyDO.getSignetType())) {
            isPersonnel = true;
        }
        //印章类型是否是人事专用章
        variables.put("isPersonnel", isPersonnel);

        //是否需要打印
        variables.put("printFlag", permissionApplyDO.getPrintFlag());
        return variables;
    }

    //获取打印人员roleCode
    public String dealPrintPersonnel(String signetType) {
        String roleCode = "";
        switch (SignetTypeEnum.toType(signetType)) {
            //人事
            case PERSONNEL:
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_PERSONNEL.getCode();
                break;
            //销售合同
            case SALES_CONTRACT:
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_SALES_CONTRACT.getCode();
                break;
            //采购合同
            case PURCHASE_CONTRACT:
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_PURCHASE_CONTRACT.getCode();
                break;
            //项目
            case PROJECT:
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_PROJECT.getCode();
                break;
            //行政
            case ADMINISTRATION:
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_ADMINISTRATION.getCode();
                break;
            //财务
            case FINANCE:
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_FINANCE.getCode();
                break;
            //市场
            case MARKETPLACE:
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_MARKETPLACE.getCode();
                break;
            default:
                break;
        }
        return roleCode;
    }
}
