package com.elitesland.tw.tw5.server.prd.partner.common.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 业务伙伴-地址信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Entity
@Table(name = "com_book_address", indexes = {
        @Index(name="index_book_id",columnList = "book_id")
})
@org.hibernate.annotations.Table(appliesTo = "com_book_address", comment = "业务伙伴-地址信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BookAddressDO extends BaseModel implements Serializable  {

    @Comment("业务伙伴主键 business_partner.id")
    @Column()
    private Long partnerId;
    /** 地址薄id */
    @Comment("地址薄id")
    @Column(name = "book_id")
    private Long bookId;
    /** 地址类型 */
    @Comment("地址类型 udc[prd:ab:addr_type]")
    @Column()
    @FieldUpdateLog(fieldName = "地址类型", selectionKey = "prd:ab:addr_type")
    @FieldCreateLog(fieldName = "地址类型", selectionKey = "prd:ab:addr_type")
    private String addressType;
    /** 国家 */
    @Comment("国家")
    @Column()
    @FieldCreateLog(fieldName = "国家")
    @FieldUpdateLog(fieldName = "国家")
    private String country;
    /** 省 */
    @Comment("省")
    @Column()
    private String province;
    /** 市 */
    @Comment("市")
    @Column()
    private String city;
    /** 区 */
    @Comment("区")
    @Column()
    private String district;
    /** 详细地址 */
    @Comment("详细地址")
    @Column()
    @FieldCreateLog(fieldName = "详细地址")
    @FieldUpdateLog(fieldName = "详细地址")
    private String detailAddress;
    /** 电话 */
    @Comment("电话")
    @Column()
    @FieldCreateLog(fieldName = "电话")
    @FieldUpdateLog(fieldName = "电话")
    private String phone;
    /** 邮箱 */
    @Comment("邮箱")
    @Column()
    @FieldCreateLog(fieldName = "邮箱")
    @FieldUpdateLog(fieldName = "邮箱")
    private String email;

    /** 邮箱 */
    @Comment("传真")
    @Column()
    @FieldCreateLog(fieldName = "传真")
    @FieldUpdateLog(fieldName = "传真")
    private String fax;

    /** 省 */
    @Comment("省")
    @Column()
    @FieldCreateLog(fieldName = "省")
    @FieldUpdateLog(fieldName = "省")
    private String provinceName;
    /** 市 */
    @Comment("市")
    @Column()
    @FieldCreateLog(fieldName = "市")
    @FieldUpdateLog(fieldName = "市")
    private String cityName;
    /** 区 */
    @Comment("区")
    @Column()
    @FieldCreateLog(fieldName = "区")
    @FieldUpdateLog(fieldName = "区")
    private String districtName;
    /** 是否为默认地址信息 */
    @Comment(value="是否为默认地址信息",defaultValue = "false")
    @Column()
    @FieldUpdateLog(fieldName = "默认地址", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    @FieldCreateLog(fieldName = "默认地址", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    private Boolean isDefault;
    /** 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标 */
    @Comment("经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标")
    @Column()
    private String longitudeLatitude;

    @Comment("联系人名称")
    @Column()
    private String contractName;

    public void copy(BookAddressDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
