package com.elitesland.tw.tw5.server.prd.partner.common.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 业务伙伴-联系信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Entity
@Table(name = "com_book_contacts", indexes = {
        @Index(name="index_book_id",columnList = "book_id")
})
@org.hibernate.annotations.Table(appliesTo = "com_book_contacts", comment = "业务伙伴-联系信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BookContactsDO extends BaseModel implements Serializable  {
    /** 地址薄id */
    @Comment("地址薄id")
    @Column(name = "book_id")
    private Long bookId;
    /** 联系人类型 */
    @Comment("联系人类型 udc[CRM:BUSINESS_PARTNER:CONTACTS_TYPE]")
    @Column()
    private String contactsType;
    /** 联系人姓名 */
    @Comment("联系人姓名")
    @Column()
    @FieldCreateLog(fieldName = "联系人姓名")
    @FieldUpdateLog(fieldName = "联系人姓名")
    private String contactsName;
    /** 联系人手机 */
    @Comment("联系人手机")
    @Column()
    @FieldCreateLog(fieldName = "联系人手机")
    @FieldUpdateLog(fieldName = "联系人手机")
    private String contactsPhone;
    /** 联系人电话 */
    @Comment("联系人电话")
    @Column()
    @FieldCreateLog(fieldName = "联系人电话")
    @FieldUpdateLog(fieldName = "联系人电话")
    private String contactsTelephone;
    /** 邮箱 */
    @Comment("邮箱")
    @Column()
    @FieldCreateLog(fieldName = "邮箱")
    @FieldUpdateLog(fieldName = "邮箱")
    private String contactsEmail;
    /** 联系地址 */
    @Comment("联系地址")
    @Column()
    @FieldCreateLog(fieldName = "联系地址")
    @FieldUpdateLog(fieldName = "联系地址")
    private String contactsAddress;
    /** 社交账户类型 */
    @Comment("社交账户类型")
    @Column()
    @FieldCreateLog(fieldName = "社交账户类型")
    @FieldUpdateLog(fieldName = "社交账户类型")
    private String socialAccountType;
    /** 社交账户 */
    @Comment("社交账户")
    @Column()
    @FieldCreateLog(fieldName = "社交账户")
    @FieldUpdateLog(fieldName = "社交账户")
    private String socialAccount;
    /** 部门 */
    @Comment("部门")
    @Column()
    @FieldCreateLog(fieldName = "部门")
    @FieldUpdateLog(fieldName = "部门")
    private String contactsDepartment;
    /** 岗位 */
    @Comment("岗位")
    @Column()
    @FieldCreateLog(fieldName = "岗位")
    @FieldUpdateLog(fieldName = "岗位")
    private String contactsPosition;
    /** 联系人关系 */
    @Comment("联系人关系")
    @Column()
    private String contactsRelation;
    /** 性别 udc[org:employee:sex] */
    @Comment("性别 udc[org:employee:sex]")
    @Column()
    @FieldUpdateLog(fieldName = "性别", selectionKey = "org:employee:sex")
    @FieldCreateLog(fieldName = "性别", selectionKey = "org:employee:sex")
    private String sex;
    /** 生日 */
    @Comment("生日")
    @Column()
    private LocalDate birthday;
    /** 是否是关键决策人 */
    @Comment("是否是关键决策人")
    @Column()
    @FieldUpdateLog(fieldName = "是否是关键决策人", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    @FieldCreateLog(fieldName = "是否是关键决策人", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    private Boolean isKeyPerson;
    /** 联系人编号 */
    @Comment("联系人编号")
    @Column()
    private String contactsNo;
    /** 联系人状态 */
    @Comment("联系人状态")
    @Column()
    private String contactsStatus;
    /** 是否为默认联系人信息 */
    @Comment(value="是否为默认联系人信息",defaultValue = "false")
    @Column()
    @FieldUpdateLog(fieldName = "默认联系人", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    @FieldCreateLog(fieldName = "默认联系人", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    private Boolean isDefault;

    public void copy(BookContactsDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
