package com.elitesland.tw.tw5.server.prd.partner.common.service;


import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.partner.business.service.CrmBusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.*;
import com.elitesland.tw.tw5.api.prd.partner.common.query.*;
import com.elitesland.tw.tw5.api.prd.partner.common.service.*;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.*;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCollaboratePartnerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCollaboratePartnerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.query.BusinessTeamMemberQuery;
import com.elitesland.tw.tw5.api.prd.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.dao.TransferUtilDAO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmFollowDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmFollowDO;
import com.elitesland.tw.tw5.server.prd.crm.service.CrmFollowServiceImpl;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BusinessPartnerConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BusinessPartnerDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BusinessPartnerRepo;
import com.elitesland.tw.tw5.server.prd.partner.constants.*;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessCollaboratePartnerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessSupplierInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCollaboratePartnerInfoRepo;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCustomerInfoRepo;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessDistributorInfoRepo;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessSupplierInfoRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.core.Tuple;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.collectingAndThen;
import static java.util.stream.Collectors.toCollection;

/**
 * 业务伙伴管理
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessPartnerServiceImpl extends BaseServiceImpl implements BusinessPartnerService {

    private final BusinessPartnerRepo businessPartnerRepo;
    private final BusinessPartnerDAO businessPartnerDAO;
    private final AddressBookService addressBookService;
    private final BookAddressService bookAddressService;
    private final BookContactsService bookContactsService;
    private final BookAccountService bookAccountService;
    private final BookInvoiceService bookInvoiceService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final BusinessTeamMemberService businessTeamMemberService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final BusinessSupplierInfoService businessSupplierInfoService;
    private final BusinessCollaboratePartnerInfoService businessCollaboratePartnerInfoService;
    private final CacheUtil cacheUtil;
    private final BusinessCustomerInfoRepo businessCustomerInfoRepo;
    private final BusinessSupplierInfoRepo businessSupplierInfoRepo;
    private final BusinessCollaboratePartnerInfoRepo businessCollaboratePartnerInfoRepo;
    private final BusinessDistributorInfoRepo businessDistributorInfoRepo;
    private final UdcUtil udcUtil;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdOrgEmployeeDAO employeeDAO;
    @Value("${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final TransactionUtilService transactionUtilService;
    private final ComChangeService changeService;
    @Value("${tw4.prd_ab.operation:api/openReport/v1/sync/asyncAbTask}")
    private String prd_ab_operation;
    private final HttpUtil httpUtil;
    private final TransferUtilServiceImpl transferUtilService;
    private final TransferUtilDAO transferUtilDAO;

    private final CrmLeadsDAO crmLeadsDAO;
    private final CrmOpportunityDAO crmOpportunityDAO;
    private final CrmFollowDAO crmFollowDAO;
    private final CrmFollowServiceImpl followService;
    private final CrmActActivityDAO actActivityDAO;
    //TODO 后续为了解耦 可以采用队列方式 发送消息，即可删除此引用

    //  private CrmBusinessPartnerService crmBusinessPartnerService;

    @Override
    public PagingVO<BusinessPartnerVO> queryPaging(BusinessPartnerQuery query) {
        // 校验权限
        dataPermission(query);
        PagingVO<BusinessPartnerVO> businessPartnerVOPagingVO = businessPartnerDAO.queryPaging(query);
        //翻译返回的身份
//        businessPartnerVOPagingVO.stream().forEach(businessPartnerVO -> translate(businessPartnerVO,businessTeamMemberVOS,crmCustomerOperationVOS,crmCustomerOperationNoPermissionVOS));
        translateList(businessPartnerVOPagingVO.getRecords());
        return businessPartnerVOPagingVO;
    }

    @Override
    public long count(BusinessPartnerQuery query) {
        // 校验权限
        dataPermission(query);
        return businessPartnerDAO.count(query);
    }

    @Override
    public List<BusinessPartnerVO> queryListDynamic(BusinessPartnerQuery query) {
        // 校验权限
        dataPermission(query);
        List<BusinessPartnerVO> businessPartnerVOList = businessPartnerDAO.queryListDynamic(query);
//        businessPartnerVOList.stream().forEach(businessPartnerVO -> translate(businessPartnerVO));
        translateList(businessPartnerVOList);
        return businessPartnerVOList;
    }


    @Override
    public void judgePartnerName(String partnerName) {
        Long total = businessPartnerDAO.judgePartnerName(partnerName);
        if (total > 0) {
            throw TwException.error("", "业务伙伴名称已存在，请重新输入");
        }
    }

    @Override
    public List<BusinessPartnerVO> queryListByIds(List<Long> ids) {
        List<BusinessPartnerVO> vos = businessPartnerDAO.findByIds(ids);
//        vos.stream().forEach(vo -> translate(vo));
        translateList(vos);
        return vos;

    }

    @Override
    public BusinessPartnerIdentityVO judgeIdentityDisplay(Long partnerId) {
        BusinessPartnerDO entityDo = businessPartnerRepo.findById(partnerId).orElseGet(BusinessPartnerDO::new);
        Assert.notNull(entityDo.getId(), "不存在");
        BusinessPartnerIdentityVO businessPartnerIdentityVO = new BusinessPartnerIdentityVO();
        List<BusinessPartnerIdentityVO.IdentityVO> IdentityVOList = new ArrayList<>();
        Long bookId = entityDo.getBookId();
        //查询银行信息数量
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(bookId);
        businessPartnerIdentityVO.setAccountCount(bookAccountService.count(bookAccountQuery));
        //查询地址信息数量
        BookAddressQuery bookAddressQuery = new BookAddressQuery();
        bookAddressQuery.setBookId(bookId);
        businessPartnerIdentityVO.setAddressCount(bookAddressService.count(bookAddressQuery));
        //查询开票信息数量
        BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
        bookInvoiceQuery.setBookId(bookId);
        businessPartnerIdentityVO.setInvoiceCount(bookInvoiceService.count(bookInvoiceQuery));
        //查询联系信息数量
        BookContactsQuery bookContactsQuery = new BookContactsQuery();
        bookContactsQuery.setBookId(bookId);
        businessPartnerIdentityVO.setContactCount(bookContactsService.count(bookContactsQuery));
        //查询团队成员数量
        BusinessTeamMemberQuery businessTeamMemberQuery = new BusinessTeamMemberQuery();
        businessTeamMemberQuery.setObjectId(entityDo.getId());
        businessPartnerIdentityVO.setTeamCount(businessTeamMemberService.count(businessTeamMemberQuery));
        BusinessCustomerInfoDO businessCustomerInfoDO = businessCustomerInfoRepo.findByPartnerId(partnerId);
        if (entityDo.getCustomerFlag() || businessCustomerInfoDO != null) {
            BusinessPartnerIdentityVO.IdentityVO identityVO = businessPartnerIdentityVO.new IdentityVO();
            identityVO.setName("客户");
            identityVO.setValue("customer");
            if (entityDo.getCustomerFlag() && !BusinessPartnerStatusEnum.APPROVING.getCode().equals(businessCustomerInfoDO.getCustomerStatus())) {
                identityVO.setCanEdit(true);
            }
            IdentityVOList.add(identityVO);
            CrmBusinessPartnerService crmBusinessPartnerService = SpringUtil.getBean(CrmBusinessPartnerService.class);
            //业务往来数量
            long countBusiness = crmBusinessPartnerService.countBusiness(partnerId, bookId);
            businessPartnerIdentityVO.setBusinessCount(countBusiness);
            //经营往来数量
            long countFollowList = crmBusinessPartnerService.countFollowList(partnerId);
            businessPartnerIdentityVO.setOperationCount(countFollowList);
        }
        //保存供应商
        if (entityDo.getSupplierFlag() || businessSupplierInfoRepo.findByPartnerId(partnerId) != null) {
            BusinessPartnerIdentityVO.IdentityVO identityVO = businessPartnerIdentityVO.new IdentityVO();
            identityVO.setName("供应商");
            identityVO.setValue("supply");
            if (entityDo.getSupplierFlag()) {
                identityVO.setCanEdit(true);
            }
            IdentityVOList.add(identityVO);

        }
        //保存经销商
        if (entityDo.getDistributorFlag() || businessDistributorInfoRepo.findByPartnerId(partnerId) != null) {
            BusinessPartnerIdentityVO.IdentityVO identityVO = businessPartnerIdentityVO.new IdentityVO();
            identityVO.setName("经销商");
            identityVO.setValue("dealer");
            if (entityDo.getDistributorFlag()) {
                identityVO.setCanEdit(true);
            }
            IdentityVOList.add(identityVO);
        }
        //保存合作伙伴
        if (entityDo.getCollaborateFlag() || businessCollaboratePartnerInfoRepo.findByPartnerId(partnerId) != null) {
            BusinessPartnerIdentityVO.IdentityVO identityVO = businessPartnerIdentityVO.new IdentityVO();
            identityVO.setName("合作伙伴");
            identityVO.setValue("partner");
            if (entityDo.getCollaborateFlag()) {
                identityVO.setCanEdit(true);
            }
            IdentityVOList.add(identityVO);
        }
        businessPartnerIdentityVO.setOperation(IdentityVOList);
        return businessPartnerIdentityVO;
    }

    /**
     * 组织树
     *
     * @param query 查询
     * @return {@link List}<{@link BusinessPartnerTreeVO}>
     */
    @Override
    public List<BusinessPartnerTreeVO> listTree(BusinessPartnerQuery query) {
        List<BusinessPartnerVO> businessPartnerVOS = queryListDynamic(query);
        if (!CollectionUtils.isEmpty(businessPartnerVOS)) {
            List<BusinessPartnerTreeVO> businessPartnerTreeVOS = BusinessPartnerConvert.INSTANCE.voListVoTreeList(businessPartnerVOS);

            final List<BusinessPartnerTreeVO> collection = treeDataSearch(businessPartnerTreeVOS);
            if (!CollectionUtils.isEmpty(collection)) {
                businessPartnerTreeVOS.addAll(collection);
            }
            // 数据去重
            businessPartnerTreeVOS = businessPartnerTreeVOS.stream().collect(
                    collectingAndThen(
                            toCollection(() -> new TreeSet<>(Comparator.comparing(BusinessPartnerTreeVO::getId))), ArrayList::new)
            );

            return businessPartnerTreeVOS;

        }
        return Collections.EMPTY_LIST;
    }

    /**
     * 级联查询母公司数据
     *
     * @param vos
     * @return {@link List}<{@link CrmCustomerOperationVO}>
     */
    private List<BusinessPartnerTreeVO> treeDataSearch(List<BusinessPartnerTreeVO> vos) {
        List<BusinessPartnerTreeVO> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(vos)) {
            vos.forEach(crmCustomerOperationVO -> {
                final Long parentId = crmCustomerOperationVO.getParentId();
                if (parentId != null) {
                    BusinessPartnerVO vo = queryByKey(parentId);
                    BusinessPartnerTreeVO treeVO = new BusinessPartnerTreeVO();
                    result.add(BusinessPartnerConvert.INSTANCE.voToTree(vo));
                }
            });
            if (!CollectionUtils.isEmpty(treeDataSearch(result))) {
                result.addAll(treeDataSearch(result));
            }
        }
        return result;
    }

    @Override
    public List<BusinessPartnerSimpleVO> queryListSimple() {
        return businessPartnerDAO.queryListSimple();
    }

    @Override
    public List<BusinessPartnerSimpleVO> queryNearCustomerList() {
        return businessPartnerDAO.queryNearCustomerList();
    }

    @Override
    public BusinessPartnerVO queryByKey(Long key) {
        BusinessPartnerVO businessPartnerVO = businessPartnerDAO.queryByKey(key);
//        BusinessPartnerDO entity = businessPartnerRepo.findById(key).orElseGet(BusinessPartnerDO::new);
//        Assert.notNull(entity.getId(), "不存在");
        //       BusinessPartnerVO vo = BusinessPartnerConvert.INSTANCE.toVo(entity);
        if (businessPartnerVO == null) {
            throw TwException.error("", "数据不存在");
        }
        if (businessPartnerVO.getParentId() != null) {
            BusinessPartnerDO partnerDO = businessPartnerRepo.findById(businessPartnerVO.getParentId()).orElseGet(BusinessPartnerDO::new);
            businessPartnerVO.setParentIdDesc(partnerDO.getPartnerName());
        }
//        BookAddressQuery bookAddressQuery = new BookAddressQuery();
//        bookAddressQuery.setBookId(vo.getBookId());
//        BookAddressVO bookAddressVO = bookAddressService.queryDefaultByBookId(vo.getBookId());
//        if(bookAddressVO!=null){
//           vo.setProvinceName(bookAddressVO.getProvinceName());
//           vo.setCityName(bookAddressVO.getProvinceName());
//           vo.setDistrictName(bookAddressVO.getDistrictName());
//           vo.setProvince(bookAddressVO.getProvince());
//           vo.setCity(bookAddressVO.getCity());
//           vo.setDistrict(bookAddressVO.getDistrict());
//        }
        Map<String, List<BusinessTeamMemberVO>> teamMemberMap = new HashMap<>();
        Map<Long, List<CrmCustomerOperationVO>> customerOperationMap = new HashMap<>();

        ///先查询团队成员
        BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
        teamMemberQuery.setObjectId(key);
        List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryListDynamic(teamMemberQuery);
        if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
            teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
        }
        //商务负责人
        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
            businessPartnerVO.setBusinessUserId(teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getUserId());
            businessPartnerVO.setBusinessUserName(teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getMemberName());

        }
        //服务负责人
        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
            businessPartnerVO.setServiceUserId(teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getUserId());
            businessPartnerVO.setServiceUserName(teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getMemberName());

        }
        //关怀负责人
        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
            businessPartnerVO.setCareUserId(teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getUserId());
            businessPartnerVO.setCareUserName(teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getMemberName());

        }
        //运维售后负责人
        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
            businessPartnerVO.setOperationUserId(teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getUserId());
            businessPartnerVO.setOperationUserName(teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getMemberName());

        }
//        translate(businessPartnerVO);
        translateList(Collections.singletonList(businessPartnerVO));
        return businessPartnerVO;
    }

    @Override
    public List<BusinessPartnerVO> queryByBookId(Long bookId) {
        return businessPartnerDAO.queryByBookId(bookId);
    }

    @Override
    public BusinessPartnerVO queryCustomerByBookId(Long bookId) {
        if (bookId == null) {
            throw TwException.error("", "地址薄id不能为空");
        }
        return businessPartnerDAO.queryCustomerByBookId(bookId);
    }

    @Override
    public BusinessPartnerVO querySupplierByBookId(Long bookId) {
        if (bookId == null) {
            throw TwException.error("", "地址薄id不能为空");
        }
        return businessPartnerDAO.querySupplierByBookId(bookId);
    }

    @Override
    public BusinessPartnerSimpleVO queryByPartnerName(String partnerName) {
        if (StringUtils.isEmpty(partnerName)) {
            return null;
        }
        return businessPartnerDAO.queryByPartnerName(partnerName);
    }

    /**
     * 简单查询
     *
     * @param key 关键
     * @return {@link BusinessPartnerVO}
     */
    @Override
    public BusinessPartnerVO queryByKeySimple(Long key) {
        BusinessPartnerDO entity = businessPartnerRepo.findById(key).orElseGet(BusinessPartnerDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessPartnerVO vo = BusinessPartnerConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessPartnerVO insert(BusinessPartnerPayload payload) {
        return insertPro(payload, true, true, true);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessPartnerVO insertPro(BusinessPartnerPayload payload, boolean checkPartnerNameFlag, boolean qixinFlag, boolean operationLogRecordFlag) {
        if (checkPartnerNameFlag) {
            //校验业务伙伴名字是否重复
            judgePartnerName(payload.getPartnerName());
        }
        //先保存地址薄
        AddressBookVO addressBookVO = addressBookService.insert(new AddressBookPayload());

        payload.setBookId(addressBookVO.getId());
        if (StringUtils.isEmpty(payload.getBusinessPartnerNo())) {
            payload.setBusinessPartnerNo(generateSeqNum(GenerateSeqNumConstants.BUSINESS_PARTNER));
        }
        BusinessPartnerDO entityDo = BusinessPartnerConvert.INSTANCE.toDo(payload);
        //将名字转为拼音
        String partnerName = entityDo.getPartnerName();
        String pinyin = PinyinUtil.getPinyin(partnerName, "");
        entityDo.setPartnerNamePinyin(pinyin);
        entityDo.setDataTransferFlag(false);
        //查询列表会根据身份查询
        entityDo.setCustomerFlag(false);
        entityDo.setSupplierFlag(false);
        entityDo.setCollaborateFlag(false);
        entityDo.setDistributorFlag(false);
        payload.setCustomerFlag(false);
        payload.setSupplierFlag(false);
        String identityDescLog = "";
        if (BusinessInsideOrOutSideEnum.OUTSIDE.getCode().equals(payload.getInsideOrOutSide())) {
            String[] identityArray = payload.getPartnerIdentity().split(",");
            List identityList = Arrays.asList(identityArray);
            if (operationLogRecordFlag) {
                String identityDesc = translateIdentity(payload.getPartnerIdentity());
                identityDescLog = "身份 创建为 " + identityDesc + "\n";
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                entityDo.setCustomerFlag(true);
                payload.setCustomerFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                entityDo.setSupplierFlag(true);
                payload.setSupplierFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                entityDo.setCollaborateFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode())) {
                entityDo.setDistributorFlag(true);
            }
        }
        //调用4.0同步 同步数据到4.0 只同步 客户 供应商 且为外部的数据 内部公司数据不同步
//        if ((payload.getCustomerFlag() || payload.getSupplierFlag()) && BusinessInsideOrOutSideEnum.OUTSIDE.getCode().equals(payload.getInsideOrOutSide())) {
//            payload.setBookId(entityDo.getBookId());
//            Long bookIdV4 = syncTw4(payload);
//            entityDo.setBookIdV4(bookIdV4);
//        }
        BusinessPartnerDO save = businessPartnerRepo.save(entityDo);
        final Long id = save.getId();
        //新增业务伙伴的时候 地址 联系人手机 联系人地址要插入到对应的表中
        //保存地址信息
        String longitudeLatitude = "";
        if (!StringUtils.isEmpty(payload.getProvince()) || !StringUtils.isEmpty(payload.getDetailAddress())) {
            BookAddressPayload bookAddressPayload = new BookAddressPayload();
            bookAddressPayload.setBookId(addressBookVO.getId());
            bookAddressPayload.setDetailAddress(payload.getDetailAddress());
            bookAddressPayload.setCountry(payload.getCountry());
            bookAddressPayload.setProvince(payload.getProvince());
            bookAddressPayload.setProvinceName(payload.getProvinceName());
            bookAddressPayload.setCity(payload.getCity());
            bookAddressPayload.setCityName(payload.getCityName());
            bookAddressPayload.setDistrict(payload.getDistrict());
            bookAddressPayload.setDistrictName(payload.getDistrictName());
            bookAddressPayload.setIsDefault(true);
            bookAddressPayload.setAddressType(BookAddressTypeEnum.company_addr.getCode());
            bookAddressPayload.setCountry(CountryEnum.CHINA.getCode());
            bookAddressPayload.setPartnerId(id);
            bookAddressPayload.setLongitudeLatitude(payload.getLongitudeLatitude());
            BookAddressVO insert = bookAddressService.insert(bookAddressPayload, true);
            longitudeLatitude = insert.getLongitudeLatitude();
            //同步4.0
        }
//        //保存联系人信息
//        if (!StringUtils.isEmpty(payload.getContactsName()) || !StringUtils.isEmpty(payload.getContactsPhone())) {
//            BookContactsPayload bookContactsPayload = new BookContactsPayload();
//            bookContactsPayload.setBookId(addressBookVO.getId());
//            bookContactsPayload.setContactsName(payload.getContactsName());
//            bookContactsPayload.setContactsPhone(payload.getContactsPhone());
//            bookContactsPayload.setContactsPosition(payload.getContactsPosition());
//            bookContactsPayload.setContactsDepartment(payload.getContactsDepartment());
//            bookContactsPayload.setIsDefault(true);
//            bookContactsPayload.setPartnerId(entityDo.getId());
//            bookContactsService.insert(bookContactsPayload, true);
//            //同步4.0
//        }

        //处理新增的 客户 供应商 合作伙伴 团队成员
        dealSaveBusinessPartner(payload, entityDo);
        if (operationLogRecordFlag) {
            // 获取变更日志
            final String fieldsCreateLog = changeFieldLogUtil.getFieldsCreateLog(entityDo);
            logService.saveNewLog(id, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), identityDescLog + fieldsCreateLog);
        }
        //TODO 后续为了解耦 可以采用队列方式 发送消息，即可删除此引用
        // 补充启信宝数据
        if (qixinFlag) {
            CrmBusinessPartnerService crmBusinessPartnerService = SpringUtil.getBean(CrmBusinessPartnerService.class);
            boolean qxbDataInitFlag = crmBusinessPartnerService.fillQxbInfo(save.getPartnerName(), save.getId(), save.getBookId());
            //  业务伙伴表增加标记，标记已经补充启信宝数据
            if (qxbDataInitFlag) {
                save.setQxbDataInitFlag(true);
            } else {
                // throw TwException.error("", "名称不合规");
            }
        }
        //线索那边有真实的客户id逻辑 因此在这里加上
        BusinessPartnerVO businessPartnerVO = BusinessPartnerConvert.INSTANCE.toVo(save);
        businessPartnerVO.setLongitudeLatitude(longitudeLatitude);
        return businessPartnerVO;
    }

    /**
     * 新增其他身份
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessPartnerVO insertOtherIdentity(BusinessPartnerPayload payload, Boolean operationLogRecordFlag) {
        BusinessPartnerDO entity = businessPartnerRepo.findById(payload.getId()).orElseGet(BusinessPartnerDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 变更日志用
        BusinessPartnerDO entityLog = new BusinessPartnerDO();
        BeanUtils.copyProperties(entity, entityLog);

        BusinessPartnerDO entityDo = BusinessPartnerConvert.INSTANCE.toDo(payload);
        entityDo.setCustomerFlag(false);
        entityDo.setSupplierFlag(false);
        entityDo.setCollaborateFlag(false);
        if (BusinessInsideOrOutSideEnum.OUTSIDE.getCode().equals(payload.getInsideOrOutSide())) {
            String oldIdentity = entity.getPartnerIdentity();
            String newIdentity = payload.getPartnerIdentity();
            if (oldIdentity.equals(newIdentity)) {
                throw TwException.error("", "身份未变更，请修改后重新提交");
            }
            //截取出新增的身份（因为身份只能增加 不能删除）
            String partnerIdentity = entity.getPartnerIdentity();
            String[] oldIdentityArray = partnerIdentity.split(",");
            List oldIdentityList = new ArrayList(Arrays.asList(oldIdentityArray));

            String[] identityArray = payload.getPartnerIdentity().split(",");
            List identityList = new ArrayList(Arrays.asList(identityArray));
            identityList.removeAll(oldIdentityList);


            if (identityList.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                entityDo.setCustomerFlag(true);
            }

            if (identityList.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                entityDo.setSupplierFlag(true);
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                entityDo.setCollaborateFlag(true);
            }
            if (operationLogRecordFlag) {
                // 获取变更日志
                logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "身份由" + oldIdentity + " 修改为 " + newIdentity);
            }
        }
        //处理新增的 客户 供应商 合作伙伴 团队成员
        dealSaveBusinessPartner(payload, entityDo);
        entity.copy(entityDo);
        String partnerIdentity = entity.getPartnerIdentity();
        //因为将原来是true的置为了false 因此重新赋值
        if (partnerIdentity.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
            entity.setCustomerFlag(true);
        }
        if (partnerIdentity.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
            entity.setSupplierFlag(true);
        }
        if (partnerIdentity.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
            entity.setSupplierFlag(true);
        }
        BusinessPartnerDO save = businessPartnerDAO.save(entity);
        // 更新补充启信宝数据
        boolean qxbDataInitFlagDb = null == entity.getQxbDataInitFlag() || (null != entity.getQxbDataInitFlag() && !entity.getQxbDataInitFlag());
        if (org.springframework.util.StringUtils.hasText(payload.getPartnerName()) && qxbDataInitFlagDb) {
            CrmBusinessPartnerService crmBusinessPartnerService = SpringUtil.getBean(CrmBusinessPartnerService.class);
            // 补充启信宝数据
            boolean qxbDataInitFlag = crmBusinessPartnerService.fillQxbInfo(save.getPartnerName(), save.getId(), save.getBookId());
            //  业务伙伴表增加标记，标记已经补充启信宝数据
            if (qxbDataInitFlag) {
                save.setQxbDataInitFlag(true);
            }
        }
        //数据同步4.0
        //调用4.0同步 同步数据到4.0 只同步 客户 供应商 且为外部的数据 内部公司数据不同步
//        if ((payload.getCustomerFlag() || payload.getSupplierFlag()) && BusinessInsideOrOutSideEnum.OUTSIDE.getCode().equals(payload.getInsideOrOutSide())) {
//            payload.setBookIdV4(entity.getBookIdV4());
//            syncTw4(payload);
//        }
        return null;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessPartnerVO update(BusinessPartnerPayload payload) {
        BusinessPartnerDO entity = businessPartnerRepo.findById(payload.getId()).orElseGet(BusinessPartnerDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 变更日志用
        BusinessPartnerDO entityLog = new BusinessPartnerDO();
        BeanUtils.copyProperties(entity, entityLog);

        BusinessPartnerDO entityDo = BusinessPartnerConvert.INSTANCE.toDo(payload);
        if (org.springframework.util.StringUtils.hasText(entityDo.getPartnerName())) {
            //将名字转为拼音
            String partnerName = entityDo.getPartnerName();
            String pinyin = PinyinUtil.getPinyin(partnerName, "");
            entityDo.setPartnerNamePinyin(pinyin);
        }
        if (!StringUtils.isEmpty(payload.getPartnerIdentity())) {
            String[] identityArray = payload.getPartnerIdentity().split(",");
            List identityList = Arrays.asList(identityArray);
            //更新的时候将身份判断字段全部更新一遍 以防某些身份去掉但表里字段是true
            entityDo.setCustomerFlag(false);
            entityDo.setSupplierFlag(false);
            entityDo.setCollaborateFlag(false);
            if (identityList.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                entityDo.setCustomerFlag(true);
            }

            if (identityList.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                entityDo.setSupplierFlag(true);
            }

            if (identityList.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                entityDo.setCollaborateFlag(true);
            }
            //如果更新的时候身份被更改了 要在对应身份的子表中插入数据 因为是更新 所以需要判断之前是否有数据
            Long id = entityDo.getId();

            //保存客户身份
            BusinessCustomerInfoDO BusinessCustomerInfoDO = businessCustomerInfoRepo.findByPartnerId(id);
            if (entityDo.getCustomerFlag()) {
                if (BusinessCustomerInfoDO != null) {
                    //客户原来存在 将状态改为新建
                    BusinessCustomerInfoDO.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessCustomerInfoRepo.save(BusinessCustomerInfoDO);
                } else {
                    // 客户不存在 新增数据
                    BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
                    businessCustomerInfoPayload.setPartnerId(id);
                    businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessCustomerInfoPayload.setIsOperate(false);
                    businessCustomerInfoPayload.setCustomerGradle(payload.getCustomerGradle());
                    businessCustomerInfoPayload.setCustomerRegion(payload.getCustomerRegion());
                    businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.POTENTIAL.getCode());
                    businessCustomerInfoService.insert(businessCustomerInfoPayload);
                }
            } else {
                //数据存在 将状态改为关闭
                if (BusinessCustomerInfoDO != null) {
                    //客户原来存在 将状态改为关闭
                    BusinessCustomerInfoDO.setCustomerStatus(BusinessPartnerStatusEnum.CLOSE.getCode());
                    businessCustomerInfoRepo.save(BusinessCustomerInfoDO);
                }
                //如果之前的数据是true 说明是由true变为false
                if (entity.getCustomerFlag()) {
                    //身份改变 更新对应的团队成员角色为普通成员
                    businessTeamMemberService.updateTeamByIdentityChange(id, BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                }

            }

            //保存供应商身份
            BusinessSupplierInfoDO supplierInfoDO = businessSupplierInfoRepo.findByPartnerId(id);
            if (entityDo.getSupplierFlag()) {
                if (supplierInfoDO != null) {
                    //供应商原来存在 将状态改为新建
                    supplierInfoDO.setSupplierStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessSupplierInfoRepo.save(supplierInfoDO);
                } else {
                    // 供应商不存在 新增数据
                    BusinessSupplierInfoPayload businessSupplierInfoPayload = new BusinessSupplierInfoPayload();
                    businessSupplierInfoPayload.setPartnerId(id);
                    businessSupplierInfoPayload.setSupplierStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessSupplierInfoService.insert(businessSupplierInfoPayload);
                }
            } else {
                //数据存在 将状态改为关闭
                if (supplierInfoDO != null) {
                    //客户原来存在 将状态改为新建
                    supplierInfoDO.setSupplierStatus(BusinessPartnerStatusEnum.CLOSE.getCode());
                    businessSupplierInfoRepo.save(supplierInfoDO);
                }
                //如果之前的数据是true 说明是由true变为false
                if (entity.getSupplierFlag()) {
                    //身份改变 更新对应的团队成员角色为普通成员
                    businessTeamMemberService.updateTeamByIdentityChange(id, BusinessPartnerIdentityEnum.SUPPLIER.getCode());
                }
            }

            //保存合作伙伴
            BusinessCollaboratePartnerInfoDO collaboratePartnerInfoDO = businessCollaboratePartnerInfoRepo.findByPartnerId(id);
            if (entityDo.getCollaborateFlag()) {
                if (collaboratePartnerInfoDO != null) {
                    //合作伙伴原来存在 将状态改为新建
                    collaboratePartnerInfoDO.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessCollaboratePartnerInfoRepo.save(collaboratePartnerInfoDO);
                } else {
                    // 合作伙伴不存在 新增数据
                    BusinessCollaboratePartnerInfoPayload businessCollaboratePartnerInfoPayload = new BusinessCollaboratePartnerInfoPayload();
                    businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    businessCollaboratePartnerInfoPayload.setPartnerId(id);
                    businessCollaboratePartnerInfoService.insert(businessCollaboratePartnerInfoPayload);
                }
            } else {
                //数据存在 将状态改为关闭
                if (collaboratePartnerInfoDO != null) {
                    //合作伙伴原来存在 将状态改为新建
                    collaboratePartnerInfoDO.setCollaborateStatus(BusinessPartnerStatusEnum.CLOSE.getCode());
                    businessCollaboratePartnerInfoRepo.save(collaboratePartnerInfoDO);
                }
                //如果之前的数据是true 说明是由true变为false 修改逻辑同上
                if (entity.getCollaborateFlag() && entityDo.getDistributorFlag()) {
                    //身份改变 更新对应的团队成员角色为普通成员
                    businessTeamMemberService.updateTeamByIdentityChange(id, BusinessPartnerIdentityEnum.COLLABORATE.getCode());
                }
            }
        }
        //更新团队成员
        BusinessCutomerManagePayload businessCutomerManagePayload = new BusinessCutomerManagePayload();
        businessCutomerManagePayload.setBusinessUserId(payload.getBusinessUserId());
        businessCutomerManagePayload.setServiceUserId(payload.getServiceUserId());
        businessCutomerManagePayload.setOperationUserId(payload.getOperationUserId());
        businessCutomerManagePayload.setCareUserId(payload.getCareUserId());
        businessCutomerManagePayload.setId(payload.getId());
        businessCustomerInfoService.updateCustomerManageTeamMember(businessCutomerManagePayload);

        entity.copy(entityDo);
        // 修改NULL值特殊处理
        final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
        final BusinessPartnerDO save = businessPartnerRepo.save(entity);

        //获取变更日志
        fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (org.springframework.util.StringUtils.hasText(fieldsUpdateLog)) {
            logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
        }

        // 更新补充启信宝数据
        boolean qxbDataInitFlagDb = null == entity.getQxbDataInitFlag() || (null != entity.getQxbDataInitFlag() && !entity.getQxbDataInitFlag());
        if (org.springframework.util.StringUtils.hasText(payload.getPartnerName()) && qxbDataInitFlagDb) {
            CrmBusinessPartnerService crmBusinessPartnerService = SpringUtil.getBean(CrmBusinessPartnerService.class);
            // 补充启信宝数据
            boolean qxbDataInitFlag = crmBusinessPartnerService.fillQxbInfo(save.getPartnerName(), save.getId(), save.getBookId());
            //  业务伙伴表增加标记，标记已经补充启信宝数据
            if (qxbDataInitFlag) {
                save.setQxbDataInitFlag(true);
            }
        }

        return BusinessPartnerConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessPartnerDAO.deleteSoft(keys);
        }
    }


    /**
     * 批量
     */
    private void translateList(List<BusinessPartnerVO> businessPartnerVOS) {

        List<Long> ids = businessPartnerVOS.stream().map(e -> e.getId()).collect(Collectors.toList());
        List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryByObjectIdsAndRole(ids, BusinessTeamRoleEnum.SALE_MANAGER.getCode());

        //处理客户经营 先查看是否有权限 如果有权限返回前端没有权限 如果没有权限 那么需要查询他是否有客户经营数据 有的话返回客户经营状态 但是权限返回false
        CrmCustomerOperationService crmCustomerOperationService = SpringUtil.getBean(CrmCustomerOperationService.class);
        CrmCustomerOperationQuery crmCustomerOperationQuery = new CrmCustomerOperationQuery();
        crmCustomerOperationQuery.setCustomerIdList(ids);
        List<CrmCustomerOperationVO> crmCustomerOperationVOS = crmCustomerOperationService.queryListCommon(crmCustomerOperationQuery);
        List<CrmCustomerOperationVO> crmCustomerOperationNoPermissionVOS = crmCustomerOperationService.queryList(crmCustomerOperationQuery);

        Map<Long, List<BusinessTeamMemberVO>> businessTeamMemberVOSMap = businessTeamMemberVOS.stream()
                .collect(Collectors.groupingBy(BusinessTeamMemberVO::getId));

        Map<Long, List<CrmCustomerOperationVO>> crmCustomerOperationVOSMap = crmCustomerOperationVOS.stream()
                .collect(Collectors.groupingBy(CrmCustomerOperationVO::getId));

        Map<Long, List<CrmCustomerOperationVO>> crmCustomerOperationNoPermissionVOSMap = crmCustomerOperationNoPermissionVOS.stream()
                .collect(Collectors.groupingBy(CrmCustomerOperationVO::getCustomerId));
        businessPartnerVOS.stream().forEach(businessPartnerVO -> translate(businessPartnerVO, businessTeamMemberVOSMap, crmCustomerOperationVOSMap, crmCustomerOperationNoPermissionVOSMap));
    }


    //处理业务逻辑
    private void translate(BusinessPartnerVO businessPartnerVO, Map<Long, List<BusinessTeamMemberVO>> businessTeamMemberVOSMap, Map<Long, List<CrmCustomerOperationVO>> crmCustomerOperationVOSMap, Map<Long, List<CrmCustomerOperationVO>> crmCustomerOperationNoPermissionVOSMap) {
        Long businessPartnerVOId = businessPartnerVO.getId();
        //处理身份
        String identity = businessPartnerVO.getPartnerIdentity();
        if (org.springframework.util.StringUtils.hasText(identity)) {
            businessPartnerVO.setPartnerIdentityDesc(translateIdentity(identity));
            //处理销售负责人
            if (identity.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
//                List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryByObjectIdAndRole(businessPartnerVO.getId(), BusinessTeamRoleEnum.SALE_MANAGER.getCode())
                List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberVOSMap.get(businessPartnerVOId);
                if (businessTeamMemberVOS != null && businessTeamMemberVOS.size() > 0) {
                    StringBuilder saleDutyIdStr = new StringBuilder();
                    StringBuilder saleDutyIdDescStr = new StringBuilder();
                    for (int i = 0; i < businessTeamMemberVOS.size(); i++) {
                        if (i == businessTeamMemberVOS.size() - 1) {
                            saleDutyIdStr.append(businessTeamMemberVOS.get(i).getUserId());
                            saleDutyIdDescStr.append(cacheUtil.getUserName(businessTeamMemberVOS.get(i).getUserId()));
                        } else {
                            saleDutyIdStr.append(businessTeamMemberVOS.get(i).getUserId() + ",");
                            saleDutyIdDescStr.append(cacheUtil.getUserName(businessTeamMemberVOS.get(i).getUserId()) + ",");
                        }
                    }
                    businessPartnerVO.setSaleDutyId(saleDutyIdStr.toString());
                    businessPartnerVO.setSaleDutyIdDesc(saleDutyIdDescStr.toString());
                }
            }
        }
        //处理省市区
        StringBuilder str = new StringBuilder();
        if (businessPartnerVO.getProvinceName() != null) {
            str.append(businessPartnerVO.getProvinceName() + "/");
        }
        if (businessPartnerVO.getCityName() != null) {
            str.append(businessPartnerVO.getCityName() + "/");
        }
        if (businessPartnerVO.getDistrictName() != null) {
            str.append(businessPartnerVO.getDistrictName());
        }
        businessPartnerVO.setAddress(str.toString());
        //处理客户经营 先查看是否有权限 如果有权限返回前端没有权限 如果没有权限 那么需要查询他是否有客户经营数据 有的话返回客户经营状态 但是权限返回false
//        CrmCustomerOperationService crmCustomerOperationService = SpringUtil.getBean(CrmCustomerOperationService.class);
//        CrmCustomerOperationQuery crmCustomerOperationQuery = new CrmCustomerOperationQuery();
//        crmCustomerOperationQuery.setCustomerId(businessPartnerVO.getId());
//        List<CrmCustomerOperationVO> crmCustomerOperationVOS = crmCustomerOperationService.queryListCommon(crmCustomerOperationQuery);
        List<CrmCustomerOperationVO> crmCustomerOperationVOS = crmCustomerOperationVOSMap.get(businessPartnerVOId);
        // 先给客户经营状态和客户经营权限赋默认值
        businessPartnerVO.setCustOperStatus(BusinessOperStatusEnum.CLOSE.getCode());
        businessPartnerVO.setBusinessOperaPermissonFlag(false);
        //有权限的情况
        if (!CollectionUtils.isEmpty(crmCustomerOperationVOS)) {
            businessPartnerVO.setBusinessOperaPermissonFlag(true);
            String custOperStatus = crmCustomerOperationVOS.get(0).getCustOperStatus();
            if (org.springframework.util.StringUtils.hasText(custOperStatus)) {
                businessPartnerVO.setCustOperStatus(custOperStatus);
                businessPartnerVO.setOperId(crmCustomerOperationVOS.get(0).getId());
            }
        } else {
            //没有权限的时候 直接通过customer_id去查询
//            List<CrmCustomerOperationVO> crmCustomerOperationNoPermissionVOS = crmCustomerOperationService.queryList(crmCustomerOperationQuery);
            List<CrmCustomerOperationVO> crmCustomerOperationNoPermissionVOS = crmCustomerOperationNoPermissionVOSMap.get(businessPartnerVOId);
            if (!CollectionUtils.isEmpty(crmCustomerOperationNoPermissionVOS)) {
                String custOperStatus = crmCustomerOperationNoPermissionVOS.get(0).getCustOperStatus();
                //有数据给客户主数据赋值 没数据有默认值不用管
                if (org.springframework.util.StringUtils.hasText(custOperStatus)) {
                    businessPartnerVO.setCustOperStatus(custOperStatus);
                    businessPartnerVO.setOperId(crmCustomerOperationNoPermissionVOS.get(0).getId());
                }
            }
        }
        businessPartnerVO.setBusinessFinancePicFlag(cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.FINANCE_MEMBER.getCode())));
        businessPartnerVO.setConfirmCustFlag(cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.POTENTIAL_CUST_CONFIRM.getCode())));
    }

    //身份字段翻译
    private String translateIdentity(String identity) {
        String[] identityArray = identity.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < identityArray.length; i++) {
            if (i == identityArray.length - 1) {
                stringBuilder.append(BusinessPartnerIdentityEnum.valueOf(identityArray[i]).getDesc());
            } else {
                stringBuilder.append(BusinessPartnerIdentityEnum.valueOf(identityArray[i]).getDesc() + ",");
            }
        }
        return stringBuilder.toString();
    }

    //身份字段翻译为4.0
    private String translateTw4Identity(String identity) {
        String[] identityArray = identity.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < identityArray.length; i++) {
            if (i == identityArray.length - 1) {
                stringBuilder.append(BusinessPartnerIdentityEnum.valueOf(identityArray[i]).getTw4Code());
            } else {
                stringBuilder.append(BusinessPartnerIdentityEnum.valueOf(identityArray[i]).getTw4Code() + ",");
            }
        }
        return stringBuilder.toString();
    }

    /**
     * 销售线索统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    @Override
    public long saleCount(BusinessPartnerQuery query) {
        return businessPartnerDAO.saleCount(query);
    }

    /**
     * 特殊查询
     *
     * @param partnerNameList 合作伙伴名单
     * @return {@link List}<{@link BusinessPartnerVO}>
     */
    @Override
    public List<BusinessPartnerVO> listForDm(List<String> partnerNameList) {
        List<BusinessPartnerVO> list = businessPartnerDAO.listForDm(partnerNameList);
        return list;
    }

    @Override
    public List<BusinessPartnerVO> queryCustPartnerListSimple() {
        return businessPartnerDAO.queryCustPartnerListSimple();
    }

    @Override
    public BusinessPartnerInfoVO queryBusinessPartnerInfoByPartnerName(String partnerName) {
        BusinessPartnerQuery query = new BusinessPartnerQuery();
        query.setPartnerName(partnerName);
        List<BusinessPartnerInfoVO> businessPartnerInfoVOS = businessPartnerDAO.queryBusinessPartnerInfo(query);
        if (!CollectionUtils.isEmpty(businessPartnerInfoVOS)) {
            BusinessPartnerInfoVO businessPartnerInfoVO = businessPartnerInfoVOS.get(0);
            if (businessPartnerInfoVO != null) {
                Long id = businessPartnerInfoVO.getId();
                Map<String, List<BusinessTeamMemberVO>> teamMemberMap = new HashMap<>();
                ///先查询团队成员
                BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
                teamMemberQuery.setObjectId(id);
                List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryListDynamic(teamMemberQuery);
                if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
                    teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
                }
                //根据身份查询对应的详情
                String partnerIdentity = businessPartnerInfoVO.getPartnerIdentity();
                //客户身份
                if (partnerIdentity.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                    BusinessCustomerInfoVO businessCustomerInfoVO = businessCustomerInfoService.queryByPartnerId(id);
                    if (businessCustomerInfoVO != null) {
                        //商务负责人
                        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
                            businessCustomerInfoVO.setBusinessUserId(teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getUserId());
                        }
                        //服务负责人
                        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
                            businessCustomerInfoVO.setServiceUserId(teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getUserId());
                        }
                        //关怀负责人
                        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
                            businessCustomerInfoVO.setCareUserId(teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getUserId());
                        }
                        //运维售后负责人
                        if (teamMemberMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
                            businessCustomerInfoVO.setOperationUserId(teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getUserId());
                        }
                        businessPartnerInfoVO.setBusinessCustomerInfoVO(businessCustomerInfoVO);
                    }
                }

                //供应商身份
                if (partnerIdentity.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                    BusinessSupplierInfoVO businessSupplierInfoVO = businessSupplierInfoService.queryByPartnerId(id);
                    //采购负责人
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode())) {
                        businessSupplierInfoVO.setPurchaseInchargeResId(teamMemberMap.get(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode()).get(0).getUserId());
                    }
                    businessPartnerInfoVO.setBusinessSupplierInfoVO(businessSupplierInfoVO);
                }

                //合作伙伴身份
                if (partnerIdentity.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                    BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = businessCollaboratePartnerInfoService.queryByPartnerId(id);
                    //渠道负责人
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode())) {
                        businessCollaboratePartnerInfoVO.setChannelUserId(teamMemberMap.get(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode()).get(0).getUserId());
                    }
                    businessPartnerInfoVO.setBusinessCollaboratePartnerInfoVO(businessCollaboratePartnerInfoVO);
                }
            }
            return businessPartnerInfoVO;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void changeAccountAndInvoice(BusinessPartnerChangePayload payload) {

        BusinessPartnerVO businessPartnerVO = businessPartnerDAO.queryByKey(payload.getId());
        if (businessPartnerVO == null) {
            throw TwException.error("", "变更数据不存在");

        }

        if (WorkFlowStatusEnum.APPROVING_WORK.getCode().equals(businessPartnerVO.getApplyStatus())) {
            throw TwException.error("", "变更流程中的数据不能再次发起变更");
        }
//        if (!BusinessPartnerStatusEnum.ACTIVE.getCode().equals(businessPartnerVO.getCustomerStatus())||) {
//
//            throw TwException.error("", "只有激活状态才能变更");
//        }
        businessPartnerVO = (BusinessPartnerVO) udcUtil.translate(businessPartnerVO);
//        translate(businessPartnerVO);
        translateList(Collections.singletonList(businessPartnerVO));
        //如果发起变更人等于接收人，需执行变更流程
        // businessPartnerVO.setApplyStatus(TaskStatusEnum.PENDING.getCode());
        //查询旧数据
        //银行账户
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(businessPartnerVO.getBookId());
        List<BookAccountVO> bookAccountVOS = bookAccountService.queryListDynamic(bookAccountQuery);
        //发票
        BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
        bookInvoiceQuery.setBookId(businessPartnerVO.getBookId());
        List<BookInvoiceVO> bookInvoiceVOS = bookInvoiceService.queryListDynamic(bookInvoiceQuery);
        //之前的数据
        BusinessPartnerChangeVO businessPartnerChangeVO = new BusinessPartnerChangeVO();
        businessPartnerChangeVO.setId(payload.getId());
        businessPartnerChangeVO.setBusinessPartnerVO(businessPartnerVO);
        businessPartnerChangeVO.setBookAccountVOList(bookAccountVOS);
        businessPartnerChangeVO.setBookInvoiceVOList(bookInvoiceVOS);
        BusinessPartnerChangeVO oldChangeVO = (BusinessPartnerChangeVO) udcUtil.translate(businessPartnerChangeVO);

        //新增的数据
        BusinessPartnerChangeVO newVO = new BusinessPartnerChangeVO();
        newVO.setId(payload.getId());
        newVO.setBusinessPartnerVO(oldChangeVO.getBusinessPartnerVO());
        List<BookInvoicePayload> bookInvoicePayloadList = payload.getBookInvoicePayloadList();
        //如果没有默认的数据随机选择一条作为默认 发票信息
        if (!CollectionUtils.isEmpty(bookInvoicePayloadList)) {
            List<BookInvoicePayload> bookInvoicePayloads = bookInvoicePayloadList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bookInvoicePayloads)) {
                bookInvoicePayloadList.stream().forEach(p -> p.setIsDefault(false));
                bookInvoicePayloadList.get(0).setIsDefault(true);
            } else {
                if (bookInvoicePayloads.size() > 1) {
                    throw TwException.error("", "发票信息不能提交多条默认的数据");
                }
                List<BookInvoicePayload> bookInvoicePayloadFalse = bookInvoicePayloadList.stream().filter(p -> p.getIsDefault() == null || !p.getIsDefault()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(bookInvoicePayloadFalse)) {
                    bookInvoicePayloadFalse.stream().forEach(p -> p.setIsDefault(false));
                }
            }
            List<BookInvoiceVO> newBookInvoiceVOS = bookInvoiceToVoList(bookInvoicePayloadList);
            newVO.setBookInvoiceVOList(newBookInvoiceVOS);
        }

        List<BookAccountPayload> bookAccountPayloadList = payload.getBookAccountPayloadList();
        //如果没有默认的数据随机选择一条作为默认 银行账户
        if (!CollectionUtils.isEmpty(bookAccountPayloadList)) {
            List<BookAccountPayload> bookAccountPayloads = bookAccountPayloadList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bookAccountPayloads)) {
                bookAccountPayloadList.stream().forEach(p -> p.setIsDefault(false));
                bookAccountPayloadList.get(0).setIsDefault(true);
            } else {
                if (bookAccountPayloads.size() > 1) {
                    throw TwException.error("", "银行信息不能提交多条默认的数据");
                }
                List<BookAccountPayload> bookAccountPayloadFalse = bookAccountPayloadList.stream().filter(p -> p.getIsDefault() == null || !p.getIsDefault()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(bookAccountPayloadFalse)) {
                    bookAccountPayloadFalse.stream().forEach(p -> p.setIsDefault(false));
                }
            }
            List<BookAccountVO> newBookAccountVOS = bookAccountToVOList(bookAccountPayloadList);
            newVO.setBookAccountVOList(newBookAccountVOS);
        }
        //翻译字段不然页面不会展示
        newVO = (BusinessPartnerChangeVO) udcUtil.translate(newVO);
        String changeStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();

        //保存变更数据
        Long saveId = changeService.save(ChangeTypeEnum.ACC_INVOICE_CHANGE.getCode(), oldChangeVO, newVO, payload.getId() + "");
        //新建审批流
        HashMap<String, Object> batchMap = new HashMap<>();
        //应收会计(何申夏)
        PrdOrgRoleVO arAccount = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getCode());
        if (ObjectUtils.isEmpty(arAccount)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getDesc() + "不存在！");
        }
        String[] splitByArAccount = arAccount.getRoleEmployees().split(",");
        batchMap.put("Activity_0nqziqi", Arrays.asList(splitByArAccount));


        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.ACC_INVOICE_CHANGE.name(),
                businessPartnerVO.getPartnerName() + "-银行账户/开票信息变更",
                saveId + "",
                batchMap)

        );
        String procInstId = processInfo.getProcInstId();
        //感觉没有必要 先注释掉 因为审批完成不会调用这个方法 应该在回调函数中处理
//        if (processInfo.getProcInstStatus().equals(ProcInstStatus.APPROVED)) {
//            changeStatus = WorkFlowStatusEnum.APPROVED_WORK.getCode();
//        }


        BusinessPartnerPayload payload0 = new BusinessPartnerPayload();
        payload0.setId(payload.getId());
        payload0.setApplyStatus(changeStatus);

        ComChangePayload changePayload = new ComChangePayload();
        changePayload.setId(saveId);
        changePayload.setProcInstId(procInstId);
        changePayload.setApprStatus(changeStatus);
        changePayload.setChangeStatus(changeStatus);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            businessPartnerDAO.updateWorkFlow(payload0);
            changeService.updateWorkFlow(changePayload);
        });

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void changeAccountAndInvoiceUpdate(BusinessPartnerChangePayload payload) {

        BusinessPartnerVO businessPartnerVO = businessPartnerDAO.queryByKey(payload.getId());
//        translate(businessPartnerVO);
        translateList(Collections.singletonList(businessPartnerVO));
        businessPartnerVO = (BusinessPartnerVO) udcUtil.translate(businessPartnerVO);
        BusinessPartnerChangeVO newVO = new BusinessPartnerChangeVO();
        newVO.setId(payload.getId());
        newVO.setBusinessPartnerVO(businessPartnerVO);

        //如果没有默认的数据随机选择一条作为默认
        List<BookInvoicePayload> bookInvoicePayloadList = payload.getBookInvoicePayloadList();
        if (!CollectionUtils.isEmpty(bookInvoicePayloadList)) {
            List<BookInvoicePayload> bookInvoicePayloads = bookInvoicePayloadList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bookInvoicePayloads)) {
                bookInvoicePayloadList.stream().forEach(p -> p.setIsDefault(false));
                bookInvoicePayloadList.get(0).setIsDefault(true);
            } else {
                if (bookInvoicePayloads.size() > 1) {
                    throw TwException.error("", "发票信息不能提交多条默认的数据");
                }
                //将不是默认的数据捞出来 然后全部置为false
                List<BookInvoicePayload> bookInvoicePayloadFalse = bookInvoicePayloadList.stream().filter(p -> p.getIsDefault() == null || !p.getIsDefault()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(bookInvoicePayloadFalse)) {
                    bookInvoicePayloadFalse.stream().forEach(p -> p.setIsDefault(false));
                }
            }
            List<BookInvoiceVO> newBookInvoiceVOS = bookInvoiceToVoList(bookInvoicePayloadList);
            newVO.setBookInvoiceVOList(newBookInvoiceVOS);
        }

        List<BookAccountPayload> bookAccountPayloadList = payload.getBookAccountPayloadList();
        //如果没有默认的数据随机选择一条作为默认
        if (!CollectionUtils.isEmpty(bookAccountPayloadList)) {
            List<BookAccountPayload> bookAccountPayloads = bookAccountPayloadList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(bookAccountPayloads)) {
                bookAccountPayloadList.stream().forEach(p -> p.setIsDefault(false));
                bookAccountPayloadList.get(0).setIsDefault(true);
            } else {
                if (bookAccountPayloads.size() > 1) {
                    throw TwException.error("", "银行信息不能提交多条默认的数据");
                }
                //将不是默认的数据捞出来 然后全部置为false
                List<BookAccountPayload> bookAccountPayloadFalse = bookAccountPayloadList.stream().filter(p -> p.getIsDefault() == null || !p.getIsDefault()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(bookAccountPayloadFalse)) {
                    bookAccountPayloadFalse.stream().forEach(p -> p.setIsDefault(false));
                }
            }
            List<BookAccountVO> newBookAccountVOS = bookAccountToVOList(bookAccountPayloadList);
            newVO.setBookAccountVOList(newBookAccountVOS);
        }


        //翻译字段不然页面不会展示
        newVO = (BusinessPartnerChangeVO) udcUtil.translate(newVO);

//        ComChangeQuery query = new ComChangeQuery();
//        query.setChangeType(ChangeTypeEnum.ACC_INVOICE_CHANGE.getCode());
//        query.setChangeDocId(payload.getId() + "");
//
//        List<String> status = Arrays.asList(WorkFlowStatusEnum.REJECTED_WORK.getCode(), WorkFlowStatusEnum.NOTSUBMIT.getCode());
//        query.setChangeStatus(status);
        ComChangeVO comChangeVO = changeService.queryByKey(payload.getBusinessKey());
        if (!ObjectUtils.isEmpty(comChangeVO)) {
            //存在授权变更中的数据
            Long saveId = comChangeVO.getId();
            String procInstId = comChangeVO.getProcInstId();
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(saveId);
            changePayload.setChangeContent(JSONObject.toJSONString(newVO));
            changeService.updateByKeyDynamic(changePayload);
        }
    }

    @Override
    public BusinessPartnerChangeVO queryChangeAccountAndInvoiceInfo(Long businessKey, Long partnerId) {
        if (businessKey != null) {
            ComChangeVO comChangeVO = changeService.queryByKey(businessKey);
            String changeContent = comChangeVO.getChangeContent();
            if (StringUtils.isEmpty(changeContent)) {
                throw TwException.error("", "数据不存在,请联系管理员");
            }
            BusinessPartnerChangeVO businessPartnerChangeVO = JSONObject.parseObject(changeContent, BusinessPartnerChangeVO.class);
            // 设置行id
            if (CollUtil.isNotEmpty(businessPartnerChangeVO.getBookInvoiceVOList())){
                for (BookInvoiceVO bookInvoiceVO : businessPartnerChangeVO.getBookInvoiceVOList()) {
                    bookInvoiceVO.setLineId(IdUtil.fastSimpleUUID());
                }
            }
            if (CollUtil.isNotEmpty(businessPartnerChangeVO.getBookAccountVOList())){
                for (BookAccountVO bookAccountVO : businessPartnerChangeVO.getBookAccountVOList()) {
                    bookAccountVO.setLineId(IdUtil.fastSimpleUUID());
                }
            }


            return businessPartnerChangeVO;
        }
        if (partnerId != null) {
            BusinessPartnerChangeVO businessPartnerChangeVO = new BusinessPartnerChangeVO();
            businessPartnerChangeVO.setId(partnerId);
            BusinessPartnerVO businessPartnerVO = queryByKey(partnerId);
            businessPartnerChangeVO.setBusinessPartnerVO(businessPartnerVO);

            BookAccountQuery bookAccountQuery = new BookAccountQuery();
            bookAccountQuery.setBookId(businessPartnerVO.getBookId());
            List<BookAccountVO> bookAccountVOS = bookAccountService.queryListDynamic(bookAccountQuery);
            businessPartnerChangeVO.setBookAccountVOList(bookAccountVOS);
            //发票
            BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
            bookInvoiceQuery.setBookId(businessPartnerVO.getBookId());
            List<BookInvoiceVO> bookInvoiceVOS = bookInvoiceService.queryListDynamic(bookInvoiceQuery);
            businessPartnerChangeVO.setBookInvoiceVOList(bookInvoiceVOS);
            return businessPartnerChangeVO;
        }
        return null;
    }

    @Override
    public BusinessPartnerTaskVO businessPartnerTaskInfo(BusinessParnerTaskInfoPayload payload) {
        if (StringUtils.isEmpty(payload.getProcDefKey())) {
            throw TwException.error("", "流程类型不能为空");
        }
        Long partnerId = null;
        if (ProcDefKey.CUSTOMER_ACTIVE.getName().equals(payload.getProcDefKey())) {
            partnerId = businessCustomerInfoService.queryByKey(payload.getObjectId()).getPartnerId();
        }
        if (ProcDefKey.COLLABORATE_ACTIVE.getName().equals(payload.getProcDefKey())) {
            partnerId = businessCollaboratePartnerInfoService.queryByKey(payload.getObjectId()).getPartnerId();
        }
        if (ProcDefKey.ACC_INVOICE_CHANGE.getName().equals(payload.getProcDefKey())) {
            partnerId = payload.getObjectId();
        }
        if (partnerId == null) {
            throw TwException.error("", "当前单据不存在");
        }
        BusinessPartnerTaskVO businessPartnerTaskVO = new BusinessPartnerTaskVO();
        BusinessPartnerVO businessPartnerVO = queryByKey(partnerId);
        if (businessPartnerVO != null) {
            businessPartnerVO = (BusinessPartnerVO) udcUtil.translate(businessPartnerVO);
            businessPartnerTaskVO.setBusinessPartnerVO(businessPartnerVO);
            Long id = businessPartnerVO.getId();
            Map<String, List<BusinessTeamMemberVO>> teamMemberMap = new HashMap<>();
            ///先查询团队成员
            BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
            teamMemberQuery.setObjectId(id);
            List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryListDynamic(teamMemberQuery);
            if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
                teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
            }
            //根据身份查询对应的详情
            String partnerIdentity = businessPartnerVO.getPartnerIdentity();
            //客户身份
            if (partnerIdentity.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                BusinessCustomerInfoVO businessCustomerInfoVO = businessCustomerInfoService.queryByPartnerId(id);
                if (businessCustomerInfoVO != null) {
                    //商务负责人
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
                        businessCustomerInfoVO.setBusinessUserId(teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getUserId());
                        businessCustomerInfoVO.setBusinessUserName(teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getMemberName());
                    }
                    //服务负责人
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
                        businessCustomerInfoVO.setServiceUserId(teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getUserId());
                        businessCustomerInfoVO.setServiceUserName(teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getMemberName());

                    }
                    //关怀负责人
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
                        businessCustomerInfoVO.setCareUserId(teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getUserId());
                        businessCustomerInfoVO.setCareUserName(teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getMemberName());

                    }
                    //运维售后负责人
                    if (teamMemberMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
                        businessCustomerInfoVO.setOperationUserId(teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getUserId());
                        businessCustomerInfoVO.setOperationUserName(teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getMemberName());
                    }
                    businessCustomerInfoVO = (BusinessCustomerInfoVO) udcUtil.translate(businessCustomerInfoVO);
                    businessPartnerTaskVO.setBusinessCustomerInfoVO(businessCustomerInfoVO);
                }
            }

            //供应商身份
            if (partnerIdentity.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                BusinessSupplierInfoVO businessSupplierInfoVO = businessSupplierInfoService.queryByPartnerId(id);
                //采购负责人
                if (teamMemberMap.containsKey(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode())) {
                    businessSupplierInfoVO.setPurchaseInchargeResId(teamMemberMap.get(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode()).get(0).getUserId());
                    businessSupplierInfoVO.setPurchaseInchargeResName(teamMemberMap.get(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode()).get(0).getMemberName());
                }
                businessSupplierInfoVO = (BusinessSupplierInfoVO) udcUtil.translate(businessSupplierInfoVO);
                businessPartnerTaskVO.setBusinessSupplierInfoVO(businessSupplierInfoVO);
            }

            //合作伙伴身份
            if (partnerIdentity.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = businessCollaboratePartnerInfoService.queryByPartnerId(id);
                //渠道负责人
                if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode())) {
                    businessCollaboratePartnerInfoVO.setChannelUserId(teamMemberMap.get(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode()).get(0).getUserId());
                    businessCollaboratePartnerInfoVO.setChannelUserName(teamMemberMap.get(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode()).get(0).getMemberName());
                }
                businessCollaboratePartnerInfoVO = (BusinessCollaboratePartnerInfoVO) udcUtil.translate(businessCollaboratePartnerInfoVO);
                businessPartnerTaskVO.setBusinessCollaboratePartnerInfoVO(businessCollaboratePartnerInfoVO);
            }
        }

        //银行账户
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(businessPartnerVO.getBookId());
        List<BookAccountVO> bookAccountVOS = bookAccountService.queryListDynamic(bookAccountQuery);
        bookAccountVOS = udcUtil.translateList(bookAccountVOS);
        businessPartnerTaskVO.setBookAccountVOList(bookAccountVOS);

        //开票信息
        BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
        bookInvoiceQuery.setBookId(businessPartnerVO.getBookId());
        List<BookInvoiceVO> bookInvoiceVOS = bookInvoiceService.queryListDynamic(bookInvoiceQuery);
        bookInvoiceVOS = udcUtil.translateList(bookInvoiceVOS);
        businessPartnerTaskVO.setBookInvoiceVOList(bookInvoiceVOS);
        return businessPartnerTaskVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateAccAndInvoice(BusinessPartnerChangeVO vo) {
        BusinessPartnerVO businessPartnerVO = vo.getBusinessPartnerVO();
        if (businessPartnerVO == null) {
            businessPartnerVO = queryByKey(vo.getId());
        }
        Long bookId = businessPartnerVO.getBookId();

        //发票数据处理
        List<BookInvoiceVO> bookInvoiceVOList = vo.getBookInvoiceVOList();
        if (!CollectionUtils.isEmpty(bookInvoiceVOList)) {
            //先对保存的数据做默认值处理
            List<BookInvoiceVO> collect = bookInvoiceVOList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            //当插入的数据没有默认的时候 选一个默认给他
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(false));
                bookInvoiceVOList.get(0).setIsDefault(true);
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "发票信息不能提交多条默认的数据");
                }
                //将不是默认的数据捞出来 然后置为false(前端传过来的时候是空 所以要给值)
                List<BookInvoiceVO> collectFalse = bookInvoiceVOList.stream().filter(p -> p.getIsDefault() == null || !p.getIsDefault()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(false));
                }
            }
            //发票删除数据处理 因为合同那边的合同批次关联的是发票id 因此不能随便删除
            BookInvoiceQuery query = new BookInvoiceQuery();
            query.setBookId(bookId);
            // 如果查询出来的是空说明都是新增的
            List<BookInvoiceVO> olBookInvoiceVOS = bookInvoiceService.queryListDynamic(query);
            if (!CollectionUtils.isEmpty(olBookInvoiceVOS)) {
                //处理删除的数据
                Map<Long, List<BookInvoiceVO>> newBookInvoiceMap = bookInvoiceVOList.stream().filter(p -> p.getId() != null).collect(Collectors.groupingBy(BookInvoiceVO::getId));
                List<Long> deleteIdList = new ArrayList<>();
                olBookInvoiceVOS.stream().forEach(p -> {
                    //如果列表中的银行账户集合不存在数据库中的id 证明他被删除了
                    if (!newBookInvoiceMap.containsKey(p.getId())) {
                        deleteIdList.add(p.getId());
                    }
                });
                //处理删除的数据
                if (!CollectionUtils.isEmpty(deleteIdList)) {
                    bookInvoiceService.deleteSoftBykeys(deleteIdList, bookId, businessPartnerVO.getId());
                }
            }
            // 处理新增的数据
            bookInvoiceVOList.stream().forEach(p -> {
                if (p.getId() == null) {
                    p.setBookId(bookId);
                }
            });
            bookInvoiceService.saveAll(bookInvoiceVOList);
        } else {
            //没有传输说明页面的数据都被删除了直接全部删除
            bookInvoiceService.deleteByBookId(bookId);
        }

        //银行账户处理
        List<BookAccountVO> bookAccountVOList = vo.getBookAccountVOList();
        if (!CollectionUtils.isEmpty(bookAccountVOList)) {
            //先处理默认值
            List<BookAccountVO> collect = bookAccountVOList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            //当插入的数据没有默认的时候 选一个默认给他
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(false));
                bookAccountVOList.get(0).setIsDefault(true);
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "银行信息不能提交多条默认的数据");
                }
                //将不是默认的数据捞出来 然后置为false(前端传过来的时候是空 所以要给值)
                List<BookAccountVO> collectFalse = bookAccountVOList.stream().filter(p -> p.getIsDefault() == null || !p.getIsDefault()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(false));
                }
            }
            //银行账户删除数据处理
            BookAccountQuery query = new BookAccountQuery();
            query.setBookId(bookId);
            // 如果查询出来的是空说明都是新增的
            List<BookAccountVO> oldBookAccountVOVOS = bookAccountService.queryListDynamic(query);
            if (!CollectionUtils.isEmpty(oldBookAccountVOVOS)) {
                //处理删除的数据
                Map<Long, List<BookAccountVO>> newBookAccountMap = bookAccountVOList.stream().filter(p -> p.getId() != null).collect(Collectors.groupingBy(BookAccountVO::getId));
                List<Long> deleteIdList = new ArrayList<>();
                oldBookAccountVOVOS.stream().forEach(p -> {
                    //如果列表中的银行账户集合不存在数据库中的id 证明他被删除了
                    if (!newBookAccountMap.containsKey(p.getId())) {
                        deleteIdList.add(p.getId());
                    }
                });
                //处理删除的数据
                if (!CollectionUtils.isEmpty(deleteIdList)) {
                    bookAccountService.deleteSoftBykeys(deleteIdList, bookId, businessPartnerVO.getId());
                }
            }

            // 处理新增的数据
            bookAccountVOList.stream().forEach(p -> {
                if (p.getId() == null) {
                    p.setBookId(bookId);
                }
            });
            bookAccountService.saveAll(bookAccountVOList);
        } else {
            //没有传输说明页面的数据都被删除了直接全部删除
            bookAccountService.deleteByBookId(bookId);
        }
    }

    @Override
    public PagingVO<BusinessConfirmedCustomerVO> queryConfirmedCustomer(BusinessPartnerQuery query) {
        // 校验权限
        dataPermission(query);
        PagingVO<BusinessConfirmedCustomerVO> businessConfirmedCustomerVOPagingVO = businessPartnerDAO.queryConfirmedCustomer(query);
        if (!CollectionUtils.isEmpty(businessConfirmedCustomerVOPagingVO.getRecords())) {
            List<Long> partnerIdList = businessConfirmedCustomerVOPagingVO.stream().map(p -> p.getPartnerId()).collect(Collectors.toList());
            BusinessTeamMemberQuery businessTeamMemberQuery = new BusinessTeamMemberQuery();
            businessTeamMemberQuery.setObjectIdList(partnerIdList);
            businessTeamMemberQuery.setMemberRole(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
            List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryListDynamic(businessTeamMemberQuery);
            Map<Long, List<BusinessTeamMemberVO>> teamMemberVOMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getObjectId));

            businessConfirmedCustomerVOPagingVO.stream().forEach(p -> {
                //处理省市区
                StringBuilder str = new StringBuilder();
                if (p.getProvinceName() != null) {
                    str.append(p.getProvinceName() + "/");
                }
                if (p.getCityName() != null) {
                    str.append(p.getCityName() + "/");
                }
                if (p.getDistrictName() != null) {
                    str.append(p.getDistrictName());
                }
                p.setAddress(str.toString());
                //处理服务负责人
                if (!CollectionUtils.isEmpty(teamMemberVOMap) && teamMemberVOMap.containsKey(p.getPartnerId())) {
                    p.setServiceUserId(teamMemberVOMap.get(p.getPartnerId()).get(0).getUserId());
                    p.setServiceUserName(teamMemberVOMap.get(p.getPartnerId()).get(0).getMemberName());
                }
            });

        }
        return businessConfirmedCustomerVOPagingVO;
    }

    @Override
    public Long countConfirmedCustomer() {
        return businessPartnerDAO.countConfirmedCustomer();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateConfirmedCustomer(CommonKeysPayload payload) {
        if (payload == null || CollectionUtils.isEmpty(payload.getKeys())) {
            throw TwException.error("", "请选择数据");
        }
        businessPartnerDAO.updateConfirmedCustomer(payload.getKeys());
    }

//    @Override
//    @Transactional
//    public void businessPartnerSync(String param) {
//        BusinessPartnerSyncVO businessPartnerSyncVO = new BusinessPartnerSyncVO();
//        List<BusinessPartnerMainSyncVO> businessPartnerMainSyncVOS = businessPartnerDAO.queryBusinessPartSync(param);
//        if (!CollectionUtils.isEmpty(businessPartnerMainSyncVOS)) {
//            List<Long> idList = businessPartnerMainSyncVOS.stream().map(p -> p.getId()).collect(Collectors.toList());
//            List<Long> bookIdList = businessPartnerMainSyncVOS.stream().map(p -> p.getBookId()).collect(Collectors.toList());
//            //银行信息数据
//            List<PrdAbAccountPayload> prdAbAccountPayloads = bookAccountService.queryTwBookAccountListByBookId(bookIdList);
//            businessPartnerSyncVO.setPrdAbAccountPayloadList(prdAbAccountPayloads);
//            //发票信息
//            List<PrdAbInvoicePayload> prdAbInvoicePayloads = bookInvoiceService.queryTwBookInvoiceListByBookId(bookIdList);
//            businessPartnerSyncVO.setPrdAbInvoicePayloadList(prdAbInvoicePayloads);
//            //地址信息
//            List<PrdAbAddressPayload> prdAbAddressPayloads = bookAddressService.queryTwBookAddressListByBookId(bookIdList);
//            if(!CollectionUtils.isEmpty(prdAbAddressPayloads)){
//                prdAbAddressPayloads.stream().forEach(p->translateAddress(p));
//            }
//            businessPartnerSyncVO.setPrdAbAddressPayloadList(prdAbAddressPayloads);
//            //联系信息
//            List<PrdAbContactsPayload> prdAbContactsPayloads = bookContactsService.queryTwBookContactsListByBookId(bookIdList);
//            businessPartnerSyncVO.setPrdAbContactsPayloadList(prdAbContactsPayloads);
//            //团队成员数据
//            Map<String, List<BusinessTeamMemberVO>> teamMemberMap = new HashMap<>();
//            Map<Long, List<PrdOrgEmployeeVO>> tw4UserIdMap = new HashMap<>();
//            ///先查询团队成员
//            BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
//            teamMemberQuery.setObjectIdList(idList);
//            List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryListDynamic(teamMemberQuery);
//            if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
//                teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
//                List<Long> userIdList = businessTeamMemberVOS.stream().filter(p -> p.getUserId() != null).map(s -> s.getUserId()).collect(Collectors.toList());
//                if (!CollectionUtils.isEmpty(userIdList)) {
//                    List<PrdOrgEmployeeVO> employeeVOList = transferUtilDAO.queryTw4ByUserIdList(userIdList);
//                    if (!CollectionUtils.isEmpty(employeeVOList)) {
//                        tw4UserIdMap = employeeVOList.stream().collect(Collectors.groupingBy(PrdOrgEmployeeVO::getUserId));
//                    }
//                }
//            }
//            //udc等翻译为4.0的数据
//            for (BusinessPartnerMainSyncVO businessPartnerMainSyncVO : businessPartnerMainSyncVOS) {
//                syncTw4Translate(businessPartnerMainSyncVO, teamMemberMap, tw4UserIdMap);
//            }
//            businessPartnerSyncVO.setBusinessPartnerMainSyncVOList(businessPartnerMainSyncVOS);
//            log.info(JSONUtil.toJsonStr(businessPartnerSyncVO));
//            Map<String, Object> objectMap = BeanMapTool.beanToMap(businessPartnerSyncVO);
//            //开始调用4.0业务伙伴主档同步接口
//            log.info("-----------业务伙伴主档同步4.0 start-------------");
//            log.info("objectMap is :"+JSONUtil.toJsonStr(objectMap));
//            String result = httpUtil.sendSyncPost(prd_ab_operation, JSONUtil.toJsonStr(businessPartnerSyncVO));
//            String resultData = httpUtil.geResultData(result);
//            log.info("resultData is :"+JSONUtil.toJsonStr(resultData));
//            //查看返回数据是否有误
//            if (org.springframework.util.StringUtils.hasText(resultData)) {
//                resultData = JSONUtil.toJsonStr(resultData);
//                Map<Object,Object> map = (Map) JSON.parse(resultData);
//                if (!CollectionUtils.isEmpty(map)) {
//                    map.forEach((key,value)->{
//                        businessPartnerDAO.updateSyncTimeAndBookIdV4(Long.valueOf(key.toString()),Long.valueOf(value.toString()), LocalDateTime.now());
//                    });
//                } else {
//                    throw TwException.error("", "客户创建失败,4.0回传的地址簿id数据异常：");
//                }
//            } else {
//                throw TwException.error("", "客户创建失败,未接收到4.0回传的地址簿id");
//            }
//            log.info("-----------业务伙伴主档同步4.0 end-------------");
//        }
//    }

    @Override
    public void updateBusinessParnerModifyTime(List<Long> bookIdList) {
        businessPartnerDAO.updateBusinessParnerModifyTime(bookIdList);
    }

    @Override
    public Map<Long, String> findNameByBookIds(List<Long> bookIdList) {
        Map<Long, String> resultMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(bookIdList)) {
            List<Long> collect = bookIdList.stream().filter(p -> p != null).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                List<Tuple> list = businessPartnerDAO.findNameByBookIds(bookIdList);
                if (!CollectionUtils.isEmpty(list)) {
                    for (Tuple tuple : list) {
                        resultMap.put(tuple.get(0, Long.class), tuple.get(1, String.class));
                    }
                }
            }
        }
        return resultMap;
    }

    @Override
    public List<BusinessPartnerListInfoVO> findListInfoByBookIds(List<Long> bookIdList) {
        List<Tuple> nameByBookIds = businessPartnerDAO.findNameByBookIds(bookIdList);
        if (CollectionUtils.isEmpty(nameByBookIds)) {
            return null;
        }
        // 银行信息Map
        Map<Long, List<BookAccountVO>> bookAddressVOMap = bookAccountService.queryByBookIdList(bookIdList);
        return nameByBookIds.stream()
                .map(tuple -> {
                    BusinessPartnerListInfoVO businessPartnerListInfoVO = new BusinessPartnerListInfoVO();
                    businessPartnerListInfoVO.setBookId(tuple.get(0, Long.class));
                    businessPartnerListInfoVO.setPartnerName(tuple.get(1, String.class));
                    // 设置账户信息
                    businessPartnerListInfoVO.setBookAccountVOList(bookAddressVOMap.get(tuple.get(0, Long.class)));
                    return businessPartnerListInfoVO;
                })
                .collect(Collectors.toList());
    }

    @Override
    public List<BusinessPartnerVO> queryByBookIdsAndType(List<Long> bookIds, String insideOrOutside) {
        return businessPartnerDAO.queryByBookIdsAndType(bookIds, insideOrOutside);
    }


    //处理新增的 客户 供应商 合作伙伴 团队成员
    public void dealSaveBusinessPartner(BusinessPartnerPayload payload, BusinessPartnerDO entityDo) {
        Long id = entityDo.getId();
        List<BusinessTeamMemberPayload> payloadList = new ArrayList<>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        String userName = cacheUtil.getUserName(GlobalUtil.getLoginUserId());
        //新增/修改判断
        if (payload.getId() != null) {
            List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryByObjectIdAndRole(id, BusinessTeamRoleEnum.CREATOR.getCode());
            if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
                List<Long> userIdcollect = businessTeamMemberVOS.stream().map(p -> p.getUserId()).collect(Collectors.toList());
                if (!userIdcollect.contains(GlobalUtil.getLoginUserId())) {
                    BusinessTeamMemberPayload businessTeamMemberPayloadCreator = new BusinessTeamMemberPayload();
                    businessTeamMemberPayloadCreator.setUserId(loginUserId);
                    businessTeamMemberPayloadCreator.setMemberName(userName);
                    businessTeamMemberPayloadCreator.setMemberRole(BusinessTeamRoleEnum.CREATOR.getCode());
                    businessTeamMemberPayloadCreator.setMemberRoleName(BusinessTeamRoleEnum.CREATOR.getDesc());
                    businessTeamMemberPayloadCreator.setObjectId(id);
                    businessTeamMemberPayloadCreator.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                    businessTeamMemberPayloadCreator.setIsCreator(true);
                    businessTeamMemberPayloadCreator.setSortNo(BusinessTeamRoleEnum.CREATOR.getSortNo());
                    businessTeamMemberPayloadCreator.setOrgId(cacheUtil.getDefaultOrgIdByUserId(loginUserId));
                    payloadList.add(businessTeamMemberPayloadCreator);
                }
            }
        } else {
            BusinessTeamMemberPayload businessTeamMemberPayloadCreator = new BusinessTeamMemberPayload();
            businessTeamMemberPayloadCreator.setUserId(loginUserId);
            businessTeamMemberPayloadCreator.setMemberName(userName);
            businessTeamMemberPayloadCreator.setMemberRole(BusinessTeamRoleEnum.CREATOR.getCode());
            businessTeamMemberPayloadCreator.setMemberRoleName(BusinessTeamRoleEnum.CREATOR.getDesc());
            businessTeamMemberPayloadCreator.setObjectId(id);
            businessTeamMemberPayloadCreator.setType(BusinessTeamTypeEnum.PARTNER.getCode());
            businessTeamMemberPayloadCreator.setIsCreator(true);
            businessTeamMemberPayloadCreator.setSortNo(BusinessTeamRoleEnum.CREATOR.getSortNo());
            businessTeamMemberPayloadCreator.setOrgId(cacheUtil.getDefaultOrgIdByUserId(loginUserId));
            payloadList.add(businessTeamMemberPayloadCreator);
        }

        //客户信息
        if (entityDo.getCustomerFlag()) {
            //处理基本信息
            BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
            businessCustomerInfoPayload.setPartnerId(id);
            String customerStatus = BusinessPartnerStatusEnum.CREATE.getCode();
            if (!StringUtils.isEmpty(payload.getCustomerStatus())) {
                customerStatus = payload.getCustomerStatus();
            }
            businessCustomerInfoPayload.setCustomerStatus(customerStatus);
            businessCustomerInfoPayload.setCustomerGradle(payload.getCustomerGradle());
            businessCustomerInfoPayload.setCustomerRegion(payload.getCustomerRegion());
            businessCustomerInfoPayload.setCustomerSource(payload.getCustomerSource());
            businessCustomerInfoPayload.setConfirmFlag(false);
            businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.POTENTIAL.getCode());
            businessCustomerInfoService.insert(businessCustomerInfoPayload);

            //服务负责人
            if (payload.getServiceUserId() != null) {
                Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getServiceUserId());
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getServiceUserId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getServiceUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.SERVICE_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(id);
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.SERVICE_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }

            //商务负责人
            if (payload.getBusinessUserId() != null) {
                Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getBusinessUserId());
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getBusinessUserId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getBusinessUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.SALE_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.SALE_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(id);
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.SALE_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);

            }

            //关怀负责人
            if (payload.getCareUserId() != null) {
                Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getCareUserId());
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getCareUserId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getCareUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.CARE.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.CARE.getDesc());
                businessTeamMemberPayload.setObjectId(id);
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.CARE.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);

            }

            //运维售后负责人
            if (payload.getOperationUserId() != null) {
                Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getOperationUserId());
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getOperationUserId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getOperationUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.OPERATION.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.OPERATION.getDesc());
                businessTeamMemberPayload.setObjectId(id);
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.OPERATION.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }

        //供应商 采购负责人
        if (entityDo.getSupplierFlag()) {
            //处理基本信息
            BusinessSupplierInfoPayload businessSupplierInfoPayload = new BusinessSupplierInfoPayload();
            businessSupplierInfoPayload.setPartnerId(id);
            businessSupplierInfoPayload.setSupplierStatus(BusinessPartnerStatusEnum.CREATE.getCode());
            businessSupplierInfoPayload.setSupplierGradle(payload.getSupplierGradle());
            businessSupplierInfoPayload.setSettlementPeriod(payload.getSettlementPeriod());
            businessSupplierInfoPayload.setStartTime(payload.getStartTime());
            businessSupplierInfoPayload.setEndTime(payload.getEndTime());
            businessSupplierInfoPayload.setFileCode1(payload.getFileCode1());
            businessSupplierInfoPayload.setFileCode2(payload.getFileCode2());
            businessSupplierInfoService.insert(businessSupplierInfoPayload);
            //处理团队成员
            if (payload.getPurchaseInchargeResId() != null) {
                Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getPurchaseInchargeResId());
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getPurchaseInchargeResId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getPurchaseInchargeResId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.PURCHASE_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.PURCHASE_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(id);
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.PURCHASE_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }

        }

        //合作伙伴 渠道负责人
        if (entityDo.getCollaborateFlag()) {
            //处理基本信息
            BusinessCollaboratePartnerInfoPayload businessCollaboratePartnerInfoPayload = new BusinessCollaboratePartnerInfoPayload();
            businessCollaboratePartnerInfoPayload.setCollaborateStatus(BusinessPartnerStatusEnum.CREATE.getCode());
            businessCollaboratePartnerInfoPayload.setPartnerId(id);
            businessCollaboratePartnerInfoPayload.setCollaborateGradle(payload.getCollaborateGradle());
            businessCollaboratePartnerInfoPayload.setCollaborateForm(payload.getCollaborateForm());
            businessCollaboratePartnerInfoPayload.setCollaborateType(payload.getCollaborateType());
            businessCollaboratePartnerInfoPayload.setCollaborateProduct(payload.getCollaborateProduct());
            businessCollaboratePartnerInfoPayload.setCollaborateServiceIndustry(payload.getCollaborateServiceIndustry());
            businessCollaboratePartnerInfoPayload.setCollaborateCustomer(payload.getCollaborateCustomer());
            businessCollaboratePartnerInfoPayload.setServiceCustomerScale(payload.getServiceCustomerScale());
            businessCollaboratePartnerInfoPayload.setCollaborateRegion(payload.getCollaborateRegion());
            businessCollaboratePartnerInfoPayload.setContactPeopleType(payload.getContactPeopleType());
            businessCollaboratePartnerInfoPayload.setChannelUserId(payload.getChannelUserId());
            businessCollaboratePartnerInfoPayload.setBuManageUserId(payload.getBuManageUserId());
            businessCollaboratePartnerInfoPayload.setBuManagePhone(payload.getBuManagePhone());
            businessCollaboratePartnerInfoPayload.setBuManageEmail(payload.getBuManageEmail());
            businessCollaboratePartnerInfoPayload.setCollaborateDescription(payload.getCollaborateDescription());
            businessCollaboratePartnerInfoPayload.setCollaborateTag(payload.getCollaborateTag());
            businessCollaboratePartnerInfoPayload.setCollaborateKeyword(payload.getCollaborateKeyword());
            businessCollaboratePartnerInfoPayload.setFileCodes1(payload.getFileCode3());
            businessCollaboratePartnerInfoPayload.setFileCodes2(payload.getFileCode4());
            businessCollaboratePartnerInfoPayload.setFileCodes3(payload.getFileCode5());
            businessCollaboratePartnerInfoPayload.setStartTime(payload.getCollaborateStartTime());
            businessCollaboratePartnerInfoPayload.setEndTime(payload.getCollaborateEndTime());
            businessCollaboratePartnerInfoService.insert(businessCollaboratePartnerInfoPayload);

            //处理团队成员
            if (payload.getChannelUserId() != null) {
                Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getChannelUserId());
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getChannelUserId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getChannelUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.CHANNEL_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(id);
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.CHANNEL_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }

        if (!CollectionUtils.isEmpty(payloadList)) {
            businessTeamMemberService.saveAll(payloadList);
        }
    }

    //payLoadList转voList
    public List<BookInvoiceVO> bookInvoiceToVoList(List<BookInvoicePayload> bookInvoicePayloadList) {
        if (bookInvoicePayloadList == null) {
            return null;
        }

        List<BookInvoiceVO> list = new ArrayList<BookInvoiceVO>(bookInvoicePayloadList.size());
        for (BookInvoicePayload bookInvoicePayload : bookInvoicePayloadList) {
            list.add(bookInvoiceToVo(bookInvoicePayload));
        }

        return list;
    }

    //payLoad转vo
    public BookInvoiceVO bookInvoiceToVo(BookInvoicePayload ado) {
        if (ado == null) {
            return null;
        }

        BookInvoiceVO bookInvoiceVO = new BookInvoiceVO();
        bookInvoiceVO.setId(ado.getId());
        bookInvoiceVO.setRemark(ado.getRemark());
        bookInvoiceVO.setCreateUserId(ado.getCreateUserId());
        bookInvoiceVO.setCreator(ado.getCreator());
        bookInvoiceVO.setCreateTime(ado.getCreateTime());
        bookInvoiceVO.setModifyUserId(ado.getModifyUserId());
        bookInvoiceVO.setModifyTime(ado.getModifyTime());
        bookInvoiceVO.setDeleteFlag(ado.getDeleteFlag());
        bookInvoiceVO.setBookId(ado.getBookId());
        bookInvoiceVO.setInvoiceMessage(ado.getInvoiceMessage());
        bookInvoiceVO.setInvoiceTitle(ado.getInvoiceTitle());
        bookInvoiceVO.setTaxRete(ado.getTaxRete());
        bookInvoiceVO.setTaxNo(ado.getTaxNo());
        bookInvoiceVO.setInvoiceType(ado.getInvoiceType());
        bookInvoiceVO.setInvoiceAddress(ado.getInvoiceAddress());
        bookInvoiceVO.setInvoicePhone(ado.getInvoicePhone());
        bookInvoiceVO.setDepositBank(ado.getDepositBank());
        bookInvoiceVO.setInvoiceAccount(ado.getInvoiceAccount());
        bookInvoiceVO.setCurrency(ado.getCurrency());
        bookInvoiceVO.setIsDefault(ado.getIsDefault());
        return bookInvoiceVO;
    }

    //payLoadList转voList
    public List<BookAccountVO> bookAccountToVOList(List<BookAccountPayload> bookAccountPayloadList) {
        if (bookAccountPayloadList == null) {
            return null;
        }

        List<BookAccountVO> list = new ArrayList<BookAccountVO>(bookAccountPayloadList.size());
        for (BookAccountPayload bookAccountPayload : bookAccountPayloadList) {
            list.add(bookAcountToVo(bookAccountPayload));
        }

        return list;
    }

    //payLoad转vo
    public BookAccountVO bookAcountToVo(BookAccountPayload ado) {
        if (ado == null) {
            return null;
        }

        BookAccountVO bookAccountVO = new BookAccountVO();
        bookAccountVO.setId(ado.getId());
        bookAccountVO.setRemark(ado.getRemark());
        bookAccountVO.setCreateUserId(ado.getCreateUserId());
        bookAccountVO.setCreator(ado.getCreator());
        bookAccountVO.setCreateTime(ado.getCreateTime());
        bookAccountVO.setModifyUserId(ado.getModifyUserId());
        bookAccountVO.setModifyTime(ado.getModifyTime());
        bookAccountVO.setDeleteFlag(ado.getDeleteFlag());
        bookAccountVO.setBookId(ado.getBookId());
        bookAccountVO.setAccountType(ado.getAccountType());
        bookAccountVO.setAccountUsage(ado.getAccountUsage());
        bookAccountVO.setDepositBank(ado.getDepositBank());
        bookAccountVO.setDepositCity(ado.getDepositCity());
        bookAccountVO.setDepositBankOutlet(ado.getDepositBankOutlet());
        bookAccountVO.setAccountName(ado.getAccountName());
        bookAccountVO.setAccountNo(ado.getAccountNo());
        bookAccountVO.setCurrency(ado.getCurrency());
        bookAccountVO.setIsDefault(ado.getIsDefault());
        return bookAccountVO;
    }

    //权限校验
    public void dataPermission(BusinessPartnerQuery query) {
        long userId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.FINANCE_MEMBER.getCode(), RoleEnum.BUSINESS_PARTNER_MANAGER.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        query.setPermissionFlag(!rolePermission);
        if (!rolePermission) {
            query.setLoginUserId(userId);
        }
    }

//    @Transactional(rollbackFor = Exception.class)
//    public Long syncTw4(BusinessPartnerPayload payload) {
//        /**
//         * 1.新增客户               prdAbPayload.getBookId() null  relateType 01  1 0
//         * 2.新增供应商             prdAbPayload.getBookId() null  relateType 02   0 1
//         * 3.新增客户供应商          prdAbPayload.getBookId() null  relateType 01 02 1 1
//         * 4.客户更新               prdAbPayload.getBookId() 不为空  relateType 01  0 0
//         * 5.有供应商的情况新增客户   prdAbPayload.getBookId() 不为空  relateType 01  1 0
//         * 6.有客户的情况新增供应商   prdAbPayload.getBookId() 不为空  relateType 02  0 1
//         *
//         * */
//        PrdAbPayload prdAbPayload = new PrdAbPayload();
//        if (payload.getBookIdV4() != null) {
//            prdAbPayload.setBookId(payload.getBookIdV4());
//        }
//        //设置relateType
//        String relateType = "";
//        String partnerIdentity = payload.getPartnerIdentity();
//        if (partnerIdentity.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
//            relateType = "01";
//        }
//        if (partnerIdentity.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
//            relateType = org.springframework.util.StringUtils.hasText(relateType) ? relateType + ",02" : "02";
//        }
//        prdAbPayload.setRelateType(relateType);
//
//        //客户新增
//        //组装客户数据
//        assembleCrmCustomerPayload(payload, prdAbPayload);
//        if (payload.getCustomerFlag()) {
//            prdAbPayload.setCustomerAddFlag(true);
//        }
//        //供应商新增
//        if (payload.getSupplierFlag()) {
//            prdAbPayload.setSupplierAddFlag(true);
//        }
//        // 01 个人 02 公司
//        if (BusinessPartnerTypeEnum.ORGANIZATION.getCode().equals(payload.getPartnerType())) {
//            prdAbPayload.setAbType("02");
//        } else {
//            prdAbPayload.setAbType("01");
//        }
//        Map<String, Object> map = transferUtilService.beanToMap(prdAbPayload);
//        map.put("bookNo", payload.getBusinessPartnerNo());
//        log.info(JSONUtil.toJsonStr(map));
//        String result = httpUtil.sendSyncPost(prd_ab_operation, map);
//        String bookId = httpUtil.geResultData(result);
//        if (payload.getBookIdV4() != null) {
//            return payload.getBookIdV4();
//        }
//        long bookIdV4 = 0;
//        if (org.springframework.util.StringUtils.hasText(bookId)) {
//            if (StringUtil.isInteger(bookId)) {
//                bookIdV4 = Long.valueOf(bookId);
//            } else {
//                throw TwException.error("", "客户创建失败,4.0回传的地址簿id数据异常：" + bookId + "，请重新提交！");
//            }
//        } else {
//            throw TwException.error("", "客户创建失败,未接收到4.0回传的地址簿id，请重新提交！");
//        }
//        return bookIdV4;
//    }


    //组装客户数据
    public void assembleCrmCustomerPayload(BusinessPartnerPayload payload, PrdAbPayload prdAbPayload) {
        //按照之前同步4.0 同步的时候是激活
        prdAbPayload.setCustomerStatus(BusinessPartnerStatusEnum.ACTIVE.getCode());
        prdAbPayload.setCustomerName(payload.getPartnerName());
        prdAbPayload.setCustomerGrade(payload.getCustomerGradle());
        prdAbPayload.setCustomerSource(payload.getCustomerSource());
        prdAbPayload.setCompanyIndustry(payload.getPartnerIndustry());
        prdAbPayload.setCompanyPhone(payload.getPartnerPhone());
        prdAbPayload.setCompanyEmail(payload.getPartnerEmail());
        prdAbPayload.setCompanyFax(payload.getPartnerFax());
        prdAbPayload.setProvince(payload.getProvince());
        prdAbPayload.setProvinceName(payload.getProvinceName());
        prdAbPayload.setCity(payload.getCity());
        prdAbPayload.setCityName(payload.getCityName());
        prdAbPayload.setDistrict(payload.getDistrict());
        prdAbPayload.setDistrictName(payload.getDistrictName());
        prdAbPayload.setCompanyAddress(payload.getDetailAddress());
        prdAbPayload.setCompanyWebsite(payload.getPartnerWebsite());
        prdAbPayload.setCompanyScale(CustomerScaleEnum.valueOf(payload.getOrganizationScale()).getTw4Code());
        //5.0 没有税号
        // prdAbPayload.setTaxNo();
        prdAbPayload.setCurrency(payload.getCurrency());
        prdAbPayload.setLanguage(payload.getLanguage());
        prdAbPayload.setCompanyNature(payload.getPartnerNature());
        prdAbPayload.setServiceUserId(payload.getServiceUserId());
        prdAbPayload.setBusinessUserId(payload.getBusinessUserId());
        prdAbPayload.setCareUserId(payload.getCareUserId());
        prdAbPayload.setOperationUserId(payload.getOperationUserId());
    }

    //4.0同步数据翻译
    public void syncTw4Translate(BusinessPartnerMainSyncVO vo, Map<String, List<BusinessTeamMemberVO>> teamMap, Map<Long, List<PrdOrgEmployeeVO>> tw4UserIdMap) {
        Long id = vo.getId();
        //团队成员翻译
        if (teamMap.containsKey(id)) {
            List<BusinessTeamMemberVO> businessTeamMemberVOS = teamMap.get(id);
            if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
                Map<String, List<BusinessTeamMemberVO>> listMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
                //商务负责人
                if (listMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
                    Long userId = listMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getUserId();
                    vo.setBusinessUserId(tw4UserIdMap.get(userId).get(0).getUserIdV4());
                }
                //服务负责人
                if (listMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
                    Long userId = listMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getUserId();
                    vo.setServiceUserId(tw4UserIdMap.get(userId).get(0).getUserIdV4());

                }
                //关怀负责人
                if (listMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
                    Long userId = listMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getUserId();
                    vo.setCareUserId(tw4UserIdMap.get(userId).get(0).getUserIdV4());

                }
                //运维售后负责人
                if (listMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
                    Long userId = listMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getUserId();
                    vo.setOperationUserId(tw4UserIdMap.get(userId).get(0).getUserIdV4());
                }
            }
        }
        //身份翻译
        vo.setRelateType(translateTw4Identity(vo.getRelateType()));
        // 类型翻译 01 个人 02 公司
        if (BusinessPartnerTypeEnum.ORGANIZATION.getCode().equals(vo.getAbType())) {
            vo.setAbType("02");
        } else {
            vo.setAbType("01");
        }
        //单位规模翻译
        if (org.springframework.util.StringUtils.hasText(vo.getCompanyScale())) {
            vo.setCompanyScale(CustomerScaleEnum.valueOf(vo.getCompanyScale()).getTw4Code());
        }
        //客户状态
        if (org.springframework.util.StringUtils.hasText(vo.getCustomerStatus())) {
            vo.setCustomerStatus(BusinessPartnerStatusEnum.valueOf(vo.getCustomerStatus()).getTw4Code());
        }
        //内部/外部翻译
        if (org.springframework.util.StringUtils.hasText(vo.getInnerType())) {
            vo.setInnerType(BusinessInsideOrOutSideEnum.valueOf(vo.getInnerType()).getTw4Code());
        }
    }

    @Override
    public int queryContractNum(Long custId) {
        return businessPartnerRepo.queryContractNum(custId);
    }

    @Override
    public List<CrmFollowVO> queryFollowList(Long customerId, Boolean withAcitityFollows) {
        //分别查询并排序
        List<CrmFollowVO> followVOS = new ArrayList<>();
        //客户关联的线索列表
        List<Long> leadIds = crmLeadsDAO.queryByFormalCustomerId(customerId);
        //客户关联的商机列表
        List<Long> oppoIds = crmOpportunityDAO.queryByFormalCustomerId(customerId);


//        //商机关联的市场活动列表
//        List<Long> activityIdsByOppoId = actActivityDAO.queryByOppoIds(oppoIds);
//        for (Long leadId : leadIds) {
        List<CrmFollowDO> leadsFollowDos = crmFollowDAO.queryByObjectIdsAndObjectType(leadIds, CrmFollowObjectEnum.Leads.getCode());
        followVOS.addAll(followService.toListVo(CrmFollowObjectEnum.Leads, leadsFollowDos));
//        }
//        for (Long oppoId : oppoIds) {
        List<CrmFollowDO> oppoFollowDos = crmFollowDAO.queryByObjectIdsAndObjectType(oppoIds, CrmFollowObjectEnum.Opportunity.getCode());
        followVOS.addAll(followService.toListVo(CrmFollowObjectEnum.Opportunity, oppoFollowDos));

        if (withAcitityFollows != null && withAcitityFollows) {
            //线索关联的市场活动列表
            List<Long> activiyProjIds = actActivityDAO.queryByLeadsIds(leadIds);
            List<Long> actIds = actActivityDAO.queryByIds(activiyProjIds);
            if (actIds != null && !actIds.isEmpty()) {
                List<CrmFollowVO> activityFollowVOS = new ArrayList<>();
                List<CrmActDynamicVO> dynamicVOS = actActivityDAO.queryActDynamicByPrjIds(actIds);
                for (CrmActDynamicVO dynamicVO : dynamicVOS) {
                    CrmFollowVO followVO = new CrmFollowVO();
                    followVO.setCreateTime(dynamicVO.getCreateTime());
                    followVO.setCreateUserId(dynamicVO.getCreateUserId());
                    followVO.setCreateUserName(dynamicVO.getEmployeeName());
                    followVO.setFollowContent(dynamicVO.getDynamicContent());
                    followVO.setFollowObject("activity");
                    followVO.setFollowObjectDesc("市场活动");
                    followVO.setFollowType(dynamicVO.getDynamicType());
                    followVO.setFollowTypeDesc(dynamicVO.getDynamicTypeName());
                    followVO.setId(dynamicVO.getId());
                    followVO.setModifyTime(dynamicVO.getModifyTime());
                    followVO.setModifyUserId(dynamicVO.getModifyUserId());
                    activityFollowVOS.add(followVO);
                }
                followVOS.addAll(activityFollowVOS);
            }


        }

//        }
        //按时间正序排序
        List<CrmFollowVO> collect = followVOS.stream().sorted((u1, u2) -> u1.getCreateTime().compareTo(u2.getCreateTime())).collect(Collectors.toList());
        return collect;
    }

    @Override
    @Transactional
    public void updateAccAndInvoice2(BusinessPartnerChangeVO vo) {


        BusinessPartnerVO businessPartnerVO = vo.getBusinessPartnerVO();
        if (businessPartnerVO == null) {
            businessPartnerVO = queryByKey(vo.getId());
        }
        Long bookId = businessPartnerVO.getBookId();

        //发票数据处理
        List<BookInvoiceVO> bookInvoiceVOList = vo.getBookInvoiceVOList();
        if (!CollectionUtils.isEmpty(bookInvoiceVOList)) {
            //先对保存的数据做默认值处理
            List<BookInvoiceVO> collect = bookInvoiceVOList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            //当插入的数据没有默认的时候 选一个默认给他
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(false));
                bookInvoiceVOList.get(0).setIsDefault(true);
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "发票信息不能提交多条默认的数据");
                }
                //将不是默认的数据捞出来 然后置为false(前端传过来的时候是空 所以要给值)
                List<BookInvoiceVO> collectFalse = bookInvoiceVOList.stream().filter(p -> p.getIsDefault() == null || !p.getIsDefault()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(false));
                }
            }
            //发票删除数据处理 因为合同那边的合同批次关联的是发票id 因此不能随便删除
            BookInvoiceQuery query = new BookInvoiceQuery();
            query.setBookId(bookId);
            // 如果查询出来的是空说明都是新增的
            List<BookInvoiceVO> olBookInvoiceVOS = bookInvoiceService.queryListDynamic(query);
            if (!CollectionUtils.isEmpty(olBookInvoiceVOS)) {
                //处理删除的数据
                Map<Long, List<BookInvoiceVO>> newBookInvoiceMap = bookInvoiceVOList.stream().filter(p -> p.getId() != null).collect(Collectors.groupingBy(BookInvoiceVO::getId));
                List<Long> deleteIdList = new ArrayList<>();
                olBookInvoiceVOS.stream().forEach(p -> {
                    //如果列表中的银行账户集合不存在数据库中的id 证明他被删除了
                    if (!newBookInvoiceMap.containsKey(p.getId())) {
                        deleteIdList.add(p.getId());
                    }
                });
                //处理删除的数据
                if (!CollectionUtils.isEmpty(deleteIdList)) {
                    bookInvoiceService.deleteSoftBykeys(deleteIdList, bookId, businessPartnerVO.getId());
                }
            }
            // 处理新增的数据
            bookInvoiceVOList.stream().forEach(p -> {
                if (p.getId() == null) {
                    p.setBookId(bookId);
                }
            });
            bookInvoiceService.saveAll(bookInvoiceVOList);
        }
//        else {
//            //没有传输说明页面的数据都被删除了直接全部删除
//            bookInvoiceService.deleteByBookId(bookId);
//        }

        //银行账户处理
        List<BookAccountVO> bookAccountVOList = vo.getBookAccountVOList();
        if (!CollectionUtils.isEmpty(bookAccountVOList)) {
            //先处理默认值
            List<BookAccountVO> collect = bookAccountVOList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            //当插入的数据没有默认的时候 选一个默认给他
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(false));
                bookAccountVOList.get(0).setIsDefault(true);
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "银行信息不能提交多条默认的数据");
                }
                //将不是默认的数据捞出来 然后置为false(前端传过来的时候是空 所以要给值)
                List<BookAccountVO> collectFalse = bookAccountVOList.stream().filter(p -> p.getIsDefault() == null || !p.getIsDefault()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(false));
                }
            }
            //银行账户删除数据处理
            BookAccountQuery query = new BookAccountQuery();
            query.setBookId(bookId);
            // 如果查询出来的是空说明都是新增的
            List<BookAccountVO> oldBookAccountVOVOS = bookAccountService.queryListDynamic(query);
            if (!CollectionUtils.isEmpty(oldBookAccountVOVOS)) {
                //处理删除的数据
                Map<Long, List<BookAccountVO>> newBookAccountMap = bookAccountVOList.stream().filter(p -> p.getId() != null).collect(Collectors.groupingBy(BookAccountVO::getId));
                List<Long> deleteIdList = new ArrayList<>();
                oldBookAccountVOVOS.stream().forEach(p -> {
                    //如果列表中的银行账户集合不存在数据库中的id 证明他被删除了
                    if (!newBookAccountMap.containsKey(p.getId())) {
                        deleteIdList.add(p.getId());
                    }
                });
                //处理删除的数据
                if (!CollectionUtils.isEmpty(deleteIdList)) {
                    bookAccountService.deleteSoftBykeys(deleteIdList, bookId, businessPartnerVO.getId());
                }
            }

            // 处理新增的数据
            bookAccountVOList.stream().forEach(p -> {
                if (p.getId() == null) {
                    p.setBookId(bookId);
                }
            });
            bookAccountService.saveAll(bookAccountVOList);
        }
//        else{
//            //没有传输说明页面的数据都被删除了直接全部删除
//            bookAccountService.deleteByBookId(bookId);
//        }

    }

    @Override
    public Boolean checkExitInvices(Long bookId) {

        Assert.notNull(bookId, "bookId不能为空");
        Integer count = 0;
//     根据BookId校验该客户是否有开票信息
        BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
        bookInvoiceQuery.setBookId(bookId);

        Long count1 = bookInvoiceService.count(bookInvoiceQuery);
        if (count1 > 0) {
            return true;
        }

        //
//     或客户发票变更流程
//        3个都不存在则返回false
        List<BusinessPartnerVO> businessPartnerVOS = this.queryByBookId(bookId);
        if (CollectionUtils.isEmpty(businessPartnerVOS)) {
            return false;
        }

        BusinessPartnerVO businessPartnerVO = businessPartnerVOS.get(0);
        if (StrUtil.isNotBlank(businessPartnerVO.getApplyStatus()) && businessPartnerVO.getApplyStatus().equals(BusinessPartnerStatusEnum.APPROVING.getCode())) {
            return true;
        }

//
//     或正在流转的  客户激活流程
        BusinessCustomerInfoVO businessCustomerInfoVO = businessCustomerInfoService.queryByPartnerId(businessPartnerVO.getId());
        if (businessCustomerInfoVO != null && businessCustomerInfoVO.getCustomerStatus().equals(BusinessPartnerStatusEnum.APPROVING.getCode())) {
            return true;
        }

        return false;
    }


//    //数据同步地址信息翻译
//    public void translateAddress(PrdAbAddressPayload prdAbAddressPayload) {
//        if (org.springframework.util.StringUtils.hasText(prdAbAddressPayload.getAddressType())) {
//            prdAbAddressPayload.setAddressType(BookAddressTypeEnum.valueOf(prdAbAddressPayload.getAddressType()).getTw4Code());
//        }
//    }
}
