package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyIndexSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyIndexSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyIndexSettingService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexModelRefVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexSettingVO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessStrategyIndexSettingConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyIndexSettingDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyIndexSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyIndexSettingRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 分级策略指标配置
 *
 * @author wangly
 * @date 2023-06-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessStrategyIndexSettingServiceImpl extends BaseServiceImpl implements BusinessStrategyIndexSettingService {

    private final BusinessStrategyIndexSettingRepo businessStrategyIndexSettingRepo;
    private final BusinessStrategyIndexSettingDAO businessStrategyIndexSettingDAO;

    @Override
    public PagingVO<BusinessStrategyIndexSettingVO> queryPaging(BusinessStrategyIndexSettingQuery query){
        return businessStrategyIndexSettingDAO.queryPaging(query);
    }

    @Override
    public List<BusinessStrategyIndexSettingVO> queryListDynamic(BusinessStrategyIndexSettingQuery query){
        return businessStrategyIndexSettingDAO.queryListDynamic(query);
    }

    @Override
    public BusinessStrategyIndexSettingVO queryByKey(Long key) {
        BusinessStrategyIndexSettingDO entity = businessStrategyIndexSettingRepo.findById(key).orElseGet(BusinessStrategyIndexSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyIndexSettingVO vo = BusinessStrategyIndexSettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyIndexSettingVO insert(BusinessStrategyIndexSettingPayload payload) {
        BusinessStrategyIndexSettingDO entityDo = BusinessStrategyIndexSettingConvert.INSTANCE.toDo(payload);
        return BusinessStrategyIndexSettingConvert.INSTANCE.toVo(businessStrategyIndexSettingRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyIndexSettingVO update(BusinessStrategyIndexSettingPayload payload) {
        BusinessStrategyIndexSettingDO entity = businessStrategyIndexSettingRepo.findById(payload.getId()).orElseGet(BusinessStrategyIndexSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyIndexSettingDO entityDo = BusinessStrategyIndexSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessStrategyIndexSettingConvert.INSTANCE.toVo(businessStrategyIndexSettingRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessStrategyIndexSettingPayload payload) {
        BusinessStrategyIndexSettingDO entity = businessStrategyIndexSettingRepo.findById(payload.getId()).orElseGet(BusinessStrategyIndexSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessStrategyIndexSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessStrategyIndexSettingDAO.deleteSoft(keys);
        }
    }

    @Override
    public void saveAll(List<BusinessStrategyIndexSettingPayload> payloadList, Long strategyId) {
        List<BusinessStrategyIndexSettingDO> businessStrategyIndexSettingDOList = payloadList.stream().map(payLoad -> {
            BusinessStrategyIndexSettingDO businessStrategyIndexSettingDO = new BusinessStrategyIndexSettingDO();
            BeanUtil.copyProperties(payLoad,businessStrategyIndexSettingDO, CopyOptions.create().setIgnoreNullValue(true));
            businessStrategyIndexSettingDO.setStrategyId(strategyId);
            return businessStrategyIndexSettingDO;
        }).collect(Collectors.toList());
        businessStrategyIndexSettingRepo.saveAll(businessStrategyIndexSettingDOList);
    }

    @Override
    public List<BusinessStrategyIndexSettingVO> queryListByStrategyId(Long strategyId) {
        List<BusinessStrategyIndexSettingDO> businessStrategyIndexSettingDOList = businessStrategyIndexSettingRepo.findByStrategyIdAndDeleteFlag(strategyId, 0);
        List<BusinessStrategyIndexSettingVO> businessStrategyIndexSettingVOList = BusinessStrategyIndexSettingConvert.INSTANCE.toVoList(businessStrategyIndexSettingDOList);
        return businessStrategyIndexSettingVOList;
    }

    @Override
    public void deleteByStrategyId(Long strategyId) {
        businessStrategyIndexSettingDAO.deleteByStrategyId(strategyId);
    }

    @Override
    public List<BusinessStrategyIndexModelRefVO> queryIndexModelRef(Long strategyId){

        return businessStrategyIndexSettingDAO.queryIndexModelRef(strategyId);
    }

    @Override
    public Long quertDeleteModelCountByStrategyIds(List<Long> strategyIdList) {
        return businessStrategyIndexSettingDAO.quertDeleteModelCountByStrategyIds(strategyIdList);
    }

}
