package com.elitesland.tw.tw5.server.prd.pms.common.functionEnum;

import lombok.Getter;

/**
 * 拨付状态
 * READY
 * ING
 * OK
 * NO
 *
 * @author duwh
 * @date 2021/12/23
 */
public enum ProjActivityAllocateStateEnum {

    READY("READY", "待拨付"),
    ING("ING", "拨付审批中"),
    OK("OK", "拨付审批通过"),
    NO("NO", "拨付审批拒绝");

    @Getter
    private String type;

    @Getter
    private String desc;

    ProjActivityAllocateStateEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDesc(String type) {
        ProjActivityAllocateStateEnum[] twRelatedDocTypeEnum = values();
        for (ProjActivityAllocateStateEnum docType : twRelatedDocTypeEnum) {
            if (docType.getType().equalsIgnoreCase(type)) {
                return docType.getDesc();
            }
        }
        return null;
    }
}
