package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 广播
 *
 * @author xxb
 * @date 2023-10-07
 */
@Entity
@Table(name = "pms_dist_broadcast", indexes = {
        @Index(name = "dist_index", columnList = "dist_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_dist_broadcast", comment = "广播")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsDistBroadcastDO extends BaseModel implements Serializable  {
    /** 派发ID */
    @Comment("派发ID")
    @Column(name = "dist_id")
    private Long distId;
    /** 应答人数上限 */
    @Comment("应答人数上限")
    @Column()
    private Long respNumber;
    /** 广播天数 */
    @Comment("广播天数")
    @Column()
    private Long broadcastDays;
    /** 剩余天数 */
    @Comment("剩余天数")
    @Column()
    private Long remainingDays;

    public void copy(PmsDistBroadcastDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
