package com.elitesland.tw.tw5.server.prd.pms.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistBroadcastPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistBroadcastQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistBroadcastService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeRespondService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistBroadcastVO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.DistributeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsDistBroadcastConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistBroadcastDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsDistBroadcastDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsDistBroadcastRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Arrays;
import java.util.List;

/**
 * 广播
 *
 * @author xxb
 * @date 2023-10-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsDistBroadcastServiceImpl extends BaseServiceImpl implements PmsDistBroadcastService {

    private final PmsDistBroadcastRepo pmsDistBroadcastRepo;
    private final PmsDistBroadcastDAO pmsDistBroadcastDAO;

    private final PmsDistBroadcastDAO distBroadcastDAO;

    private final PmsDistributeDAO pmsDistributeDAO;

    private final PmsDistributeRespondService distributeRespondService;

    @Override
    public void cancelBroadcast(Long distId) {
        // 删除广播表记录
        distBroadcastDAO.deleteByDistIds(Arrays.asList(distId));

        // 删除响应表 TODO
        distributeRespondService.deleteByDistIds(Arrays.asList(distId));

        // 变更派发状态，由“广播中”=>“新建”
        PmsDistributePayload distributePayload = new PmsDistributePayload();
        distributePayload.setId(distId);
        distributePayload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
        pmsDistributeDAO.updateByKeyDynamic(distributePayload);
    }

    @Override
    public List<PmsDistBroadcastVO> findListByRespondentResId(Long respondentResId) {
        return distBroadcastDAO.findListByRespondentResId(respondentResId);
    }

    @Override
    public PagingVO<PmsDistBroadcastVO> queryPaging(PmsDistBroadcastQuery query) {
        return pmsDistBroadcastDAO.queryPaging(query);
    }

    @Override
    public List<PmsDistBroadcastVO> queryListDynamic(PmsDistBroadcastQuery query) {
        return pmsDistBroadcastDAO.queryListDynamic(query);
    }

    @Override
    public PmsDistBroadcastVO queryByKey(Long key) {
        PmsDistBroadcastDO entity = pmsDistBroadcastRepo.findById(key).orElseGet(PmsDistBroadcastDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsDistBroadcastVO vo = PmsDistBroadcastConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsDistBroadcastVO insert(PmsDistBroadcastPayload payload) {
        PmsDistBroadcastDO entityDo = PmsDistBroadcastConvert.INSTANCE.toDo(payload);
        return PmsDistBroadcastConvert.INSTANCE.toVo(pmsDistBroadcastRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsDistBroadcastVO update(PmsDistBroadcastPayload payload) {
        PmsDistBroadcastDO entity = pmsDistBroadcastRepo.findById(payload.getId()).orElseGet(PmsDistBroadcastDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsDistBroadcastDO entityDo = PmsDistBroadcastConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsDistBroadcastConvert.INSTANCE.toVo(pmsDistBroadcastRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsDistBroadcastPayload payload) {
        PmsDistBroadcastDO entity = pmsDistBroadcastRepo.findById(payload.getId()).orElseGet(PmsDistBroadcastDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsDistBroadcastDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            distBroadcastDAO.deleteSoft(keys);
        }
    }

}
