package com.elitesland.tw.tw5.server.prd.pms.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInspectionItemConfigPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsInspectionItemConfigQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsInspectionItemConfigService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInspectionItemConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsInspectionItemConfigConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsInspectionItemConfigDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsInspectionItemConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsInspectionItemConfigRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 结项检查项配置
 *
 * @author xxb
 * @date 2023-11-27
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsInspectionItemConfigServiceImpl extends BaseServiceImpl implements PmsInspectionItemConfigService {

    private final PmsInspectionItemConfigRepo pmsInspectionItemConfigRepo;
    private final PmsInspectionItemConfigDAO pmsInspectionItemConfigDAO;


    @Override
    public void batchSave(List<PmsInspectionItemConfigPayload> payloads) {
        if (!ObjectUtils.isEmpty(payloads)) {
            // checkItem  不能重复
            long count = payloads.stream().map(v -> v.getCheckItem()).distinct().count();
            if (count != payloads.size()) {
                throw TwException.error("", "不能有重复的检查事项");
            }
            // sortNo 不能为空 且 不能重复
            count = payloads.stream().filter(v -> ObjectUtils.isEmpty(v.getSortNo())).count();
            if (count > 0) {
                throw TwException.error("", "排序号不能为空");
            }
            count = payloads.stream().map(v -> v.getSortNo()).distinct().count();
            if (count != payloads.size()) {
                throw TwException.error("", "不能有重复的排序号");
            }
            List<PmsInspectionItemConfigDO> list = new ArrayList<>();
            for (PmsInspectionItemConfigPayload payload : payloads) {
                PmsInspectionItemConfigDO entityDo = PmsInspectionItemConfigConvert.INSTANCE.toDo(payload);
                list.add(entityDo);
            }
            pmsInspectionItemConfigRepo.saveAll(list);
        }

    }

    @Override
    public PagingVO<PmsInspectionItemConfigVO> queryPaging(PmsInspectionItemConfigQuery query) {
        return pmsInspectionItemConfigDAO.queryPaging(query);
    }

    @Override
    public List<PmsInspectionItemConfigVO> queryListDynamic(PmsInspectionItemConfigQuery query) {
        return pmsInspectionItemConfigDAO.queryListDynamic(query);
    }

    @Override
    public PmsInspectionItemConfigVO queryByKey(Long key) {
        PmsInspectionItemConfigDO entity = pmsInspectionItemConfigRepo.findById(key).orElseGet(PmsInspectionItemConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsInspectionItemConfigVO vo = PmsInspectionItemConfigConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsInspectionItemConfigDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<PmsInspectionItemConfigVO> getListByWorkTypeAndApprovalNode(String workType, String approvalNode) {
        PmsInspectionItemConfigQuery query = new PmsInspectionItemConfigQuery();
        query.setWorkTypeCodes(workType);
        query.setApprovalNodes(approvalNode);
        return pmsInspectionItemConfigDAO.queryListDynamic(query);
    }

}
