package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConTemplatePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConTemplateQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConTemplateService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConTemplateVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConTemplateConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConTemplateDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConTemplateDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConTemplateRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * 合同模板
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConTemplateServiceImpl extends BaseServiceImpl implements ConTemplateService {

    private final ConTemplateRepo conTemplateRepo;
    private final ConTemplateDAO conTemplateDAO;
    private final FileUtil fileUtil;

    @Override
    public PagingVO<ConTemplateVO> queryPaging(ConTemplateQuery query) {
//        dynamicVOS.forEach(dynamicVO -> {
//            dynamicVO.setDynamicTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmActDynamicType.getCode(), dynamicVO.getDynamicType()));
//            dynamicVO.setFileDatas(fileUtil.getFileDatas(dynamicVO.getFileCodes()));
//        });
        PagingVO<ConTemplateVO> pagingVO = conTemplateDAO.queryPaging(query);
        List<ConTemplateVO> records = pagingVO.getRecords();
        records.forEach(e -> e.setFileData(fileUtil.getFileDatas(e.getFileCodes())));
        return pagingVO;
    }

    @Override
    public List<ConTemplateVO> queryListDynamic(ConTemplateQuery query) {
        return conTemplateDAO.queryListDynamic(query);
    }

    @Override
    public ConTemplateVO queryByKey(Long key) {
        ConTemplateDO entity = conTemplateRepo.findById(key).orElseGet(ConTemplateDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConTemplateVO vo = ConTemplateConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConTemplateVO insert(ConTemplatePayload payload) {
        ConTemplateVO conTemplateVO = conTemplateDAO.selectInspect(payload.getName());
        if (conTemplateVO != null) {
            throw TwException.error("", "模板名称已存在，请重新输入！");
        }
        ConTemplateDO entityDo = ConTemplateConvert.INSTANCE.toDo(payload);
        return ConTemplateConvert.INSTANCE.toVo(conTemplateRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConTemplateVO update(ConTemplatePayload payload) {
        ConTemplateVO conTemplateVO = conTemplateDAO.selectInspect(payload.getName());
        if (conTemplateVO != null) {
            if (!conTemplateVO.getId().equals(payload.getId())) {
                throw TwException.error("", "模板名称已存在，请重新输入！");
            }
        }

        ConTemplateDO entity = conTemplateRepo.findById(payload.getId()).orElseGet(ConTemplateDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConTemplateDO entityDo = ConTemplateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConTemplateConvert.INSTANCE.toVo(conTemplateRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conTemplateDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public void deleteById(Long key) {
        conTemplateDAO.deleteSoft(Collections.singletonList(key));
    }

}
