package com.elitesland.tw.tw5.server.prd.sms.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.coord.messenger.sender.provider.param.SimpleSmsDTO;
import com.elitescloud.coord.messenger.sender.provider.param.TemplateSmsDTO;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.Map;

/**
 * tw短信服务
 *
 * @author duwh
 * @date 2023/06/08
 */
public interface TwSmsService {

    /**
     * 发送模板短信
     *
     * @param phone        电话
     * @param templateCode 模板代码
     * @param param        模版参数
     * @return {@link ApiResult}<{@link Boolean}>
     */
    ApiResult<Boolean> sendTemplateMsg(String phone, String templateCode, Map param);

    /**
     * 发送模板短信
     *
     * @param smsDTO 短信参数
     * @return 发送结果
     */
    ApiResult<Boolean> sendTemplateMsg(@RequestBody @Valid TemplateSmsDTO smsDTO);

    /**
     * 发送普通短信
     *
     * @param smsDTO 短信参数
     * @return 发送结果
     */
    ApiResult<Boolean> sendSimpleMsg(@RequestBody @Valid SimpleSmsDTO smsDTO);
}
