package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemLogDetailPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogDetailQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogDetailVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemLogDetailDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemLogDetailRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemLogDetailDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemLogDetailRepo repo;
//    private final QCrmLogDetailDO qdo = QCrmLogDetailDO.crmLogDetailDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemLogDetailDO save(PrdSystemLogDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdSystemLogDetailDO> saveAll(List<PrdSystemLogDetailDO> dos) {
        return repo.saveAll(dos);
    }


}
