package com.elitesland.tw.tw5.server.yeedocref.functions;

import com.elitesland.tw.tw5.server.yeedocref.CommonFormulaFunction;
import com.elitesland.tw.tw5.server.yeedocref.TwFormulaFunctionAnnotation;
import org.springframework.stereotype.Component;

import java.util.List;

@Component(CommonFormulaFunction.SERVICE_NAME_PREFIX + TwBuNameFunction.FUNCTION_CODE)
@TwFormulaFunctionAnnotation(
        name = "获取BU名称",
        code = TwBuNameFunction.FUNCTION_CODE,
        scope = "COMMON",
        tableName = "",
        params = "BuId",
        description = "获取BU名称,参数可直接填写BuId，或者上下文中的属性名称",
        enabled = true
)
public class TwBuNameFunction implements CommonFormulaFunction {

    public static final String FUNCTION_CODE = "GetBuName";

    @Override
    public Object exec(List list) {
        // 检查阐述是否合法
        if (list.size() != 1) {
            throw new IllegalArgumentException("参数个数错误");
        }
        Long buId = Long.valueOf(list.get(0).toString());
        // todo 获取BU名称
        return buId + "";
    }
}
