/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimExportVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccPayBatchTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimPayModeEnum;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccFinancialSubjectDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimDetailDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class AccReimDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final AccReimRepo repo;
    private final QAccReimDO qdo = QAccReimDO.accReimDO;
    private final QAccReimDetailDO qDtldo = QAccReimDetailDO.accReimDetailDO;
    private final QAccFinancialSubjectDO qFinancialSubjectDO = QAccFinancialSubjectDO.accFinancialSubjectDO;

    private JPAQuery<AccReimVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccReimVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.reimNo, this.qdo.reimUserId, this.qdo.reimOrgId, this.qdo.reimResGrade, this.qdo.reimType, this.qdo.reasonType, this.qdo.reimDocType, this.qdo.relatedDocId, this.qdo.relatedDocName, this.qdo.relatedBudgetId, this.qdo.expenseClassification, this.qdo.expenseProjectId, this.qdo.expenseOrgId, this.qdo.expenseCompany, this.qdo.expenseByType, this.qdo.accountingDate, this.qdo.reimStatus, this.qdo.reimTotalAmt, this.qdo.adjustAmt, this.qdo.reimRemark, this.qdo.payAmt, this.qdo.borrowWriteOffAmt, this.qdo.payDate, this.qdo.payStatus, this.qdo.reasonId, this.qdo.reasonName, this.qdo.payMethod, this.qdo.accountNo, this.qdo.holderName, this.qdo.bankName, this.qdo.bankBranch, this.qdo.batchNo, this.qdo.payAccountNo, this.qdo.payMode, this.qdo.finChargeUpTime, this.qdo.fileCode, this.qdo.applyDate, this.qdo.apprProcName, this.qdo.finPicApprTime, this.qdo.bankTime, this.qdo.apprStatus, this.qdo.contractId, this.qdo.procInstId, this.qdo.procInstName, this.qdo.finPeriodId, this.qdo.finRejectFlag, this.qdo.procTaskKey, this.qdo.abnormalFlag, this.qdo.reimDetailFlag, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5, this.qdo.ext6})).from((EntityPath)this.qdo);
    }

    private JPAQuery<AccReimVO> getJpaQueryWhere(AccReimQuery query) {
        JPAQuery<AccReimVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(AccReimQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(AccReimQuery query) {
        String likeStr;
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIdList())) {
            list.add(this.qdo.id.in((Collection)query.getIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimNo())) {
            likeStr = SqlUtil.toSqlLikeString(query.getReimNo());
            list.add(this.qdo.reimNo.like(likeStr));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimOrgId())) {
            list.add(this.qdo.reimOrgId.eq((Object)query.getReimOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimResGrade())) {
            list.add(this.qdo.reimResGrade.eq((Object)query.getReimResGrade()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimDocType())) {
            list.add(this.qdo.reimDocType.eq((Object)query.getReimDocType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedDocId())) {
            list.add(this.qdo.relatedDocId.eq((Object)query.getRelatedDocId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedBudgetId())) {
            list.add(this.qdo.relatedBudgetId.eq((Object)query.getRelatedBudgetId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExpenseClassification())) {
            list.add(this.qdo.expenseClassification.eq((Object)query.getExpenseClassification()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExpenseProjectId())) {
            list.add(this.qdo.expenseProjectId.eq((Object)query.getExpenseProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExpenseOrgId())) {
            list.add(this.qdo.expenseOrgId.eq((Object)query.getExpenseOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExpenseCompany())) {
            list.add(this.qdo.expenseCompany.eq((Object)query.getExpenseCompany()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccountingDate())) {
            list.add(this.qdo.accountingDate.eq((Object)query.getAccountingDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimStatus())) {
            list.add(this.qdo.reimStatus.eq((Object)query.getReimStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimRemark())) {
            list.add(this.qdo.reimRemark.eq((Object)query.getReimRemark()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayAmt())) {
            list.add(this.qdo.payAmt.eq((Object)query.getPayAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayDate())) {
            list.add(this.qdo.payDate.eq((Object)query.getPayDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonId())) {
            list.add(this.qdo.reasonId.eq((Object)query.getReasonId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonType())) {
            list.add(this.qdo.reasonType.eq((Object)query.getReasonType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonName())) {
            likeStr = SqlUtil.toSqlLikeString(query.getReasonName());
            list.add(this.qdo.reasonName.like(likeStr));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayMethod())) {
            list.add(this.qdo.payMethod.eq((Object)query.getPayMethod()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccountNo())) {
            list.add(this.qdo.accountNo.eq((Object)query.getAccountNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getHolderName())) {
            list.add(this.qdo.holderName.eq((Object)query.getHolderName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBankName())) {
            list.add(this.qdo.bankName.eq((Object)query.getBankName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBankBranch())) {
            list.add(this.qdo.bankBranch.eq((Object)query.getBankBranch()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBatchNo())) {
            likeStr = SqlUtil.toSqlLikeString(query.getBatchNo());
            list.add(this.qdo.batchNo.like(likeStr));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBatchNoList())) {
            list.add(this.qdo.batchNo.in((Collection)query.getBatchNoList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBatchNoLast())) {
            likeStr = SqlUtil.toSqlLikeString(query.getBatchNoLast());
            list.add(this.qdo.batchNoLast.like(likeStr));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayAccountNo())) {
            list.add(this.qdo.payAccountNo.eq((Object)query.getPayAccountNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprProcName())) {
            likeStr = SqlUtil.toSqlLikeString(query.getApprProcName());
            list.add(this.qdo.apprProcName.like(likeStr));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNotId())) {
            list.add(this.qdo.id.ne((Object)query.getNotId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprStatus())) {
            list.add(this.qdo.apprStatus.eq((Object)query.getApprStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimUserId())) {
            if (!ObjectUtils.isEmpty((Object)query.getMyReimUserId())) {
                list.add(this.qdo.reimUserId.eq((Object)query.getReimUserId()).or((Predicate)this.qdo.createUserId.eq((Object)query.getMyReimUserId())));
            } else {
                list.add(this.qdo.reimUserId.eq((Object)query.getReimUserId()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonTypeList())) {
            list.add(this.qdo.reasonType.in((Collection)query.getReasonTypeList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonIdList())) {
            list.add(this.qdo.reasonId.in((Collection)query.getReasonIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReimStatusList())) {
            list.add(this.qdo.reimStatus.in((Collection)query.getReimStatusList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNotReimStatusList())) {
            list.add(this.qdo.reimStatus.notIn((Collection)query.getNotReimStatusList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetItemId())) {
            list.add(this.qDtldo.budgetItemId.eq((Object)query.getBudgetItemId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetItemIdList())) {
            list.add(this.qDtldo.budgetItemId.in((Collection)query.getBudgetItemIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyDate())) {
            list.add(this.qdo.applyDate.eq((Object)query.getApplyDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyDateStart()) && !ObjectUtils.isEmpty((Object)query.getApplyDateEnd())) {
            list.add(this.qdo.applyDate.goe((Comparable)query.getApplyDateStart()).and((Predicate)this.qdo.applyDate.loe((Comparable)query.getApplyDateEnd())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayDateStart()) && !ObjectUtils.isEmpty((Object)query.getPayDateEnd())) {
            list.add(this.qdo.payDate.goe((Comparable)query.getPayDateStart()).and((Predicate)this.qdo.payDate.loe((Comparable)query.getPayDateEnd())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccountingDateStart()) && !ObjectUtils.isEmpty((Object)query.getAccountingDateEnd())) {
            list.add(this.qdo.accountingDate.goe((Comparable)query.getAccountingDateStart()).and((Predicate)this.qdo.accountingDate.loe((Comparable)query.getAccountingDateEnd())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinChargeUpTimeStart()) && !ObjectUtils.isEmpty((Object)query.getFinChargeUpTimeEnd())) {
            list.add(this.qdo.finChargeUpTime.goe((Comparable)query.getFinChargeUpTimeStart()).and((Predicate)this.qdo.finChargeUpTime.loe((Comparable)query.getFinChargeUpTimeEnd())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinPicApprTimeStart()) && !ObjectUtils.isEmpty((Object)query.getFinPicApprTimeEnd())) {
            list.add(this.qdo.finPicApprTime.goe((Comparable)query.getFinPicApprTimeStart()).and((Predicate)this.qdo.finPicApprTime.loe((Comparable)query.getFinPicApprTimeEnd())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayStatus())) {
            list.add(this.qdo.payStatus.eq((Object)query.getPayStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayMode())) {
            list.add(this.qdo.payMode.eq((Object)query.getPayMode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExpenseDateStart()) && !ObjectUtils.isEmpty((Object)query.getExpenseDateEnd())) {
            list.add(this.qDtldo.expenseDate.goe((Comparable)query.getExpenseDateStart()).and((Predicate)this.qDtldo.expenseDate.lt((Comparable)query.getExpenseDateEnd())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAbnormalFlag())) {
            list.add(this.qdo.abnormalFlag.eq((Object)query.getAbnormalFlag()));
        }
        return ExpressionUtils.allOf(list);
    }

    public AccReimVO queryByKey(Long id) {
        JPAQuery<AccReimVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (AccReimVO)jpaQuery.fetchFirst();
    }

    public AccReimVO queryOneByReimNo(String reimNo) {
        JPAQuery<AccReimVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.reimNo.eq((Object)reimNo));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (AccReimVO)jpaQuery.fetchFirst();
    }

    public List<AccReimVO> queryListDynamic(AccReimQuery query) {
        JPAQuery<AccReimVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<AccReimVO> queryPaging(AccReimQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<AccReimVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public AccReimDO save(AccReimDO ado) {
        return (AccReimDO)this.repo.save(ado);
    }

    public List<AccReimDO> saveAll(List<AccReimDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(AccReimPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getReimNo() != null) {
            update.set((Path)this.qdo.reimNo, (Object)payload.getReimNo());
        }
        if (payload.getReimUserId() != null) {
            update.set(this.qdo.reimUserId, (Object)payload.getReimUserId());
        }
        if (payload.getReimOrgId() != null) {
            update.set(this.qdo.reimOrgId, (Object)payload.getReimOrgId());
        }
        if (payload.getReimTotalAmt() != null) {
            update.set(this.qdo.reimTotalAmt, (Object)payload.getReimTotalAmt());
        }
        if (payload.getReimResGrade() != null) {
            update.set((Path)this.qdo.reimResGrade, (Object)payload.getReimResGrade());
        }
        if (payload.getReimDocType() != null) {
            update.set((Path)this.qdo.reimDocType, (Object)payload.getReimDocType());
        }
        if (payload.getRelatedDocId() != null) {
            update.set(this.qdo.relatedDocId, (Object)payload.getRelatedDocId());
        }
        if (payload.getRelatedDocName() != null) {
            update.set((Path)this.qdo.relatedDocName, (Object)payload.getRelatedDocName());
        }
        if (payload.getRelatedBudgetId() != null) {
            update.set(this.qdo.relatedBudgetId, (Object)payload.getRelatedBudgetId());
        }
        if (payload.getExpenseClassification() != null) {
            update.set((Path)this.qdo.expenseClassification, (Object)payload.getExpenseClassification());
        }
        if (payload.getExpenseProjectId() != null) {
            update.set(this.qdo.expenseProjectId, (Object)payload.getExpenseProjectId());
        }
        if (payload.getExpenseOrgId() != null) {
            update.set(this.qdo.expenseOrgId, (Object)payload.getExpenseOrgId());
        }
        if (payload.getExpenseCompany() != null) {
            update.set(this.qdo.expenseCompany, (Object)payload.getExpenseCompany());
        }
        if (payload.getAccountingDate() != null) {
            update.set(this.qdo.accountingDate, (Object)payload.getAccountingDate());
        }
        if (payload.getReimStatus() != null) {
            update.set((Path)this.qdo.reimStatus, (Object)payload.getReimStatus());
        }
        if (payload.getProcInstId() != null) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (payload.getApplyDate() != null) {
            update.set(this.qdo.applyDate, (Object)payload.getApplyDate());
        }
        if (payload.getReimRemark() != null) {
            update.set((Path)this.qdo.reimRemark, (Object)payload.getReimRemark());
        }
        if (payload.getPayAmt() != null) {
            update.set(this.qdo.payAmt, (Object)payload.getPayAmt());
        }
        if (payload.getPayDate() != null) {
            update.set(this.qdo.payDate, (Object)payload.getPayDate());
        }
        if (payload.getPayMethod() != null) {
            update.set((Path)this.qdo.payMethod, (Object)payload.getPayMethod());
        }
        if (payload.getAccountNo() != null) {
            update.set((Path)this.qdo.accountNo, (Object)payload.getAccountNo());
        }
        if (payload.getHolderName() != null) {
            update.set((Path)this.qdo.holderName, (Object)payload.getHolderName());
        }
        if (payload.getBankName() != null) {
            update.set((Path)this.qdo.bankName, (Object)payload.getBankName());
        }
        if (payload.getBankBranch() != null) {
            update.set((Path)this.qdo.bankBranch, (Object)payload.getBankBranch());
        }
        if (payload.getBatchNo() != null) {
            update.set((Path)this.qdo.batchNo, (Object)payload.getBatchNo());
        }
        if (payload.getBankFlag() != null) {
            update.set(this.qdo.bankFlag, (Object)payload.getBankFlag());
        }
        if (payload.getBankTime() != null) {
            update.set(this.qdo.bankTime, (Object)payload.getBankTime());
        }
        if (payload.getPayStatus() != null) {
            update.set((Path)this.qdo.payStatus, (Object)payload.getPayStatus());
        }
        if (payload.getPayAccountNo() != null) {
            update.set((Path)this.qdo.payAccountNo, (Object)payload.getPayAccountNo());
        }
        if (payload.getApprStatus() != null) {
            update.set((Path)this.qdo.apprStatus, (Object)payload.getApprStatus());
        }
        if (payload.getFinChargeUpTime() != null) {
            update.set(this.qdo.finChargeUpTime, (Object)payload.getFinChargeUpTime());
        }
        if (payload.getFinPicApprTime() != null) {
            update.set(this.qdo.finPicApprTime, (Object)payload.getFinPicApprTime());
        }
        if (payload.getFileCode() != null) {
            update.set((Path)this.qdo.fileCode, (Object)payload.getFileCode());
        }
        if (payload.getContractId() != null) {
            update.set(this.qdo.contractId, (Object)payload.getContractId());
        }
        if (payload.getProcInstName() != null) {
            update.set((Path)this.qdo.procInstName, (Object)payload.getProcInstName());
        }
        if (payload.getFinRejectFlag() != null) {
            update.set(this.qdo.finRejectFlag, (Object)payload.getFinRejectFlag());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        if (StringUtils.hasText((String)payload.getProcTaskKey())) {
            update.set((Path)this.qdo.procTaskKey, (Object)payload.getProcTaskKey());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getAbnormalFlag())) {
            update.set(this.qdo.abnormalFlag, (Object)payload.getAbnormalFlag());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getReimDetailFlag())) {
            update.set(this.qdo.reimDetailFlag, (Object)payload.getReimDetailFlag());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getExt1())) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getExt2())) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getExt3())) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getExt4())) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getExt5())) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getExt6())) {
            update.set((Path)this.qdo.ext6, (Object)payload.getExt6());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("reimNo")) {
                update.setNull((Path)this.qdo.reimNo);
            }
            if (nullFields.contains("reimUserId")) {
                update.setNull(this.qdo.reimUserId);
            }
            if (nullFields.contains("reimOrgId")) {
                update.setNull(this.qdo.reimOrgId);
            }
            if (nullFields.contains("reimResGrade")) {
                update.setNull((Path)this.qdo.reimResGrade);
            }
            if (nullFields.contains("reimDocType")) {
                update.setNull((Path)this.qdo.reimDocType);
            }
            if (nullFields.contains("relatedDocId")) {
                update.setNull(this.qdo.relatedDocId);
            }
            if (nullFields.contains("relatedBudgetId")) {
                update.setNull(this.qdo.relatedBudgetId);
            }
            if (nullFields.contains("expenseClassification")) {
                update.setNull((Path)this.qdo.expenseClassification);
            }
            if (nullFields.contains("expenseProjectId")) {
                update.setNull(this.qdo.expenseProjectId);
            }
            if (nullFields.contains("expenseOrgId")) {
                update.setNull(this.qdo.expenseOrgId);
            }
            if (nullFields.contains("expenseCompany")) {
                update.setNull(this.qdo.expenseCompany);
            }
            if (nullFields.contains("accountingDate")) {
                update.setNull(this.qdo.accountingDate);
            }
            if (nullFields.contains("reimStatus")) {
                update.setNull((Path)this.qdo.reimStatus);
            }
            if (nullFields.contains("reimRemark")) {
                update.setNull((Path)this.qdo.reimRemark);
            }
            if (nullFields.contains("payAmt")) {
                update.setNull(this.qdo.payAmt);
            }
            if (nullFields.contains("payDate")) {
                update.setNull(this.qdo.payDate);
            }
            if (nullFields.contains("reasonId")) {
                update.setNull(this.qdo.reasonId);
            }
            if (nullFields.contains("reasonName")) {
                update.setNull((Path)this.qdo.reasonName);
            }
            if (nullFields.contains("payMethod")) {
                update.setNull((Path)this.qdo.payMethod);
            }
            if (nullFields.contains("accountNo")) {
                update.setNull((Path)this.qdo.accountNo);
            }
            if (nullFields.contains("holderName")) {
                update.setNull((Path)this.qdo.holderName);
            }
            if (nullFields.contains("bankName")) {
                update.setNull((Path)this.qdo.bankName);
            }
            if (nullFields.contains("bankBranch")) {
                update.setNull((Path)this.qdo.bankBranch);
            }
            if (nullFields.contains("batchNo")) {
                update.setNull((Path)this.qdo.batchNo);
            }
            if (nullFields.contains("payAccountNo")) {
                update.setNull((Path)this.qdo.payAccountNo);
            }
            if (nullFields.contains("finChargeUpTime")) {
                update.setNull(this.qdo.finChargeUpTime);
            }
            if (nullFields.contains("abnormalFlag")) {
                update.setNull(this.qdo.abnormalFlag);
            }
            if (nullFields.contains("reimDetailFlag")) {
                update.setNull(this.qdo.reimDetailFlag);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
            if (nullFields.contains("ext6")) {
                update.setNull((Path)this.qdo.ext6);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updatePayMode(Long[] keys, String payMode) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.payMode, (Object)payMode).where(new Predicate[]{this.qdo.id.in((Object[])keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateFinChargeUp(Long key) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.finChargeUpTime, (Object)LocalDateTime.now()).set((Path)this.qdo.reimStatus, (Object)AccReimDocStatusEnum.FINANCIAL_AUDIT.getCode()).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateBatchNo(List<Long> keys, String batchNo, String type, Long finPeriodId, LocalDate expenseAccountDate, String payMode) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo);
        if (AccPayBatchTypeEnum.ACCOUNT.getCode().equals(type)) {
            update.set((Path)this.qdo.batchNo, (Object)batchNo);
        } else {
            if (AccReimPayModeEnum.PAY_MODE_2.getCode().equals(payMode)) {
                update.set((Path)this.qdo.reimStatus, (Object)AccReimDocStatusEnum.APPROVED.getCode());
            }
            update.set((Path)this.qdo.batchNoLast, (Object)batchNo);
        }
        update.set(this.qdo.finPeriodId, (Object)finPeriodId);
        update.where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<AccReimExportVO> getExportChargeData(String batchNo) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(AccReimExportVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.expenseCompany, this.qdo.reasonType, this.qdo.reasonId, this.qdo.reasonName, this.qdo.reimNo, this.qdo.reimUserId, this.qdo.reimDocType, this.qdo.reimOrgId, this.qdo.expenseOrgId, this.qdo.expenseProjectId, this.qDtldo.id.as("detailId"), this.qDtldo.reimAmt, this.qDtldo.adjustAmt, this.qDtldo.taxAmt, this.qDtldo.expenseDate, this.qDtldo.finAccSubjId, this.qFinancialSubjectDO.accName, this.qFinancialSubjectDO.accCode.as("finAccSubjCode"), this.qDtldo.reimRemark.as("dtlReimRemark"), this.qDtldo.invoiceNum})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qDtldo)).on((Predicate)this.qDtldo.masId.eq(this.qdo.id).and((Predicate)this.qDtldo.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qFinancialSubjectDO)).on((Predicate)this.qDtldo.finAccSubjId.eq(this.qFinancialSubjectDO.id).and((Predicate)this.qFinancialSubjectDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qdo.batchNo.eq((Object)batchNo));
        return query.fetch();
    }

    public List<AccReimExportVO> getExportChargeDataByKeys(List<Long> keys) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(AccReimExportVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.expenseCompany, this.qdo.reasonType, this.qdo.reasonId, this.qdo.reasonName, this.qdo.reimNo, this.qdo.reimUserId, this.qdo.reimDocType, this.qdo.reimOrgId, this.qdo.expenseOrgId, this.qdo.expenseProjectId, this.qdo.batchNo, this.qDtldo.id.as("detailId"), this.qDtldo.reimAmt, this.qDtldo.taxAmt, this.qDtldo.expenseDate, this.qDtldo.finAccSubjId, this.qDtldo.adjustAmt, this.qFinancialSubjectDO.accName, this.qFinancialSubjectDO.accCode.as("finAccSubjCode"), this.qDtldo.reimRemark.as("dtlReimRemark"), this.qDtldo.invoiceNum})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qDtldo)).on((Predicate)this.qDtldo.masId.eq(this.qdo.id).and((Predicate)this.qDtldo.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qFinancialSubjectDO)).on((Predicate)this.qDtldo.finAccSubjId.eq(this.qFinancialSubjectDO.id).and((Predicate)this.qFinancialSubjectDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qdo.id.in(keys));
        return query.fetch();
    }

    public long updatePayStatus(AccReimPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo);
        update.set(this.qdo.payDate, (Object)payload.getPayDate());
        update.set((Path)this.qdo.payStatus, (Object)payload.getPayStatus());
        if (!ObjectUtils.isEmpty((Object)payload.getReimStatus())) {
            update.set((Path)this.qdo.reimStatus, (Object)payload.getReimStatus());
        }
        update.set(this.qdo.modifyTime, (Object)payload.getPayDate());
        update.where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        return update.execute();
    }

    public PagingVO<AccReimVO> paging2Budget(AccReimQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qDtldo.count()).from((EntityPath)this.qDtldo)).leftJoin((EntityPath)this.qdo)).on((Predicate)this.qdo.id.eq(this.qDtldo.masId).and((Predicate)this.qdo.deleteFlag.eq((Object)0)));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<AccReimVO> jpaDataQuery = this.getJpaQueryWhere4Budget(query);
        List result = ((JPAQuery)((JPAQuery)jpaDataQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    private JPAQuery<AccReimVO> getJpaQueryWhere4Budget(AccReimQuery query) {
        JPAQuery<AccReimVO> jpaQuery = this.getJpaQuerySelect4Budget();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<AccReimVO> getJpaQuerySelect4Budget() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccReimVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.reimNo, this.qdo.reimUserId, this.qdo.reimOrgId, this.qdo.reimResGrade, this.qdo.reimType, this.qdo.reasonType, this.qdo.reimDocType, this.qdo.expenseOrgId, this.qdo.expenseCompany, this.qdo.expenseByType, this.qdo.accountingDate, this.qdo.reimStatus, this.qDtldo.reimAmt.as("reimTotalAmt"), this.qdo.adjustAmt, this.qdo.reimRemark, this.qdo.payAmt, this.qdo.payDate, this.qdo.payStatus, this.qdo.reasonId, this.qdo.reasonName, this.qdo.applyDate})).from((EntityPath)this.qDtldo)).leftJoin((EntityPath)this.qdo)).on((Predicate)this.qDtldo.masId.eq(this.qdo.id).and((Predicate)this.qdo.deleteFlag.eq((Object)0)));
    }

    public List<AccReimVO> queryList4Rule(AccReimQuery query) {
        JPAQuery<AccReimVO> jpaQuery = this.getJpaQuerySelect4Rule(query);
        return jpaQuery.fetch();
    }

    private JPAQuery<AccReimVO> getJpaQuerySelect4Rule(AccReimQuery query) {
        JPAQuery<AccReimVO> jpaQuery = this.getJpaQuerySelect4Rule();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<AccReimVO> getJpaQuerySelect4Rule() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccReimVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.reimNo, this.qdo.reimUserId, this.qdo.reimOrgId, this.qdo.reimResGrade, this.qdo.reimType, this.qdo.reasonType, this.qdo.reimDocType, this.qdo.relatedDocId, this.qdo.relatedDocName, this.qdo.relatedBudgetId, this.qdo.expenseClassification, this.qdo.expenseProjectId, this.qdo.expenseOrgId, this.qdo.expenseCompany, this.qdo.expenseByType, this.qdo.accountingDate, this.qdo.reimStatus, this.qdo.reimTotalAmt, this.qdo.adjustAmt, this.qdo.reimRemark, this.qdo.payAmt, this.qdo.payDate, this.qdo.payStatus, this.qdo.reasonId, this.qdo.reasonName, this.qdo.payMethod, this.qdo.accountNo, this.qdo.holderName, this.qdo.bankName, this.qdo.bankBranch, this.qdo.batchNo, this.qdo.payAccountNo, this.qdo.payMode, this.qdo.finChargeUpTime, this.qdo.fileCode, this.qdo.applyDate, this.qdo.apprProcName, this.qdo.finPicApprTime, this.qdo.bankTime, this.qdo.apprStatus, this.qdo.contractId, this.qdo.procInstId, this.qdo.procInstName, this.qdo.finPeriodId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qDtldo)).on((Predicate)this.qDtldo.masId.eq(this.qdo.id).and((Predicate)this.qDtldo.deleteFlag.eq((Object)0)));
    }

    public void updateAccountDigestAndStatusByKeys(List<Long> keys, String expenseProofDigest, String expenseProofNo, String expenseProofStatus, String expenseProofFailReason) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo);
        update.set((Path)this.qdo.reimStatus, (Object)AccReimDocStatusEnum.PENDING_PAYMENT.getCode());
        update.where(new Predicate[]{this.qdo.id.in(keys)});
        update.execute();
    }

    public void updatePayDigestAndStatusByKeys(List<Long> keys, String payProofDigest, String payProofNo, String payProofStatus, String payProofFailReason) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo);
        update.set((Path)this.qdo.reimStatus, (Object)AccReimDocStatusEnum.APPROVED.getCode());
        update.where(new Predicate[]{this.qdo.id.in(keys)});
        update.execute();
    }

    public AccReimDAO(JPAQueryFactory jpaQueryFactory, AccReimRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

