/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.adm.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmFeeApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmFeeApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmFeeApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyDetailService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.adm.convert.AdmFeeApplyConvert;
import com.elitesland.tw.tw5.server.prd.adm.dao.AdmFeeApplyDAO;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmFeeApplyDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmFeeApplyRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FeeApplyStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AdmFeeApplyServiceImpl
extends BaseServiceImpl
implements AdmFeeApplyService {
    private static final Logger log = LoggerFactory.getLogger(AdmFeeApplyServiceImpl.class);
    private final AdmFeeApplyRepo admFeeApplyRepo;
    private final AdmFeeApplyDAO admFeeApplyDAO;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private final PmsProjectService pmsProjectService;
    private final AdmFeeApplyDetailService admFeeApplyDetailService;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;

    @Transactional(rollbackFor={Exception.class})
    public AdmFeeApplyVO insertOrUpdate(AdmFeeApplyPayload payload) {
        AdmFeeApplyVO admFeeApplyVO = this.checkData(payload);
        PmsProjectVO pmsProjectVO = null;
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            pmsProjectVO = this.pmsProjectService.queryByKey(payload.getReasonId());
            payload.setExpenseBuId(pmsProjectVO.getDeliBuId());
        }
        payload.setApplyStatus(FeeApplyStatusEnum.CREATE.getCode());
        if (admFeeApplyVO == null) {
            String code = this.generateSeqNum("AMD_FEE_APPLY", new String[0]);
            payload.setApplyNo(code);
            payload.setApplyDate(LocalDate.now());
        } else {
            payload.setApplyStatus(admFeeApplyVO.getApplyStatus());
            payload.setProcInstId(admFeeApplyVO.getProcInstId());
            payload.setApplyDate(admFeeApplyVO.getApplyDate());
        }
        AdmFeeApplyDO entityDo = AdmFeeApplyConvert.INSTANCE.toDo(payload);
        AdmFeeApplyDO save = (AdmFeeApplyDO)this.admFeeApplyRepo.save(entityDo);
        if (!ObjectUtils.isEmpty((Object)payload.getDelDetailIds())) {
            this.admFeeApplyDetailService.deleteSoft(payload.getDelDetailIds());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDetailPayloads())) {
            payload.getDetailPayloads().forEach(act -> {
                if (act.getApplyAmt() == null || act.getApplyAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    throw TwException.error("", "\u8d39\u7528\u91d1\u989d\u9700\u5927\u4e8e0");
                }
                act.setApplyId(save.getId());
            });
            this.admFeeApplyDetailService.bacthInsert(payload.getDetailPayloads());
        }
        String apprStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
        String applyStatus = FeeApplyStatusEnum.APPLYING.getCode();
        String procInstId = null;
        if (admFeeApplyVO != null) {
            procInstId = admFeeApplyVO.getProcInstId();
        }
        HashMap<String, Object> variables = this.getVariables(payload);
        if (procInstId == null) {
            String selection = this.cacheUtil.transferSystemSelection("ADM:COST:USE_TYPE", payload.getUsageType());
            String procName = "A06.\u7279\u6b8a\u8d39\u7528\u7533\u8bf7-" + selection + "-" + this.cacheUtil.getUserName(payload.getApplyResId());
            ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)"AMD_FEE_APPLY", (String)procName, (String)("" + entityDo.getId()), variables), new Long[0]);
            procInstId = processInfo.getProcInstId();
            apprStatus = processInfo.getProcInstStatus().name();
            if (apprStatus.equals(ProcInstStatus.APPROVED.name())) {
                applyStatus = FeeApplyStatusEnum.APPROVED.getCode();
                procInstId = null;
            }
        } else {
            this.workflowUtil.setVariables(SetVariablesPayload.of((String)procInstId, variables));
        }
        AdmFeeApplyPayload payload0 = new AdmFeeApplyPayload();
        payload0.setId(entityDo.getId());
        payload0.setProcInstId(procInstId);
        payload0.setApprStatus(apprStatus);
        payload0.setApplyStatus(applyStatus);
        this.transactionUtilService.executeWithRunnable(() -> this.admFeeApplyDAO.updateByKeyDynamic(payload0));
        return AdmFeeApplyConvert.INSTANCE.toVo(save);
    }

    HashMap<String, Object> getVariables(AdmFeeApplyPayload payload) {
        HashMap<String, Object> batchMap = new HashMap<String, Object>();
        PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(payload.getApplyResId());
        batchMap.put("Activity_1lrfsda", Lists.newArrayList((Object[])new Long[]{userDefaultOrg.getParentId()}));
        PrdOrgOrganizationVO org = this.cacheUtil.getOrg(payload.getExpenseBuId());
        batchMap.put("Activity_0ia1fug", Lists.newArrayList((Object[])new Long[]{org.getManageId()}));
        PrdOrgOrganizationRefVO organizationRefVO = this.cacheUtil.getBULevel1ByOrgId(org.getId());
        if (organizationRefVO == null) {
            throw TwException.error("", "\u8d39\u7528\u627f\u62c5\u4e8b\u4e1a\u90e8\u8d1f\u8d23\u4eba\u4e3a\u7a7a\uff01");
        }
        batchMap.put("Activity_1ij2306", Lists.newArrayList((Object[])new Long[]{organizationRefVO.getManageId()}));
        batchMap.put("Activity_0vg7sa8", this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ALL_PIC.getCode()));
        return batchMap;
    }

    AdmFeeApplyVO checkData(AdmFeeApplyPayload payload) {
        if (!StringUtils.hasText((String)payload.getReasonType())) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (payload.getReasonId() == null) {
            throw TwException.error("", "\u5f52\u5c5e\u4e8b\u7531\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!StringUtils.hasText((String)payload.getReasonName())) {
            throw TwException.error("", "\u5f52\u5c5e\u4e8b\u7531\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) && payload.getExpenseBuId() == null) {
            throw TwException.error("", "\u8d39\u7528\u627f\u62c5bu\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getApplyResId() == null) {
            throw TwException.error("", "\u7533\u8bf7\u4eba\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(payload.getApplyResId());
        payload.setApplyBuId(userDefaultOrg.getOrgId());
        AdmFeeApplyVO admFeeApplyVO = null;
        if (payload.getId() != null) {
            admFeeApplyVO = this.admFeeApplyDAO.queryByKey(payload.getId());
            if (admFeeApplyVO == null) {
                throw TwException.error("", "\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
            }
            if (!admFeeApplyVO.getApplyStatus().equals(FeeApplyStatusEnum.CREATE.getCode()) && !admFeeApplyVO.getApplyStatus().equals(FeeApplyStatusEnum.REJECTED.getCode())) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u6216\u5df2\u62d2\u7edd\u72b6\u6001\u4fee\u6539");
            }
        }
        return admFeeApplyVO;
    }

    public PagingVO<AdmFeeApplyVO> queryPaging(AdmFeeApplyQuery query) {
        return this.admFeeApplyDAO.queryPaging(query);
    }

    public List<AdmFeeApplyVO> queryListDynamic(AdmFeeApplyQuery query) {
        List<AdmFeeApplyVO> admFeeApplyVOS = this.admFeeApplyDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(admFeeApplyVOS)) {
            admFeeApplyVOS.forEach(vo -> vo.setOuName(this.cacheUtil.getCompanyNameByBookId(vo.getOuId())));
        }
        return admFeeApplyVOS;
    }

    public AdmFeeApplyVO queryByKey(Long key) {
        AdmFeeApplyVO admFeeApplyVO = this.admFeeApplyDAO.queryByKey(key);
        AdmFeeApplyDetailQuery queryDetail = new AdmFeeApplyDetailQuery();
        queryDetail.setApplyId(key);
        List admFeeApplyDetailVOS = this.admFeeApplyDetailService.queryListDynamic(queryDetail);
        String companyName = this.cacheUtil.getCompanyNameByBookId(admFeeApplyVO.getOuId());
        admFeeApplyVO.setOuName(companyName);
        admFeeApplyVO.setCustName(this.cacheUtil.getCompanyNameByBookId(admFeeApplyVO.getCustId()));
        admFeeApplyVO.setDetailVOs(admFeeApplyDetailVOS);
        PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee(admFeeApplyVO.getApplyResId());
        String applyResLevel = "";
        if (employee != null) {
            applyResLevel = employee.getExtString1();
        }
        admFeeApplyVO.setApplyResLevel(applyResLevel);
        return admFeeApplyVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AdmFeeApplyPayload payload) {
        return this.admFeeApplyDAO.updateByKeyDynamic(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        List<AdmFeeApplyVO> admFeeApplyVOS;
        if (!keys.isEmpty() && !ObjectUtils.isEmpty(admFeeApplyVOS = this.admFeeApplyDAO.queryByKeys(keys))) {
            admFeeApplyVOS.forEach(vo -> {
                if (!vo.getApplyStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u7684\u5220\u9664");
                }
                try {
                    if (StringUtils.hasText((String)vo.getProcInstId())) {
                        this.workflowUtil.deleteProcess(DeleteProcessPayload.of((String)vo.getProcInstId(), (String)""));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            this.admFeeApplyDAO.deleteSoft(keys);
            this.admFeeApplyDetailService.deleteSoftByApplyId(keys);
        }
    }

    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        AdmFeeApplyVO admFeeApplyVO = this.admFeeApplyDAO.queryByKey(Long.valueOf(businessKey));
        if (admFeeApplyVO != null) {
            AdmFeeApplyPayload busitripApplyPayload = new AdmFeeApplyPayload();
            busitripApplyPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
            busitripApplyPayload.setApprStatus(procInstStatus.name());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.CREATE.getCode());
                    break;
                }
                case INTERRUPT: {
                    busitripApplyPayload.setProcInstId(null);
                    busitripApplyPayload.setNullFields(List.of("procInstId"));
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.CREATE.getCode());
                    break;
                }
                case INVALID: {
                    busitripApplyPayload.setDeleteFlag(Integer.valueOf(1));
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.CREATE.getCode());
                    break;
                }
                case REJECTED: {
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.CREATE.getCode());
                    break;
                }
                case APPROVED: {
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.APPROVED.getCode());
                    String content = "\u7279\u6b8a\u8d39\u7528\u7533\u8bf7\u540d\u79f0\u4e3a[" + admFeeApplyVO.getApplyName() + "] \u7684\u6d41\u7a0b\u5df2\u5b8c\u6210\u5ba1\u6279\uff0c\u8bf7\u77e5\u6089";
                    String title = "\u7279\u6b8a\u8d39\u7528\u7533\u8bf7\u7ed3\u679c\u63d0\u9192";
                    this.sendMessage(Long.valueOf(businessKey), title, content);
                    break;
                }
                case APPROVING: {
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.APPLYING.getCode());
                }
            }
            this.admFeeApplyDAO.updateByKeyDynamic(busitripApplyPayload);
        }
    }

    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(Integer.valueOf(2));
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.systemMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(Integer.valueOf(0));
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(Integer.valueOf(3));
        ado.setMessageContent(content);
        ArrayList list = new ArrayList();
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.OPERATION_PRESIDENT.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode()));
        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            this.messageConfigService.insert(ado);
        }
    }

    public AdmFeeApplyVO queryOneByKey(Long key) {
        return this.admFeeApplyDAO.queryByKey(key);
    }

    public void unbindReim(Long reimId) {
        this.admFeeApplyDAO.unbindReim(reimId);
    }

    public AdmFeeApplyServiceImpl(AdmFeeApplyRepo admFeeApplyRepo, AdmFeeApplyDAO admFeeApplyDAO, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, CacheUtil cacheUtil, PmsProjectService pmsProjectService, AdmFeeApplyDetailService admFeeApplyDetailService, PrdMessageConfigService messageConfigService, PrdSystemRoleService roleService) {
        this.admFeeApplyRepo = admFeeApplyRepo;
        this.admFeeApplyDAO = admFeeApplyDAO;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.cacheUtil = cacheUtil;
        this.pmsProjectService = pmsProjectService;
        this.admFeeApplyDetailService = admFeeApplyDetailService;
        this.messageConfigService = messageConfigService;
        this.roleService = roleService;
    }
}

