/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.copartner.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigPayload;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigUserPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigDetailQuery;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigQuery;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigUserQuery;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigDetailService;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigService;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigUserService;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigUserVO;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.copartner.convert.PerformanceReadmeConfigConvert;
import com.elitesland.tw.tw5.server.prd.copartner.convert.PerformanceReadmeConfigUserConvert;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeConfigDAO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeConfigDO;
import com.elitesland.tw.tw5.server.prd.copartner.repo.PerformanceReadmeConfigRepo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PerformanceReadmeConfigServiceImpl
extends BaseServiceImpl
implements PerformanceReadmeConfigService {
    private static final Logger log = LoggerFactory.getLogger(PerformanceReadmeConfigServiceImpl.class);
    private final PerformanceReadmeConfigRepo performanceReadmeConfigRepo;
    private final PerformanceReadmeConfigDAO performanceReadmeConfigDAO;
    private final PerformanceReadmeConfigDetailService performanceReadmeConfigDetailService;
    private final PerformanceReadmeConfigUserService performanceReadmeConfigUserService;

    public PagingVO<PerformanceReadmeConfigVO> queryPaging(PerformanceReadmeConfigQuery query) {
        return this.performanceReadmeConfigDAO.queryPaging(query);
    }

    public List<PerformanceReadmeConfigVO> queryListDynamic(PerformanceReadmeConfigQuery query) {
        return this.performanceReadmeConfigDAO.queryListDynamic(query);
    }

    public PerformanceReadmeConfigVO queryByKey(Long key) {
        PerformanceReadmeConfigVO performanceReadmeConfigVO = this.performanceReadmeConfigDAO.queryByKey(key);
        PerformanceReadmeConfigDetailQuery queryDetail = new PerformanceReadmeConfigDetailQuery();
        queryDetail.setConfigId(key);
        List performanceReadmeConfigDetailVOS = this.performanceReadmeConfigDetailService.queryListDynamic(queryDetail);
        PerformanceReadmeConfigUserQuery queryUser = new PerformanceReadmeConfigUserQuery();
        queryUser.setConfigId(key);
        List performanceReadmeConfigUserVOS = this.performanceReadmeConfigUserService.queryListDynamic(queryUser);
        performanceReadmeConfigVO.setPerformanceReadmeConfigDetailVOs(performanceReadmeConfigDetailVOS);
        performanceReadmeConfigVO.setPerformanceReadmeConfigUserVO(performanceReadmeConfigUserVOS);
        return performanceReadmeConfigVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public PerformanceReadmeConfigVO insertOrUpdate(PerformanceReadmeConfigPayload payload) {
        if (payload.getId() != null) {
            PerformanceReadmeConfigVO vo = this.performanceReadmeConfigDAO.queryByKey(payload.getId());
            if (vo != null && !"0".equals(vo.getConfigStatus())) {
                throw TwException.error("", "\u8be5\u72b6\u6001\u4e0d\u53ef\u7f16\u8f91");
            }
            this.performanceReadmeConfigDetailService.deleteSoftByConfigId(payload.getId());
            this.performanceReadmeConfigUserService.deleteSoftByConfigId(payload.getId());
        }
        payload.setConfigStatus("0");
        PerformanceReadmeConfigDO entityDo = PerformanceReadmeConfigConvert.INSTANCE.toDo(payload);
        PerformanceReadmeConfigDO save = (PerformanceReadmeConfigDO)this.performanceReadmeConfigRepo.save(entityDo);
        payload.getPerformanceReadmeConfigDetailPayloads().forEach(detail -> detail.setConfigId(save.getId()));
        payload.getPerformanceReadmeConfigUserPayloads().forEach(user -> user.setConfigId(save.getId()));
        this.performanceReadmeConfigDetailService.batchInsert(payload.getPerformanceReadmeConfigDetailPayloads());
        this.performanceReadmeConfigUserService.batchInsert(payload.getPerformanceReadmeConfigUserPayloads());
        return PerformanceReadmeConfigConvert.INSTANCE.toVo((PerformanceReadmeConfigDO)this.performanceReadmeConfigRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PerformanceReadmeConfigVO update(PerformanceReadmeConfigPayload payload) {
        PerformanceReadmeConfigDO entity = this.performanceReadmeConfigRepo.findById(payload.getId()).orElseGet(PerformanceReadmeConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PerformanceReadmeConfigDO entityDo = PerformanceReadmeConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PerformanceReadmeConfigConvert.INSTANCE.toVo((PerformanceReadmeConfigDO)this.performanceReadmeConfigRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PerformanceReadmeConfigPayload payload) {
        long result = this.performanceReadmeConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PerformanceReadmeConfigVO> performanceReadmeConfigVOS = this.performanceReadmeConfigDAO.queryByKeys(keys);
            long count = performanceReadmeConfigVOS.stream().filter(vo -> StringUtils.hasText((String)vo.getConfigStatus()) && !"0".equals(vo.getConfigStatus())).count();
            if (count > 0L) {
                throw TwException.error("", "\u8be5\u72b6\u6001\u4e0d\u652f\u6301\u5220\u9664\u64cd\u4f5c");
            }
            this.performanceReadmeConfigDAO.deleteSoft(keys);
        }
    }

    public void startAssessment(Long key) {
        PerformanceReadmeConfigVO vo = this.performanceReadmeConfigDAO.queryByKey(key);
        if (vo == null || !"0".equals(vo.getConfigStatus())) {
            throw TwException.error("", "\u4e0d\u53ef\u518d\u6b21\u53d1\u8d77");
        }
        PerformanceReadmeConfigUserQuery query = new PerformanceReadmeConfigUserQuery();
        query.setConfigId(key);
        List performanceReadmeConfigUserVOS = this.performanceReadmeConfigUserService.queryListDynamic(query);
        if (ObjectUtils.isEmpty((Object)performanceReadmeConfigUserVOS)) {
            throw TwException.error("", "\u8003\u6838\u8303\u56f4\u672a\u914d\u7f6e");
        }
        PerformanceReadmeConfigPayload payload = new PerformanceReadmeConfigPayload();
        payload.setId(key);
        payload.setConfigStatus("1");
        payload.setApplyUserId(GlobalUtil.getLoginUserId());
        payload.setApplyTime(LocalDateTime.now());
        this.performanceReadmeConfigDAO.updateByKeyDynamic(payload);
        performanceReadmeConfigUserVOS.forEach(userVO -> {
            PerformanceReadmeConfigUserPayload userPayload = PerformanceReadmeConfigUserConvert.INSTANCE.toPayload((PerformanceReadmeConfigUserVO)userVO);
            userPayload.setConfigName(vo.getConfigName());
            userPayload.setInitFlag(Boolean.valueOf(false));
            this.performanceReadmeConfigUserService.procInstUpdate(userPayload);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PerformanceReadmeConfigUserVO configUserVO = this.performanceReadmeConfigUserService.querySimpleByKey(Long.valueOf(Long.parseLong(businessKey)));
        if (configUserVO != null) {
            PerformanceReadmeConfigUserPayload configUserPayload = new PerformanceReadmeConfigUserPayload();
            configUserPayload.setId(configUserVO.getId());
            configUserPayload.setProcInstStatus(procInstStatus.name());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    configUserPayload.setApplyStatus(Integer.valueOf(0));
                    break;
                }
                case INTERRUPT: {
                    configUserPayload.setApplyStatus(Integer.valueOf(1));
                    break;
                }
                case INVALID: {
                    configUserPayload.setApplyStatus(Integer.valueOf(1));
                    break;
                }
                case REJECTED: {
                    configUserPayload.setApplyStatus(Integer.valueOf(0));
                    break;
                }
                case APPROVED: {
                    configUserPayload.setApplyStatus(Integer.valueOf(1));
                    break;
                }
                case APPROVING: {
                    configUserPayload.setApplyStatus(Integer.valueOf(0));
                }
            }
            this.performanceReadmeConfigUserService.updateByKeyDynamic(configUserPayload);
            if (configUserPayload.getApplyStatus() != null && configUserPayload.getApplyStatus() == 1) {
                PerformanceReadmeConfigUserQuery query = new PerformanceReadmeConfigUserQuery();
                query.setConfigId(configUserVO.getConfigId());
                List configUserVOS = this.performanceReadmeConfigUserService.queryListDynamic(query);
                List collect = configUserVOS.stream().filter(vo -> (vo.getApplyStatus() == null || vo.getApplyStatus() == 0) && vo.getId().longValue() != configUserVO.getId().longValue()).collect(Collectors.toList());
                if (ObjectUtils.isEmpty(collect)) {
                    PerformanceReadmeConfigPayload configPayload = new PerformanceReadmeConfigPayload();
                    configPayload.setId(configUserVO.getConfigId());
                    configPayload.setConfigStatus("2");
                    configPayload.setFinishTime(LocalDateTime.now());
                    long l = this.performanceReadmeConfigDAO.updateByKeyDynamic(configPayload);
                }
            }
        }
    }

    public PerformanceReadmeConfigServiceImpl(PerformanceReadmeConfigRepo performanceReadmeConfigRepo, PerformanceReadmeConfigDAO performanceReadmeConfigDAO, PerformanceReadmeConfigDetailService performanceReadmeConfigDetailService, PerformanceReadmeConfigUserService performanceReadmeConfigUserService) {
        this.performanceReadmeConfigRepo = performanceReadmeConfigRepo;
        this.performanceReadmeConfigDAO = performanceReadmeConfigDAO;
        this.performanceReadmeConfigDetailService = performanceReadmeConfigDetailService;
        this.performanceReadmeConfigUserService = performanceReadmeConfigUserService;
    }
}

