/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOffshoreService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u8fd1\u6d77\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/crm"})
public class CrmOffshoreController {
    private static final Logger log = LoggerFactory.getLogger(CrmOffshoreController.class);
    private final CrmOffshoreService service;
    private final CrmLeadsService leadsService;

    @ApiOperation(value="\u65b0\u589e\u548c\u4fee\u6539")
    @PostMapping(value={"/offshore/saveOne"})
    public TwOutputUtil insert(@RequestBody CrmOffshorePayload payload) {
        CrmOffshoreVO vo = this.service.saveOne(payload);
        return TwOutputUtil.ok(vo);
    }

    @PostMapping(value={"/offshore/dynamicUpdate"})
    public TwOutputUtil dynamicUpdate(@RequestBody CrmOffshorePayload payload) {
        this.service.dynamicUpdate(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/offshore/list"})
    public TwOutputUtil queryList(CrmOffshoreQuery query) {
        List list = this.service.queryList(query);
        return TwOutputUtil.ok(list);
    }

    @GetMapping(value={"/offshore/paging"})
    public TwOutputUtil paging(CrmOffshoreQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    @ApiOperation(value="\u8be6\u60c5\u67e5\u8be2")
    @GetMapping(value={"/offshore/detail/{id}"})
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        CrmOffshoreVO vo = this.service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/offshore/delete"})
    public TwOutputUtil delete(@RequestParam Long offshoreId, @RequestParam Long newOffshoreId) {
        this.leadsService.deleteOffshoreSoft(offshoreId, newOffshoreId);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @PostMapping(value={"/offshore/batchExport"})
    public void batchExport(HttpServletResponse response, CrmOffshoreQuery query) {
        this.service.downloadOffshores(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/offshore/batchImport"}, consumes={"multipart/form-data"})
    @Transactional
    public TwOutputUtil batchImport(MultipartFile file) {
        this.service.importOffshores(file);
        return TwOutputUtil.ok();
    }

    public CrmOffshoreController(CrmOffshoreService service, CrmLeadsService leadsService) {
        this.service = service;
        this.leadsService = leadsService;
    }
}

