/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationEmployeesPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationEnterpriseInfoPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationExcel;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationPartnersPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationSitesPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeoplePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationBusinessQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCommonService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationChanceService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationEmployeesService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationEnterpriseInfoService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationPartnersService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationSitesService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailMemberService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempDetailService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerDataVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationSimpleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanTempVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.partner.business.service.CrmBusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAddressService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelEntityDataListener;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.BusinessFollowServiceImpl;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.constant.CustomerOperationNoticeEnum;
import com.elitesland.tw.tw5.server.prd.crm.constant.CustomerOperationTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.constant.SystemBasicStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerOperationConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbBasicInfoDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbContactInfoDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbEntBriefDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbGetEmployeeDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbGetWebSiteDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbPartnersDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbRootDTO;
import com.elitesland.tw.tw5.server.prd.qixin.service.QiXinService;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CrmCustomerOperationServiceImpl
extends BaseServiceImpl
implements CrmCustomerOperationService {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerOperationServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final CrmCustomerOperationRepo repo;
    private final CrmCustomerOperationDAO dao;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final BookAddressService bookAddressService;
    private final CrmOperationPlanTempDetailService crmOperationPlanTempDetailService;
    private final CrmOperationPlanTempService crmOperationPlanTempService;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final CrmOperationPlanDetailMemberService crmOperationPlanDetailMemberService;
    private final UdcUtil udcUtil;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final CrmCustomerOperationEnterpriseInfoService enterpriseInfoService;
    private final CrmCustomerOperationSitesService sitesService;
    private final CrmCustomerOperationPartnersService partnersService;
    private final CrmCustomerOperationEmployeesService employeesService;
    private final CrmPeopleService peopleService;
    private final BusinessFollowServiceImpl globalUtilService;
    private final CrmCustomerOperationChanceService operationChanceService;
    private final QiXinService qiXinService;
    private final SaleConContractDAO saleConContractDAO;
    private final PrdMessageConfigService messageConfigService;
    private final BusinessPartnerService businessPartnerService;
    private final CrmCommonService crmCommonService;
    private final String SPECIAL_CUST_GRADE = "99";
    private final String CUST_OPER_NO = "CUST_OPER_NO";
    @Value(value="${tw5.sys_default.dimensionId}")
    private Long default_dimension_id;
    private static final Map<String, String> qxbTypeNewMap = new HashMap<String, String>(){
        {
            this.put("01", "\u5927\u9646\u4f01\u4e1a");
            this.put("02", "\u793e\u4f1a\u7ec4\u7ec7");
            this.put("03", "\u673a\u5173\u53ca\u4e8b\u4e1a\u5355\u4f4d");
            this.put("04", "\u6e2f\u6fb3\u53f0\u53ca\u56fd\u5916\u4f01\u4e1a");
            this.put("05", "\u5f8b\u6240\u53ca\u5176\u4ed6\u7ec4\u7ec7\u673a\u6784");
        }
    };

    @Transactional(rollbackFor={Exception.class})
    public CrmCustomerOperationVO insert(CrmCustomerOperationPayload payload, boolean flag) {
        this.check(payload, flag);
        String code = this.generateSeqNum("CUST_OPER_NO", new String[0]);
        payload.setCustNo(code);
        CrmCustomerOperationDO entityDo = CrmCustomerOperationConvert.INSTANCE.toDo(payload);
        entityDo.setCustOperStatus(SystemBasicStatusEnum.ACTIVE.getCode());
        this.repo.save((Object)entityDo);
        this.initOperationPlan(entityDo);
        Long operId = entityDo.getId();
        this.saveQxbInfo(payload, operId);
        String fieldsCreateLog = this.changeFieldLogUtil.getFieldsCreateLog(entityDo);
        this.logService.saveNewLog(operId, PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), fieldsCreateLog);
        CrmCustomerOperationVO crmCustomerOperationVO = CrmCustomerOperationConvert.INSTANCE.toVo(entityDo);
        this.noticeOperManagers(crmCustomerOperationVO, CustomerOperationNoticeEnum.ADD.getCode());
        return crmCustomerOperationVO;
    }

    private void saveQxbInfo(CrmCustomerOperationPayload payload, Long operId) {
        this.saveEnterpriseInfo(payload, operId);
        this.saveSites(payload, operId);
        this.savePartners(payload, operId);
        this.saveEmployees(payload, operId);
        this.syncToPeople(payload, operId);
    }

    public List<CrmCustomerOperationVO> queryListCommon(CrmCustomerOperationQuery query) {
        String idListStr = query.getIdListStr();
        if (org.springframework.util.StringUtils.hasText((String)idListStr)) {
            String[] split = idListStr.split(",");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (String s : split) {
                idList.add(Long.valueOf(s));
            }
            query.setIdList(idList);
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setUserId(loginUserId);
        Boolean permission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.SALE_ADMIN.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        List<Object> vos = permission != false ? this.queryList(query) : this.queryListDataFilter(query);
        if (null != query.getTreeSearch() && query.getTreeSearch().booleanValue() && !CollectionUtils.isEmpty(vos)) {
            List<CrmCustomerOperationVO> collection = this.treeDataSearch(vos);
            if (!CollectionUtils.isEmpty(collection)) {
                vos.addAll(collection);
            }
            vos = vos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CrmCustomerOperationVO>(Comparator.comparing(BaseViewModel::getId))), ArrayList::new));
        }
        return vos;
    }

    private List<CrmCustomerOperationVO> treeDataSearch(List<CrmCustomerOperationVO> vos) {
        ArrayList<CrmCustomerOperationVO> result = new ArrayList<CrmCustomerOperationVO>();
        if (!CollectionUtils.isEmpty(vos)) {
            vos.forEach(crmCustomerOperationVO -> {
                Long parentId = crmCustomerOperationVO.getParentId();
                if (parentId != null) {
                    CrmCustomerOperationVO operationVO = this.queryByKey(parentId);
                    result.add(operationVO);
                }
            });
            if (!CollectionUtils.isEmpty(this.treeDataSearch(result))) {
                result.addAll(this.treeDataSearch(result));
            }
        }
        return result;
    }

    private void syncToPeople(CrmCustomerOperationPayload payload, Long operId) {
        List employeesList = payload.getEmployeesList();
        if (!CollectionUtils.isEmpty((Collection)employeesList)) {
            employeesList.forEach(employeesPayload -> {
                CrmPeoplePayload peoplePayload = new CrmPeoplePayload();
                peoplePayload.setOperId(operId);
                peoplePayload.setCustomerId(payload.getCustomerId());
                peoplePayload.setPeopleName(employeesPayload.getName());
                peoplePayload.setJobs(employeesPayload.getTitle());
                this.peopleService.insertOrUpdate(peoplePayload);
            });
        }
    }

    private void saveEmployees(CrmCustomerOperationPayload payload, Long operId) {
        List employeesList = payload.getEmployeesList();
        if (!CollectionUtils.isEmpty((Collection)employeesList)) {
            employeesList.forEach(employeesPayload -> {
                employeesPayload.setOperId(operId);
                this.employeesService.insert(employeesPayload);
            });
        }
    }

    private void savePartners(CrmCustomerOperationPayload payload, Long operId) {
        List partnersList = payload.getPartnersList();
        if (!CollectionUtils.isEmpty((Collection)partnersList)) {
            partnersList.forEach(partnersPayload -> {
                partnersPayload.setOperId(operId);
                this.partnersService.insert(partnersPayload);
            });
        }
    }

    private void saveSites(CrmCustomerOperationPayload payload, Long operId) {
        List sitesList = payload.getSitesList();
        if (!CollectionUtils.isEmpty((Collection)sitesList)) {
            sitesList.forEach(site -> {
                site.setOperId(operId);
                this.sitesService.insert(site);
            });
        }
    }

    private void saveEnterpriseInfo(CrmCustomerOperationPayload payload, Long operId) {
        CrmCustomerOperationEnterpriseInfoPayload enterpriseInfo = payload.getEnterpriseInfo();
        if (null != enterpriseInfo) {
            enterpriseInfo.setOperId(operId);
            this.enterpriseInfoService.insert(enterpriseInfo);
        }
    }

    private void check(CrmCustomerOperationPayload payload, boolean flag) {
        if (org.springframework.util.StringUtils.hasText((String)payload.getCustName())) {
            int count = this.repo.countByCustName(payload.getCustName());
            if (count > 0) {
                throw TwException.error("", "\u8bf7\u52ff\u91cd\u590d\u521b\u5efa\u5ba2\u6237\u7ecf\u8425\uff01");
            }
        } else {
            throw TwException.error("", "\u5ba2\u6237\u7ecf\u8425\u540d\u79f0\u5fc5\u586b\uff01");
        }
        String custType = payload.getCustType();
        if (!org.springframework.util.StringUtils.hasText((String)custType)) {
            throw TwException.error("", "\u8bf7\u9009\u62e9\u7c7b\u578b");
        }
        if ((custType.equals(CustomerOperationTypeEnum.ENTERPRISE.getCode()) || custType.equals(CustomerOperationTypeEnum.ENTERPRISE_ECO_PARTNER.getCode())) && flag && !org.springframework.util.StringUtils.hasText((String)payload.getCustGrade())) {
            throw TwException.error("", "\u5ba2\u6237\u7ea7\u522b\u5fc5\u586b\uff01");
        }
    }

    public int checkCustNameUnique(String custName) {
        return this.repo.countByCustName(custName);
    }

    private void initOperationPlan(CrmCustomerOperationDO entity) {
        CrmOperationPlanTempQuery planTempQuery;
        List planTempVOList;
        boolean isEnterprise;
        String custType = entity.getCustType();
        String custGrade = entity.getCustGrade();
        boolean bl = isEnterprise = custType.equals(CustomerOperationTypeEnum.ENTERPRISE.getCode()) || custType.equals(CustomerOperationTypeEnum.ENTERPRISE_ECO_PARTNER.getCode());
        if (!isEnterprise) {
            custGrade = "99";
        }
        if (!CollectionUtils.isEmpty((Collection)(planTempVOList = this.crmOperationPlanTempService.queryList(planTempQuery = new CrmOperationPlanTempQuery(custType, custGrade))))) {
            if (planTempVOList.size() > 1) {
                log.error("\u5ba2\u6237\u7ecf\u8425-\u7ecf\u8425\u8ba1\u5212\u6a21\u677f\u6709\u91cd\u590d\u6570\u636e\uff0c\u7c7b\u578b\uff1a{},\u7ea7\u522b\uff1a{}", (Object)custType, (Object)custGrade);
            }
            CrmOperationPlanTempVO planTempVO = (CrmOperationPlanTempVO)planTempVOList.get(0);
            CrmOperationPlanTempDetailQuery planTempDetailQuery = new CrmOperationPlanTempDetailQuery(planTempVO.getId());
            List planTempDetailVOList = this.crmOperationPlanTempDetailService.queryList(planTempDetailQuery);
            ArrayList planDetailDOS = new ArrayList();
            planTempDetailVOList.forEach(crmOperationPlanTempDetailVO -> {
                CrmOperationPlanDetailPayload planDetailDO = new CrmOperationPlanDetailPayload();
                BeanUtils.copyProperties((Object)crmOperationPlanTempDetailVO, (Object)planDetailDO);
                planDetailDO.setOperId(entity.getId());
                planDetailDO.setReadFlag(Integer.valueOf(0));
                planDetailDOS.add(planDetailDO);
            });
            this.crmOperationPlanDetailService.saveAll(planDetailDOS);
        } else {
            log.warn("\u5ba2\u6237\u7ecf\u8425-\u7ecf\u8425\u8ba1\u5212\u6a21\u677f\u672a\u914d\u7f6e\uff0c\u7c7b\u578b\uff1a{},\u7ea7\u522b\uff1a{}", (Object)custType, (Object)custGrade);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmCustomerOperationVO update(CrmCustomerOperationPayload payload) {
        CrmCustomerOperationDO entity = this.repo.findById(payload.getId()).orElseGet(CrmCustomerOperationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmCustomerOperationDO entityLog = new CrmCustomerOperationDO();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)entityLog));
        CrmCustomerOperationDO entityDo = CrmCustomerOperationConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
        CrmCustomerOperationDO save = (CrmCustomerOperationDO)((Object)this.repo.save((Object)entity));
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (org.springframework.util.StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), fieldsUpdateLog.toString());
        }
        return CrmCustomerOperationConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateCustOperStatus(Long key, String custOperStatus) {
        this.dao.updateCustOperStatus(key, custOperStatus);
        this.logService.saveNewLog(key, PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), custOperStatus) + PrdSystemObjectEnum.CUSTOMER_OPERATION.getDesc());
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public void relationCustomer(CrmCustomerOperationPayload payload) {
        CrmCustomerOperationDO entity = this.repo.findById(payload.getId()).orElseGet(CrmCustomerOperationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (entity.getCustomerId() != null) {
            throw TwException.error("", "\u5df2\u5173\u8054\u5ba2\u6237\u4e0d\u53ef\u91cd\u590d\u64cd\u4f5c\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        CrmCustomerOperationVO crmCustomerOperationVO = this.dao.queryCrmCustomerOperationVOByCustomerId(payload.getCustomerId());
        if (crmCustomerOperationVO != null) {
            throw TwException.error("", "\u8be5\u5ba2\u6237\u5df2\u88ab\u3010" + crmCustomerOperationVO.getCustName() + "\u3011\u5173\u8054\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.dao.relationCustomer(payload.getId(), payload.getCustomerId());
        this.peopleService.relationCustomer(payload.getId(), payload.getCustomerId());
    }

    public CrmCustomerOperationVO queryByKey(Long key) {
        CrmCustomerOperationDO entity = this.repo.findById(key).orElseGet(CrmCustomerOperationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmCustomerOperationVO crmCustomerOperationVO = CrmCustomerOperationConvert.INSTANCE.toVo(entity);
        return crmCustomerOperationVO;
    }

    public List<PrdSystemLogVO> queryLogList(Long id) {
        return this.logService.queryLogList(id, PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode());
    }

    public List<CrmCustomerOperationVO> queryList(CrmCustomerOperationQuery query) {
        List list = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
        return CrmCustomerOperationConvert.INSTANCE.toVoList(list);
    }

    public List<CrmCustomerOperationVO> queryListDataFilter(CrmCustomerOperationQuery query) {
        OrderItem orderItem = OrderItem.desc((String)"createTime");
        query.defaultOrder(orderItem);
        Specification<CrmCustomerOperationDO> specification = this.where(query);
        return CrmCustomerOperationConvert.INSTANCE.toVoList(this.repo.findAll(specification));
    }

    public PagingVO<CrmCustomerOperationVO> pagingDataFilter(CrmCustomerOperationQuery query) {
        Specification<CrmCustomerOperationDO> specification = this.where(query);
        Page page = this.repo.findAll(specification, (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmCustomerOperationConvert.INSTANCE::toVo));
    }

    public PagingVO<CrmCustomerOperationVO> paging(CrmCustomerOperationQuery query) {
        List custOperOrgIdList;
        List prdOrgOrganizationRefVOS1;
        List saleOperOrgIdList;
        if (query.getSubSaleOperBuFlag() != null && query.getSubSaleOperBuFlag().booleanValue() && query.getSaleOperBu() != null && !CollectionUtils.isEmpty(saleOperOrgIdList = (prdOrgOrganizationRefVOS1 = this.prdOrgOrganizationService.queryAllChildOrgByOrgId(query.getSaleOperBu())).stream().map(p -> p.getOrgId()).collect(Collectors.toList()))) {
            query.setSaleOperBu(null);
            query.setSaleOperBuList(saleOperOrgIdList);
        }
        if (query.getSubCustOperBuFlag() != null && query.getSubCustOperBuFlag().booleanValue() && query.getCustOperBu() != null && !CollectionUtils.isEmpty(custOperOrgIdList = (prdOrgOrganizationRefVOS1 = this.prdOrgOrganizationService.queryAllChildOrgByOrgId(query.getCustOperBu())).stream().map(p -> p.getOrgId()).collect(Collectors.toList()))) {
            query.setCustOperBu(null);
            query.setCustOperBuList(custOperOrgIdList);
        }
        Page page = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmCustomerOperationConvert.INSTANCE::toVo));
    }

    private Specification<CrmCustomerOperationDO> where(CrmCustomerOperationQuery query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            List custOperOrgIdList;
            List prdOrgOrganizationRefVOS1;
            List saleOperOrgIdList;
            Long userId = GlobalUtil.getLoginUserId();
            List prdOrgOrganizationRefVOS = this.prdOrgOrganizationService.queryAllChildOrgByUserId(userId);
            List orgIdList = prdOrgOrganizationRefVOS.stream().map(s -> s.getOrgId()).collect(Collectors.toList());
            Join memberJoin = root.join("memberList", JoinType.LEFT);
            Join planDetailJoin = root.join("planDetailList", JoinType.LEFT);
            if (query.getSubSaleOperBuFlag() != null && query.getSubSaleOperBuFlag().booleanValue() && query.getSaleOperBu() != null && !CollectionUtils.isEmpty(saleOperOrgIdList = (prdOrgOrganizationRefVOS1 = this.prdOrgOrganizationService.queryAllChildOrgByOrgId(query.getSaleOperBu())).stream().map(p -> p.getOrgId()).collect(Collectors.toList()))) {
                query.setSaleOperBu(null);
                query.setSaleOperBuList(saleOperOrgIdList);
            }
            if (query.getSubCustOperBuFlag() != null && query.getSubCustOperBuFlag().booleanValue() && query.getCustOperBu() != null && !CollectionUtils.isEmpty(custOperOrgIdList = (prdOrgOrganizationRefVOS1 = this.prdOrgOrganizationService.queryAllChildOrgByOrgId(query.getCustOperBu())).stream().map(p -> p.getOrgId()).collect(Collectors.toList()))) {
                query.setCustOperBu(null);
                query.setCustOperBuList(custOperOrgIdList);
            }
            Predicate predicate = QueryHelp.getPredicate(root, query, criteriaBuilder);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(predicate);
            if (!ObjectUtils.isEmpty((Object)query.getUserId())) {
                ArrayList<Predicate> dataFilterQuery = new ArrayList<Predicate>();
                if (!CollectionUtils.isEmpty(orgIdList)) {
                    Predicate pred5 = root.get("saleOperBu").in(orgIdList);
                    dataFilterQuery.add(pred5);
                    Predicate pred6 = root.get("custOperBu").in(orgIdList);
                    dataFilterQuery.add(pred6);
                    Predicate pred13 = root.get("channelBu").in(orgIdList);
                    dataFilterQuery.add(pred13);
                }
                Predicate pred2 = criteriaBuilder.equal((Expression)root.get("createUserId"), (Object)userId);
                Predicate pred3 = criteriaBuilder.equal((Expression)root.get("saleOperManagerId"), (Object)userId);
                Predicate pred4 = criteriaBuilder.equal((Expression)root.get("custOperManagerId"), (Object)userId);
                Predicate pred7 = criteriaBuilder.equal((Expression)root.get("channelUserId"), (Object)userId);
                Predicate predMember = criteriaBuilder.equal((Expression)memberJoin.get("userId"), (Object)userId);
                Predicate pred8 = criteriaBuilder.equal((Expression)root.get("productUserId"), (Object)userId);
                Predicate pred9 = criteriaBuilder.equal((Expression)root.get("serviceUserId"), (Object)userId);
                Predicate pred10 = criteriaBuilder.equal((Expression)root.get("businessUserId"), (Object)userId);
                Predicate pred11 = criteriaBuilder.equal((Expression)root.get("careUserId"), (Object)userId);
                Predicate pred12 = criteriaBuilder.equal((Expression)root.get("operationUserId"), (Object)userId);
                Predicate[] predicatesList = new Predicate[]{predMember, pred2, pred3, pred4, pred7, pred8, pred9, pred10, pred11, pred12};
                dataFilterQuery.addAll(Arrays.asList(predicatesList));
                Predicate[] predicatesListResult = dataFilterQuery.toArray(new Predicate[dataFilterQuery.size()]);
                predicates.add(criteriaBuilder.or(predicatesListResult));
            }
            criteriaQuery.distinct(true);
            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        return specification;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> operIdList) {
        if (!operIdList.isEmpty()) {
            this.dao.deleteSoft(operIdList);
            this.crmOperationPlanDetailService.deleteSoftByOperIds(operIdList);
            this.crmOperationPlanDetailMemberService.deleteSoftByOperIds(operIdList);
            this.peopleService.deleteSoftByOperIds(operIdList);
            this.operationChanceService.deleteSoftByOperIds(operIdList);
        }
    }

    public List<CrmCustomerOperationSimpleVO> selectList(CrmCustomerOperationQuery query) {
        return CrmCustomerOperationConvert.INSTANCE.toListVoSimple(this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public List<CrmFollowVO> queryOperateFollowList(Long operId) {
        CrmCustomerOperationVO operationVO = this.dao.queryById(operId);
        this.checkeRelation(operationVO);
        List crmFollowVOS = this.businessPartnerService.queryFollowList(operationVO.getCustomerId(), Boolean.valueOf(true));
        return crmFollowVOS;
    }

    public CrmCustomerDataVO queryCustomerByOperId(Long operId) {
        CrmCustomerOperationVO operationVO = this.dao.queryById(operId);
        this.checkeRelation(operationVO);
        CrmCustomerDataVO customerDataVO = this.dao.queryByCustomerId(operationVO.getCustomerId());
        if (customerDataVO != null) {
            List bookAddressVOS = this.bookAddressService.queryByBookId(customerDataVO.getBookId());
            customerDataVO.setPrdAbAddressVOs(bookAddressVOS);
        }
        return customerDataVO;
    }

    public CrmCustomerOperationVO queryCustomerOperationByCustomerId(Long customerId) {
        return this.dao.queryCrmCustomerOperationVOByCustomerId(customerId);
    }

    public Object queryCustomerView(Long operId) {
        CrmCustomerOperationVO operationVO = this.dao.queryById(operId);
        if (operationVO == null) {
            throw TwException.error("", "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Number contractCount = 0L;
        long projectCount = 0L;
        long opportunityCount = 0L;
        if (operationVO.getCustomerId() != null) {
            contractCount = this.businessPartnerService.queryContractNum(operationVO.getCustomerId());
            BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(operationVO.getCustomerId());
            if (ObjectUtils.isEmpty((Object)businessPartnerVO)) {
                throw TwException.error("", "\u5173\u8054\u5ba2\u6237\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            Long bookId = businessPartnerVO.getBookId();
            projectCount = this.crmCommonService.queryProjectNum(bookId);
            opportunityCount = this.dao.queryOpportunityCount(operationVO.getCustomerId());
        }
        long peopleCount = this.peopleService.queryList(operId).size();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("contractCount", (Long)contractCount);
        map.put("projectCount", projectCount);
        map.put("opportunityCount", opportunityCount);
        map.put("peopleCount", peopleCount);
        return map;
    }

    public Map<String, Object> excelImport(MultipartFile file, Boolean force, HttpServletResponse response) throws IOException {
        if (force == null) {
            force = false;
        }
        ExcelEntityDataListener dataListener = new ExcelEntityDataListener();
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), CrmCustomerOperationExcel.class, dataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(4))).doRead();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165 excel\u7684\u5217\u503c\u662f\u5426\u4e0e\u6a21\u677f\u5bf9\u5e94");
        }
        List excelDataList = dataListener.getDatas();
        if (CollectionUtils.isEmpty(excelDataList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        excelDataList = this.udcUtil.translateListReverse(excelDataList);
        List<CrmCustomerOperationVO> dataDbList = this.queryList(new CrmCustomerOperationQuery());
        List businessPartnerVOS = this.businessPartnerService.queryCustPartnerListSimple();
        List<PrdOrgOrganizationRefVO> organizationRefVOS = this.prdOrgOrganizationDAO.queryOrgList(this.default_dimension_id, SystemDefaultEnum.DefaultOrgStatus.getCode());
        StringBuilder error = new StringBuilder();
        StringBuilder warn = new StringBuilder();
        for (CrmCustomerOperationExcel payload : excelDataList) {
            String historyCooOutputStr;
            String saleScaleStr;
            List managerIdList;
            String excelCommitBuName;
            Optional<Long> first;
            StringBuilder importError = new StringBuilder();
            StringBuilder importWarn = new StringBuilder();
            String custName = payload.getCustName();
            if (StringUtils.isEmpty((CharSequence)custName)) {
                warn.append("\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u6b64\u6570\u636e\uff1b\n");
                continue;
            }
            long count = dataDbList.stream().filter(crmCustomerOperationVO -> crmCustomerOperationVO.getCustName().equals(custName)).count();
            if (count > 0L) {
                importError.append("\u5ba2\u6237\u540d\u79f0\u3010" + custName + "\u3011\u91cd\u590d");
                error.append("\u5ba2\u6237\u540d\u79f0\u3010" + custName + "\u3011\u91cd\u590d;\n");
            }
            if ((first = businessPartnerVOS.stream().filter(businessPartnerVO -> businessPartnerVO.getPartnerName().equals(custName)).map(BaseViewModel::getId).findFirst()).isPresent()) {
                Long customerId = first.get();
                payload.setCustomerId(customerId);
            }
            if (org.springframework.util.StringUtils.hasText((String)(excelCommitBuName = payload.getExcelCommitBuName())) && !CollectionUtils.isEmpty(managerIdList = organizationRefVOS.stream().filter(prdOrgOrganizationRefVO -> prdOrgOrganizationRefVO.getOrgName().equals(excelCommitBuName)).map(PrdOrgOrganizationRefVO::getManageId).collect(Collectors.toList()))) {
                Long managerId = (Long)managerIdList.get(0);
                payload.setCreateUserId(managerId);
            }
            if (org.springframework.util.StringUtils.hasText((String)(saleScaleStr = payload.getSaleScaleStr()))) {
                String trim = saleScaleStr.trim();
                if (NumberUtil.isNumber((CharSequence)trim)) {
                    payload.setSaleScale(new BigDecimal(trim));
                } else {
                    importWarn.append("\"\u5ba2\u6237\u540d\u79f0\u3010\" + custName + \"\u3011:\u9500\u552e\u89c4\u6a21\u3010" + saleScaleStr + "\u3011\u4e0d\u662f\u6570\u5b57\u7c7b\u578b");
                    warn.append("\"\u5ba2\u6237\u540d\u79f0\u3010\" + custName + \"\u3011: \u9500\u552e\u89c4\u6a21\u3010" + saleScaleStr + "\u3011\u4e0d\u662f\u6570\u5b57\u7c7b\u578b;+\n");
                }
            }
            if (org.springframework.util.StringUtils.hasText((String)(historyCooOutputStr = payload.getHistoryCooOutputStr()))) {
                String trim = historyCooOutputStr.trim();
                if (NumberUtil.isNumber((CharSequence)trim)) {
                    payload.setHistoryCooOutput(new BigDecimal(trim));
                } else {
                    importWarn.append("\"\u5ba2\u6237\u540d\u79f0\u3010\" + custName + \"\u3011: \u5386\u53f2\u5408\u4f5c\u4ea7\u51fa\u3010" + saleScaleStr + "\u3011\u4e0d\u662f\u6570\u5b57\u7c7b\u578b");
                    warn.append("\"\u5ba2\u6237\u540d\u79f0\u3010\" + custName + \"\u3011: \u5386\u53f2\u5408\u4f5c\u4ea7\u51fa\u3010" + saleScaleStr + "\u3011\u4e0d\u662f\u6570\u5b57\u7c7b\u578b;\n");
                }
            }
            payload.setImoprtError(importError.toString());
            payload.setImportWarn(importWarn.toString());
        }
        int warnNum = 0;
        int errorNum = 0;
        for (CrmCustomerOperationExcel operationExcel : excelDataList) {
            if (org.springframework.util.StringUtils.hasText((String)operationExcel.getImoprtError()) && !force.booleanValue()) {
                ++errorNum;
            }
            if (!org.springframework.util.StringUtils.hasText((String)operationExcel.getImportWarn()) || force.booleanValue()) continue;
            ++warnNum;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (errorNum > 0) {
            resultMap.put("ok", "error");
            resultMap.put("errorNum", errorNum);
            resultMap.put("error", error);
            resultMap.put("warnNum", warnNum);
            resultMap.put("warn", warn);
        } else {
            for (CrmCustomerOperationExcel payload : excelDataList) {
                payload.setCustType(CustomerOperationTypeEnum.ENTERPRISE.getCode());
                payload.setDeleteFlag(Integer.valueOf(0));
                payload.setRemark("excel\u5bfc\u5165");
                String code = this.generateSeqNum("CUST_OPER_NO", new String[0]);
                payload.setCustNo(code);
                CrmCustomerOperationDO entityDo = CrmCustomerOperationConvert.INSTANCE.excelToDo(payload);
                entityDo.setCustOperStatus(SystemBasicStatusEnum.ACTIVE.getCode());
                this.repo.save((Object)entityDo);
                this.initOperationPlan(entityDo);
                String fieldsCreateLog = this.changeFieldLogUtil.getFieldsCreateLog(entityDo);
                this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), fieldsCreateLog, payload.getCreateUserId());
            }
            resultMap.put("ok", "ok");
        }
        return resultMap;
    }

    private void downloadErrorData(HttpServletResponse response, List<CrmCustomerOperationExcel> excelDataList) throws IOException {
        ArrayList rows = CollUtil.newArrayList(excelDataList);
        ExcelWriter writer = ExcelUtil.getWriter((boolean)true);
        writer.write((Iterable)rows, true);
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=error.xls");
        ServletOutputStream out = response.getOutputStream();
        writer.flush((OutputStream)out, true);
        writer.close();
        IoUtil.close((Closeable)out);
    }

    public Object queryBusinessFollowPaging(CrmCustomerOperationBusinessQuery query) {
        Map<String, Object> resultData = new Map<String, Object>();
        CrmCustomerOperationVO operationVO = this.dao.queryById(query.getOperId());
        this.checkeRelation(operationVO);
        query.setCustomerId(operationVO.getCustomerId());
        if ("1".equals(query.getBusinessType())) {
            resultData = this.globalUtilService.queryContractFollow((TwQueryParam)query, operationVO.getCustomerId());
        }
        if ("2".equals(query.getBusinessType())) {
            resultData = this.globalUtilService.queryOppoFollow((TwQueryParam)query, operationVO.getCustomerId());
        }
        if ("3".equals(query.getBusinessType())) {
            resultData = this.globalUtilService.queryLeadsFollow((TwQueryParam)query, operationVO.getCustomerId());
        }
        return resultData;
    }

    void checkeRelation(CrmCustomerOperationVO operationVO) {
        if (ObjectUtils.isEmpty((Object)operationVO)) {
            throw TwException.error("", "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (operationVO.getCustomerId() == null) {
            throw TwException.error("", "\u6682\u672a\u5173\u8054\u5ba2\u6237\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    public List<CrmCustomerOperationVO> findOperationEnterpriseInfoAbsent() {
        return this.dao.findOperationEnterpriseInfoAbsent();
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean fillQxbInfo(String custName, long operId) {
        CrmCustomerOperationPayload operationPayload = new CrmCustomerOperationPayload();
        String qxbBasicInfoStr = this.qiXinService.getBasicInfo(custName);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u7ed3\u679c:{}", (Object)custName, (Object)qxbBasicInfoStr);
        QxbRootDTO qxbBasicInfoRoot = (QxbRootDTO)JSON.parseObject((String)qxbBasicInfoStr, QxbRootDTO.class);
        if (!"200".equals(qxbBasicInfoRoot.getStatus())) {
            return false;
        }
        QxbBasicInfoDTO qxbBasicInfoDTO = (QxbBasicInfoDTO)qxbBasicInfoRoot.getData().toJavaObject(QxbBasicInfoDTO.class);
        CrmCustomerOperationEnterpriseInfoPayload operationEnterpriseInfoPayload = new CrmCustomerOperationEnterpriseInfoPayload();
        operationEnterpriseInfoPayload.setOrgNo(qxbBasicInfoDTO.getOrgNo());
        operationEnterpriseInfoPayload.setStartDate(qxbBasicInfoDTO.getStartDate());
        operationEnterpriseInfoPayload.setOperName(qxbBasicInfoDTO.getOperName());
        operationEnterpriseInfoPayload.setCreditNo(qxbBasicInfoDTO.getCreditNo());
        operationEnterpriseInfoPayload.setNewStatus(qxbBasicInfoDTO.getNew_status());
        operationEnterpriseInfoPayload.setActualCapi(qxbBasicInfoDTO.getActualCapi());
        operationEnterpriseInfoPayload.setTitle(qxbBasicInfoDTO.getTitle());
        operationEnterpriseInfoPayload.setCheckDate(qxbBasicInfoDTO.getCheckDate());
        if (org.springframework.util.StringUtils.hasText((String)qxbBasicInfoDTO.getType_new())) {
            String typeNew = qxbTypeNewMap.get(qxbBasicInfoDTO.getType_new());
            operationEnterpriseInfoPayload.setTypeNew(typeNew);
        }
        operationEnterpriseInfoPayload.setScope(qxbBasicInfoDTO.getScope());
        String contactInfoStr = this.qiXinService.getContactInfo(custName);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u4f01\u4e1a\u8054\u7cfb\u65b9\u5f0f\u7ed3\u679c:{}", (Object)custName, (Object)contactInfoStr);
        QxbRootDTO qxbContactInfoRoot = (QxbRootDTO)JSON.parseObject((String)contactInfoStr, QxbRootDTO.class);
        if ("200".equals(qxbContactInfoRoot.getStatus())) {
            QxbContactInfoDTO qxbContactInfoDTO = (QxbContactInfoDTO)qxbContactInfoRoot.getData().toJavaObject(QxbContactInfoDTO.class);
            CrmCustomerOperationDO operationDO = (CrmCustomerOperationDO)((Object)this.repo.findById(operId).get());
            boolean changed = false;
            if (org.springframework.util.StringUtils.hasText((String)qxbContactInfoDTO.getAddress())) {
                operationDO.setCustAddress(qxbContactInfoDTO.getAddress());
                changed = true;
            }
            if (org.springframework.util.StringUtils.hasText((String)qxbContactInfoDTO.getTelephone())) {
                operationDO.setLandline(qxbContactInfoDTO.getTelephone());
                changed = true;
            }
            if (org.springframework.util.StringUtils.hasText((String)qxbContactInfoDTO.getEmail())) {
                operationDO.setEmail(qxbContactInfoDTO.getEmail());
                changed = true;
            }
            if (changed) {
                this.repo.save((Object)operationDO);
            }
        }
        String entBriefStr = this.qiXinService.getEntBriefByName(custName);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u4f01\u4e1a\u7b80\u4ecb\u7ed3\u679c:{}", (Object)custName, (Object)entBriefStr);
        QxbRootDTO qxbEntBriefRoot = (QxbRootDTO)JSON.parseObject((String)entBriefStr, QxbRootDTO.class);
        if ("200".equals(qxbEntBriefRoot.getStatus())) {
            QxbEntBriefDTO qxbEntBriefDTO = (QxbEntBriefDTO)qxbEntBriefRoot.getData().toJavaObject(QxbEntBriefDTO.class);
            operationEnterpriseInfoPayload.setEnterpriseDesc(qxbEntBriefDTO.getBrief());
        }
        operationPayload.setEnterpriseInfo(operationEnterpriseInfoPayload);
        String qxbGetWebsitesStr = this.qiXinService.getGetWebsites(custName, null);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u4f01\u4e1a\u5e74\u62a5\u7f51\u5740\u7ed3\u679c:{}", (Object)custName, (Object)qxbGetWebsitesStr);
        QxbRootDTO qxbGetWebsitesRoot = (QxbRootDTO)JSON.parseObject((String)qxbGetWebsitesStr, QxbRootDTO.class);
        if ("200".equals(qxbGetWebsitesRoot.getStatus())) {
            JSONObject data = qxbGetWebsitesRoot.getData();
            JSONArray items = data.getJSONArray("items");
            List qxbGetWebSiteDTOList = items.toJavaList(QxbGetWebSiteDTO.class);
            List sitesList = qxbGetWebSiteDTOList.stream().map(qxbGetWebSiteDTO -> {
                CrmCustomerOperationSitesPayload sitesPayload = new CrmCustomerOperationSitesPayload();
                sitesPayload.setDate(qxbGetWebSiteDTO.getDate());
                sitesPayload.setUrl(qxbGetWebSiteDTO.getUrl());
                return sitesPayload;
            }).collect(Collectors.toList());
            operationPayload.setSitesList(sitesList);
        }
        String qxbPartnersStr = this.qiXinService.getPartners(custName, null);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u80a1\u4e1c\u4fe1\u606f\u7ed3\u679c:{}", (Object)custName, (Object)qxbPartnersStr);
        QxbRootDTO qxbPartnersDTO = (QxbRootDTO)JSON.parseObject((String)qxbPartnersStr, QxbRootDTO.class);
        if ("200".equals(qxbPartnersDTO.getStatus())) {
            JSONObject data = qxbPartnersDTO.getData();
            JSONArray items = data.getJSONArray("items");
            List qxbPartnersDTOList = items.toJavaList(QxbPartnersDTO.class);
            List partnersList = qxbPartnersDTOList.stream().map(qxbPartnersDTO1 -> {
                CrmCustomerOperationPartnersPayload partnersPayload = new CrmCustomerOperationPartnersPayload();
                partnersPayload.setName(qxbPartnersDTO1.getName());
                partnersPayload.setStockPercent(qxbPartnersDTO1.getStockPercent());
                partnersPayload.setTotalShouldCapi(qxbPartnersDTO1.getTotalShouldCapi());
                partnersPayload.setTotalRealCapi(qxbPartnersDTO1.getTotalRealCapi());
                return partnersPayload;
            }).collect(Collectors.toList());
            operationPayload.setPartnersList(partnersList);
        }
        String qxbGetEmployeesStr = this.qiXinService.getGetEmployees(custName, null);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u4e3b\u8981\u4eba\u5458\u5b57\u6bb5\u7ed3\u679c:{}", (Object)custName, (Object)qxbGetEmployeesStr);
        QxbRootDTO qxbGetEmployeesRoot = (QxbRootDTO)JSON.parseObject((String)qxbGetEmployeesStr, QxbRootDTO.class);
        if ("200".equals(qxbGetEmployeesRoot.getStatus())) {
            JSONObject data = qxbGetEmployeesRoot.getData();
            JSONArray items = data.getJSONArray("items");
            List qxbGetEmployeeDTOList = items.toJavaList(QxbGetEmployeeDTO.class);
            List employeesList = qxbGetEmployeeDTOList.stream().map(qxbGetEmployeeDTO -> {
                CrmCustomerOperationEmployeesPayload employeesPayload = new CrmCustomerOperationEmployeesPayload();
                employeesPayload.setName(qxbGetEmployeeDTO.getName());
                employeesPayload.setTitle(qxbGetEmployeeDTO.getTitle());
                employeesPayload.setIsHistory(qxbGetEmployeeDTO.getIs_history());
                return employeesPayload;
            }).collect(Collectors.toList());
            operationPayload.setEmployeesList(employeesList);
        }
        this.saveQxbInfo(operationPayload, operId);
        return true;
    }

    public void autoCustOperation(String param) {
        SaleConContractQuery conContractQuery = new SaleConContractQuery();
        conContractQuery.setStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        conContractQuery.setMainType("MAIN");
        List<SaleConContractVO> saleConContractVOS = this.saleConContractDAO.queryListByMainTypeAndStatus(conContractQuery);
        List crmCustomerOperationDOS = this.repo.findAll();
        List usedCustomerIds = crmCustomerOperationDOS.stream().map(CrmCustomerOperationDO::getCustomerId).collect(Collectors.toList());
        for (SaleConContractVO conContractVO : saleConContractVOS) {
            BusinessPartnerVO businessPartnerVO;
            if (ObjectUtils.isEmpty((Object)conContractVO.getCustId()) || ObjectUtils.isEmpty((Object)(businessPartnerVO = this.businessPartnerService.queryCustomerByBookId(conContractVO.getCustId()))) || usedCustomerIds.contains(businessPartnerVO.getId())) continue;
            CrmCustomerOperationPayload payload = new CrmCustomerOperationPayload();
            payload.setCustName(businessPartnerVO.getPartnerName());
            payload.setCustType(CustomerOperationTypeEnum.ENTERPRISE.getCode());
            payload.setCustomerId(businessPartnerVO.getId());
            payload.setNoticeTime(LocalDateTime.now());
            payload.setSaleOperBu(conContractVO.getSaleManUserBuId());
            payload.setSaleOperManagerId(conContractVO.getSaleManUserId());
            payload.setCustOperBu(conContractVO.getDeliBuId());
            payload.setCustOperManagerId(conContractVO.getDeliUserId());
            try {
                CrmCustomerOperationVO operationVO = this.insert(payload, false);
                this.fillQxbInfo(operationVO.getCustName(), operationVO.getId());
                operationVO.setCustOperManagerName(this.cacheUtil.getUserName(operationVO.getCustOperManagerId()));
                operationVO.setSaleOperManagerName(this.cacheUtil.getUserName(operationVO.getSaleOperManagerId()));
                this.noticeOperManagers(operationVO, CustomerOperationNoticeEnum.COMPLETE.getCode());
            }
            catch (TwException e) {
                log.warn("\u9500\u552e\u5408\u540c\u521b\u5efa\u5ba2\u6237\u7ecf\u8425\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f is {}", e.getErrors());
            }
        }
    }

    public void overdueCompleteCustOperation(String param) {
        LocalDate weekAgoTime = LocalDate.now().minus(7L, ChronoUnit.DAYS);
        List<CrmCustomerOperationVO> crmCustomerOperationVOS = this.dao.queryNeedOperas(weekAgoTime);
        if (CollectionUtils.isEmpty(crmCustomerOperationVOS)) {
            return;
        }
        for (CrmCustomerOperationVO vo : crmCustomerOperationVOS) {
            if (ObjectUtils.isEmpty((Object)vo.getCustOperManagerId()) || ObjectUtils.isEmpty((Object)vo.getSaleOperManagerId())) continue;
            vo.setCustOperManagerName(this.cacheUtil.getUserName(vo.getCustOperManagerId()));
            vo.setSaleOperManagerName(this.cacheUtil.getUserName(vo.getSaleOperManagerId()));
            this.noticeOperManagers(vo, CustomerOperationNoticeEnum.OVERDUE.getCode());
        }
    }

    public void noticeOperManagers(CrmCustomerOperationVO operationVO, String type) {
        PrdMessageConfigVO configVO;
        String noticeSourceListStr;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> noticeSourceList = new ArrayList<String>();
        result.put("custName", operationVO.getCustName());
        result.put("url", "/crm/customerOperation/custOperDetail?id=" + operationVO.getId());
        if (operationVO.getCustOperManagerId() != null) {
            operationVO.setCustOperManagerName(this.cacheUtil.getUserName(operationVO.getCustOperManagerId()));
        }
        if (operationVO.getSaleOperManagerId() != null) {
            operationVO.setSaleOperManagerName(this.cacheUtil.getUserName(operationVO.getSaleOperManagerId()));
        }
        if (CustomerOperationNoticeEnum.COMPLETE.getCode().equals(type)) {
            if (operationVO.getCustOperManagerId() != null) {
                noticeSourceList.add(operationVO.getCustOperManagerId().toString());
            }
            if (operationVO.getSaleOperManagerId() != null) {
                noticeSourceList.add(operationVO.getSaleOperManagerId().toString());
            }
            if (!CollectionUtils.isEmpty(noticeSourceList)) {
                noticeSourceList.add(operationVO.getCustOperManagerId().toString());
                noticeSourceList.add(operationVO.getSaleOperManagerId().toString());
                noticeSourceListStr = String.join((CharSequence)",", noticeSourceList);
                configVO = this.messageConfigService.queryByMessageCode("MC202310160191022");
                this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSourceListStr);
                configVO = this.messageConfigService.queryByMessageCode("MC202310160190907");
                result.put("deliUserName", operationVO.getCustOperManagerName());
                result.put("saleManUserName", operationVO.getSaleOperManagerName());
                this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", "579786621575104237");
            }
        }
        if (CustomerOperationNoticeEnum.OVERDUE.getCode().equals(type)) {
            if (operationVO.getCustOperManagerId() != null) {
                noticeSourceList.add(operationVO.getCustOperManagerId().toString());
            }
            if (operationVO.getSaleOperManagerId() != null) {
                noticeSourceList.add(operationVO.getSaleOperManagerId().toString());
            }
            if (!CollectionUtils.isEmpty(noticeSourceList)) {
                noticeSourceListStr = String.join((CharSequence)",", noticeSourceList);
                configVO = this.messageConfigService.queryByMessageCode("MC202310160191233");
                this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSourceListStr);
                configVO = this.messageConfigService.queryByMessageCode("MC202310160191125");
                result.put("deliUserName", operationVO.getCustOperManagerName());
                result.put("saleManUserName", operationVO.getSaleOperManagerName());
                this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", "579786621575104237");
            }
        }
        if (CustomerOperationNoticeEnum.ADD.getCode().equals(type)) {
            if (operationVO.getCustOperManagerId() != null) {
                noticeSourceList.add(operationVO.getCustOperManagerId().toString());
            }
            if (operationVO.getSaleOperManagerId() != null) {
                noticeSourceList.add(operationVO.getSaleOperManagerId().toString());
            }
            if (!CollectionUtils.isEmpty(noticeSourceList)) {
                noticeSourceListStr = String.join((CharSequence)",", noticeSourceList);
                String content = "<p><span style=\"color:#000000\"> \u5ba2\u6237\u540d\u79f0</span><span style=\"color:#000000\"><a href=\"#{url}\" target=\"\">#{custName}</a></span><span style=\"color:#000000\">\uff0c\u5f00\u542f\u4e86\u5ba2\u6237\u7ecf\u8425\uff0c\u76f8\u5173\u8d1f\u8d23\u4eba\u53ca\u65f6\u67e5\u770b\u3002</span></p>";
                configVO = this.messageConfigService.queryByMessageCode("MC202310160191233");
                configVO.setMessageTitle("\u5ba2\u6237\u7ecf\u8425\u67e5\u770b\u63d0\u9192");
                configVO.setContentType("crm");
                configVO.setMessageContent(content);
                configVO.setContentBigType("businessMessage");
                configVO.setReleaseSource("profileMessage");
                configVO.setReleaseStatus(Integer.valueOf(3));
                configVO.setNoticeWay("instation");
                this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSourceListStr);
            }
        }
    }

    @Transactional
    public void syncQxbInfo(Long key) {
        CrmCustomerOperationVO crmCustomerOperationVO = this.queryByKey(key);
        if (crmCustomerOperationVO == null) {
            throw TwException.error("", "\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (crmCustomerOperationVO.getCustomerId() == null) {
            throw TwException.error("", "\u5ba2\u6237\u7ecf\u8425\u672a\u5173\u8054\u5ba2\u6237,\u8bf7\u5173\u8054\u5bf9\u5e94\u5ba2\u6237\u540e\u518d\u540c\u6b65\u542f\u4fe1\u5b9d\u4fe1\u606f");
        }
        BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(crmCustomerOperationVO.getCustomerId());
        if (businessPartnerVO == null) {
            throw TwException.error("", "\u5ba2\u6237\u7ecf\u8425\u5173\u8054\u7684\u5ba2\u6237\u4e0d\u5b58\u5728");
        }
        CrmBusinessPartnerService crmBusinessPartnerService = (CrmBusinessPartnerService)SpringUtil.getBean(CrmBusinessPartnerService.class);
        crmBusinessPartnerService.deleteQxbInfo(businessPartnerVO.getId().longValue());
        boolean qxbDataInitFlag = crmBusinessPartnerService.fillQxbInfo(businessPartnerVO.getPartnerName(), businessPartnerVO.getId().longValue(), businessPartnerVO.getBookId());
        if (!qxbDataInitFlag) {
            throw TwException.error("", "\u540c\u6b65\u542f\u4fe1\u5b9d\u4fe1\u606f\u5931\u8d25");
        }
        BusinessPartnerPayload payload = new BusinessPartnerPayload();
        payload.setId(businessPartnerVO.getId());
        payload.setQxbDataInitFlag(Boolean.valueOf(true));
        this.businessPartnerService.update(payload);
    }

    public CrmCustomerOperationServiceImpl(CacheUtil cacheUtil, CrmCustomerOperationRepo repo, CrmCustomerOperationDAO dao, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService, BookAddressService bookAddressService, CrmOperationPlanTempDetailService crmOperationPlanTempDetailService, CrmOperationPlanTempService crmOperationPlanTempService, CrmOperationPlanDetailService crmOperationPlanDetailService, CrmOperationPlanDetailMemberService crmOperationPlanDetailMemberService, UdcUtil udcUtil, PrdOrgOrganizationDAO prdOrgOrganizationDAO, PrdOrgOrganizationService prdOrgOrganizationService, CrmCustomerOperationEnterpriseInfoService enterpriseInfoService, CrmCustomerOperationSitesService sitesService, CrmCustomerOperationPartnersService partnersService, CrmCustomerOperationEmployeesService employeesService, CrmPeopleService peopleService, BusinessFollowServiceImpl globalUtilService, CrmCustomerOperationChanceService operationChanceService, QiXinService qiXinService, SaleConContractDAO saleConContractDAO, PrdMessageConfigService messageConfigService, BusinessPartnerService businessPartnerService, CrmCommonService crmCommonService) {
        this.cacheUtil = cacheUtil;
        this.repo = repo;
        this.dao = dao;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
        this.bookAddressService = bookAddressService;
        this.crmOperationPlanTempDetailService = crmOperationPlanTempDetailService;
        this.crmOperationPlanTempService = crmOperationPlanTempService;
        this.crmOperationPlanDetailService = crmOperationPlanDetailService;
        this.crmOperationPlanDetailMemberService = crmOperationPlanDetailMemberService;
        this.udcUtil = udcUtil;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.enterpriseInfoService = enterpriseInfoService;
        this.sitesService = sitesService;
        this.partnersService = partnersService;
        this.employeesService = employeesService;
        this.peopleService = peopleService;
        this.globalUtilService = globalUtilService;
        this.operationChanceService = operationChanceService;
        this.qiXinService = qiXinService;
        this.saleConContractDAO = saleConContractDAO;
        this.messageConfigService = messageConfigService;
        this.businessPartnerService = businessPartnerService;
        this.crmCommonService = crmCommonService;
    }
}

