/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.file.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="file")
public class FileProperties {
    public static final String WIN = "win";
    public static final String MAC = "mac";
    private Long maxSize;
    private Long avatarMaxSize;
    private ElPath mac;
    private ElPath linux;
    private ElPath windows;

    public ElPath getPath() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().startsWith(WIN)) {
            return this.windows;
        }
        if (os.toLowerCase().startsWith(MAC)) {
            return this.mac;
        }
        return this.linux;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public Long getAvatarMaxSize() {
        return this.avatarMaxSize;
    }

    public ElPath getMac() {
        return this.mac;
    }

    public ElPath getLinux() {
        return this.linux;
    }

    public ElPath getWindows() {
        return this.windows;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }

    public void setAvatarMaxSize(Long avatarMaxSize) {
        this.avatarMaxSize = avatarMaxSize;
    }

    public void setMac(ElPath mac) {
        this.mac = mac;
    }

    public void setLinux(ElPath linux) {
        this.linux = linux;
    }

    public void setWindows(ElPath windows) {
        this.windows = windows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileProperties)) {
            return false;
        }
        FileProperties other = (FileProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$maxSize = this.getMaxSize();
        Long other$maxSize = other.getMaxSize();
        if (this$maxSize == null ? other$maxSize != null : !((Object)this$maxSize).equals(other$maxSize)) {
            return false;
        }
        Long this$avatarMaxSize = this.getAvatarMaxSize();
        Long other$avatarMaxSize = other.getAvatarMaxSize();
        if (this$avatarMaxSize == null ? other$avatarMaxSize != null : !((Object)this$avatarMaxSize).equals(other$avatarMaxSize)) {
            return false;
        }
        ElPath this$mac = this.getMac();
        ElPath other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !((Object)this$mac).equals(other$mac)) {
            return false;
        }
        ElPath this$linux = this.getLinux();
        ElPath other$linux = other.getLinux();
        if (this$linux == null ? other$linux != null : !((Object)this$linux).equals(other$linux)) {
            return false;
        }
        ElPath this$windows = this.getWindows();
        ElPath other$windows = other.getWindows();
        return !(this$windows == null ? other$windows != null : !((Object)this$windows).equals(other$windows));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $maxSize = this.getMaxSize();
        result = result * 59 + ($maxSize == null ? 43 : ((Object)$maxSize).hashCode());
        Long $avatarMaxSize = this.getAvatarMaxSize();
        result = result * 59 + ($avatarMaxSize == null ? 43 : ((Object)$avatarMaxSize).hashCode());
        ElPath $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : ((Object)$mac).hashCode());
        ElPath $linux = this.getLinux();
        result = result * 59 + ($linux == null ? 43 : ((Object)$linux).hashCode());
        ElPath $windows = this.getWindows();
        result = result * 59 + ($windows == null ? 43 : ((Object)$windows).hashCode());
        return result;
    }

    public String toString() {
        return "FileProperties(maxSize=" + this.getMaxSize() + ", avatarMaxSize=" + this.getAvatarMaxSize() + ", mac=" + this.getMac() + ", linux=" + this.getLinux() + ", windows=" + this.getWindows() + ")";
    }

    public static class ElPath {
        private String path;
        private String avatar;

        public String getPath() {
            return this.path;
        }

        public String getAvatar() {
            return this.avatar;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElPath)) {
                return false;
            }
            ElPath other = (ElPath)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$avatar = this.getAvatar();
            String other$avatar = other.getAvatar();
            return !(this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ElPath;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $avatar = this.getAvatar();
            result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
            return result;
        }

        public String toString() {
            return "FileProperties.ElPath(path=" + this.getPath() + ", avatar=" + this.getAvatar() + ")";
        }
    }
}

